#!/bin/sh
LOGGER="/usr/bin/logger"
PRIVATE_LOCATION="/var/packages/ProxyServer/target"
CUSTOM_WPAD="/var/services/web/wpad_custom.dat"
WPAD="/var/services/web/wpad.dat"
install_wpad()
{
	if [ -f ${CUSTOM_WPAD} ]; then
		cp ${CUSTOM_WPAD} ${WPAD}
		return;
	fi
        PORT=`cat ${PRIVATE_LOCATION}/squid/etc/setting_syno.json  | grep http_port | cut -d":" -f2 | tr -d ' ",'`
        IP_ADDR_PORT="$1:$PORT"
        cp ${PRIVATE_LOCATION}/etc/WPAD/wpad.dat_template ${PRIVATE_LOCATION}/etc/WPAD/wpad.dat
        sed -i "s/syno_proxy_server_ip_port/$IP_ADDR_PORT/g" ${PRIVATE_LOCATION}/etc/WPAD/wpad.dat
        cp ${PRIVATE_LOCATION}/etc/WPAD/wpad.dat ${WPAD}
}
install_dhcp_related_files()
{
        cp ${PRIVATE_LOCATION}/etc/WPAD/dhcpd-proxyserver-options.conf_template ${PRIVATE_LOCATION}/etc/WPAD/dhcpd-proxyserver-options.conf
        sed -i "s/syno_proxy_server_ip_port/$1/g" ${PRIVATE_LOCATION}/etc/WPAD/dhcpd-proxyserver-options.conf
        sed -i "s/syno_proxy_server_ip_port/$1/g" ${PRIVATE_LOCATION}/etc/WPAD/dhcpd-proxyserver-options.info
        [ -d /etc/dhcpd ] || mkdir -p /etc/dhcpd
        cp ${PRIVATE_LOCATION}/etc/WPAD/dhcpd-proxyserver-options.conf /etc/dhcpd/
        cp ${PRIVATE_LOCATION}/etc/WPAD/dhcpd-proxyserver-options.info /etc/dhcpd/
}
uninstall_wpad()
{
        rm -f ${WPAD}
}
uninstall_dhcp_related_files()
{
        rm -f /etc/dhcpd/dhcpd-proxyserver-options.*
}

case $1 in
        --install)
        shift
        install_wpad $@
        install_dhcp_related_files $@
        ;;
        --uninstall)
        uninstall_wpad
        uninstall_dhcp_related_files
        ;;
esac
/etc/rc.network nat-restart-dhcp
