#!/bin/sh
#set -x
INLINE=0
TARGET="main.html"
BASE_PATH='../../'
TEMPLATE_DIR="${BASE_PATH}template"
SZF_DAR_PROJECT_DIR="/usr/syno/synoreport"

LANG_LIB="$BASE_PATH/lang"
JS_LIB_COMMON="$TEMPLATE_DIR/js/lib.js"
CSS_LIB_COMMON="$TEMPLATE_DIR/css/syno.css"

#extjs
EXTJS_DIR="$TEMPLATE_DIR/ext-3"
EXTJS_ALL="$EXTJS_DIR/ext-all.js"
EXTJS_ALL_DEBUG="$EXTJS_DIR/ext-all-debug.js"
EXTJS_BASE="$EXTJS_DIR/adapter/ext/ext-base.js"
EXTJS_CSS="$EXTJS_DIR/resources/css/ext-all.css"
EXTJS_PIC_BASE_DIR="$EXTJS_DIR/resources/images"

#flotr2
FLOTR2_DIR="$TEMPLATE_DIR/flotr2"
FLOTR2_MAIN_JS="$FLOTR2_DIR/flotr2.js"
FLOTR2_MAIN_IE_JS="$FLOTR2_DIR/flotr2.ie.min.js"

#flexcroll
FLEXCROLL_DIR="$TEMPLATE_DIR/scrollbar"
FLEXCROLL_JS="$FLEXCROLL_DIR/flexcroll.js"
FLEXCROLL_CSS="$FLEXCROLL_DIR/flexcrollstyles.css"

# Replace Image List
#IMG_LIST=()
IMG_HTML="pic-html.txt"
IMG_QUOTA_USAGE="pic-quota-usage.txt"

# Quota Usage
EXTJS_QUOTA_USAGE1="$TEMPLATE_DIR/js/TabScrollerMenu.js"
EXTJS_QUOTA_USAGE2="$TEMPLATE_DIR/js/tab-scroller-menu.js"
EXTJS_QUOTA_USAGE3="$TEMPLATE_DIR/css/tab-scroller-menu.css"

# accep argument
TARGET_PART=$1;
TARGET=$2;
TARGET_REPORT=$3;

CreateHeader()
{
	rm $TARGET 2>/dev/null
	cat >$TARGET <<HEADER
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=9">
HEADER

	ImportExtJsAll $TARGET

	ImportCSS $TARGET $CSS_LIB_COMMON

	ImportJS $TARGET $JS_LIB_COMMON
}

CreateBody()
{
	echo "" >>$TARGET
	cat >>$TARGET <<BD
	</head>
	<body>
	<div class=header_bg>
		<table class=header_container align='center'>
			<tr><td>
			<div id='storage_report' class=header_left>Storage Report</div>
			<div id='title_name_time' class=header_center1>Device Name:  <br>Generate at:  </div>
			<div id='value_name_time' class=header_center2>dsOOO<br>12/03/2012 5:01:06 PM</div>
			<img class=header_right src='../../template/pic/logo.png' />
			</td></tr>
		</table>
	</div>
	<table class=content_container align='center'>
		<tr><td>
BD

	#IMG_LIST+=($IMG_HTML);
}

ImportJS()
{
	local target=$1;
	local file=$2;
	echo "import $file";
	if [ $INLINE -eq 0 ]; then
		echo "<script type='text/javascript' src='$file'></script>" >>$target
	else
		echo "<script type='text/javascript'>" >> $target
		cat $file >> $target
		echo "" >> $target
		echo  "</script>" >>$target
	fi
}

ImportCSS()
{
	local target=$1;
	local file=$2;
	echo "import $file";
	if [ $INLINE -eq 0 ]; then
		echo "<link rel='stylesheet' type='text/css' href='$file' />" >>$target
	else
		echo  "<style type='text/css'>" >> $target
		cat $file >> $target
		echo "" >> $target
		echo  "</style>" >>$TARGET
	fi
}

ImportHTML()
{
	local target=$1;
	local file=$2;
	cat $file >> $target
	#IMG_LIST+=($IMG_QUOTA_USAGE);
}

ImportExtJsAll()
{
	#Extjs-css
	ImportCSS $TARGET $EXTJS_CSS;

	#Extjs-all
	ImportJS $TARGET $EXTJS_BASE;

	#Extjs-all
	ImportJS $TARGET $EXTJS_ALL_DEBUG;
}

ImportReportScript()
{
	local css js oldPath

	ImportJS $TARGET $FLOTR2_MAIN_JS
	ImportJS $TARGET $FLOTR2_MAIN_IE_JS
	#if [ "$TARGET_REPORT" = "file_group" -o "$TARGET_REPORT" = "volume_usage" ]; then
	#	ImportJS $TARGET $FLOTR2_MAIN_JS
	#fi

	ImportJS $TARGET $FLEXCROLL_JS
	ImportCSS $TARGET $FLEXCROLL_CSS

	oldPath=`pwd`
	cd $SZF_DAR_PROJECT_DIR/reportUI;
	for css in `ls template/css/*.css`; do
		ImportCSS $TARGET "${BASE_PATH}$css"
	done
	for js in `ls template/js/*.js`; do
		ImportJS $TARGET "${BASE_PATH}$js"
	done
	cd $oldPath
}

ImportReportBody()
{
	local html
	for html in `ls $SZF_DAR_PROJECT_DIR/reportUI/report/$TARGET_REPORT/*.htm`; do
		ImportHTML $TARGET $html
	done
}


ImportQuotaUsage()
{
	ImportCSS $TARGET $EXTJS_QUOTA_USAGE3;

	ImportJS $TARGET $EXTJS_QUOTA_USAGE1;

	ImportJS $TARGET $EXTJS_QUOTA_USAGE2;

	cat >>$TARGET <<QB
		<div id='syno' align='center'></div>
QB
	#IMG_LIST+=($IMG_QUOTA_USAGE);
}


CreateTail()
{
	local timeV=`date +%Y/%m/%d\ %H:%M:%S`;
	local nameV=`hostname`;
	cat >>$TARGET <<BODY
	</td></tr>
	</table>
	<div class=footer_bg></div>
	</body>
	<script type='text/javascript'>
	synoHostName='$nameV';
	synoCreateTime='$timeV';
	</script>
	</html>
BODY
}

SetLang()
{
	# now $TARGET_REPORT is language
	echo "<script type='text/javascript' src='$LANG_LIB/$TARGET_REPORT.js'></script>" >> $TARGET
}

#EncodeImage()
#{
#	for i in "${IMG_LIST[@]}"; do
#	set -x
#		./encode_image.pl "$TARGET" "$i" -f
#	set +x
#	done
#}

# main
if [ "$TARGET_PART" = "header" ]; then
	if [ "$TARGET_REPORT" = "" ]; then
		CreateHeader
	else
		ImportReportScript
	fi
elif [ "$TARGET_PART" = "body" ]; then
	if [ "$TARGET_REPORT" = "" ]; then
		CreateBody
	else
		ImportReportBody
	fi
elif [ "$TARGET_PART" = "tail" ]; then
	CreateTail
elif [ "$TARGET_PART" = "lang" ]; then
	SetLang
fi
#EncodeImage

set +x
