/*var synoDuplicateFileData = [
	[ '1', 'public', '/volume1/public/aa', 1024, 1353491284 ],
	[ '2', 'music',  '/volume1/music/bb',  2048, 1353491284 ],
	[ '3', 'video',  '/volume1/video/vv',  4096, 1353491284 ]
];*/

function DuplicateFile()
{
    Ext.QuickTips.init();

	if(typeof synoDuplicateFileData === 'undefined' || synoDuplicateFileData.length === 0) {
		NoDataSet('duplicate_file_nodata');
		return ;
	}
    // NOTE: This is an example showing simple state management. During development,
    // it is generally best to disable state management as dynamically-generated ids
    // can change across page loads, leading to unpredictable results.  The developer
    // should ensure that stable state ids are set for stateful components in real apps.    
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

    var store = new Ext.data.ArrayStore({
        fields: [
           {name: 'Group'},
           {name: 'Share'},
           {name: 'File'},
           {name: 'Size', type: 'int'},
           {name: 'Time', type: 'date', dateFormat:'U'}
        ]
    });

    // manually load local data
    store.loadData(synoDuplicateFileData);

    // create the Grid
    var grid = new Ext.grid.GridPanel({
		border: false,
        store: store,
		stripeRows: true,
        width: 930,
		enableColumnResize: false,
		enableHdMenu: false,
		enableColumnHide: false,
		enableColumnMove: false,
		view: new Ext.ux.grid.BufferView(BufferViewConfig),
        columns: [
            {
				header   : _T('report','reportUI_title_group'),
                width    : 80,
                sortable : true,
				tooltip  : _T('report','reportUI_title_group'),
                dataIndex: 'Group'
            },
            {
                header   : _T('report','reportUI_title_share'),
                width    : 150,
                sortable : true,
                dataIndex: 'Share',
				tooltip  : _T('report','reportUI_title_share'),
				css: 'font-weight: bold;',
				renderer: tooltipCellRenderer
            },
            {
				header   : _T('common','file'),
                width    : 350,
                sortable : true,
                dataIndex: 'File',
				tooltip  : _T('common','file'),
                renderer: htmlEncodeRenderer
            },
            {
                header   : _T('common','size'),
                width    : 150,
                sortable : true,
				tooltip  : _T('common','size'),
                renderer : SizeUnit,
                dataIndex: 'Size'
            },
            {
				header   : _T('report', 'reportUI_title_modify_time'),
                width    : 200,
                sortable : true,
				tooltip  : _T('report', 'reportUI_title_modify_time'),
				renderer: Ext.util.Format.dateRenderer('Y-m-d H:i:s'),
                dataIndex: 'Time'
            }
        ],
        plugins: [ new GridPanelPlugin(14) ]
    });

    // render the grid to the specified div in the page
    grid.render('duplicate_file');
}

function DuplicateFile2()
{
    Ext.QuickTips.init();
	var store, column5;

	if (typeof synoDisableDuplicateFinder !== 'undefined' && synoDisableDuplicateFinder == true) {
		duplicate_file_overview = Ext.fly('duplicate_file_overview');
		duplicate_file_overview.hide();
		return ;
	}

	if(typeof synoDuplicateFileData === 'undefined' || synoDuplicateFileData.length === 0) {
		NoDataSet('duplicate_file_nodata');
		return ;
	}
    // NOTE: This is an example showing simple state management. During development,
    // it is generally best to disable state management as dynamically-generated ids
    // can change across page loads, leading to unpredictable results.  The developer
    // should ensure that stable state ids are set for stateful components in real apps.    
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

	store = new Ext.data.ArrayStore({
		fields: [
		   {name: 'Group'},
		   {name: 'Share'},
		   {name: 'File'},
		   {name: 'Size', type: 'int'},
           {name: 'Time', type: 'date', dateFormat:'U'},
		   {name: 'Status'}
		]
		/*],
		listeners:  {
			load: {
				fn: StatFileList
			}
		}*/
	});
	store.loadData(synoDuplicateFileData);

	//preload need image(session time will load img failed
	//Ext.Msg.confirm(_T('report','reportUI_msgbox_title_info'), _T('common','loading')).hide();

	// create the Grid
	var grid = new Ext.grid.GridPanel({
			border: false,
			store: store,
			stripeRows: true,
			width: 930,
			enableColumnResize: false,
			enableHdMenu: false,
			enableColumnHide: false,
			enableColumnMove: false,
			cls: 'without-dirty-red-grid',
			view: new Ext.ux.grid.BufferView(BufferViewConfig),
			columns: [
				{
					header   : _T('report','reportUI_title_group'),
					width    : 80,
					sortable : true,
					tooltip  : _T('report','reportUI_title_group'),
					dataIndex: 'Group'
				},
				{
					header   : _T('report','reportUI_title_share'),
					width    : 150,
					sortable : true,
					dataIndex: 'Share',
					tooltip  : _T('report','reportUI_title_share'),
					css: 'font-weight: bold;',
					renderer: tooltipCellRenderer
				},
				{
					header   : _T('common','file'),
					width    : 350,
					sortable : true,
					dataIndex: 'File',
					tooltip  : _T('common','file'),
					renderer: htmlEncodeRenderer
				},
				{
					header   : _T('common','size'),
					width    : 150,
					sortable : true,
					tooltip  : _T('common','size'),
					renderer : SizeUnit,
					dataIndex: 'Size'
				},
				{
					header   : _T('report', 'reportUI_title_modify_time'),
					width    : 200,
					sortable : true,
					tooltip  : _T('report', 'reportUI_title_modify_time'),
					renderer: Ext.util.Format.dateRenderer('Y-m-d H:i:s'),
					dataIndex: 'Time'
				}
			],
			plugins: [new SYNO.Report.BufferViewFlexcrollPlugin(), new SYNO.Report.GridPanelFlexcrollPlugin()]
		});

    // render the grid to the specified div in the page
    grid.render('duplicate_file');
}

function onDeleteFile(grid, rowIndex, colIndex)
{
	var url = 'webapi/entry.cgi';
	var rec = grid.store.getAt(rowIndex);
	var share_path = VolumePath2SharePath(rec.data['File'], rec.data['Share'], true);

	if ('undefined' !== typeof synoDemoMode && !!synoDemoMode) {
		Ext.Msg.alert("", _T('common', "error_demo"));
		return;
	}

	rec.set('Status', 'file_ajax');
	grid.store.doUpdate(rec);

	Ext.Ajax.request({
		url: url,
		method: 'POST',
		scope: this,
		params: { api: 'SYNO.FileStation.Delete', version: 2, method: 'delete', path: Ext.encode(share_path), recursive: false },
		callback: function (options, success, response) {
			try {
				var obj = Ext.decode(response.responseText);
				if(obj.success === false) {
					if(obj.error.code === 105) {
						rec.set('Status', 'delete_failed_login');
						grid.store.doUpdate(rec);
						Ext.Msg.confirm(_T('report','reportUI_msgbox_title_info'), _T('report','reportUI_msgbox_ask_login'), function(btn) {
							if(btn === 'yes') {
								location.reload(true);
							}
						});
					} else {
						rec.set('Status', 'delete_failed');
						grid.store.doUpdate(rec);
					}
					return;
				}
				rec.set('Status', 'delete_ok');
				grid.store.doUpdate(rec);
			} catch(e) {
				//reset status
				rec.set('Status', rec.data.File);
				grid.store.doUpdate(rec);
			}
			return;
		}
	});
}
