/*var synoFileGroupPieData = [
    { data : [[ 0,5 ]], label : 'Comedy' },
    { data : [[ 0,2 ]], label : 'Action' },
    { data : [[ 0,3 ]], label : 'Romance' }
];*/

/*var synoFileGroupTableData = [
	[ 'doc', 'public', 500 , 0, 0],
	[ 'doc', 'web', 1500 , 1, 500],
	[ 'music', 'public', 2500, 0 ,0 ],
	[ 'music', 'web', 3500, 0, 0 ]
];*/

Ext.namespace('SYNO.StorageReport');

SYNO.StorageReport.FileGroupPanel = Ext.extend(Ext.Panel, {
	border: false,
	constructor: function(cfg) {
		var config = this.fillConfig(cfg);
		if(synoFileGroupTableData.synoAll[0].length <= 3) {
			this.getHeaderPanel().hide();
		}
		SYNO.StorageReport.FileGroupPanel.superclass.constructor.call(this, config);
	},  
	fillConfig: function(cfg) {
		var config = {
			pie: cfg.pie,
			tableData: cfg.tableData,
			name: cfg.name,
			items: [
				this.getHeaderPanel(cfg.header),
				this.getGridPanel(cfg.container, cfg.tableData)
			]   
		};  
		Ext.apply(config, cfg);
		return config;
	},
	getHeaderPanel: function(header) {
		if (!Ext.isDefined(this.headerPanel)) {
			this.headerPanel = new Ext.form.FormPanel({
				border: false,
				layout: 'hbox',
				renderTo: header,
				items: [{
					xtype: 'checkbox',
					scope: this,
					height: 25,
					boxLabel: _T('report', 'exclude_recycle'),
					handler: function(cmp, checked){
						this.gridPanel.store.each(function(record) {
							if (checked) {
								record.data.Size = record.data.Size - record.data.recycle_size;
							} else {
								record.data.Size = record.data.Size + record.data.recycle_size;
							}
						});
						this.gridPanel.store.fireEvent('datachanged');
						FileGroupPie(this.pie, this.tableData, name, checked);
					}
				}]
			});
		}
		return this.headerPanel;
	}, 
	getGridPanel: function(container, tableData) {
		if(!Ext.isDefined(this.gridPanel)) {

			var storeConfig = {
				fields: [
				   {name: 'Type'},
				   {name: 'Share'},
				   {name: 'Size'}
				]
			};
			if(synoFileGroupTableData.synoAll[0].length >= 3) {
				storeConfig.fields.push(
					{name: 'recycle_count', type: 'int'},
					{name: 'recycle_size', type: 'int'}
				);
			}
			var store = new Ext.data.ArrayStore(storeConfig);
			// manually load local data
			store.loadData(tableData);
			
			// create the Grid
			this.gridPanel = new Ext.grid.GridPanel({
				border: false,
				store: store,
				renderTo: container,
				width: 670,
				enableColumnResize: false,
				enableHdMenu: false,
				enableColumnHide: false,
				enableColumnMove: false,
				view: new Ext.ux.grid.BufferView(BufferViewConfig),
				columns: [
					{
						id       : 'Type',
						header   : _T('report', 'reportUI_title_file_type'),
						width    : 230,
						sortable : true,
						tooltip  : _T('report', 'reportUI_title_file_type'),
						renderer : styleRendererDecorator(function(val) {
										return "<table><tr><td width=12 height=10 bgcolor='" + FileGroupSubNameColor[val] +
											"'>&nbsp;</td><td>&nbsp;" + _T('report', val) + "</td></tr></table>";
									}),
						dataIndex: 'Type'
					},
					{
						id       : 'Share',
						header   : _T('report', 'reportUI_title_share'),
						width    : 280,
						sortable : true,
						tooltip  : _T('report', 'reportUI_title_share'),
						dataIndex: 'Share',
						renderer: tooltipCellRenderer
					},
					{
						header   : _T('common', 'size'),
						width    : 120,
						sortable : true,
						tooltip  : _T('common', 'size'),
						renderer : sizeRenderer.createDelegate(this),
						dataIndex: 'Size'
					}
				],
				plugins: [new SYNO.Report.BufferViewFlexcrollPlugin(), new SYNO.Report.GridPanelFlexcrollPlugin()],
				// config options for stateful behavior
				stripeRows: true
			});
		}
		return this.gridPanel;
	}
});

var FileGroupSubNameColor = {
	reportUI_file_type_document:'#066EC3',
	reportUI_file_type_zip:		'#14B9EB',
	reportUI_file_type_video:	'#DC440F',
	reportUI_file_type_audio:	'#FF9128',
	reportUI_file_type_image:	'#F5C82C',
	reportUI_file_type_web:		'#A5C010',
	reportUI_file_type_iso:		'#96B200',
	reportUI_file_type_exe:		'#029E3C',
	reportUI_file_type_other:	'#A8865F'
};

function addChildTable(name)
{
	var table, divPie, divPieTitle, divPieBody, divGrid;
	var title = 'synoAll' === name ? _T('report','reportUI_title_all_user') : _T('report','reportUI_title_user_is') + name;

	table= Ext.get('file_group_table_all').createChild({
		tag: 'div',
		style: "width:930px; height:500px;",
		html: ''
	});

	divPie = table.createChild({
		tag: 'div',
		style: 'width: 230px; float: left;',
		html: ''
	});

	divHeader = table.createChild({
		tag: 'div',
		style: 'width: 700px; padding-top:25px; float: right;',
		html: ''
	});
	divPieTitle = divPie.createChild({
		tag: 'div',
		style: 'font-size: 15px; color: #313131; padding-top: 25px; font-weight: bold;',
		html: Ext.util.Format.htmlEncode(title)
	});

	divPieBody = divPie.createChild({
		tag: 'div',
		style: 'width: 230px; height: 230px;',
		html: ''
	});

	divGrid = table.createChild({
		tag: 'div',
		style: 'float: left; padding-left: 30px;',
		html: ''
	});

	return [ divPieBody, divGrid, divHeader ];

}

function FileGroup()
{
	if(typeof synoFileGroupTableData === 'undefined' || !synoFileGroupTableData['synoAll'] || synoFileGroupTableData['synoAll'].length === 0) {
		NoDataSet('file_group_nodata');
		return;
	}

	var data, tmp;
	for ( data in synoFileGroupTableData) {
		tmp = addChildTable(data);
		FileGroupPie(tmp[0], synoFileGroupTableData[data], data);
		var FileGroupPanel = new SYNO.StorageReport.FileGroupPanel({container: tmp[1], tableData: synoFileGroupTableData[data], header: tmp[2], pie: tmp[0], name: data});
	}
}

function FileGroupTranslateData(tableData, pieData, myColor, user, isExcludeRecycle)
{
	var i, key, total=0;
	var HashTmp = {};

	for(i=0; i<tableData.length; i++) {
		if( HashTmp[tableData[i][0]] === undefined) {
			HashTmp[tableData[i][0]] = tableData[i][2];
			total++;
		} else {
			HashTmp[tableData[i][0]] += tableData[i][2];
		}
		HashTmp[tableData[i][0]] -= (isExcludeRecycle)? (tableData[i][4] || 0) : 0;
	}

	i=0;
	/*if(FileGroupColorHash[user] === undefined) {
		FileGroupColorHash[user] = {};
	}*/
	for(key in HashTmp) {
		//pickColor(FileGroupColorHash[user], key, i, total);
		pieData.push( { data: [[ 0, HashTmp[key] ]], label : key } );
		//myColor.push(FileGroupColorHash[user][key]);
		myColor.push(FileGroupSubNameColor[key]);
		i++;
	}
}

function FileGroupPie(container, tableData, user, isExcludeRecycle)
{
  var pieData = [];

  var graph, myColor = [], key;

  FileGroupTranslateData(tableData, pieData, myColor, user, isExcludeRecycle);
  

  graph = Flotr.draw(container.dom, pieData, {
  /*graph = Flotr.draw(container, [
    { data : d1, label : 'Comedy' },
    { data : d2, label : 'Action' },
    { data : d3, label : 'Romance'},
    { data : d4, label : 'Drama' }
  ], {*/
    HtmlText : false,
    grid : {
	  outlineWidth: 0,
	  labelMargin: 0,
      verticalLines : false,
      horizontalLines : false
    },
    xaxis : { showLabels : false },
    yaxis : { showLabels : false },
    pie : {
      sizeRatio: 0.95,
      show : true, 
	  fill: true,
	  startAngle: 0.5,
	  explode: 0,
	  labelFormatter: function() {return '';}
    },
	colors: myColor,
	mouse: { 
		track : true,
		lineColor : '#FFFFFF',
		trackFormatter: function(x) {
			return _T('report', x.series.label);
		}
	},
	shadowSize: 0,
	legend : { show : false }
  });
}
