/*var synoFileOwnerData = [
	['admin', 'homes', '2', '1028653232', 0, 0]
	[ 'admin', 'music', '1', '10122143', 1, 10122143 ],
	[ 'admin', 'vol3', '2', '368', 0, 0 ]
];*/
Ext.namespace('SYNO.StorageReport');

SYNO.StorageReport.FileOwnerPanel = Ext.extend(Ext.Panel, {
	border: false,
	constructor: function(cfg) {
		var config = this.fillConfig(cfg);
		//hide checkbox in older profile
		if(synoFileOwnerData[0].length <= 4) {
			this.getHeaderPanel().hide();
		}
		SYNO.StorageReport.FileOwnerPanel.superclass.constructor.call(this, config);
	},
	fillConfig: function(cfg) {
		var config = {
			items: [
				this.getHeaderPanel(),
				this.getGridPanel()
			]
		};
		Ext.apply(config, cfg);
		return config;
	},
	getHeaderPanel: function() {
	if (!Ext.isDefined(this.headerPanel)) {
			this.headerPanel = new Ext.form.FormPanel({
				border: false,
				layout: 'hbox',
				items: [{
					xtype: 'checkbox',
					scope: this,
					height: 25,
					boxLabel: _T('report', 'exclude_recycle'),
					handler: function(cmp, checked){
						this.gridPanel.store.each(function(record) {
							if (checked) {
								record.data.Size = record.data.Size - record.data.recycle_size;
								record.data.Count = record.data.Count - record.data.recycle_count;
							} else {
								record.data.Size = record.data.Size + record.data.recycle_size;
								record.data.Count = record.data.Count + record.data.recycle_count;
							}
						});
						this.gridPanel.store.fireEvent('datachanged');
					}
				}]
			});
		}
		return this.headerPanel;
	},
	getGridPanel: function() {
		if (!Ext.isDefined(this.gridPanel)) {
			var storeConfig = {
				fields: [
					{name: 'User'},
					{name: 'Share'},
					{name: 'Count', type: 'int'},
					{name: 'Size',  type: 'int'}
				]
			};
			//read recycle info in new profile
			if(synoFileOwnerData[0].length >= 5) {
				storeConfig.fields.push(
					{name: 'recycle_count', type: 'int'},
					{name: 'recycle_size', type: 'int'}
				);
			}

			var store = new Ext.data.ArrayStore(storeConfig);
			
			// manually load local data
			store.loadData(synoFileOwnerData);

			this.gridPanel = new Ext.grid.GridPanel({
				border: false,
				store: store,
				stripeRows: true,
				width: 930,
				enableColumnResize: false,
				enableHdMenu: false,
				enableColumnHide: false,
				enableColumnMove: false,
				view: new Ext.ux.grid.BufferView(BufferViewConfig),
				columns: [{
					header   : _T('common', 'username'),
					width    : 200,
					sortable : true,
					dataIndex: 'User',
					tooltip  : _T('common', 'username')
				},
				{
					header   : _T('report', 'reportUI_title_share'),
					width    : 200,
					sortable : true,
					dataIndex: 'Share',
					css: 'font-weight: bold;',
					tooltip: _T('report', 'reportUI_title_share'),
					renderer: tooltipCellRenderer
				},
				{
					header   : _T('report', 'reportUI_title_file_count'),
					sortable : true,
					tooltip  : _T('report', 'reportUI_title_file_count'),
					dataIndex: 'Count'
				},
				{
					header   : _T('common', 'size'),
					width   : 100,
					sortable : true,
					dataIndex: 'Size',
					tooltip  : _T('common', 'size'),
					renderer: sizeRenderer.createDelegate(this)
				}],
				plugins: [new SYNO.Report.BufferViewFlexcrollPlugin(), new SYNO.Report.GridPanelFlexcrollPlugin()]
			});
		}
		return this.gridPanel;
	}
});

function FileOwner(){

	if(typeof synoFileOwnerData === 'undefined' || synoFileOwnerData.length === 0) {
		NoDataSet('file_owner_nodata');
		return;
	}

    // render the grid to the specified div in the page
	var fileOwnerPanel = new SYNO.StorageReport.FileOwnerPanel();
	fileOwnerPanel.render('file_owner');
}
