var langId = {
	title_quota_usage:		[ 'report',  'report_quota_usage'],
	share_title_quota_usage:[ 'report',  'report_quota_usage_by_share'],
	title_file_owner:		[ 'report',  'report_file_owner'],
	title_volume_usage :	[ 'report',  'report_volume_usage'],
	title_share_list:		[ 'report',  'report_share_list'],
	title_file_group:		[ 'report',  'report_file_group'],
	title_duplicate_file:	[ 'report',  'report_duplicate_file'],
	title_duplicate_list:	[ 'report',  'reportUI_duplicate_list'],
	title_large_file:		[ 'report',  'report_large_file'],
	title_least_modify:		[ 'report',  'report_lrm'],
	title_most_modify:		[ 'report',  'report_mrm'],
	storage_report:			[ 'report',  'reportUI_report_name'],
	download_csv1:			[ 'report',  'reportUI_download_csv' ],
	download_csv2:			[ 'report',  'reportUI_download_csv' ],
	download_csv3:			[ 'report',  'reportUI_download_csv' ],
	download_csv4:			[ 'report',  'reportUI_download_csv' ],
	download_csv5:			[ 'report',  'reportUI_download_csv' ],
	title_name_time:		[ 'report',  'reportUI_title_name_time' ],
	sample_quota_usage1:	[ 'report',  'reportUI_title_free' ],
	sample_quota_usage2:	[ 'report',  'reportUI_title_used' ]
};

function _T(g, s)
{
	try {
		return SYNO_WebManager_Strings[g][s];
	} catch(e) {
		return '';
	}
}

function consumedTimeRender() {
	if (typeof synoConsumedTime === 'undefined' || typeof _T('report', 'consumed_time') === 'undefined') {
		return '';
	}
	var retTime = ' (' + _T('report', 'consumed_time') + ': ';
	var sec = synoConsumedTime;
	var maxTime = 0;
	var timeStamp = [
		{val: 1, limit: 60, str: _T('common', 'time_less_min')},
		{val: 0, limit: 60, str: ' ' + _T('common', 'time_minute'), strs: ' ' + _T('common', 'time_minutes')},
		{val: 0, str: ' ' + _T('common', 'time_hour'), strs: ' ' + _T('common', 'time_hours')}
	];

	for (var t = 0 ; t < timeStamp.length; ++t) {
		if (0 < sec) {
			if (timeStamp[t].limit) {
				timeStamp[t].val = sec % timeStamp[t].limit;

				sec /= timeStamp[t].limit;
				sec = parseInt(sec, 10);
				maxTime = t;
			} else {
				timeStamp[t].val = sec;
				maxTime = t;
				break;
			}
		}
	}

	if (maxTime === 0) {
		retTime += timeStamp[maxTime].str;
	} else {
		var blFirst = true;
		for (var i = maxTime; i > 0; --i) {
			if (!blFirst) {
				retTime += ' ';
			}
			blFirst = false;

			if (timeStamp[i].val > 1) {
				retTime += timeStamp[i].val + timeStamp[i].strs;
			} else {
				retTime += timeStamp[i].val + timeStamp[i].str;
			}
		}
	}
	retTime += ')';

	return retTime;
}

function SetNameTime()
{
	var com = Ext.get('value_name_time');

	try {
		com.update(synoHostName + '<BR>' + synoCreateTime + consumedTimeRender());
	} catch(e) {
	}
}

function langReplace()
{
	var com, item;

	SetNameTime();

	for(item in langId) {
		com = Ext.get(item);
		try {
			com.update(_T(langId[item][0], langId[item][1]));
		} catch(e) {
		}
	}

	if(typeof synoDuplicateHashMatch != 'undefined' && synoDuplicateHashMatch === 1) {
		com = Ext.get('title_duplicate_file');
		try {
			com.update(_T(langId['title_duplicate_list'][0], langId['title_duplicate_list'][1]));
		} catch(e) {
		}
	}

}

function NoDataSet(myDiv)
{
	var container = Ext.fly(myDiv);
	var html = '<div align="center" style="width:930px; font-size: 23px;">' + _T('photo_viewer','no_data') + '</div>';

	if(container) {
		container.update(html);
	}
}

function pickColor(hash, key, i, total)
{
	var defaultColor = [ '#0067bb', '#10b6e6', '#db430c', '#ff8e27', '#ffd440', '#aec900', '#019d3b', '#7f39e8', '#a7855e' ];
	if (defaultColor[i]) {
		hash[key] = defaultColor[i];
		return hash[key];
	}

	var r=255, g=255, b=255;
	var totalPickingColor = total - defaultColor.length;
	var index = parseInt((255+255+255) / (totalPickingColor + 1), 10);

	i = i - defaultColor.length;

	r -= (i+1) * index;
	if( r < 0) {
		g -= 0 - r;
		r = 0;
    }
	if( g < 0) {
		b -= 0 - g;
		g = 0;
    }
	if( r < 0x10) {
		r = '0' + r.toString(16);
	} else {
		r = r.toString(16);
	}

	if( g < 0x10) {
		g = '0' + g.toString(16);
	}  else {
		g = g.toString(16);
	}

	if( b < 0x10) {
		b = '0' + b.toString(16);
	}  else {
		b = b.toString(16);
	}

	if(i % 3 === 0) {
		hash[key] = '#' + r + g + b;
	} else if(i % 3 === 1) {
		hash[key] = '#' + g + b + r;
	} else if(i % 3 === 2) {
		hash[key] = '#' + b + r + g;
	}
	return hash[key];
}

function pickRandomColor(hash, key, i, total)
{
    var r=255, g=255, b=255;
	var index = parseInt((255+255+255) / (total + 1), 10);

	r -= (i+1) * index;
    if( r < 0) {
		g -= 0 - r;
		r = 0;
    }
    if( g < 0) {
		b -= 0 - g;
		g = 0;
    }
	if( r < 0x10) {
		r = '0' + r.toString(16);
	}  else {
		r = r.toString(16);
	}

	if( g < 0x10) {
		g = '0' + g.toString(16);
	}  else {
		g = g.toString(16);
	}

	if( b < 0x10) {
		b = '0' + b.toString(16);
	}  else {
		b = b.toString(16);
	}

	if(i % 3 === 0) {
		hash[key] = '#' + r + g + b;
	} else if(i % 3 === 1) {
		hash[key] = '#' + g + b + r;
	} else if(i % 3 === 2) {
		hash[key] = '#' + b + r + g;
	}
    return hash[key];
}

function DayToFull(val, cellmeta, rec)
{
	var tmp = _T('report', 'reportUI_cannot_estimate');
	if(val <= 0) {
		cellmeta.attr = 'ext:qtip="' + tmp + '"; ext:qwidth=auto';
		return tmp;
	}
	cellmeta.attr = 'ext:qtip="' + val + '"; ext:qwidth=auto';
	return val;
}

function SizePercent(val)
{
	var a = val.split('%');
	//return new Number(a[0]).toFixed(1) + '%';
	return (1 * a[0]).toFixed(1) + '%';
}

function QuotaUsageRenderQuota(val)
{
	if(val === 0) {
		return _T('user', 'user_quota_nolimit');
	}
	return SizeUnit(val);
}

function sizeRenderer(value, cellmeta, record, rowIdx) {
	return SizeUnit(value);
}

function SizeUnit(val)
{
    var rv = '';
    var i=0;
    for(i=0; i<4; i++) {
        if(val > 1024) {
            val = val/1024;
        } else {
            break;
        }
    }

	if(i > 0) {
		val = val.toFixed(1);
	} else {
		val = parseInt(val, 10);
	}

    if( i == 0) {
        rv = val + ' ' + _T('common','size_byte');
    } else if( i == 1) {
        rv = val + ' ' + _T('common','size_kb');
    } else if( i == 2) {
		rv = val + ' ' + _T('common','size_mb');
    } else if( i == 3) {
        rv = val + ' ' + _T('common','size_gb');
    } else if( i == 4) {
        rv = val + ' ' + _T('common','size_tb');
    }
    return rv;
}

function VolumeId2Name(volume)
{
	var tmp, ret='-';
	if(volume !== '') {
		tmp	= volume.split('_');
		num = tmp[1];
		ret = String.format("{0} {1}", _T('volume', 'volume'), num);
	}

	return ret;
}

BufferViewConfig = {
	cacheSize: 30,
	forceFit: true,
    onLayout: function() {
		var els = this.el.select('.x-grid3-scroller', this);
		var scroller = els.elements[0];

		if (scroller.clientWidth === scroller.offsetWidth) {
			// no scroller
			this.scrollOffset = 2;
		} else {
			this.scrollOffset = undefined;
		}
		this.fitColumns(false);
	}
};

GridPanelPlugin = Ext.extend(Ext.Component, {
    constructor: function(limit) {
	this.limit = limit > 1 ? limit : 14;
    },
    init: function(gridpanel) {
	var me = this;
	Ext.apply(gridpanel, {
	    updateScrollbar: me.updateScrollbar
	});

	gridpanel.mon(gridpanel, 'afterrender', function(gridpanel) {
	    var count = gridpanel.getStore().getCount();

	    if (count < 1) {
		    count = 1;
	    } else if (count > this.limit) {
		    count = this.limit;
	    }

	    gridpanel.setHeight(35 + (count * 30));

		gridpanel.updateScrollbar(gridpanel.getView().scroller.dom);
	}, this, {buffer: 500});
	gridpanel.mon(gridpanel, 'resize', function(gridpanel) {
	    gridpanel.updateScrollbar(gridpanel.getView().scroller.dom);
	}, this, {buffer: 500});
    },
    updateScrollbar: function(dom) {
	if (dom && dom.fleXcroll) {
	    dom.fleXcroll.updateScrollBars();
	} else if (dom) {
	    fleXenv.fleXcrollMain(dom);
	}
    }
});

function VolumePath2SharePath(path, share, blIncludeShare)
{
	var keyEncode;
	var fileNewPath = '';
	var value = '';
	var sortKey = [];
	var i=0;

	if(typeof(synoSharePathHash2) !== 'undefined') {
		if(blIncludeShare) {
			fileNewPath = path.replace(synoSharePathHash2[share], "/" + share);
		} else {
			fileNewPath = path.replace(synoSharePathHash2[share] + "/",  '');
		}
		return fileNewPath;
	}

	for(var key in synoSharePathHash) {
		sortKey.push(key);
	}
	sortKey.sort();
	sortKey.reverse();

	for(i=0; i< sortKey.length; i++) {
		keyEncode = sortKey[i].replace(/\//g, '\\/');
		if(path.search(keyEncode + "\/") !== -1) {
			value = synoSharePathHash[sortKey[i]];
			if(blIncludeShare) {
				fileNewPath = path.replace(sortKey[i], "/" + value);
			} else {
				fileNewPath = path.replace(sortKey[i] + '/', '');
			}
			break;
		}
	}

	return fileNewPath;
}

function onOpenFile(file, share)
{
	var httpPrefix = 'http';
	if(typeof synoWebIp == 'undefined' || typeof synoWebPort == 'undefined') {
		return;
	}

	if(typeof blHttps != 'undefined' && blHttps) {
		httpPrefix = 'https';
	}

	var url = httpPrefix + '://' + synoWebIp + ':' + synoWebPort + '/webman/index.cgi?launchApp=SYNO.SDS.App.FileStation3.Instance&';
	var keyEncode;
	var fileNewPath = '';
	var value = '';

	fileNewPath = VolumePath2SharePath(file, share, true);

	var param = { openfile: fileNewPath };
	var lparam =  Ext.urlEncode({ launchParam: Ext.urlEncode(param) });

	url += lparam;

	window.open(url, "synoreport_filestation");
}

function GetShareNameIndex(rec)
{
	var i=0;
	try {
		for(i=0; i< rec.store.fields.items.length; i++) {
			if(rec.store.fields.items[i].name === 'Share') {
				return i;
			}
		}
	} catch(e){
	}
	return 0;
}

function htmlEncodeRenderer(val, cellmeta, rec) {
	var tmp = Ext.util.Format.htmlEncode(val);
	var link = tmp;
	cellmeta.attr = String.format('align="left"; ext:qtip="{0}"; ext:qclass="syno-report-qtip";', Ext.util.Format.htmlEncode(tmp));
	return link;
}

function tooltipCellRenderer(val, cellmeta, rec) {
	cellmeta.attr = String.format('ext:qtip="{0}"; ext:qclass="syno-report-qtip";', val);
	return val;
}

function styleRenderer(val, cellmeta, rec) {
	var format = '<div class = "x-grid3-first-column">{0}</div>';
	return String.format(format, val);
}

function styleRendererDecorator(func) {
	var renderer = function(val, cellmeta, rec) {
		val = func(val, cellmeta, rec);
		return styleRenderer(val, cellmeta, rec);
	};
	return renderer;
}

function styleHeaderRenderer(val) {
	return styleRenderer(val);
}



/*!
 * Ext JS Library 3.4.0
 * Copyright(c) 2006-2011 Sencha Inc.
 * licensing@sencha.com
 * http://www.sencha.com/license
 */
Ext.ns('Ext.ux.grid');

/**
 * @class Ext.ux.grid.BufferView
 * @extends Ext.grid.GridView
 * A custom GridView which renders rows on an as-needed basis.
 */
Ext.ux.grid.BufferView = Ext.extend(Ext.grid.GridView, {
	/**
	 * @cfg {Number} rowHeight
	 * The height of a row in the grid.
	 */
	rowHeight: 30,

	/**
	 * @cfg {Number} borderHeight
	 * The combined height of border-top and border-bottom of a row.
	 */
	borderHeight: 2,

	/**
	 * @cfg {Boolean/Number} scrollDelay
	 * The number of milliseconds before rendering rows out of the visible
	 * viewing area. Defaults to 100. Rows will render immediately with a config
	 * of false.
	 */
	scrollDelay: 100,

	/**
	 * @cfg {Number} cacheSize
	 * The number of rows to look forward and backwards from the currently viewable
	 * area.  The cache applies only to rows that have been rendered already.
	 */
	cacheSize: 20,

	/**
	 * @cfg {Number} cleanDelay
	 * The number of milliseconds to buffer cleaning of extra rows not in the
	 * cache.
	 */
	cleanDelay: 500,

	initTemplates : function(){
		Ext.ux.grid.BufferView.superclass.initTemplates.call(this);
		var ts = this.templates;
		// empty div to act as a place holder for a row
		    ts.rowHolder = new Ext.Template('<div class="x-grid3-row {alt}" style="{tstyle}"></div>');
		ts.rowHolder.disableFormats = true;
		ts.rowHolder.compile();

		ts.rowBody = new Ext.Template(
			'<table class="x-grid3-row-table" border="0" cellspacing="0" cellpadding="0" style="{tstyle}">',
			'<tbody><tr>{cells}</tr>',
			(this.enableRowBody ? '<tr class="x-grid3-row-body-tr" style="{bodyStyle}"><td colspan="{cols}" class="x-grid3-body-cell" tabIndex="0" hidefocus="on"><div class="x-grid3-row-body">{body}</div></td></tr>' : ''),
			'</tbody></table>'
		);
		ts.rowBody.disableFormats = true;
		ts.rowBody.compile();
	},

	getStyleRowHeight : function(){
		return Ext.isBorderBox ? (this.rowHeight + this.borderHeight) : this.rowHeight;
	},

	getCalculatedRowHeight : function(){
		return this.rowHeight + this.borderHeight;
	},

	getVisibleRowCount : function(){
		var rh = this.getCalculatedRowHeight(),
			visibleHeight = this.scroller.dom.clientHeight;
		return (visibleHeight < 1) ? 0 : Math.ceil(visibleHeight / rh);
	},

	getVisibleRows: function(){
		var count = this.getVisibleRowCount(),
			sc = this.scroller.dom.scrollTop,
			start = (sc === 0 ? 0 : Math.floor(sc/this.getCalculatedRowHeight())-1);
		return {
			first: Math.max(start, 0),
			last: Math.min(start + count + 2, this.ds.getCount()-1)
		};
	},

	doRender : function(cs, rs, ds, startRow, colCount, stripe, onlyBody){
		var ts = this.templates,
			ct = ts.cell,
			rt = ts.row,
			rb = ts.rowBody,
			last = colCount-1,
			rh = this.getStyleRowHeight(),
			vr = this.getVisibleRows(),
			tstyle = 'width:'+this.getTotalWidth()+';height:'+rh+'px;',
			// buffers
			buf = [],
			cb,
			c,
			p = {},
			rp = {tstyle: tstyle},
			r;
		for (var j = 0, len = rs.length; j < len; j++) {
			r = rs[j]; cb = [];
			var rowIndex = (j+startRow),
				visible = rowIndex >= vr.first && rowIndex <= vr.last;
			if (visible) {
				for (var i = 0; i < colCount; i++) {
					c = cs[i];
					p.id = c.id;
					p.css = i === 0 ? 'x-grid3-cell-first ' : (i == last ? 'x-grid3-cell-last ' : '');
					p.attr = p.cellAttr = "";
					p.value = c.renderer(r.data[c.name], p, r, rowIndex, i, ds);
					p.style = c.style;
					if (p.value === undefined || p.value === "") {
						p.value = "&#160;";
					}
					if (r.dirty && typeof r.modified[c.name] !== 'undefined') {
						p.css += ' x-grid3-dirty-cell';
					}
					cb[cb.length] = ct.apply(p);
				}
			}
		    var alt = [];
		    if(stripe && ((rowIndex+1) % 2 === 0)){
				alt[0] = "x-grid3-row-alt";
		    }
		    if(r.dirty){
				alt[1] = " x-grid3-dirty-row";
		    }
		    rp.cols = colCount;
		    if(this.getRowClass){
				alt[2] = this.getRowClass(r, rowIndex, rp, ds);
		    }
		    rp.alt = alt.join(" ");
		    rp.cells = cb.join("");
		    buf[buf.length] =  !visible ? ts.rowHolder.apply(rp) : (onlyBody ? rb.apply(rp) : rt.apply(rp));
		}
		return buf.join("");
	},

	isRowRendered: function(index){
		var row = this.getRow(index);
		return row && row.childNodes.length > 0;
	},

	syncScroll: function(){
		Ext.ux.grid.BufferView.superclass.syncScroll.apply(this, arguments);
		this.update();
	},

	// a (optionally) buffered method to update contents of gridview
	update: function(){
		if (this.scrollDelay) {
			if (!this.renderTask) {
				this.renderTask = new Ext.util.DelayedTask(this.doUpdate, this);
			}
			this.renderTask.delay(this.scrollDelay);
		} else{
			this.doUpdate();
		}
	},

	onRemove : function(ds, record, index, isUpdate){
		Ext.ux.grid.BufferView.superclass.onRemove.apply(this, arguments);
		if(isUpdate !== true){
			this.update();
		}
	},

	doUpdate: function(){
		if (this.getVisibleRowCount() > 0) {
			var g = this.grid,
				cm = g.colModel,
				ds = g.store,
				cs = this.getColumnData(),
				vr = this.getVisibleRows(),
				row;
			for (var i = vr.first; i <= vr.last; i++) {
				// if row is NOT rendered and is visible, render it
				if(!this.isRowRendered(i) && (row = this.getRow(i))){
					var html = this.doRender(cs, [ds.getAt(i)], ds, i, cm.getColumnCount(), g.stripeRows, true);
					row.innerHTML = html;
				}
			}
			this.clean();
		}
	},

	// a buffered method to clean rows
	clean : function(){
		if(!this.cleanTask){
			this.cleanTask = new Ext.util.DelayedTask(this.doClean, this);
		}
		this.cleanTask.delay(this.cleanDelay);
	},

	doClean: function(){
		if (this.getVisibleRowCount() > 0) {
			var vr = this.getVisibleRows();
			vr.first -= this.cacheSize;
			vr.last += this.cacheSize;

			var i = 0, rows = this.getRows();
			// if first is less than 0, all rows have been rendered
			// so lets clean the end...
			if(vr.first <= 0){
				i = vr.last + 1;
			}
			for(var len = this.ds.getCount(); i < len; i++){
				// if current row is outside of first and last and
				// has content, update the innerHTML to nothing
				if ((i < vr.first || i > vr.last) && rows[i].innerHTML) {
					rows[i].innerHTML = '';
				}
			}
		}
	},
	removeTask: function(name){
		var task = this[name];
		if(task && task.cancel){
			task.cancel();
			this[name] = null;
		}
	},
	destroy : function(){
		this.removeTask('cleanTask');
		this.removeTask('renderTask');
		Ext.ux.grid.BufferView.superclass.destroy.call(this);
	},

	layout: function(){
		Ext.ux.grid.BufferView.superclass.layout.call(this);
		this.update();
	}
});

Ext.ns('SYNO.Report');

SYNO.Report.GridPanelFlexcrollPlugin = Ext.extend(Ext.Component, {
	limit: 14,
	init: function(gridpanel){
		var me = this;
		Ext.apply(gridpanel, {
			updateScrollbar: me.updateScrollbar
		});

		gridpanel.mon(gridpanel, 'beforerender', function() {
			gridpanel.cls = gridpanel.cls ? gridpanel.cls + ' syno-webfm-scroll' : 'syno-webfm-scroll';
			gridpanel.overCls = gridpanel.overCls ? gridpanel.overCls + ' syno-webfm-scroll-over' : 'syno-webfm-scroll-over';
		}, this);
		gridpanel.mon(gridpanel, 'afterlayout', function(gridpanel) {
			var scroller = gridpanel.getView().scroller,
				count = gridpanel.getStore().getCount();
			if (count < 1) {
				count = 1;
			} else if (count > this.limit) {
				count = this.limit;
			}

			gridpanel.setHeight(35 + (count * 30));
			gridpanel.updateScrollbar(scroller.dom);

			gridpanel.mon(gridpanel, 'resize', function() {
				this.updateScrollbar(scroller.dom);
			}, gridpanel, {buffer: 500});
			gridpanel.mon(gridpanel.getView(), 'refresh', function() {
				this.updateScrollbar(scroller.dom);
			}, gridpanel, {buffer: 500});
			gridpanel.mon(gridpanel.getView(), 'viewready', function() {
				this.updateScrollbar(scroller.dom);
			}, gridpanel, {buffer: 500});
			gridpanel.mon(gridpanel.getStore(), 'load', function() {
				this.updateScrollbar(scroller.dom, true);
				this.fireEvent('afterUpdateScrollbar', this);
			}, gridpanel, {buffer: 500});
			gridpanel.mon(gridpanel.getStore(), 'clear', function() {
				this.updateScrollbar(scroller.dom, true);
			}, gridpanel, {buffer: 500});
			gridpanel.mon(gridpanel.getStore(), 'datachanged', function() {
				this.updateScrollbar(scroller.dom);
			}, gridpanel, {buffer: 500});
			gridpanel.mon(gridpanel.getStore(), 'update', function() {
				this.updateScrollbar(scroller.dom);
			}, gridpanel, {buffer: 500});
		}, this);
	},
	updateScrollbar: function(dom, blToTop) {
		if (dom && dom.fleXcroll) {
			if (blToTop) {
				dom.fleXcroll.setScrollPos(false, 0);
			}
			dom.fleXcroll.updateScrollBars();
			if (!blToTop) {
				dom.fleXcroll.setScrollPos(0, 0, true);
			}
		} else if (dom) {
			fleXenv.fleXcrollMain(dom);
			dom.onfleXcroll = (function() {
				if (this.isVisible() && this.getView().update) {
					this.getView().update();
				}
			}).createDelegate(this);
		}
	}
});
SYNO.Report.GridPanelFlexcrollPluginInstance = new SYNO.Report.GridPanelFlexcrollPlugin();
Ext.preg('gridpanelflexcrollplugin', SYNO.Report.GridPanelFlexcrollPlugin);

SYNO.Report.BufferViewFlexcrollPlugin = Ext.extend(Ext.Component, {
	init: function(gridpanel){
		var me = this;
		Ext.apply(gridpanel.getView(), {
			initTemplates: me.initTemplates,
			getVscrollerbarBase: me.getVscrollerbarBase,
			getContentwrapper: me.getContentwrapper,
			getVisibleRowCount: me.getVisibleRowCount,
			getVisibleRows: me.getVisibleRows
		});
	},
	initTemplates: function() {
		Ext.ux.grid.BufferView.prototype.initTemplates.apply(this, arguments);
		var ts = this.templates;

		ts.hcell = new Ext.Template('<td class="x-grid3-hd x-grid3-cell x-grid3-td-{id} {css}" style="{style}">' +
		'<div class="x-grid3-hd-row-split"></div>' +
		'<div {tooltip} {attr} class="x-grid3-hd-inner webfm-x-grid3-hd x-grid3-hd-{id}" unselectable="on" style="{istyle}">', this.grid.enableHdMenu ? '<a class="x-grid3-hd-btn" href="#"></a>' : '', '{value}', '<img alt="" class="x-grid3-sort-icon" src="', Ext.BLANK_IMAGE_URL, '" />', '</div>', '</td>');
		ts.hcell.disableFormats = true;
		ts.hcell.compile();
	},
	getVscrollerbarBase: function() {
		if (this.scrollerbarbase) {
			return this.scrollerbarbase;
		}
		return (this.scrollerbarbase = Ext.get(this.el.child("div.scrollerbarbase")));
	},
	getContentwrapper: function() {
		if (this.vscrollerbar) {
			return this.vscrollerbar;
		}
		return (this.vscrollerbar = Ext.get(this.el.child("div.contentwrapper")));
	},
	getVisibleRowCount: function() {
		var rh = this.getCalculatedRowHeight(), visibleHeight = !Ext.isEmpty(this.getVscrollerbarBase()) ? this.getVscrollerbarBase().getHeight() : this.scroller.dom.clientHeight;
		return (visibleHeight < 1) ? 0 : Math.ceil(visibleHeight / rh);
	},
	getVisibleRows: function() {
		var count = this.getVisibleRowCount(), sc = !Ext.isEmpty(this.getContentwrapper()) ? (-1 * this.getContentwrapper().getTop(true) + 1) : this.scroller.dom.scrollTop, start = (sc === 0 ? 0 : Math.floor(sc / this.getCalculatedRowHeight()) - 1);
		return {
			first: Math.max(start, 0),
			last: Math.min(start + count + 3, this.ds.getCount() - 1)
		};
	}
});
SYNO.Report.BufferViewFlexcrollPluginInstance = new SYNO.Report.BufferViewFlexcrollPlugin();
Ext.preg('bufferviewflexcrollplugin', SYNO.Report.BufferViewFlexcrollPlugin);

Ext.onReady(langReplace);
