/*var synoShareListData = [
	[ 'public', 'volume1', '324', 0, 2, 70 ],
	[ 'music',  'volume1', '223421', 512, 0, 0 ],
	[ 'video',  'volume2', '0', 0, 1, 20 ]
];*/
Ext.namespace('SYNO.StorageReport');

ShareListColorHash = {};

SYNO.StorageReport.ShareListPanel = Ext.extend(Ext.Panel, {
	border: false,
	constructor: function(cfg) {
		var config = this.fillConfig(cfg);
		//hide checkbox in old profile
		if(synoShareListData[0].length <= 4) {
			this.getHeaderPanel().hide();
		}
		SYNO.StorageReport.ShareListPanel.superclass.constructor.call(this, config);
	},
	fillConfig: function(cfg) {
		var config = {
			items: [
				this.getHeaderPanel(),
				this.getGridPanel()
			]
		};
		Ext.apply(config, cfg);
		return config;
	},
	getHeaderPanel: function() {
		if (!Ext.isDefined(this.headerPanel)) {
			this.headerPanel = new Ext.form.FormPanel({
				border: false,
				layout: 'hbox',
				items: [{
					xtype: 'checkbox',
					scope: this,
					height: 25,
					boxLabel: _T('report', 'exclude_recycle'),
					handler: function(cmp, checked){
						this.gridPanel.store.each(function(record) {
							if (checked) {
								record.data.Size = record.data.Size - record.data.recycle_size;
							} else {
								record.data.Size = record.data.Size + record.data.recycle_size;
							}
						});
						this.gridPanel.store.fireEvent('datachanged');
						shareListPie(Ext.fly('share_list_pie'), synoShareListData, checked);
					}
				}]
			});
		}
        return this.headerPanel;
	},
	getGridPanel: function() {
		if(!Ext.isDefined(this.gridPanel)) {
			var storeConfig = {
				fields: [
					{name: 'Share'},
					{name: 'Volume'},
					{name: 'Size', sortType: function(val) {return parseInt(val, 10);}}
				]
			};
			//add new info in new profile
			if(synoShareListData[0].length >= 4) {
				storeConfig.fields.push(
					{name: 'Quota'},
					{name: 'recycle_count', type: 'int'},
					{name: 'recycle_size', type: 'int'}
				);
			}
			var store = new Ext.data.ArrayStore(storeConfig);

			// manually load local data
			store.loadData(synoShareListData);

			// create the Grid
			var config = {
				border: false,
				store: store,
				stripeRows: true,
				width: 670,
				enableColumnResize: false,
				enableHdMenu: false,
				enableColumnHide: false,
				enableColumnMove: false,
				view: new Ext.ux.grid.BufferView(BufferViewConfig),
				autoExpandColumn: 'Share',
				columns: [{
					id       : 'Share',
					header   : _T('report', 'reportUI_title_share'),
					width    : 270,
					sortable : true,
					tooltip  : _T('report', 'reportUI_title_share'),
					renderer : styleRendererDecorator(shareColor),
					dataIndex: 'Share'
				}, {
					id       : 'Volume',
					header   : _T('report', 'reportUI_title_volume'),
					width    : 200,
					sortable : true,
					tooltip  : _T('report', 'reportUI_title_volume'),
					renderer : VolumeId2Name,
					dataIndex: 'Volume',
					align: 'center'
				}, {
					header   : _T('common','size'),
					sortable : true,
					width    : 200,
					tooltip  : _T('common','size'),
					renderer : sizeRenderer.createDelegate(this),
					dataIndex: 'Size'
				}],
				plugins: [new SYNO.Report.BufferViewFlexcrollPlugin(), new SYNO.Report.GridPanelFlexcrollPlugin()]
			};
			// #71584
			if(synoShareListData[0].length >= 4) {
				config.columns.push({
					header:  _T('user', 'user_quota_capacity'),
					sortable : true,
					width    : 200,
					tooltip:  _T('user', 'user_quota_capacity'),
					renderer : QuotaUsageRenderQuota,
					dataIndex: 'Quota'
				});
			}
			this.gridPanel = new Ext.grid.GridPanel(config);
		}
		return this.gridPanel;
	},
	getTotalShareSize: function() {
		var i, sum = 0;
		for (i = 0; i < synoShareListData.length; i++) {
			sum += parseInt(synoShareListData[i][2], 10);
		}
		return sum;
	},
	shareListTable: function() {

		// render the grid to the specified div in the page
		grid.render('share_list');
	}
});

function shareColor(val, cellmeta) {
	cellmeta.attr = String.format('ext:qtip="{0}"; ext:qclass="syno-report-qtip";', val);
	return "<table width=100%><tr><td width=12 height=10 bgcolor='" + ShareListColorHash[val] +
		"'>&nbsp;</td><td>&nbsp;" + val + "</td></tr></table>";
}

function shareListTranslateData(tableData, pieData, myColor, isExcludeRecycle) {
	var i = 0, recycle_size = 0;
	ShareListColorHash = {};

	for(i = 0; i < tableData.length; i++) {
		if(i > 8) {
			ShareListColorHash[tableData[i][0]] = ShareListColorHash[tableData[8][0]];
		} else {
			pickColor(ShareListColorHash, tableData[i][0], i, tableData.length);
		}
		recycle_size = isExcludeRecycle ? parseInt(tableData[i][5] || 0, 10) : 0;
		pieData.push({ data: [[ 0, parseInt(tableData[i][2] - recycle_size,10) ]], label : tableData[i][0] });
		myColor.push(ShareListColorHash[tableData[i][0]]);
	}
}

function shareListPie (container, tableData, isExcludeRecycle) {
	var pieData = [];

	var graph, myColor = [];

	shareListTranslateData(tableData, pieData, myColor, isExcludeRecycle);


  graph = Flotr.draw(container.dom, pieData, {
    HtmlText : false,
    grid : {
      outlineWidth: 0,
      labelMargin: 0,
      verticalLines : false,
      horizontalLines : false
    },
    xaxis : { showLabels : false },
    yaxis : { showLabels : false },
    pie : {
	sizeRatio: 0.95,
      show : true,
      fill: true,
      startAngle: 0.5,
      explode: 0,
      labelFormatter: function() {return '';}
    },
    colors: myColor,
    mouse: {
        track : true,
        lineColor : '#FFFFFF',
        trackFormatter: function(x) {
			return x.series.label;
        }
    },
    shadowSize: 0,
    legend : { show : false }
  });
}

function showShareList()
{
    Ext.QuickTips.init();

	if(typeof synoShareListData === "undefined" || synoShareListData.length === 0) {
		NoDataSet('share_list_nodata');
		return ;
	}

	/*var html = '<table width="930px"><tr height="30px">\n';
	var shareListBar = Ext.fly('share_list_bar');
	var i, percent;
	var color;
	var totalShareSize = getTotalShareSize();
	for (i=0; i<synoShareListData.length; i++) {
		percent = parseInt(100 * synoShareListData[i][2]/totalShareSize, 10);
		color = pickColor(ShareListColorHash, synoShareListData[i][0], i, synoShareListData.length);
		html += '<td ext:qtip="' + synoShareListData[i][0] + '" width="' + percent + '%" bgcolor="' + color + '">&nbsp;</td>';
	}
	html += '</tr></table>';
	shareListBar.update(html);
	*/

	var shareListPanel = new SYNO.StorageReport.ShareListPanel();
	shareListPie(Ext.fly('share_list_pie'), synoShareListData);
	shareListPanel.render("share-list");
}

