#!/bin/sh
# Copyright (c) 2015 Synology Inc. All rights reserved.

# This file is scripts utils for packages scripts.

CURR_SCRIPT_NAME="$(basename $0)"
SS_LOG_FILE="/var/log/surveillance/surveillance.log"

SS_TARGET_DIR="/var/packages/SurveillanceStation/target"
SS_CAM_SETTING_CORRECTOR="${SS_TARGET_DIR}/bin/sscamsettingcorrector"
SS_DP_DIR="${SS_TARGET_DIR}/device_pack"
SS_DP_UPGRADER="${SS_TARGET_DIR}/device_pack/bin/dpupgrader"
SS_DP_DOWNGRADER="${SS_TARGET_DIR}/device_pack/bin/dpdowngrader"
PRE_DP_VER_FILE="/tmp/.predpver"
PRE_DPDOWNGRADER="/tmp/.predpdowngrader"

DpDebugLog()
{
	local CurrDate="$(date +'%b %e %H:%M:%S')"
	local LogMsg="$1"

	echo "${LogMsg}"
	echo "${CurrDate} ${CURR_SCRIPT_NAME}: ${LogMsg}" >> "${SS_LOG_FILE}"
}

SaveCurDpVer()
{
	local DPVer=`grep "version" $SS_DP_DIR/conf`
	echo $DPVer > $PRE_DP_VER_FILE
	cp $SS_DP_DOWNGRADER $PRE_DPDOWNGRADER
}

UpdateDb()
{
	if [ -f $PRE_DP_VER_FILE ];then
		local PreDPVer=`grep "version" $PRE_DP_VER_FILE | cut -d'=' -f2 | sed 's/\"//g'`
		local PreDPBuildNum=`echo $PreDPVer |cut -d'-' -f2`

		local DPVer=`grep "version" $SS_DP_DIR/conf | cut -d'=' -f2 | sed 's/\"//g'`
		local DPBuildNum=`echo $DPVer |cut -d'-' -f2`

		if [ $DPBuildNum -gt $PreDPBuildNum ]; then
			# Do upgrader with previous dp version
			if [ -f $SS_DP_UPGRADER ]; then
				$SS_DP_UPGRADER $PreDPBuildNum
			fi
		fi

		if [ $DPBuildNum -lt $PreDPBuildNum ]; then
			# Do downgrader with previous dpdowngrader
			if [ -f $PRE_DPDOWNGRADER ]; then
				$PRE_DPDOWNGRADER $DPBuildNum
			fi
		fi
		rm -f $PRE_DP_VER_FILE
		rm -f $PRE_DPDOWNGRADER
	else
		# Do upgrader with 0
		if [ -f $SS_DP_UPGRADER ]; then
			$SS_DP_UPGRADER 0
		fi
	fi

        DpDebugLog "Start to correct camera table."
        ${SS_CAM_SETTING_CORRECTOR}
}
