#!/bin/bash
# Copyright (c) 2016 Synology Inc. All rights reserved.

Lv555Dir=/source/live555-20141020
SSName="SurveillanceStation"
SSMinVer=`grep "ss_min_ver=" /source/SurvDevicePack/INFO.sh | cut -d'=' -f2 | sed 's/\"//g'`

# check out live555 to tag
cd ${Lv555Dir}
TagName=`git tag -l | grep ${SSName}-${SSMinVer}-`

if [ "$TagName" == "" ]; then
	# no tag exists, do build and exit
	echo "No tag ${SSName}-${SSMinVer} exists, failed to fetch device pack"
	exit
else
	# tag exists, reset to tag
	git checkout .
	git checkout -b temp-branch $TagName

	echo "Checkout live555 to Tag:" $TagName
fi
