CREATE TABLE axisacsevtlog (
	id				integer PRIMARY KEY AUTOINCREMENT,
	ctrler_id		integer DEFAULT 0,
	src_type		integer DEFAULT 0,
	src_direct		integer DEFAULT 0,
	src_idpt_type	integer DEFAULT 0,
	src_id			integer DEFAULT 0,
	src_token		varchar(256) DEFAULT '',
	owner_type		integer DEFAULT 0,
	owner_direct	integer DEFAULT 0,
	owner_idpt_type	integer DEFAULT 0,
	owner_id		integer DEFAULT 0,
	owner_token		varchar(256) DEFAULT '',
	owner_info		text DEFAULT '',
	evt_grp			integer DEFAULT 0,
	evt_type		integer DEFAULT 0,
	row_id			integer DEFAULT 0,
	tmstmp			integer DEFAULT 0,
	playback		boolean DEFAULT '0',
	update_time		integer DEFAULT 0,
	log_level		integer DEFAULT 1,
	token			varchar(256) DEFAULT '',
	alarm_token		varchar(256) DEFAULT ''
);
CREATE INDEX IF NOT EXISTS log_tmstmp_idx ON axisacsevtlog(tmstmp);
CREATE INDEX IF NOT EXISTS log_categ_idx ON axisacsevtlog(ctrler_id, log_level);
CREATE INDEX IF NOT EXISTS axisacsevtlog_update_time_idx ON axisacsevtlog (update_time);
CREATE TRIGGER IF NOT EXISTS axisacsevtlog_update_time AFTER INSERT ON axisacsevtlog BEGIN
	UPDATE OR IGNORE axisacsevtlog SET update_time = strftime('%s','now') WHERE id = new.id;
END;
