#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

SURVEILLANCE_INC_SCRP=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
. ${SURVEILLANCE_INC_SCRP}

SS_BIN_DIR="${SS_TARGET_DIR}/bin"
SSCTL="${SS_BIN_DIR}/ssctl"
SYNO_SERVICE_CFG="/usr/syno/sbin/synoservicecfg"

CheckPgsqlService()
{
	${SYNO_SERVICE_CFG} --is-enabled pgsql > /dev/null 2>&1
	if [ 0 == $? ]; then
		return 1
	fi

	return 0
}

CheckPgsqlDBExist()
{
	local Ret

	${PGSQL_BIN_PSQL} -c "select 1 from camera" > /dev/null 2>&1
	Ret=$?
	if [ $Ret == 2 ]; then
		return 1
	fi

	return 0
}

Start()
{
	local Ret

	if [ false == $(IsNonRecordingMode) ]; then
		PrepareShareFolder true
		Ret=$?
		if [ 0 -ne ${Ret} ]; then
			SSDebugLog "Failed to prepare share folder."
			UpdateNonRecordingMode
		fi

		if [ ! -f ${SS_REC_DB} ]; then
			SSDebugLog "Recording db not found."
			UpdateNonRecordingMode
		fi
	fi

	if [ ${USE_SQLITE} == false ]; then
		CheckPgsqlService
		Ret=$?
		if [ $Ret -ne 0 ]; then
			SSDebugLog "PGSQL is not enabled"
			exit 1;
		fi
	
		CheckPgsqlDBExist
		Ret=$?
		if [ $Ret -ne 0 ]; then
			SSDebugLog "PGSQL db have not been created yet."
			exit 1
		fi
	else 
		if [ ! -f ${SS_SYSTEM_DB} ]; then
			SSDebugLog "System db not found."
			exit 1
		fi
	fi

	echo "10240 163840" > /proc/sys/kernel/sem
	${SSCTL} start
}

Stop()
{
	if [ ${USE_SQLITE} == false ]; then
		CheckPgsqlDBExist
		Ret=$?
		if [ $Ret -ne 0 ]; then
			echo "Surveillance: DB is stopped before Surveillance stops"
		fi
	else 
		if [ ! -f ${SS_SYSTEM_DB} ]; then
			echo "Surveillance System DB not found."
		fi
	fi

	${SSCTL} stop
}

Restart()
{
	Stop
	sleep 1
	Start
}

TriggerSctrl()
{
	${SSCTL} "$1" "$2"
}

main()
{
	case $1 in
	"start")
		Start
		;;
	"stop")
		Stop
		;;
	"restart")
		Restart
		;;
	"trigger-ssctl")
		TriggerSctrl "$2" "$3"
		;;
	*)
		echo "Usage: $0 start|stop|restart|share_folder"
		;;
	esac
}

main "$@"
