#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

# This file is scripts utils for packages scripts.
# DO NOT USE in preinst / postuninst.

SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
. ${SS_COMMON_SCRIPT}

PACKAGE_DEST=$SYNOPKG_PKGDEST

UDC_CONF_DIR="/usr/syno/etc/user.data.conf"
UDC_CONF_SRC_NAME="user_data_collector.config"
UDC_CONF_FILE="${UDC_CONF_DIR}/surveillance.config"
SDK_PLUGIN_INSTALL_DIR="/usr/local/libexec"

# Synosdk plugin
InstallSynosdkPlugin()
{
	SSDebugLog "Start to install sdk plugin."

	local PluginScriptsDir="${SS_SCRIPTS_DIR}/sdkplugin"
	local ServiceDir="${SDK_PLUGIN_INSTALL_DIR}/service"
	local ShareSetDir="${SDK_PLUGIN_INSTALL_DIR}/share_set"
	local ShareDeleteDir="${SDK_PLUGIN_INSTALL_DIR}/share_delete"
	local ShareSnapshotDir="${SDK_PLUGIN_INSTALL_DIR}/share_snapshot"
	local ShareDirList="${ShareSetDir} ${ShareDeleteDir} ${ShareSnapshotDir}"
	local VolumeDir="${SDK_PLUGIN_INSTALL_DIR}/volume"
	local VolumeMountDir="${VolumeDir}/mount"
	local VolumeUnmountDir="${VolumeDir}/unmount"
	local VolumeDirList="${VolumeDir} ${VolumeMountDir} ${VolumeUnmountDir}"
	local DirList="${SDK_PLUGIN_INSTALL_DIR} ${ServiceDir} ${ShareDirList} ${VolumeDirList}"

	for Dir in ${DirList}; do
		if [ ! -d "${Dir}" ]; then
			mkdir -p "${Dir}"
		fi
	done

	ln -sf "${SS_SCRIPTS_DIR}/SurveillanceStationCommon.sh" "${SDK_PLUGIN_INSTALL_DIR}/"
	ln -sf "${PluginScriptsDir}/surveillance_service.sh" "${ServiceDir}/"
	ln -sf "${PluginScriptsDir}/surveillance_share_set.sh" "${ShareSetDir}/"
	ln -sf "${PluginScriptsDir}/surveillance_share_del.sh" "${ShareDeleteDir}/"
	ln -sf "${PluginScriptsDir}/surveillance_share_snapshot.sh" "${ShareSnapshotDir}/"
	ln -sf "${PluginScriptsDir}/surveillance_volume_mount.sh" "${VolumeMountDir}/"
	ln -sf "${PluginScriptsDir}/surveillance_volume_unmount.sh" "${VolumeUnmountDir}/"
}

RemoveSynosdkPlugin()
{
	SSDebugLog "Remove Synosdk plugin."

	local CommonScript="SurveillanceStationCommon.sh"
	local ServiceScript="service/surveillance_service.sh"
	local ShareSetScript="share_set/surveillance_share_set.sh"
	local ShareDelScript="share_delete/surveillance_share_del.sh"
	local ShareSnapshotScript="share_snapshot/surveillance_share_snapshot.sh"
	local ShareScriptList="${ShareSetScript} ${ShareDelScript} ${ShareSnapshotScript}"
	local VolumeMountScript="volume/mount/surveillance_volume_mount.sh"
	local VolumeUnmountScript="volume/unmount/surveillance_volume_unmount.sh"
	local VolumeScriptList="${VolumeMountScript} ${VolumeUnmountScript}"
	local ScriptList="${CommonScript} ${ServiceScript} ${ShareScriptList} ${VolumeScriptList}"

	for Script in ${ScriptList}; do
		rm -f "${SDK_PLUGIN_INSTALL_DIR}/${Script}"
	done
}

# Firewall config
InstallFirewallConf()
{
	SSDebugLog "Start to install firewall rule."

	${SERVICETOOL} --install-configure-file --package "${PACKAGE_DEST}"/etc/SurveillanceStation.sc
}

RemoveFirewallConfig()
{
	SSDebugLog "Remove firewall rule."

	if [ $SYNOPKG_PKG_STATUS != "UPGRADE" ]; then
		# remove port-forwarding config file and related firewall records
		${SERVICETOOL} --remove-configure-file --package SurveillanceStation.sc
	fi
}

# User data collection
InstallUserDataCollector()
{
	SSDebugLog "Start to install user data collector."

	local VersionFile="/etc.defaults/VERSION"
	local DSMMajorVer=$(grep -s ^majorversion ${VersionFile} | head -1 | awk -F \" '{print $2}' | sed 's/ //g')

	if [ ${DSMMajorVer} -ge 5 ]; then
		cp -s "${SS_PACKAGE_DIR}"/target/scripts/${UDC_CONF_SRC_NAME} ${UDC_CONF_FILE}
	fi
}

RemoveUserDataCollector()
{
	SSDebugLog "Remove user data collector."

	if [ -f ${UDC_CONF_FILE} ]; then
		rm -f ${UDC_CONF_FILE}
	fi
}

