#!/bin/sh
# Copyright (c) 2000-2013 Synology Inc. All rights reserved.

###############################################################
#   This script should be hooked when invoking SLIBNetService()
#   Usable environment variable:
#       PATH, SERVICE_IP_CHANGE, SERVICE_HOSTNAME_CHANGE,
#       SERVICE_MTU_CHANGE, SERVICE_DAEMON_ACTION, RESULT
#
#   Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
SURVEILLANCE_INC_SCRP=/usr/local/libexec/SurveillanceStationCommon.sh
. ${SURVEILLANCE_INC_SCRP}

#At begining, acquire package settings
PackageInfoGet;

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0"
	;;
	--name)
		#Print package name
		echo ${SURVEILLANCE_PKG_NAME};
	;;
	--pkg-ver)
		#Print package version
		echo ${SURVEILLANCE_PKG_VERSION};
	;;
	--vendor)
		#Print package vendor
		echo ${SURVEILLANCE_PKG_VENDOR};
	;;
	--pre)
	;;
	--post)
		if [ -f "${SS_PKG_ENABLED_FILE}" -a "1" = "${SERVICE_IP_CHANGE}" ]; then
			SurveillanceStationRestart;
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

