#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

###############################################################
#	This script should be hooked when invoking SYNOShareDelete()
#	Usable environment variable:
#		NITEMS, CLEAN_DATA, SHARE_NAME_#, SHARE_PATH_#,
#		SHARE_STATUS_#(encrypt/decrypt/normal), SHARE_OP_RESULT_#,
#		#: $(seq 1 ${NITEMS})
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
SURVEILLANCE_INC_SCRP=/usr/local/libexec/SurveillanceStationCommon.sh
. ${SURVEILLANCE_INC_SCRP}

PreDelete()
{
	if [ false == $(ShouldHandleVolumeEvent) -o false == $(IsSSCoredRunning) ]; then
		return
	fi

	local ShareName

	for i in $(seq 1 ${NITEMS}); do
		eval "ShareName=\"\${SHARE_NAME_${i}}\""
		if [ "${DEFAULT_SS_SHARE_NAME}" == "${ShareName}" ]; then
			SSDebugLog "SS share folder deleted while SS was running. Enter non-recording mode."
			SetNonRecordingMode true volume
			return
		fi
	done
}

main()
{
	PackageInfoGet;

	case $1 in
		--sdk-mod-ver)
			#Print SDK support version
			echo "2.0"
		;;
		--name)
			#Print package name
			echo ${SURVEILLANCE_PKG_NAME};
		;;
		--pkg-ver)
			#Print package version
			echo ${SURVEILLANCE_PKG_VERSION};
		;;
		--vendor)
			#Print package vendor
			echo ${SURVEILLANCE_PKG_VENDOR};
		;;
		--pre)
			#Actions before share delete
			PreDelete;
		;;
		--post)
			#Actions after share delete
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
	esac
}

main "$@"
