#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

###############################################################
#	This script should be hooked when invoking SYNOShareSet()
#	Usable environment variable:
#		ORIGIN_SHARE_NAME, SHARE_NAME, ORIGIN_SHARE_PATH, SHARE_PATH,
#		ORIGIN_SHARE_STATUS(encrypt/decrypt/normal), SHARE_STATUS(encrypt/decrypt/normal),
#		RESULT, ORIGIN_SHARE_ENABLE, SHARE_ENABLE
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
SURVEILLANCE_INC_SCRP=/usr/local/libexec/SurveillanceStationCommon.sh
. ${SURVEILLANCE_INC_SCRP}

ShareEnableChangeStatus()
{
	if [ "${ORIGIN_SHARE_ENABLE}" != "${SHARE_ENABLE}" ]; then
		echo "${SHARE_ENABLE}"
	fi
}

PathChangeWhenShareEnable()
{
	if [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ] &&
	   [ "1" == "${SHARE_ENABLE}" ]; then
		echo "true"
	else
		echo "false"
	fi
}

UpdateConf()
{
	local ConfVolPath=$(GetValueFromConfFile "${SS_SETTINGS_CONF}" "${CONF_KEY_ACTIVE_VOLUME}")
	local VolPath=$(echo "${SHARE_PATH}" | sed 's,\(/[^/[:blank:]]*\).*,\1,')

	if [ -z "${ConfVolPath}" ] || [ "${VolPath}" != "${ConfVolPath}" ]; then
		SetValueToConfFile "${SS_SETTINGS_CONF}" "${CONF_KEY_ACTIVE_VOLUME}" "${VolPath}"
	fi
}

SSShareSetBegin()
{
	if [ "${DEFAULT_SS_SHARE_NAME}" != "${ORIGIN_SHARE_NAME}" -o \
		 true == $(IsNonRecordingMode) ]; then
		return
	fi

	if [ "0" == "$(ShareEnableChangeStatus)" ] || [ "true" == "$(PathChangeWhenShareEnable)" ]; then
		SSDebugLog "Share folder was set inaccessible. Enter non-recording mode."
		SetNonRecordingMode true share-set
	fi
}

SSShareSetEnd()
{
	if [ "${DEFAULT_SS_SHARE_NAME}" != "${ORIGIN_SHARE_NAME}" ]; then
		return
	fi

	if [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ]; then
		UpdateConf
	fi

	if [ "1" == "$(ShareEnableChangeStatus)" ] || [ "true" == "$(PathChangeWhenShareEnable)" ]; then
		SSDebugLog "Share folder was set accessible. Leave non-recording mode."
		SetNonRecordingMode false share-set
	fi
}

main()
{
	PackageInfoGet;

	case $1 in
		--sdk-mod-ver)
			#Print SDK support version
			echo "2.0"
		;;
		--name)
			#Print package name
			echo ${SURVEILLANCE_PKG_NAME};
		;;
		--pkg-ver)
			#Print package version
			echo ${SURVEILLANCE_PKG_VERSION};
		;;
		--vendor)
			#Print package vendor
			echo ${SURVEILLANCE_PKG_VENDOR};
		;;
		--pre)
			#Actions before share set
			SSShareSetBegin;
		;;
		--post)
			#Actions after share set
			SSShareSetEnd;
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
	esac
}

main "$@"

