#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

#	--sdk-mod-ver
#								SYNOMODULE=”share”
#	--name/--pkg-ver/--vendor
#								NONE
#	--pre/--post
#								SHARE_NAME,
#								SHARE_PATH,
#								NEW_SHARE_NAME(available at CLONE action),
#								NEW_SHARE_PATH(available at CLONE action),
#								SNAPSHOT(CREATE: snapshot to be created, RESTORE: snapshot to restore from, CLONE_SNAP: snapshot to clone from),
#								RESULT(0 for success, the others for failure),
#								ACTION(CREATE, RESTORE, CLONE_SHARE, CLONE_SNAP),
#								ENC_STATUS(0: normal share, 1: encrypted share, 2: decrypted share)

SS_COMMON_SCRIPT=/usr/local/libexec/SurveillanceStationCommon.sh
. ${SS_COMMON_SCRIPT}

PrintArgs()
{
	SSDebugLog "SHARE_NAME: ${SHARE_NAME}"
	SSDebugLog "SHARE_PATH: ${SHARE_PATH}"
	SSDebugLog "NEW_SHARE_NAME: ${NEW_SHARE_NAME}"
	SSDebugLog "NEW_SHARE_PATH: ${NEW_SHARE_PATH}"
	SSDebugLog "SNAPSHOT: ${SNAPSHOT}"
	SSDebugLog "RESULT: ${RESULT}"
	SSDebugLog "ACTION: ${ACTION}"
	SSDebugLog "ENC_STATUS: ${ENC_STATUS}"
}

PreSnapshot()
{
	if [ "${DEFAULT_SS_SHARE_NAME}" == "${SHARE_NAME}"  -a \
		 "CREATE" == "${ACTION}" -a \
		 false == $(IsNonRecordingMode) ]; then
		SSDebugLog "Surveillance share folder is about to take snapshot. Enter non-recording mode."
		SetNonRecordingMode true share-snapshot-create
	fi
}

PostSnapshot()
{
	if [ "${DEFAULT_SS_SHARE_NAME}" != "${SHARE_NAME}" ]; then
		return
	fi

	case "${ACTION}" in
		"CREATE")
			if [ true == $(IsNonRecordingMode) ]; then
				SSDebugLog "Leave non-recording mode after share folder snapshot creation."
				SetNonRecordingMode false share-snapshot-create
			fi
		;;
		"RESTORE")
			SSDebugLog "Snapshot of shared folder has been restored."
			ShareSnapshotRestored
		;;
		*)
		;;
	esac
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "2.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--pre)
			PreSnapshot
		;;
		--post)
			PostSnapshot
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"
