#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

# --sdk-mod-ver
#								SYNOMODULE="volume"
# --name/--pkg-ver/--vendor
#								NONE
# --post	
#								DEVICE: mount device (ex: /dev/md1) 
#								MOUNTPOINT: mount point (ex: /volume1) 
#								TYPE: file system type (ex: ext4) 
#								LOCATION: location ("INTERNAL", "EUNIT", "USB", "ESATA")

SS_COMMON_SCRIPT=/usr/local/libexec/SurveillanceStationCommon.sh
. ${SS_COMMON_SCRIPT}

RestoreDBTableIfNonExist()
{
	if [ ! -f "${SS_REC_DB}" ] || [ ! -s "${SS_REC_DB}"]; then
		SSDebugLog "Recording db not exists or size=0, prepare it."
		${SQLITE3} "${SS_REC_DB}" < "${SS_REC_SQL_SCRIPT}" > /dev/null 2>&1
	fi
	if [ ! -f "${SS_REC_CNT_DB}" || [ ! -s "${SS_REC_CNT_DB}"]; then
		SSDebugLog "Recording count db not exists or size=0, prepare it."
		${SQLITE3} "${SS_REC_CNT_DB}" < "${SS_REC_CNT_SQL_SCRIPT}" > /dev/null 2>&1
	fi
	if [ ! -f "${SS_AXISACSEVTLOG_DB}" || [ ! -s "${SS_AXISACSEVTLOG_DB}"]; then
		SSDebugLog "axisacsevtlog db not exists or size=0, prepare it."
		${SQLITE3} "${SS_AXISACSEVTLOG_DB}" < "${SS_AXISACSEVTLOG_SQL_SCRIPT}" > /dev/null 2>&1
	fi
	if [ ! -f "${SS_SNAPSHOT_DB}" || [ ! -s "${SS_SNAPSHOT_DB}"]; then
		SSDebugLog "snapshot db not exists or size=0, prepare it."
		${SQLITE3} "${SS_SNAPSHOT_DB}" < "${SS_SNAPSHOT_SQL_SCRIPT}" > /dev/null 2>&1
	fi
}

PostMount()
{
	if [ false == $(IsNonRecordingMode) -o \
		 false == $(IsValidSSVolumeLocation "${LOCATION}") ]; then
		if [ "USB" == "${LOCATION}" ]; then
			USBVolumeMounted "${MOUNTPOINT}"
		fi

		return
	fi

	local blLeaveNonRecMode=true

	if [ -L "${SS_SHARE_FOLDER_LINK}" ]; then
		SSDebugLog "Surveillance share folder found on the mounted volume."
		RestoreDBTableIfNonExist
	else
		SSDebugLog "Surveillance share folder not found. Try to rebuild a new one."
		PrepareShareFolder true "${MOUNTPOINT}"
		local Ret="$?"

		if [ 0 -ne ${Ret} ]; then
			SSDebugLog "Failed to rebuild surveillance share folder."
			blLeaveNonRecMode=false
		fi
	fi

	if [ true == ${blLeaveNonRecMode} ]; then
		SSDebugLog "Leave non-recording mode due to new volume mounted."
		UpdateActiveVolume
		SetNonRecordingMode false volume
	fi
}

main()
{
	PackageInfoGet
	
	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--post)
			PostMount
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"
