#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

# --sdk-mod-ver
#								SYNOMODULE="volume"
# --name/--pkg-ver/--vendor
#								NONE
# --pre / --post	
#								DEVICE: device (ex: /dev/md1) 
#								MOUNTPOINT: mount point (ex: /volume1) 
#								TYPE: file system type (ex: ext4) 
#								LOCATION: location ("INTERNAL", "EUNIT", "USB", "ESATA")

SS_COMMON_SCRIPT=/usr/local/libexec/SurveillanceStationCommon.sh
. ${SS_COMMON_SCRIPT}

PreUnmount()
{
	if [ false == $(ShouldHandleVolumeEvent) -o \
		 false == $(IsValidSSVolumeLocation "${LOCATION}") ]; then
		return
	fi

	local ActiveVolume=$(GetValueFromConfFile "${SS_SETTINGS_CONF}" "${CONF_KEY_ACTIVE_VOLUME}")
	if [ -n "$(echo ${ActiveVolume} | grep "@sharebin")" ]; then
		ActiveVolume="$(dirname ${ActiveVolume})"
	fi

	if [ ${MOUNTPOINT} == ${ActiveVolume} ]; then
		SSDebugLog "Active volume[${ActiveVolume}] is unmounted. Enter non-recording mode."
		SetNonRecordingMode true volume
	fi
}

main()
{
	PackageInfoGet;

	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--pre)
			PreUnmount
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
	esac
}

main "$@"
