
CREATE TABLE event (
	id						integer PRIMARY KEY AUTOINCREMENT,
	camera_id					integer,
	video_width					integer,
	video_height				integer,
	start_time					integer,
	stop_time					integer,
	update_time					integer,
	framecount					integer,
	cause						integer,
	archived					boolean,
	path						text,
	filesize					integer,
	video_type					integer,
	recording					boolean DEFAULT '0',
	audfmt						text,
	mark_as_del					boolean DEFAULT '0',
	closing 					boolean DEFAULT '0',
	ds_id						integer DEFAULT 0,
	id_on_rec_server			integer DEFAULT 0,
	cam_id_on_rec_server		integer DEFAULT 0,
	snapshot_small				text,
	snapshot_medium				text,
	edge_storage_recording_id	integer DEFAULT -1,
	for_rotation_only			boolean DEFAULT '0',
	fisheye_origin_view			boolean DEFAULT '1'
);

CREATE INDEX IF NOT EXISTS event_start_time_idx  ON event(start_time);
CREATE INDEX IF NOT EXISTS event_update_time_idx ON event(update_time);
CREATE INDEX IF NOT EXISTS event_recording_idx   ON event(recording);

CREATE TABLE analyticsEvent (
	id				integer PRIMARY KEY AUTOINCREMENT,
	user_id			integer DEFAULT 0,
	ds_id			integer DEFAULT 0,
	camera_id		integer DEFAULT 0,
	camera_name		varchar(256),
	event_id		integer DEFAULT 0,
	type			integer DEFAULT 0,
	start_time		integer DEFAULT 0,
	stop_time		integer DEFAULT 0,
	archived		boolean DEFAULT '0',
	video_width		integer,
	video_height	integer,
	framecount		integer,
	path			text,
	filesize		integer,
	video_type		integer,
	audfmt			text,
	recording		boolean DEFAULT '0',
	closing			boolean DEFAULT '0',
	mark_as_del		boolean DEFAULT '0'
);

CREATE TABLE log (
	id					integer PRIMARY KEY AUTOINCREMENT,
	dsid				integer DEFAULT 0,
	id_on_rec_server	integer DEFAULT 0,
	level				integer,
	timestamp			integer,
	update_time			integer,
	event_msg			text,
	log_type			bigint DEFAULT -1,
	log_grp				integer DEFAULT -1,
	item_id				bigint DEFAULT -1
);

CREATE INDEX IF NOT EXISTS log_timestamp_idx ON log(timestamp);

CREATE TABLE edgevideoclip (
	id						integer PRIMARY KEY AUTOINCREMENT,
	cam_id					integer DEFAULT 0,
	status					integer DEFAULT 0,
	start_time				bigint DEFAULT 0,
	stop_time				bigint DEFAULT 0,
	video_type				integer DEFAULT 0,
	audio_type				integer DEFAULT 0,
	owner_ds_id				integer DEFAULT 0,
	path					text DEFAULT '',
	streaming_type			integer DEFAULT 0,
	media_port				integer DEFAULT -1,
	retrieve_method			integer DEFAULT 0,
	width					integer DEFAULT 0,
	height					integer DEFAULT 0,
	framerate				integer DEFAULT 0,
	fisheye_view			boolean DEFAULT '0',
	enable_audio			boolean DEFAULT '0',
	download_type			integer DEFAULT 0
);

CREATE TABLE actrulehistory (
	id				integer PRIMARY KEY AUTOINCREMENT,
	level			integer DEFAULT 0,
	timestamp		integer default 0,
	rule_name		varchar(512),
	rule_type		integer DEFAULT 0,
	act_status		integer DEFAULT 0
);
CREATE INDEX IF NOT EXISTS rulehistory_timestamp_idx ON actrulehistory(timestamp);

CREATE TABLE customaudiopattern (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256) DEFAULT '',
	length			integer default 0,
	description		varchar(256) DEFAULT '',
	filefmt			varchar(8) DEFAULT '',
	is_default		boolean DEFAULT '0'
);
INSERT INTO customaudiopattern (id) VALUES (10);
