
CREATE TABLE camera (
	id							integer PRIMARY KEY AUTOINCREMENT,
	enabled						boolean,
	name						varchar(256),
	type						integer,
	api							integer,
	vendor						varchar(128),
	model						varchar(128),
	hostname					varchar(256),
	port						integer,
	media_port					integer,
	live_media_port				integer,
	stmout_port					integer,
	path						varchar(512),
	live_path					varchar(512),
	username					varchar(128),
	password					varchar(128),
	fps							integer,
	fps_2						integer DEFAULT 0,
	image_width					integer,
	image_height				integer,
	rec_time					integer,
	enable_audio				boolean DEFAULT '0',
	recording_path				varchar(256),
	recording_prefix			varchar(256),
	recording_capacity			integer,
	recording_days				integer,
	enable_capacity				boolean,
	enable_days					boolean,
	motion_sensitivity			integer,
	motion_threshold			integer,
	motion_object_size			integer,
	motion_percentage			integer,
	enable_motionlog			boolean,
	schedule					varchar(512),
	notifyschedule				varchar(2048) DEFAULT '7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF',
	resolution					varchar(128),
	video_type					integer,
	streaming_type				integer,
	enable_camera_motion		boolean,
	enable_io_log				boolean,
	liveview_all				boolean,
	quality						varchar(128),
	live_quality				varchar(128),
	live_resolution				varchar(128),
	live_fps					integer DEFAULT 0,
	channel						varchar(128),
	liveview_mode				integer DEFAULT 0,
	rotation_option				integer DEFAULT 0,
	pre_rec_time				integer DEFAULT 5,
	post_rec_time				integer DEFAULT 5,
	audio_format				integer DEFAULT 0,
	exporting					integer DEFAULT 0,
	enable_manual_rec			boolean DEFAULT '0',
	cap_file_path				varchar(128),
	is_deleted					boolean DEFAULT '0',
	status_flags				integer DEFAULT 0,
	occupied_size				integer DEFAULT 0,
	live_analytics_type			integer DEFAULT 0,
	live_analytics_setting		integer DEFAULT 0,
	live_analytics_sensitivity	integer DEFAULT 0,
	live_analytics_dwell_time	integer DEFAULT 5,
	live_analytics_direction	integer DEFAULT 1,
	live_analytics_width		integer DEFAULT 0,
	live_analytics_height		integer DEFAULT 0,
	live_analytics_obj_size		integer DEFAULT 0,
	live_analytics_region		varchar(800),
	mount_type					integer DEFAULT 0,
	param_chklist				integer DEFAULT 0,
	time_server					text,
	osd_status					boolean DEFAULT '1',
	osd_position				integer DEFAULT 0,
	osd_format					integer DEFAULT 0,
	exposure_mode				integer DEFAULT 0,
	daybegin					integer DEFAULT 0,
	dayend						integer DEFAULT 0,
	video_mirror				boolean DEFAULT '1',
	video_flip					boolean DEFAULT '1',
	video_rotation				integer DEFAULT 0,
	exposure_control			integer DEFAULT 0,
	onvif_profile				varchar(256),
	tunneling 					boolean DEFAULT '0',
	owner_ds_id 				integer DEFAULT 0,
	id_on_rec_server 			integer DEFAULT 0,
	status_on_rec_server		integer DEFAULT 0,
	rec_status_on_rec_server	integer DEFAULT 0,
	device_type					integer DEFAULT 1,
	fov							varchar(256) DEFAULT '',
	rec_stream_no				integer DEFAULT 0,
	live_stream_no				integer DEFAULT 0,
	rec_bitrate_ctrl			integer DEFAULT 1,
	live_bitrate_ctrl			integer DEFAULT 1,
	rec_cbr_bitrate				integer DEFAULT 0,
	live_cbr_bitrate			integer DEFAULT 0,
	tv_standard					integer DEFAULT 0,
	rtsp_protocol				integer DEFAULT 0,
	edge_storage_enabled		boolean DEFAULT '0',
	edge_storage_sch			varchar(512) DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111',
	brightness					integer DEFAULT 0,
	contrast					integer DEFAULT 0,
	saturation					integer DEFAULT 0,
	sharpness					integer DEFAULT 0,
	volume						integer DEFAULT 50,
	mobile_media_port			integer DEFAULT 0,
	mobile_quality				varchar(128),
	mobile_resolution			varchar(128),
	mobile_fps					integer DEFAULT 0,
	mobile_path					varchar(512),
	mobile_stream_no			integer DEFAULT 0,
	mobile_bitrate_ctrl			integer DEFAULT 1,
	mobile_cbr_bitrate			integer DEFAULT 0,
	mute						boolean DEFAULT '0',
	update_time					integer DEFAULT 0,
	pt_speed					integer DEFAULT 3,
	zoom_speed					integer DEFAULT 3,
	ptz_speed_keep_origin		boolean DEFAULT '0',
	ui_stream_no				text,
	custom_detect				integer DEFAULT 1,
	custom_alarm_detect			integer DEFAULT -1
);

CREATE INDEX IF NOT EXISTS camera_update_time_idx ON camera (update_time);

CREATE TRIGGER IF NOT EXISTS camera_update_time AFTER UPDATE ON camera BEGIN
	UPDATE OR IGNORE camera SET update_time = strftime('%s','now') WHERE id = new.id;
END;

CREATE TRIGGER IF NOT EXISTS camera_update_time_insert AFTER INSERT ON camera BEGIN
	UPDATE OR IGNORE camera SET update_time = strftime('%s','now') WHERE id = new.id;
END;

CREATE TABLE motion (
	id			integer PRIMARY KEY AUTOINCREMENT,
	camera_id	integer,
	name		varchar(256),
	top			integer,
	bottom		integer,
	m_left		integer,
	m_right		integer
);

CREATE TABLE notification (
	type					integer,
	server					varchar(256),
	port					integer,
	needauth				boolean,
	username				varchar(128),
	password				varchar(128),
	needssl					boolean,
	sendtestmail			boolean,
	email					varchar(512),
	email2					varchar(512),
	subject_prefix			varchar(128) DEFAULT '',
	sender_name				varchar(128) DEFAULT '',
	sender_mail				varchar(512) DEFAULT '',
	attach_snapshot			boolean default '1',
	enable_msg_interval		boolean default '0',
	msg_interval			integer default 1
);

INSERT INTO notification(type, server, port, needauth, username, password, needssl, sendtestmail, email, email2)
VALUES (0, '', 25, '0', '', '', '0', '0', '', '');

CREATE TABLE camerastatus (
	cameraid	integer PRIMARY KEY,
	status		integer,
	pid			integer,
	updatetime	integer
);

CREATE TABLE licensekey (
	id				integer PRIMARY KEY AUTOINCREMENT,
	camera_count	integer,
	key				text,
	serial			varchar(64),
	owner_ds_id		integer DEFAULT 0,
	install_date	integer DEFAULT 0
);

CREATE TABLE account (
	id								integer PRIMARY KEY AUTOINCREMENT,
	uid								bigint DEFAULT 0,
	name							text,
	privilege						integer,
	privprofileid					integer DEFAULT 0,
	init_module						varchar(64) DEFAULT '',
	def_layout_id					integer DEFAULT -1,
	def_timeline_layout_id			integer DEFAULT -1,
	photo_name						varchar(256),
	photo_width						integer,
	photo_height					integer,
	photo_tmstmp					integer DEFAULT 0,
	view_mode						text DEFAULT '',
	status							integer DEFAULT 1,
	remind_quickconnect_tunnel		boolean DEFAULT '1'
);

INSERT INTO account(name, privilege, privprofileid, uid) VALUES ('admin', 0, 3, 1024);

CREATE TABLE visualstation (
	id					integer PRIMARY KEY AUTOINCREMENT,
	enabled				boolean,
	name				text,
	mac_addr			varchar(64),
	camgrpid			integer DEFAULT -1,
	layout				integer,
	channel_1			integer,
	channel_2			integer,
	channel_3			integer,
	channel_4			integer,
	channel_5			integer,
	channel_6			integer,
	dhcp				boolean DEFAULT '1',
	ip					varchar(64),
	mask				varchar(64),
	gateway				varchar(64) DEFAULT '0.0.0.0',
	version				varchar(32),
	platform			varchar(32) DEFAULT 'VS60',
	max_ch				integer DEFAULT 6,
	channel_list		varchar(1024),
	def_layout			text,
	playing_layout		text,
	timezone			text,
	language			text,
	capflags			integer DEFAULT 0,
	notifyschedule		varchar(2048) DEFAULT 'F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F',
	owner_ds_id 		integer DEFAULT 0,
	id_on_rec_server	integer DEFAULT 0
);

CREATE TABLE vslayout (
	id					integer PRIMARY KEY AUTOINCREMENT,
	name				varchar(256),
	vs_id				integer,
	emap_id				integer,
	camgrp_id			integer DEFAULT -1,
	type				integer,
	is_default			boolean,
	fix_aspect_ratio	boolean DEFAULT '0',
	custom_pos_list		text
);

CREATE TABLE vslayoutchannel (
	id			integer PRIMARY KEY AUTOINCREMENT,
	layout_id	integer,
	location	integer,
	type		integer,
	ds_id		integer,
	item_id		integer,
	ds_name		varchar(256),
	item_name	varchar(256)
);

CREATE TABLE nvrconfig (
	id			integer PRIMARY KEY AUTOINCREMENT,
	def_layout	text,
	capflags	integer DEFAULT 0
);

INSERT INTO nvrconfig (def_layout)
VALUES ('0,0');

CREATE TABLE nvrlayout (
	id					integer PRIMARY KEY AUTOINCREMENT,
	name				varchar(256),
	emap_id				integer,
	camgrp_id			integer DEFAULT -1,
	type				integer,
	is_default			boolean,
	fix_aspect_ratio	boolean DEFAULT '0',
	custom_pos_list		text
);

INSERT INTO nvrlayout (name, emap_id, camgrp_id, type, is_default, fix_aspect_ratio, custom_pos_list)
VALUES ('Default', 0, -1, 6, '1', '0', '');

CREATE TABLE nvrlayoutchannel (
	id			integer PRIMARY KEY AUTOINCREMENT,
	layout_id	integer,
	location	integer,
	type		integer,
	ds_id		integer,
	item_id		integer,
	ds_name		varchar(256),
	item_name	varchar(256)
);

CREATE TABLE smsprovider (
	id			integer PRIMARY KEY AUTOINCREMENT,
	name		text,
	port		integer,
	fullurl		text,
	template	text,
	sepchar		varchar(4),
	needssl		boolean
);

INSERT INTO smsprovider(name, port, fullurl, template, sepchar, needssl)
VALUES ('clickatell', 80, 'http://api.clickatell.com/http/sendmsg?user=Syno&password=1234&api_id=&to=886&text=Hello+world',
		'https://api.clickatell.com/http/sendmsg?user=@@USER@@&password=@@PASS@@&api_id=&to=@@PHONE@@&text=@@TEXT@@',
		'+', '1');

CREATE TABLE notificationsms (
	type			integer,
	server			varchar(512),
	username		varchar(128),
	password		varchar(128),
	phone1prefix	varchar(4),
	phone1code		varchar(10),
	phone1num		varchar(512),
	phone2prefix	varchar(4),
	phone2code		varchar(10),
	phone2num		varchar(512),
	needinterval	boolean,
	interval		integer
);

INSERT INTO notificationsms(type,server,username,password,phone1prefix,phone1code,phone1num,phone2prefix,phone2code,phone2num,needinterval,interval)
VALUES (0,'clickatell','','','','','','','','','0',1);

CREATE TABLE notificationfilter (
	addcamera				integer,
	deletecamera			integer,
	connectionlost			integer,
	connectionresume		integer,
	recordingfailed			integer,
	motiondetected			integer,
	alarmtriggered			integer,
	motionalarmtriggered	integer,
	rotationlimitreached	integer,
	vsadded					integer,
	vsdeleted				integer,
	vsconnectionlost		integer,
	vsconnectionresume		integer,
	rec_storage_removed		integer DEFAULT 1,
	rec_storage_installed	integer DEFAULT 1
);

CREATE TABLE notificationpushservice (
	mobile_enable			boolean,
	msn_enable				boolean,
	skype_enable			boolean,
	msn_account				varchar(256),
	msn_bot					varchar(256),
	skype_account			varchar(256),
	skype_bot				varchar(256),
	syno_mail_enable		boolean DEFAULT '0',
	mail_account			varchar(1024) DEFAULT '',
	ds_serial				varchar(64) DEFAULT '--',
	attach_snapshot			boolean default '1',
	enable_msg_interval		boolean default '0',
	msg_interval			integer default 1
);

INSERT INTO notificationpushservice(mobile_enable, msn_enable, skype_enable, msn_account, msn_bot, skype_account, skype_bot)
VALUES ('0','0','0','','--','','--');

INSERT INTO notificationfilter(addcamera, deletecamera, connectionlost,connectionresume,
recordingfailed, motiondetected, alarmtriggered, motionalarmtriggered, rotationlimitreached,
vsadded, vsdeleted, vsconnectionlost, vsconnectionresume, rec_storage_removed, rec_storage_installed)
VALUES (1,1,1,1,1,1,1,1,1,1,1,1,1,1,1);

CREATE TABLE layout (
	id					integer PRIMARY KEY AUTOINCREMENT,
	name				varchar(256),
	emapid				integer,
	camgrpid			integer DEFAULT -1,
	type				integer,
	interval			integer,
	isdefault			boolean,
	fix_aspect_ratio	boolean DEFAULT '0',
	custom_pos_list		text,
	app_type			integer
);

CREATE TABLE layoutcamera (
	id					integer PRIMARY KEY AUTOINCREMENT,
	layoutid			integer,
	location			integer,
	dsid				integer,
	cameraid			integer,
	regionid			integer,
	dsname				varchar(256),
	cameraname			varchar(256),
	fisheye_type		integer,
	region_name			varchar(256),
	region_type			integer,
	item_type			integer,
	mountid				integer,
	analytics_enabled	boolean DEFAULT '0',
	item_id				integer DEFAULT -1
);

CREATE TABLE ssgeneric (
	central_enable			boolean,
	central_mode			integer,
	central_key				varchar(256),
	central_host_ds_name	varchar(256) DEFAULT '',
	central_host_mac		varchar(256) DEFAULT '',
	central_host_ip			varchar(256) DEFAULT '',
	central_host_port		integer DEFAULT 0,
	central_host_model		varchar(256) DEFAULT '',
	notifyschedule			varchar(2048),
	vsnotifyschedule		varchar(2048),
	nvr_enable				boolean
);

INSERT INTO ssgeneric (central_enable, central_mode, central_key, central_host_ds_name, central_host_mac, central_host_ip, central_host_port, central_host_model, notifyschedule, vsnotifyschedule, nvr_enable)
VALUES ('0', 2, '', '', '', '', 0, '', '7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF',
'F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F,F', '1');

CREATE TABLE slaveds (
	id						integer PRIMARY KEY AUTOINCREMENT,
	name					varchar(256),
	ip						varchar(256),
	port					integer,
	key						varchar(256),
	ss_version				varchar(256) DEFAULT '',
	dp_version				varchar(256) DEFAULT '',
	ds_model				varchar(256) DEFAULT '',
	enable					boolean,
	cms_locked				boolean DEFAULT '0',
	type					integer DEFAULT 0,
	max_cam_num				integer DEFAULT 1,
	default_license_cnt		integer DEFAULT 0,
	status					integer DEFAULT 0,
	cookie					varchar(256) DEFAULT '',
	mac_addr				varchar(256) DEFAULT '',
	camera_count			integer DEFAULT 0,
	admin_username			varchar(128) DEFAULT 'admin',
	admin_passwd			varchar(256) DEFAULT '',
	failed_sync_log_id		integer DEFAULT 0,
	failed_sync_rec_id		integer DEFAULT 0,
	cms_masked				boolean DEFAULT '0',
	cms_sync_time			boolean DEFAULT '0',
	volSpace				numeric DEFAULT 0,
	verify					text,
	status_flags			integer DEFAULT 0,
	serial_num				varchar(256) DEFAULT '',
	dsm_version				varchar(256) DEFAULT ''
);

CREATE TABLE patrol (
	id			integer PRIMARY KEY AUTOINCREMENT,
	camid		integer,
	name		varchar(256),
	stayTime	integer DEFAULT 5,
	speed		integer DEFAULT 3
);

CREATE TABLE patrolPresetData (
	id			integer PRIMARY KEY AUTOINCREMENT,
	patrolId	integer,
	camId		integer,
	position	integer,
	name		varchar(256),
	sequence	integer,
	stayTime	integer DEFAULT 5,
	speed		integer DEFAULT 3
);

CREATE TABLE guard (
	camid		integer PRIMARY KEY,
	cycle		integer,
	interval	integer
);

CREATE TABLE guardSchedule (
	id			integer PRIMARY KEY AUTOINCREMENT,
	camid		integer,
	day			integer,
	halfHour	integer,
	type		integer,
	patrolId	integer
);

CREATE TABLE emap (
	id					integer PRIMARY KEY AUTOINCREMENT,
	name				varchar(256),
	filename			varchar(256),
	imgW				integer,
	imgH				integer,
	owner_ds_id			integer DEFAULT 0,
	id_on_rec_server	integer DEFAULT 0
);

CREATE TABLE emapItem (
	id				integer PRIMARY KEY AUTOINCREMENT,
	emapId  		integer,
	type			integer,
	refId			integer,
	refName			varchar(256),
	dsId			integer,
	xPos			integer,
	yPos			integer,
	direction		integer,
	txtPos			integer,
	iconCenterX		integer DEFAULT 0,
	iconCenterY		integer DEFAULT 0
);

CREATE TABLE preset (
	id			integer PRIMARY KEY AUTOINCREMENT,
	camid		integer,
	position	integer,
	name		varchar(256),
	speed		integer DEFAULT 3
);

CREATE TABLE eventexport (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256),
	expid			varchar(64),
	camlistid		varchar(128),
	dstdir			varchar(1024),
	start_time		integer,
	stop_time		integer,
	export_time		integer,
	total_size		integer,
	total_count		integer,
	exported_count	integer,
	status			integer,
	src_ds_id		integer DEFAULT 0,
	dst_ds_id		integer DEFAULT 0
);

CREATE TABLE eventmount (
	id			integer PRIMARY KEY AUTOINCREMENT,
	ds_id 		integer DEFAULT 0,
	name		varchar(256),
	expid		varchar(64),
	camlist		varchar(1024),
	srcdir		varchar(1024),
	share_name	varchar(1024),
	start_time	integer,
	stop_time	integer,
	enable		boolean,
	version 	integer DEFAULT 0,
	db_status	integer DEFAULT 0
);

CREATE TABLE privilege (
	id			integer PRIMARY KEY AUTOINCREMENT,
	uid			integer,
	dsId		integer,
	inaCamIds	text
);

CREATE TABLE sswebinfo (
	init_module	varchar(64)
);

INSERT INTO sswebinfo (init_module)
VALUES ('');

CREATE TABLE cameragroup (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256),
	description		varchar(256)
);

CREATE TABLE cameragroupcam (
	id						integer PRIMARY KEY AUTOINCREMENT,
	camgrpid				integer,
	dsid					integer,
	cameraid				integer,
	cam_id_on_rec_server	integer DEFAULT 0,
	dsname					varchar(256),
	cameraname				varchar(256)
);

CREATE TABLE privilegeprofile (
	id						integer PRIMARY KEY AUTOINCREMENT,
	name					varchar(256),
	privilege				integer,
	inacamids				text DEFAULT '',
	inacamgrpids			text DEFAULT '',
	allcamdsids				text DEFAULT '',
	custom_uid				integer,
	description				varchar(256),
	ina_emap_ids			text DEFAULT '',
	ina_layout_ids			text DEFAULT '',
	ina_adv_oper			integer DEFAULT 0,
	all_emap_ds_ids			text DEFAULT '',
	all_layout_type			interger DEFAULT 0,
	ina_edit_emap_ids		text DEFAULT '-1',
	ina_edit_layout_ids		text DEFAULT '-1',
	all_edit_emap_ds_ids	text DEFAULT '',
	all_edit_layout_type	integer DEFAULT 0
);

INSERT INTO privilegeprofile(name, privilege, inacamids, inacamgrpids, allcamdsids, custom_uid, description)
VALUES ('All-Object Manager', 1, '', '', '', 0, 'System default manager');
INSERT INTO privilegeprofile(name, privilege, inacamids, inacamgrpids, allcamdsids, custom_uid, description)
VALUES ('All-Object Spectator', 2, '', '', '', 0, 'System default spectator');
INSERT INTO privilegeprofile(name, privilege, inacamids, inacamgrpids, allcamdsids, custom_uid, description)
VALUES ('', 0, '', '', '', 0, 'System default admin');

CREATE TABLE privilegeprofilecam (
	id				integer PRIMARY KEY AUTOINCREMENT,
	privprofileid	integer,
	dsid			integer,
	inacamids		text
);

CREATE TABLE fisheyeregion (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256),
	camera_id		integer DEFAULT 0,
	type			integer DEFAULT 0,
	position_x		integer DEFAULT 0,
	position_y		integer DEFAULT 0,
	zoom			integer DEFAULT 0,
	subregion_info	varchar(512) DEFAULT ''
);

CREATE TABLE migration (
	id					integer PRIMARY KEY AUTOINCREMENT,
	dstCamId			integer DEFAULT 0,
	srcCamId			integer DEFAULT 0,
	camName				varchar(256) DEFAULT '',
	ip					varchar(256) DEFAULT '',
	size				integer DEFAULT 0,
	status				integer DEFAULT 0,
	progress			real DEFAULT 0,
	src					integer DEFAULT 0,
	dst					integer DEFAULT 0
);

CREATE TABLE joystick (
	model				varchar(128) PRIMARY KEY,
	options				varchar(2048)
);

CREATE TABLE privilegepercamera (
	id						integer PRIMARY KEY AUTOINCREMENT,
	privprofile_id			integer,
	ina_live_cam_ids		text DEFAULT '',
	ina_play_cam_ids		text DEFAULT '',
	ina_lens_cam_ids		text DEFAULT '',
	ina_audio_cam_ids		text DEFAULT '',
	ina_live_camgrp_ids		text DEFAULT '',
	ina_play_camgrp_ids		text DEFAULT '',
	ina_lens_camgrp_ids		text DEFAULT '',
	ina_audio_camgrp_ids	text DEFAULT '',
	live_allcamds_ids		text default '',
	play_allcamds_ids		text default '',
	lens_allcamds_ids		text default '',
	audio_allcamds_ids		text default ''
);

INSERT INTO privilegepercamera(privprofile_id, ina_live_cam_ids, ina_play_cam_ids, ina_lens_cam_ids, ina_audio_cam_ids,
							   ina_live_camgrp_ids, ina_play_camgrp_ids, ina_lens_camgrp_ids, ina_audio_camgrp_ids,
							   live_allcamds_ids, play_allcamds_ids, lens_allcamds_ids, audio_allcamds_ids)
VALUES (1, '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO privilegepercamera(privprofile_id, ina_live_cam_ids, ina_play_cam_ids, ina_lens_cam_ids, ina_audio_cam_ids,
							   ina_live_camgrp_ids, ina_play_camgrp_ids, ina_lens_camgrp_ids, ina_audio_camgrp_ids,
							   live_allcamds_ids, play_allcamds_ids, lens_allcamds_ids, audio_allcamds_ids)
VALUES (2, '', '', '', '', '', '', '', '', '', '', '', '');
INSERT INTO privilegepercamera(privprofile_id, ina_live_cam_ids, ina_play_cam_ids, ina_lens_cam_ids, ina_audio_cam_ids,
							   ina_live_camgrp_ids, ina_play_camgrp_ids, ina_lens_camgrp_ids, ina_audio_camgrp_ids,
							   live_allcamds_ids, play_allcamds_ids, lens_allcamds_ids, audio_allcamds_ids)
VALUES (3, '', '', '', '', '', '', '', '', '', '', '', '');

CREATE TABLE edgestoragesettings (
	id  					integer PRIMARY KEY AUTOINCREMENT,
	cam_id 					integer DEFAULT 0,
	cam_id_on_rec_server 	integer DEFAULT 0,
	owner_ds_id				integer DEFAULT 0,
	enabled 				boolean DEFAULT '0',
	retrieve_method			integer DEFAULT 0,
	download_sch 			varchar(512) DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111',
	edge_rec_sch_days		integer DEFAULT 127,
	edge_rec_start_time		string DEFAULT '00:00',
	edge_rec_stop_time		string DEFAULT '00:00',
	edge_rec_mode			integer DEFAULT 0,
	last_download_clip_id	integer DEFAULT 0,
	last_getlost_clip_id	integer DEFAULT 0
);

CREATE TABLE actionrule (
	id  				integer PRIMARY KEY AUTOINCREMENT,
	name 				varchar(512),
	status				integer DEFAULT 0,
	rule_type			integer DEFAULT 0,
	act_type			integer DEFAULT 0,
	evt_source			integer DEFAULT 0,
	evt_server_id		integer DEFAULT 0,
	evt_device_id		integer DEFAULT 0,
	evt_id				integer DEFAULT 0,
	evt_item			integer DEFAULT -1,
	evt_min_interval	integer DEFAULT 10,
	act_source			integer DEFAULT 0,
	act_server_id		integer DEFAULT 0,
	act_device_id		integer DEFAULT 0,
	act_id				integer DEFAULT 0,
	act_item_id			integer DEFAULT 0,
	act_times			integer DEFAULT 1,
	act_time_unit		integer DEFAULT 1,
	act_time_duration	integer DEFAULT 10,
	act_return_pos		integer DEFAULT 0,
	schedule 			varchar(512) DEFAULT '111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111',
	ext_url				text,
	username			varchar(128),
	password			varchar(128),
	enabled				boolean DEFAULT '1'
);

CREATE TABLE camdeviceoutput (
	id						integer PRIMARY KEY AUTOINCREMENT,
	cam_id					integer DEFAULT 0,
	cam_id_on_rec_server 	integer DEFAULT 0,
	owner_ds_id				integer DEFAULT 0,
	type					integer DEFAULT 0,
	keep					boolean DEFAULT '1',
	idx						integer DEFAULT 0,
	audio_gain				varchar(32) DEFAULT '0',
	normal_state			integer DEFAULT 0,
	trigger					boolean DEFAULT '0'
);

CREATE TABLE audiopattern (
	id				integer PRIMARY KEY AUTOINCREMENT,
	name			varchar(256) DEFAULT '',
	length			integer default 0,
	description		varchar(256) DEFAULT '',
	filefmt			varchar(8) DEFAULT '',
	is_default		boolean DEFAULT '0'
);

CREATE TABLE camdetsetting (
	id						integer PRIMARY KEY AUTOINCREMENT,
	cam_id					integer DEFAULT 0,
	cam_id_on_rec_server 	integer DEFAULT 0,
	owner_ds_id				integer DEFAULT 0,
	type					integer DEFAULT 0,
	keep					boolean DEFAULT '1',
	idx						integer DEFAULT 0,
	det_src					integer DEFAULT 0
	sensitivity				integer DEFAULT 0,
	threshold				integer DEFAULT 0,
	object_size				integer DEFAULT 0,
	percentage				integer DEFAULT 0,
	duration				integer DEFAULT 0,
	normal_state			integer DEFAULT 0,
	level					integer DEFAULT 0,
	notifyschedule			text DEFAULT '7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF,7FF',
	region					varchar(305) DEFAULT 'FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF'
);
