#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

TestTableColumnToRunScript -t "camera" -c "update_time" -s "169_camera_update_time.sql"

ExecuteSqlCmd "system" "CREATE INDEX IF NOT EXISTS camera_update_time_idx ON camera (update_time);\
CREATE TRIGGER IF NOT EXISTS camera_update_time AFTER UPDATE ON camera BEGIN\
	UPDATE OR IGNORE camera SET update_time = strftime('%s','now') WHERE id = new.id;\
END;\
CREATE TRIGGER IF NOT EXISTS camera_update_time_insert AFTER INSERT ON camera BEGIN\
	UPDATE OR IGNORE camera SET update_time = strftime('%s','now') WHERE id = new.id;\
END;"
