/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.namespace("SYNO.SS.App.AxisAcsCtrler");Ext.define("SYNO.SS.App.AxisAcsCtrler.AdvancedDlgPanel",{extend:"SYNO.ux.FormPanel",ADV_LABEL_WIDTH:240,ADV_FIELD_WIDTH:280,DOOR_ID_PREFIX:"aacDoor",MAX_DOOR_CNT:2,parentWin:null,model:null,cmbNetTimeServer:null,dsTimeZone:null,cmbTimeZone:null,fldSetTimeSync:null,constructor:function(a){this.parentWin=a.parentWin;this.model=a.model;this.Init();Ext.applyIf(a,{title:_T("ss_common","advanced"),itemId:"advanced",items:[this.fldSetTimeSync]});this.callParent([a])},Init:function(){var a=this.model.GetDeviceInfo();this.cmbNetTimeServer=new SYNO.ux.ComboBox({name:"timeServer",fieldLabel:_T("ss_common","ntpdate_server"),mode:"local",store:new Ext.data.ArrayStore({id:0,fields:["name","displayText"],data:[["Surveillance Station",_T("common","displayname")],["pool.ntp.org","pool.ntp.org"],["time.nist.gov","time.nist.gov"],["disable",_T("ss_common","common_disable")]]}),valueField:"name",displayField:"displayText",editable:false,value:a.time_server||"Surveillance Station"});this.cmbNetTimeServer.setRawValue(this.cmbNetTimeServer.getValue());this.dsTimeZone=SYNO.SS.Utils.GetTimeZoneStore();this.cmbTimeZone=new SYNO.ux.ComboBox({name:"cmbTimeZone",fieldLabel:_T("ss_common","time_zone"),store:this.dsTimeZone,valueField:"value",displayField:"display",value:a.time_zone||_S("SS_TIMEZONE"),mode:"local",forceSelection:true,triggerAction:"all",editable:false,allowBlank:false});this.cmbTimeZone.setRawValue(this.cmbTimeZone.getValue());this.fldSetTimeSync=new SYNO.ux.FieldSet({title:_T("ss_common","time_sync"),autoHeight:true,collapsible:true,labelWidth:this.ADV_LABEL_WIDTH,defaults:{width:this.ADV_FIELD_WIDTH},items:[this.cmbNetTimeServer,this.cmbTimeZone]})},GetDoorId:function(a){var b=this.parentWin.findAppWindow();return this.DOOR_ID_PREFIX+"_"+b.getCMSAppDSId()+"_"+a},ApplyCtrlerObj:function(d){var c=this.model.GetDeviceInfo();Ext.apply(d,{time_server:this.cmbNetTimeServer.getValue(),time_zone:this.cmbTimeZone.getValue(),door:[]});var a,e,b;for(a=0;a<this.MAX_DOOR_CNT;a++){e=Ext.getCmp(this.GetDoorId(a));if(e){b=e.chbSetVideoSource.getValue();d.door.push({id:(c.door&&c.door[a])?c.door[a].id:undefined,name:e.fieldName.getValue(),enable_cam:b,cam_ds_id:(true===b)?e.cmbServer.getValue():0,cam_id:(true===b)?e.cmbCamera.getValue():0});if("number"!==typeof(d.door[a].cam_id)){if(c.door&&(_T("camera","conn_status_unknown")===d.door[a].cam_id)){d.door[a].cam_ds_id=c.door[a].cam_ds_id;d.door[a].cam_id=c.door[a].cam_id}else{d.door[a].cam_id=0}}}}},AppendDoorFldSets:function(c){var a;var b=c.length;for(a=0;a<b;a++){this.add(this.GetDoorFieldSet(a,c[a]))}this.doLayout()},RemoveDoorFldSets:function(){var a;for(a=0;a<this.MAX_DOOR_CNT;a++){this.remove(this.GetDoorId(a))}},GetDoorFieldSet:function(j,d){var c=function(n,m){var o=new Ext.data.JsonStore({fields:[{name:"id",type:"int"},{name:"name"},{name:"ownerDsId",type:"int"}]});n.filter("ownerDsId",m,false,true,true);SYNO.SS.Utils.StoreDataCopy(n,o);return o};var g=function(o,n){var m=o.getStore();if(m.getById(n)){o.setValue(n)}else{o.setValue(_T("camera","conn_status_unknown"))}};var k=new SYNO.SS.Form.NameTextField({name:"doorName"+j,value:d.name,width:this.ADV_FIELD_WIDTH,fieldLabel:_T("ss_common","common_name"),maxLength:32});k.setRawValue(d.name);var h=true;if(true===Ext.isDefined(d.enable_cam)){h=d.enable_cam}var f=new SYNO.SS.Form.Checkbox({boxLabel:_T("axis_access_controller","set_relative_video_source"),checked:h,handler:function(o,n){if(!this.ownerCt){return}var p=this.ownerCt.cmbServer;var m=this.ownerCt.cmbCamera;p.setDisabled(!n);m.setDisabled(!n);if(0===m.dsCamera.getCount()){m.setDisabled(true)}}});var b=c(this.model.GetDsCamera(),d.cam_ds_id||LOCAL_DS_ID);var l=d.cam_id;if(!l){if(0<b.getCount()){l=b.getAt(0).data.id}else{f.setValue(false)}}var i;if(true===this.model.IsCmsHost()){i=new SYNO.ux.ComboBox({fieldLabel:_T("ss_common","surveillance_server"),width:this.ADV_FIELD_WIDTH,mode:"local",store:this.model.GetDsDS(),valueField:"id",displayField:"name",editable:false,value:d.cam_ds_id||LOCAL_DS_ID});i.dsDS=this.model.GetDsDS();i.setDisabled(!f.checked);g(i,i.getValue())}else{i=new Ext.form.Hidden({value:LOCAL_DS_ID})}var a=new SYNO.ux.ComboBox({allowBlank:false,blankText:_T("camera","no_cam_found"),fieldLabel:_T("ss_common","common_camera"),width:this.ADV_FIELD_WIDTH,mode:"local",store:b,valueField:"id",displayField:"name",editable:false,value:l});a.dsCamera=this.model.GetDsCamera();a.dsId=i.getValue();a.SetValue=function(m){if(m){g(this,m)}else{this.setValue(_T("camera","no_cam_found"))}};a.UpdateStore=function(m){var n=c(this.dsCamera,m);this.bindStore(n);if(0<n.getCount()){this.SetValue(n.getAt(0).get("id"));this.setDisabled(false)}else{this.SetValue(0);this.setDisabled(true)}this.dsId=m};a.SetValue(l);if(0===a.dsCamera.getCount()){a.setDisabled(true)}else{a.setDisabled(!f.checked)}var e=new SYNO.ux.FieldSet({id:this.GetDoorId(j),title:String.format(_T("axis_access_controller","door_section"),j+1),autoHeight:true,collapsible:true,labelWidth:this.ADV_LABEL_WIDTH,items:[k,f,i,a]});e.fieldName=k;e.chbSetVideoSource=f;e.cmbServer=i;e.cmbCamera=a;e.dsCamera=this.model.GetDsCamera();if(true===this.model.IsCmsHost()){e.mon(i,"valid",function(n){var m=n.getValue();if("number"!==typeof(m)){n.dsDS.each(function(o){if(o.data.name===m){m=o.data.id;return false}})}if(m!==this.cmbCamera.dsId){this.cmbCamera.UpdateStore(m)}},e)}return e}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");Ext.define("SYNO.SS.App.AxisAcsCtrler.Search",{extend:"SYNO.SDS.ModalWindow",WINDOW_WIDTH:838,btnSearch:null,btnOK:null,gridCtrlers:null,dsCtrlers:null,selectedData:null,pid:0,offset:0,isSearching:false,timerQueryTimeout:null,reqId:null,constructor:function(b,c){this.Init();var a={owner:b,id:c,title:_T("axis_access_controller","controller_search_title"),width:this.WINDOW_WIDTH,height:574,bodyStyle:"padding: 8px;",onEsc:Ext.emptyFn,layout:"fit",items:this.gridCtrlers,buttons:[this.btnSearch,this.btnOK,{xtype:"syno_button",text:_T("ss_common","common_cancel"),handler:this.close,scope:this}],listeners:{beforeclose:function(){if(true===this.isSearching){this.SearchStop()}},scope:this}};this.callParent([a])},Init:function(){this.btnSearch=new SYNO.ux.Button({cls:"search_window_btn",text:_T("ss_common","common_search"),handler:this.OnStartStop,scope:this});this.btnOK=new SYNO.ux.Button({text:_T("ss_common","common_ok"),disabled:true,handler:this.OnOK,scope:this});this.dsCtrlers=new Ext.data.JsonStore({root:"ctrlers",fields:[{name:"vendor"},{name:"model"},{name:"ip"},{name:"port",type:"int"},{name:"mac"}]});var b=new Ext.grid.ColumnModel([{header:_T("camera","camera_attr_vendor"),align:"center",width:180,sortable:true,dataIndex:"vendor"},{header:_T("camera","camera_attr_model_name"),align:"center",width:180,sortable:true,dataIndex:"model"},{header:_T("camera","camera_attr_ip"),align:"center",width:160,sortable:true,dataIndex:"ip"},{header:_T("camera","camera_attr_port"),align:"center",width:80,sortable:true,dataIndex:"port"},{header:_T("camera","camera_attr_mac"),align:"center",width:220,sortable:true,dataIndex:"mac"}]);var a=new Ext.grid.RowSelectionModel({singleSelect:true});a.on("selectionchange",function(c){if(1===c.getSelections().length){this.btnOK.enable()}else{this.btnOK.disable()}},this);this.gridCtrlers=new SYNO.SS.Grid.GridPanel({store:this.dsCtrlers,cls:"grid_row_height_fixed",cm:b,sm:a,viewConfig:{forceFit:true},listeners:{celldblclick:function(d,f,e,c){this.OnOK()},scope:this},emptyStyleTip:_T("axis_access_controller","no_controller_found"),fnNeedApplyEmptyStyle:function(){return((false===this.isSearching)&&(0===this.dsCtrlers.getCount()))}.createDelegate(this)})},OnOK:function(){var a=this.gridCtrlers.getSelectionModel().getSelections();if(0<a.length){this.selectedData=a[0].data;this.close()}},OnStartStop:function(){if(true===this.isSearching){this.SearchStop()}else{this.SearchStart()}},SetSearchSts:function(a){if(true===a){this.setStatus({text:_T("ss_common","searching2"),iconCls:"syno-ux-statusbar-loading"})}else{this.clearStatus()}},SearchStart:function(){if(true===this.isSearching){return}this.isSearching=true;this.pid=0;this.offset=0;this.timerQueryTimeout=null;this.dsCtrlers.removeAll();this.SendRequest({action:"Start"},this.OnStartRequestDone);this.btnSearch.disable();this.SetSearchSts(true);this.gridCtrlers.UpdateEmptyStyle()},SearchStop:function(){if(false===this.isSearching){return}this.isSearching=false;if(this.timerQueryTimeout){window.clearTimeout(this.timerQueryTimeout);delete this.timerQueryTimeout;this.timerQueryTimeout=null}if(this.reqId){Ext.Ajax.abort(this.reqId)}this.gridCtrlers.UpdateEmptyStyle();this.btnSearch.enable();this.SetSearchSts(false)},SendRequest:function(a,b){this.reqId=this.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.SearchApi,method:a.action,version:1,params:a,callback:b,scope:this})},OnStartRequestDone:function(b,a){if(b){this.pid=a.pid;this.SearchQuery()}else{this.SearchStop();this.getMsgBox().alert(this.title,_T("axis_access_controller","controller_search_fail_msg"))}},SearchQuery:function(){if(true===this.isSearching){this.SendRequest({action:"InfoGet",pid:this.pid,offset:this.offset},this.OnSearchQueryDone)}},OnSearchQueryDone:function(b,a){if(b){if(false===this.isSearching){return}if((a.ctrlers)&&(0<a.ctrlers.length)){this.dsCtrlers.loadData(a,true);this.offset+=a.ctrlers.length}if(!a.alive){this.SearchStop();return}this.timerQueryTimeout=window.setTimeout(function(){this.SearchQuery()}.createDelegate(this),1000)}else{this.SearchStop();this.getMsgBox().alert(this.title,_T("ss_common","error_system"))}}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");Ext.define("SYNO.SS.App.AxisAcsCtrler.DeviceInfoDlgPanel",{extend:"SYNO.ux.FormPanel",FIELD_WIDTH:220,parentWin:null,model:null,fieldName:null,fieldIP:null,btnAutoSearch:null,dlgCtrlerSearch:null,fieldPort:null,cmbModel:null,fieldUserName:null,fieldPassword:null,btnCtrlerTest:null,panelCtrlerTestLoading:null,panelCtrlerTestOK:null,panelCtrlerTest:null,constructor:function(a){this.model=a.model;this.Init();Ext.applyIf(a,{title:_T("ss_common","device_info"),items:[this.fieldName,{xtype:"syno_panel",layout:"column",items:[{xtype:"syno_panel",width:374,layout:"form",items:this.fieldIP},{xtype:"syno_panel",width:30,style:"margin-left: 1px;",items:this.btnAutoSearch}]},this.fieldPort,this.cmbModel,this.fieldUserName,this.fieldPassword,this.panelCtrlerTest]});this.callParent([a])},Init:function(){var a=this.model.GetDeviceInfo();this.fieldName=new SYNO.SS.Form.NameTextField({name:"name",width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","common_name"),maxLength:32,value:a.name});this.fieldIP=new SYNO.ux.TextField({name:"ip",width:185,fieldLabel:_T("ss_common","ip_address"),maxLength:256,allowBlank:false,validateOnBlur:true,validationEvent:"blur",vtype:"iporhostname",value:a.host});this.btnAutoSearch=new SYNO.ux.Button({name:"autoSearch",iconCls:"icon_camera_search",tooltip:_T("ss_common","common_search"),handler:this.OnAutoSearch,scope:this});this.fieldPort=new SYNO.ux.TextField({name:"port",width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","port"),maxLength:5,allowBlank:false,validateOnBlur:true,validationEvent:"blur",vtype:"port",value:a.port||80});this.cmbModel=new SYNO.ux.ComboBox({name:"model",width:this.FIELD_WIDTH,listWidth:this.FIELD_WIDTH,fieldLabel:_T("ss_common","model"),mode:"local",store:new Ext.data.ArrayStore({id:0,fields:["displayText"],data:[["A1001"]]}),valueField:"displayText",displayField:"displayText",editable:false,value:"A1001"});this.fieldUserName=new SYNO.ux.TextField({name:"userName",width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","account_user_name"),preventAutoFill:true,maxLength:32,value:a.username});this.fieldPassword=new SYNO.ux.TextField({name:"password",width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","password"),inputType:"password",preventAutoFill:true,maxLength:24,value:a.password});this.btnCtrlerTest=new SYNO.ux.Button({text:_T("ss_common","test_connection"),style:"margin-left: 185px",handler:function(){this.fieldName.disable();this.OnCtrlerTest.call(this);this.fieldName.enable()},scope:this});this.panelCtrlerTestLoading=new SYNO.ux.Panel({hidden:true,width:22,html:"<img style='vertical-align:middle;' src='"+_IMG(SYNO.SS.Image.Syncing)+"'>",listeners:{show:function(b){this.btnCtrlerTest.disable()},hide:function(b){this.btnCtrlerTest.enable()},scope:this}});this.panelCtrlerTestOK=new SYNO.ux.Panel({hidden:true,width:22,html:"<img style='vertical-align:middle;' ext:qtip='"+_T("camera","conn_test_ok")+"' src='"+_IMG(SYNO.SS.Image.IconIndicatorSuccess)+"'>"});this.panelCtrlerTest=new SYNO.ux.Panel({layout:"table",layoutConfig:{columns:4},style:"margin-top: 8px;",items:[this.btnCtrlerTest,{xtype:"syno_panel",width:10,html:"<span>&nbsp;</span>"},this.panelCtrlerTestLoading,this.panelCtrlerTestOK]})},ApplyCtrlerObj:function(b){var a=this.model.GetDeviceInfo();Ext.apply(b,{id:a.id||0,name:this.fieldName.getValue(),host:this.fieldIP.getValue(),port:parseInt(this.fieldPort.getValue(),10),model:this.cmbModel.getValue(),username:this.fieldUserName.getValue(),password:this.fieldPassword.getValue()})},OnCtrlerTest:function(){if(false===this.getForm().isValid()){return}this.panelCtrlerTestLoading.show();this.panelCtrlerTestOK.hide();var a={ctrlerId:this.model.GetDeviceInfo().id||0,ip:this.fieldIP.getValue(),port:parseInt(this.fieldPort.getValue(),10),userName:this.fieldUserName.getValue(),password:this.fieldPassword.getValue()};this.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"TestConnect",version:1,params:a,callback:function(c,b){this.panelCtrlerTestLoading.hide();if(true===c){this.panelCtrlerTestOK.show()}else{SYNO.SS.Utils.Alert(this.parentWin.getMsgBox(),_T("axis_access_controller","axis_access_controller"),b.errors)}},scope:this})},OnAutoSearch:function(){this.dlgCtrlerSearch=Ext.WindowMgr.get("ctrler_search_dlg");if(!this.dlgCtrlerSearch){this.dlgCtrlerSearch=new SYNO.SS.App.AxisAcsCtrler.Search(this.parentWin,"ctrler_search_dlg")}this.dlgCtrlerSearch.show();this.dlgCtrlerSearch.SearchStart();this.dlgCtrlerSearch.on("beforeclose",function(){var a=this.dlgCtrlerSearch.selectedData;if(a){this.fieldIP.setValue(a.ip);this.fieldPort.setValue(a.port);this.fieldUserName.setValue("root")}},this)}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");Ext.define("SYNO.SS.App.AxisAcsCtrler.EditCtrlerDlgPlugin",{extend:"Object",constructor:function(a){this.parentOverrides.model=a.model;this.parentOverrides.owner=a.owner;this.parentOverrides.blResetOnClose=a.blResetOnClose},init:function(a){Ext.applyIf(a,this.parentOverrides)},parentOverrides:{panelDeviceInfo:null,panelAdvanced:null,doors:null,model:null,owner:null,blResetOnClose:false,InitForm:function(){this.InitFormDeviceInfo();this.InitFormAdvanced()},InitFormDeviceInfo:function(){this.panelDeviceInfo=new SYNO.SS.App.AxisAcsCtrler.DeviceInfoDlgPanel({model:this.model,parentWin:this})},InitFormAdvanced:function(){this.panelAdvanced=new SYNO.SS.App.AxisAcsCtrler.AdvancedDlgPanel({model:this.model,parentWin:this})},SaveDoor:function(){if((false===this.panelDeviceInfo.getForm().isValid())||(false===this.panelAdvanced.getForm().isValid())){return}var a=this.GetCtrlerObj();var b={arrayJson:Ext.encode([a])};this.owner.setStatusBusy();this.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"Save",version:1,params:b,callback:this.OnSaveDoor,scope:this,setBusy:_T("ss_common","common_saving")})},GetCtrlerObj:function(){var b=this.model.GetDeviceInfo();var a={enable:(undefined===b.enable)?true:b.enable};this.panelDeviceInfo.ApplyCtrlerObj(a);this.panelAdvanced.ApplyCtrlerObj(a);return a},OnSaveDoor:function(d,a){var c;var b;if(d){b=this.GetCtrlerObj();SYNO.SDS.StatusNotifier.fireEvent("doorEdited",b.door);this.owner.fireEvent("updateactivepage");if(true===this.blResetOnClose){this.Reset()}this.close()}else{this.owner.clearStatusBusy();if(SS_WEBAPI_ERR_IMPROPER_FIRMWARE_VER==a.code){c=String.format(_T("axis_access_controller","update_firmware_tip"),a.errors)}else{c=_T("ss_common","error_system")}this.getMsgBox().alert(this.title,c)}},PrepareAdvancedPanel:function(){if(false===this.model.PrepareAdvanced(this,this.GetCtrlerObj())){return false}else{this.doors=this.model.GetDoors();this.panelAdvanced.RemoveDoorFldSets();this.panelAdvanced.AppendDoorFldSets(this.doors);return true}},GoAdvancedPanel:function(){}}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");Ext.define("SYNO.SS.App.AxisAcsCtrler.AddCtrlerDialog",{extend:"SYNO.SDS.Wizard.ModalWindow",plugin:null,steps:null,constructor:function(a){this.plugin=new SYNO.SS.App.AxisAcsCtrler.EditCtrlerDlgPlugin({model:a.model,owner:a.owner});this.plugin.init(this);this.Init();Ext.apply(a,{title:_T("axis_access_controller","add_controller"),banner:false,width:640,height:480,steps:this.steps});this.callParent([a])},Init:function(){this.InitForm();this.InitForWizard()},InitForWizard:function(){this.panelDeviceInfo.getNext=function(){if(false===this.getForm().isValid()){return false}if(false===this.parentWin.PrepareAdvancedPanel()){return false}return"advanced"};this.panelAdvanced.getNext=function(){if(true===this.getForm().isValid()){this.parentWin.SaveDoor()}return false};this.panelAdvanced.activate=function(){this.disableNextInDemoMode=true;this.checkState()};this.steps=[this.panelDeviceInfo,this.panelAdvanced]},GoAdvancedPanel:function(){this.goNext(this.getActiveStep().getNext())}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");SYNO.SS.App.AxisAcsCtrler.CardHolder.GetStatusColor=function(a){if(SYNO.SS.App.AxisAcsCtrler.CardHolder.Status.Normal===a){return SYNO.SS.Color.NORMAL_GRAY}else{return SYNO.SS.Color.ALERT_RED}};Ext.define("SYNO.SS.App.AxisAcsCtrler.CardHolderExpandableListView",{extend:"SYNO.ux.ExpandableListView",owner:null,dsCtrler:null,constructor:function(a){this.owner=a.owner;this.dsCtrler=a.dsCtrler;var b=Ext.apply({innerTpl:this.GetInnerTpl(),iconTpl:new Ext.XTemplate("{photo_name:this.PhotoRender}"),titleTpl:new Ext.XTemplate('{name}<span class="title-status">{status:this.StatusRender}</span>'),descTpl:new Ext.XTemplate("{ctrler_id:this.CtrlerRender}"),titleRightTpl:new Ext.XTemplate("{valid_until:this.ValidRender}"),descRightTpl:new Ext.XTemplate("{last_access:this.LastAccessRender}")},a);this.callParent([b]);this.addClass("axis-cardholder");this.AddTplRenderer()},GetInnerTpl:function(){var c='<td class="detail-row-key">{0}</td>';var d='<td class="detail-row-value">{1}</td>';var b="<tr>"+c+d+"</tr>";var a=new Ext.XTemplate('<div class="item-detail-inner">','<table class="detail-table">',String.format(b,_T("ss_common","pin"),"{pin:this.OptionalDataRender}"),String.format(b,_T("axis_access_controller","card_num"),"{card_num:this.OptionalDataRender}"),String.format(b,_T("axis_access_controller","card_raw"),"{card_raw:this.OptionalDataRender}"),"</table>","</div>");return a},AddTplRenderer:function(){this.tpl.dsCtrler=this.dsCtrler;this.tpl.appWindow=this.owner.findAppWindow();this.tpl.USER_PHOTO=SYNO.SS.App.AxisAcsCtrler.UserPhoto;this.tpl.PHOTO_WIDTH_DEF=62;this.tpl.PHOTO_HEIGHT_DEF=46;this.tpl.PhotoRender=function(e,a){var d='<div style="width: {0}px; height: {1}px;"><img src="{2}" style="{3}"></div>';var b=e;var c,f;if(""===b){f=SYNO.SS.Image.GetImgByRetinaSupport(SYNO.SS.App.AxisAcsCtrler.Image.PHOTO_DEF_1x,SYNO.SS.App.AxisAcsCtrler.Image.PHOTO_DEF_2x);c="width: "+this.PHOTO_WIDTH_DEF+"px;"}else{f=this.USER_PHOTO.GetCardholderRedirectPath(this.GetDsId(),b);f+="&t="+a.photo_tmstmp;c=this.USER_PHOTO.GetResizeStyle(this.PHOTO_WIDTH_DEF,this.PHOTO_HEIGHT_DEF,a.photo_width,a.photo_height)}c+="border: 1px solid #222528;";return String.format(d,this.PHOTO_WIDTH_DEF,this.PHOTO_HEIGHT_DEF,f,c)};this.tpl.GetDsId=function(){return(this.appWindow)?this.appWindow.getCMSAppDSId():LOCAL_DS_ID};this.tpl.GeneralRender=function(c,a){var b=this.RenderRowColor(a);return String.format("<span style='color:{0}'>{1}</span>",b,c)};this.tpl.DescRender=function(c,a){var b=this.RenderRowColor(a);return String.format("<span style='color:{0}'>{1}</span>",b,c)};this.tpl.StatusRender=function(d,b){var a,c;if(SYNO.SS.App.AxisAcsCtrler.CardHolder.Status.Normal===d){return""}else{a=SYNO.SS.App.AxisAcsCtrler.CardHolder.GetStatusString(d);c=SYNO.SS.App.AxisAcsCtrler.CardHolder.GetStatusColor(d);return String.format("&nbsp;-&nbsp;<span style='color:{0}'>{1}</span>",c,a)}};this.tpl.CtrlerRender=function(c,b){var a=this.dsCtrler.getById(c);if(a){return this.DescRender(a.data.name,b)}else{return this.DescRender(c,b)}};this.tpl.OptionalDataRender=function(b,a){return this.GeneralRender(b||"--",a)};this.tpl.ValidRender=function(c,b){if(false===b.enable_valid_until){return this.GeneralRender(_T("axis_access_controller","valid_until")+" --",b)}var a=SYNO.SS.Utils.ToUtcTmstmp(c*TRANS_MILLISECOND);var d=GenLocalDateTimeStr(a);d=d.substring(0,d.indexOf(" "));return this.GeneralRender(_T("axis_access_controller","valid_until")+" "+d,b)};this.tpl.LastAccessRender=function(b,a){if(0===b){return this.DescRender(_T("axis_access_controller","last_access")+" --",a)}var c=GenLocalDateTimeStr(b*TRANS_MILLISECOND);return this.DescRender(_T("axis_access_controller","last_access")+" "+c,a)};this.tpl.RenderRowColor=function(b){var c;var a=b.status;if((SYNO.SS.App.AxisAcsCtrler.Status.Disabled===a)||(SYNO.SS.App.AxisAcsCtrler.Status.Deleted===a)){c=SYNO.SS.Color.DISABLED_GRAY}return c}}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");Ext.define("SYNO.SS.App.AxisAcsCtrler.EditCardHolderDialog",{extend:"SYNO.SDS.ModalWindow",USER_PHOTO_HTML_DEF:"<div class='axis-cardholder-upload-img axis-cardholder-def'>&nbsp;</div>",MAX_PHOTO_SIZE:1024*1024,FIELD_WIDTH:220,fieldFirstName:null,fieldLastName:null,btnDelete:null,btnUpload:null,fieldPhotoUpload:null,imgPhoto:null,fldSetUserInfo:null,fieldPin:null,fieldCardNum:null,fieldCardRaw:null,cmbRetrieveCard:null,btnRetrieveCard:null,panelRetrieveCard:null,chbValidFrom:null,dfValidFrom:null,chbValidUntil:null,dfValidUntil:null,fldSetCredential:null,panelForm:null,btnSave:null,btnCancel:null,record:null,owner:null,fileReader:null,blDeletePhoto:false,imgId:0,constructor:function(a){this.owner=a.owner;this.record=a.record;this.Init();Ext.apply(a,{title:_T("axis_access_controller","edit_card_holder")+" - "+this.record.get("name"),width:667,height:500,layout:"fit",items:[this.panelForm],buttons:[this.btnSave,this.btnCancel],listeners:{activate:this.RegFileChangedEvent,beforeclose:this.OnBeforeClose,scope:this}});this.callParent([a])},Init:function(){this.InitForm();this.InitBtnMain()},InitForm:function(){this.InitUserInfo();this.InitCredential();this.panelForm=new SYNO.ux.FormPanel({cls:"management_panel",autoHeight:true,layout:"fit",items:[this.fldSetUserInfo,this.fldSetCredential]})},InitUserInfo:function(){this.fieldFirstName=new SYNO.SS.Form.NameTextField({width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","first_name"),maxLength:30,allowBlank:true,value:this.record.data.first_name,validator:this.ValidateUserInfo.createDelegate(this)});this.fieldLastName=new SYNO.SS.Form.NameTextField({width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","last_name"),maxLength:30,allowBlank:true,value:this.record.data.last_name,validator:this.ValidateUserInfo.createDelegate(this)});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.OnDeletePhoto,scope:this});this.btnUpload=new SYNO.SS.Form.FileUploadField({strBtnText:_T("ss_common","common_upload"),blBtnOnly:true});this.imgPhoto=new SYNO.ux.Panel({width:128,height:96,layout:"fit",style:"margin-left: 38px;",html:this.CreatePhotoHtmlByData(this.record.data),scope:this});this.fldSetUserInfo=new SYNO.ux.FieldSet({title:_T("axis_access_controller","card_holder_info"),autoHeight:true,collapsible:true,layout:"hbox",items:[{xtype:"syno_panel",layout:"form",items:[this.fieldFirstName,this.fieldLastName,{xtype:"syno_panel",layout:"column",items:[{xtype:"label",text:_T("ss_privilege","user_photo")+":",width:185,style:"margin-top: 7px;"},this.btnDelete,{xtype:"syno_panel",width:100,items:this.btnUpload}]}]},this.imgPhoto]})},InitCredential:function(){this.fieldPin=new SYNO.SS.Form.NameTextField({width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","pin"),maxLength:32,allowBlank:true,value:this.record.data.pin,validator:function(a){return this.ValidateCredential(a,/^[0-9]*$/,_T("axis_access_controller","number_only_tip"))}.createDelegate(this)});this.fieldCardNum=new SYNO.SS.Form.NameTextField({width:this.FIELD_WIDTH,fieldLabel:_T("axis_access_controller","card_num"),maxLength:32,allowBlank:true,value:this.record.data.card_num,validator:function(a){return this.ValidateCredential(a,/^[0-9]*$/,_T("axis_access_controller","number_only_tip"))}.createDelegate(this)});this.fieldCardRaw=new SYNO.SS.Form.NameTextField({width:this.FIELD_WIDTH,fieldLabel:_T("axis_access_controller","card_raw"),maxLength:32,allowBlank:true,value:this.record.data.card_raw,validator:function(a){return this.ValidateCredential(a,/^[0-9a-f]*$/,_T("axis_access_controller","tip_card_raw"))}.createDelegate(this)});this.fieldCardRaw.on("afterrender",function(){SYNO.SS.Utils.AddTip(this.fieldCardRaw.getEl(),_T("axis_access_controller","tip_card_raw"))},this);this.cmbRetrieveCard=new SYNO.ux.ComboBox({width:this.FIELD_WIDTH,fieldLabel:_T("axis_access_controller","retrieve_last_card"),mode:"local",store:new Ext.data.JsonStore({fields:[{name:"displayText"},{name:"id",type:"int"}]}),valueField:"id",displayField:"displayText",forceSelection:true,editable:false,listeners:{beforerender:this.CreateIdPtStore,scope:this}});this.btnRetrieveCard=new SYNO.ux.Button({text:_T("axis_access_controller","retrieve"),handler:this.OnRetrieveCard,scope:this});this.panelRetrieveCard=new SYNO.ux.Panel({hidden:true,layout:"column",items:[{xtype:"syno_panel",width:410,layout:"form",items:this.cmbRetrieveCard},{xtype:"syno_panel",style:"margin-left: 3px;",layout:"form",items:this.btnRetrieveCard}]});this.chbValidFrom=new SYNO.SS.Form.Checkbox({width:185,boxLabel:_T("axis_access_controller","valid_from"),checked:this.record.data.enable_valid_from,handler:function(c,b){var a=(true===b)?this.dfValidFrom.getValue():null;this.dfValidFrom.setDisabled(false===b);this.dfValidUntil.setMinValue(a)},scope:this});this.dfValidFrom=new SYNO.ux.DateField({width:this.FIELD_WIDTH,editable:false,format:"Y/m/d",value:this.GetDateFromLocalTimeSec(this.record.data.valid_from,this.record.data.valid_until),menu:new Ext.menu.DateMenu({hideOnClick:false,focusOnSelect:false}),listeners:{select:this.SetProperValidUntil,scope:this}});this.dfValidFrom.setDisabled(!this.chbValidFrom.checked);this.chbValidUntil=new SYNO.SS.Form.Checkbox({width:185,boxLabel:_T("axis_access_controller","valid_until"),checked:this.record.data.enable_valid_until,handler:function(c,b){var a=(true===b)?this.dfValidFrom.getValue():null;this.dfValidUntil.setDisabled(false===b);this.dfValidFrom.setMaxValue(a)},scope:this});this.dfValidUntil=new SYNO.ux.DateField({width:this.FIELD_WIDTH,editable:false,format:"Y/m/d",value:this.GetDateFromLocalTimeSec(this.record.data.valid_until,this.record.data.valid_from),menu:new Ext.menu.DateMenu({hideOnClick:false,focusOnSelect:false}),listeners:{select:this.SetProperValidFrom,scope:this}});this.dfValidUntil.setDisabled(!this.chbValidUntil.checked);this.fldSetCredential=new SYNO.ux.FieldSet({title:_T("ss_common","credential"),autoHeight:true,collapsible:true,items:[this.fieldPin,this.fieldCardNum,this.fieldCardRaw,this.panelRetrieveCard,{xtype:"syno_panel",layout:"column",style:"margin-bottom: 4px;",items:[this.chbValidFrom,this.dfValidFrom]},{xtype:"syno_panel",layout:"column",style:"margin-bottom: 4px;",items:[this.chbValidUntil,this.dfValidUntil]}]})},InitBtnMain:function(){this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",handler:function(a,b){this.SaveCardHolder()},scope:this});this.btnCancel=new SYNO.ux.Button({text:_T("ss_common","common_cancel"),handler:function(a,b){this.close()},scope:this})},RegFileChangedEvent:function(){this.fieldPhotoUpload=this.btnUpload.getExtFormField();this.fieldPhotoUpload.getEl().on("change",this.OnFileChanged,this)},GetDateFromLocalTimeSec:function(b,c){var d=b||c;var a=Math.floor(d/DAY_SECONDS)*DAY_MILLISECOND;if(a){return new Date(SYNO.SS.Utils.ToUtcTmstmp(a))}else{return new Date()}},SaveCardHolder:function(){if(false===this.panelForm.getForm().isValid()){return}var a=this.GetCardHolderObj();var b={arrayJson:Ext.encode([a])};this.owner.setStatusBusy();this.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"SaveCardHolder",version:1,params:b,callback:this.OnSaveCardHolder,scope:this,setBusy:_T("ss_common","common_saving")})},GetCardHolderObj:function(){var c;var a=function(d){return Math.floor(SYNO.SS.Utils.GetLocalTime(d.getValue())/TRANS_MILLISECOND)};var b=Ext.applyIf({first_name:this.fieldFirstName.getValue(),last_name:this.fieldLastName.getValue(),pin:this.fieldPin.getValue(),card_num:this.fieldCardNum.getValue(),card_raw:this.fieldCardRaw.getValue(),enable_valid_from:this.chbValidFrom.checked,valid_from:a(this.dfValidFrom),enable_valid_until:this.chbValidUntil.checked,valid_until:a(this.dfValidUntil)+DAY_SECONDS-1,del_photo:this.blDeletePhoto},this.record.data);if((this.fileReader)&&(this.fileReader.result)){c=document.getElementById(this.GetPhotoImgId(this.imgId));b=Ext.apply(b,{photo:this.fileReader.result,photo_width:c.originWidth,photo_height:c.originHeight})}return b},OnSaveCardHolder:function(b,a){if(b){this.owner.fireEvent("updateactivepage");this.Reset();this.close()}else{this.owner.clearStatusBusy();if(SS_WEBAPI_ERR_MSG_CONNECT_FAILED===a.code){this.getMsgBox().alert(this.title,_T("axis_access_controller","conn_err_msg"))}else{this.getMsgBox().alert(this.title,_T("ss_common","error_system"))}}},OnFileChanged:function(){var a=this.btnUpload.fileInput.dom.files[0];if((!a)||(""===a.name)){return}else{if(false===SYNO.SS.Image.IsUploadFormatSupported(a.name)){this.getMsgBox().alert(this.title,_T("emap","emap_alert_image_format"));return}else{if(this.MAX_PHOTO_SIZE<a.size){this.getMsgBox().alert(this.title,String.format(_T("ss_common","photo_size_too_large"),"1MB"));return}}}this.fileReader=new FileReader();this.fileReader.addEventListener("load",this.OnFileLoaded.createDelegate(this));this.fileReader.readAsDataURL(a)},OnFileLoaded:function(){this.imgPhoto.removeAll(true);this.imgPhoto.add({xtype:"syno_panel",html:this.CreatePhotoHtml(this.fileReader.result)});this.imgPhoto.doLayout();this.blDeletePhoto=false},OnDeletePhoto:function(){delete this.fileReader;this.blDeletePhoto=true;this.imgPhoto.removeAll(true);this.imgPhoto.add({xtype:"syno_panel",html:this.USER_PHOTO_HTML_DEF});this.imgPhoto.doLayout()},CreatePhotoHtmlByData:function(b){var a=SYNO.SS.App.AxisAcsCtrler.UserPhoto.GetCardholderRedirectPath;var c;if(""===b.photo_name){return this.USER_PHOTO_HTML_DEF}else{c=a(this.GetDsId(),b.photo_name);c+="&t="+b.photo_tmstmp;return this.CreatePhotoHtml(c)}},GetDsId:function(){var a=this.owner.findAppWindow();return(a)?a.getCMSAppDSId():LOCAL_DS_ID},CreatePhotoHtml:function(a){this.imgId+=1;return"<div class='axis-cardholder-upload-img'><img id='"+this.GetPhotoImgId(this.imgId)+"' src='"+a+"' style='visibility: hidden; border: 1px solid #222528;' onload='SYNO.SS.Utils.ResizeFit(126, 94, this, true); this.style.visibility = \"visible\";'></div>"},GetPhotoImgId:function(a){return this.getId()+"_$_$_"+a},ValidateUserInfo:function(){return this.ValidateBlank([this.fieldFirstName,this.fieldLastName],_T("axis_access_controller","validation_failed_user_info"))},ValidateCredential:function(c,d,b){var a=this.ValidateBlank([this.fieldPin,this.fieldCardNum,this.fieldCardRaw],_T("axis_access_controller","validation_failed_credential"));if(c.match(d)){return a}else{return b}},ValidateBlank:function(a,c){var b=true;a.each(function(d){if(d.getRawValue()){b=false}});a.each(function(d){if(true===b){d.markInvalid(c)}else{if(""===d.getRawValue()){d.clearInvalid()}}});return(true===b)?c:true},CreateIdPtStore:function(c){var a=c.getStore();var b=this.GetIdPtInfo(this.owner.GetDsCtrler(),this.record.get("ctrler_id"));if(0<b.length){a.loadData(b);c.setValue(b[0].id);this.panelRetrieveCard.show()}},GetIdPtInfo:function(e,b){var d=SYNO.SS.App.AxisAcsCtrler.IdPt;var a=[];var c=[];e.each(function(f){if(b===f.get("id")){a=f.get("idpoint");return false}});a.each(function(f){if(SYNO.SS.App.AxisAcsCtrler.IdPt.TYPE_READER===f.type){f.displayText=f.door_name+" - "+d.GetDirectString(f.direction);c.push(f)}});return c},OnRetrieveCard:function(){this.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"RetrieveLastCard",version:1,params:{idPtId:this.cmbRetrieveCard.getValue(),ctrlerId:this.record.get("ctrler_id")},callback:function(b,a){if(b){if(a.card_num||a.card_raw){this.fieldCardNum.setValue(a.card_num);this.fieldCardRaw.setValue(a.card_raw)}else{this.getMsgBox().alert(this.title,_T("axis_access_controller","no_last_card_info"))}}else{this.getMsgBox().alert(this.title,_T("axis_access_controller","conn_err_msg"))}},scope:this,setBusy:true})},SetProperValidUntil:function(c,a){var b=a.getTime();this.dfValidUntil.setMinValue(a);if(b>this.dfValidUntil.getValue().getTime()){this.dfValidUntil.setValue(new Date(b+DAY_MILLISECOND))}},SetProperValidFrom:function(b,a){var c=a.getTime();this.dfValidFrom.setMaxValue(a);if(c<this.dfValidFrom.getValue().getTime()){this.dfValidFrom.setValue(new Date(c-DAY_MILLISECOND))}},OnBeforeClose:function(){if(false===this.IsDirty()){return true}SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.Reset();this.close()},scope:this});return false},IsDirty:function(){var b=((this.fileReader)&&(this.fileReader.result));var a=((true===this.blDeletePhoto)&&(this.record.data.photo_name));this.cmbRetrieveCard.originalValue=this.cmbRetrieveCard.getValue();return(b||a||this.panelForm.getForm().isDirty())},Reset:function(){delete this.fileReader;this.blDeletePhoto=false;this.panelForm.getForm().reset()}});Ext.define("SYNO.SS.App.AxisAcsCtrler.CardHolderPanel",{extend:"SYNO.ux.Panel",PADDING:20,CATEG_CONTROLLER:"ctrler_id",CATEG_STATUS:"status",owner:null,contextMenu:null,btnEdit:null,menuItemBlock:null,menuItemUnblock:null,btnBlock:null,btnSwitchCateg:null,fieldSearch:null,toolBar:null,gridCateg:null,dsCardHolder:null,expandableList:null,panelCtrlerList:null,panelCategContainer:null,dsCtrler:null,constructor:function(a){this.owner=a.appWin;this.Init();this.callParent([Ext.apply({title:_T("axis_access_controller","card_holder"),layout:"fit",tbar:this.toolBar,items:[this.panelCategContainer],listeners:{activate:this.Activate}},a)])},Init:function(){this.dsCtrler=this.owner.GetDsCtrler();this.btnEdit=new SYNO.ux.Button({text:_T("ss_common","common_edit"),handler:this.OnEditCardHolder,scope:this});this.menuItemBlock=new Ext.menu.Item({text:_T("ss_common","block"),disabled:true,handler:this.ConfirmBlock,scope:this});this.menuItemUnblock=new Ext.menu.Item({text:_T("ss_common","unblock"),disabled:true,handler:this.Unblock,scope:this});this.btnBlock=new SYNO.ux.Button({text:_T("ss_common","block"),menu:{items:[this.menuItemBlock,this.menuItemUnblock]}});this.dsCateg=new Ext.data.JsonStore({fields:["id","type","category","entryName","entryVal","recCnt"]});this.gridCateg=new SYNO.SS.Grid.CategoryGridPanel({category:[this.CATEG_CONTROLLER,this.CATEG_STATUS],store:this.dsCateg,delegate:this});this.btnSwitchCateg=this.gridCateg.btnSwitch;this.fieldSearch=new SYNO.SS.SearchField({listeners:{searchfield:this.OnSearchFieldChanged,scope:this}},500);this.toolBar=new SYNO.ux.Toolbar({items:[this.btnEdit,this.btnBlock,{xtype:"tbfill"},this.btnSwitchCateg,this.fieldSearch]});this.dsCardHolder=new SYNO.API.JsonStore({autoDestroy:true,appWindow:this.owner,api:SYNO.SS.App.AxisAcsCtrler.Api,method:"EnumCardHolder",version:1,baseParams:{start:0,limit:SYNO.SS.Pgls.MIN_PAGE_RECORDS},totalProperty:"total",root:"data",fields:[{name:"id",type:"int"},{name:"ctrler_id",type:"int"},{name:"grp_id",type:"int"},{name:"valid_from",type:"int"},{name:"valid_until",type:"int"},{name:"last_access",type:"int"},{name:"name"},{name:"first_name"},{name:"last_name"},{name:"photo_name"},{name:"photo_width",type:"int"},{name:"photo_height",type:"int"},{name:"photo_tmstmp",type:"int"},{name:"card_num"},{name:"card_raw"},{name:"pin"},{name:"enable_valid_from",type:"boolean"},{name:"enable_valid_until",type:"boolean"},{name:"blocked",type:"boolean"},{name:"status",type:"int"}],listeners:{load:this.OnCardHolderLoad,scope:this}});this.expandableList=new SYNO.SS.App.AxisAcsCtrler.CardHolderExpandableListView({owner:this.owner,dsCtrler:this.dsCtrler,store:this.dsCardHolder,listeners:{selectionchange:this.ChgButtonStatus,dblclick:this.OnEditCardHolder,contextmenu:this.OnContextMenu,scope:this}});this.expandablePanel=new SYNO.SS.ViewPanel({view:this.expandableList,plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsCategPlugin",store:this.dsCardHolder,gridCateg:this.gridCateg,pageSize:SYNO.SS.Pgls.MIN_PAGE_RECORDS,divLoadingHeight:60,GetParams:this.GetFilterParams.createDelegate(this)})});var a=new SYNO.SS.Pgls.BottomBar({panelRecord:this.expandableList,refreshFunction:this.OnRefresh,refreshFunctionScope:this});this.panelCtrlerList=new SYNO.ux.Panel({region:"center",layout:"fit",items:[this.expandablePanel],bbar:a});this.panelCategContainer=new SYNO.SS.Pgls.PglsCategContainerPanel({items:[this.gridCateg,this.panelCtrlerList],gridCateg:this.gridCateg,panelRecord:this.expandablePanel,labelItemCnt:a.labelItemCnt,dsRecord:this.dsCardHolder,countMethod:"CountByCategoryCardHolder",countParams:{limit:0,needMask:false},GetParams:this.GetFilterParams.createDelegate(this)})},Activate:function(){this.OnRefresh()},OnRefresh:function(b,c,a){this.LoadData();this.ChgButtonStatus()},GetCategEntryId:function(a,b){return b.toString()},GetCategName:function(a){switch(a){case this.CATEG_CONTROLLER:return _T("ss_common","controller");case this.CATEG_STATUS:return _T("ss_common","status");default:return undefined}},GetCategEntryName:function(b,c){var a;if(this.CATEG_CONTROLLER===b){if(SYNO.SS.Grid.Categ.VALUE_ALL===c){return _T("ss_common","categ_all_controller")}else{a=this.dsCtrler.getById(c);if(a){return a.data.name}else{return c}}}else{if(this.CATEG_STATUS===b){if(SYNO.SS.Grid.Categ.VALUE_ALL===c){return _T("ss_common","categ_all_status")}else{return SYNO.SS.App.AxisAcsCtrler.CardHolder.GetStatusString(c)}}}},GetCategEntryType:function(a,b){return a},FilterCateg:function(c,b,a){if(c==SYNO.SS.Grid.Categ.ENTRY_ALL){a.clearFilter();return}a.filter(c,b,false,true,true)},LoadData:function(){var a=this.GetFilterParams();this.dsCardHolder.abortLoad();this.owner.clearStatusBusy();this.owner.setStatusBusy();this.dsCardHolder.load({params:a,callback:function(b,d,c){this.owner.clearStatusBusy();if(0<this.owner.maskCnt){this.owner.clearStatusBusy()}},scope:this})},OnEditCardHolder:function(){var a=this.expandableList.getSelectedRecords();var b=new SYNO.SS.App.AxisAcsCtrler.EditCardHolderDialog({owner:this.owner,record:a[0]});b.show()},ConfirmBlock:function(){var a=_T("axis_access_controller","block_cardholder_tips");this.owner.getMsgBox().confirm(this.title,a,function(b){if("yes"===b){this.Block(true)}},this)},Unblock:function(){this.Block(false)},Block:function(c){var b=[];var a=this.expandableList.getSelectedRecords();a.forEach(function(e,d,f){if(e.data.blocked!==c){b.push(e.data.id)}});if(0===b.length){return}this.owner.setStatusBusy();this.owner.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"BlockCardHolder",version:1,params:{arrayJson:Ext.encode(b)},callback:function(e,d){if(true===e){this.owner.fireEvent("updateactivepage")}else{this.owner.clearStatusBusy();if(SS_WEBAPI_ERR_MSG_CONNECT_FAILED===d.code){this.owner.getMsgBox().alert(this.title,_T("axis_access_controller","conn_err_msg"))}else{this.owner.getMsgBox().alert(this.title,_T("ss_common","error_system"))}}},setBusy:true,scope:this})},ChgButtonStatus:function(){var d=false;var a=false;var b=this.expandableList.getSelectedRecords();var c=function(f,e,g){if(true===f.data.blocked){d=true}else{a=true}};b.forEach(c);this.menuItemBlock.setDisabled(false===a);this.menuItemUnblock.setDisabled(false===d);this.btnEdit.setDisabled(1!==b.length)},GetFilterParams:function(b){var d=Ext.apply({},this.dsCardHolder.baseParams);var a=this.gridCateg.curEntry;var c=a.entryVal;if(true!==b){return d}if(a.type===this.CATEG_STATUS){d.filterStatus=a.entryVal}else{if(a.type===this.CATEG_CONTROLLER){d.filterCtrlerId=a.entryVal}}return d},OnCardHolderLoad:function(b,a,c){this.gridCateg.ReloadDsCateg()},OnSearchFieldChanged:function(a){this.dsCardHolder.setBaseParam("filterKeyword",a);this.LoadData()},OnContextMenu:function(a,d,b,c){if(false===a.isSelected(b)){a.select(b)}this.ShowContextMenu(c)},ShowContextMenu:function(b){var a=[this.btnEdit,this.menuItemBlock,this.menuItemUnblock];if(!this.contextMenu){this.InitContextMenu()}a.each(function(d,c){this.contextMenu.items.itemAt(c).setVisible(false===d.disabled)},this);this.contextMenu.showAt(b.getXY())},InitContextMenu:function(){this.contextMenu=new SYNO.ux.Menu({items:[{text:_T("ss_common","common_edit"),handler:this.OnEditCardHolder,scope:this},{text:_T("ss_common","block"),handler:this.ConfirmBlock,scope:this},{text:_T("ss_common","unblock"),handler:this.Unblock,scope:this}]});this.addManagedComponent(this.contextMenu)}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");SYNO.SS.App.AxisAcsCtrler.GetStatusColor=function(b,a){switch(b){case SYNO.SS.App.AxisAcsCtrler.Status.Normal:return SYNO.SS.Color.INFO_BLUE;case SYNO.SS.App.AxisAcsCtrler.Status.Disabled:case SYNO.SS.App.AxisAcsCtrler.Status.Deleted:return SYNO.SS.Color.DISABLED_GRAY;default:return SYNO.SS.Color.ALERT_RED}};SYNO.SS.App.AxisAcsCtrler.GetStatusCls=function(b,a){switch(b){case SYNO.SS.App.AxisAcsCtrler.Status.Normal:return"";case SYNO.SS.App.AxisAcsCtrler.Status.Disabled:case SYNO.SS.App.AxisAcsCtrler.Status.Deleted:return"axis-status-disabled";default:return"axis-status-error"}};SYNO.SS.App.AxisAcsCtrler.GetDoorStatusColor=function(b,a){switch(b){case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_UNKNOWN:case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_DISCONNECTED:case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_INCOMPATIBLE:return SYNO.SS.Color.ALERT_RED;default:return SYNO.SS.Color.NORMAL_GRAY}};SYNO.SS.App.AxisAcsCtrler.PairedCamLinkClickEvent=function(b){var a=Ext.getCmp(b);a.EditCtrler(true)};SYNO.SS.App.AxisAcsCtrler.NeedToRetrieveClickEvent=function(b){var a=Ext.getCmp(b);a.Retrieve()};Ext.define("SYNO.SS.App.AxisAcsCtrler.CtrlerExpandableListView",{extend:"SYNO.ux.ExpandableListView",ON_MOUSEOVER_HTML:' onmouseover="SYNO.SS.App.AxisAcsCtrler.DoorIconEvent.OnMouseOver({0}, {1})" ',ON_MOUSEOUT_HTML:' onmouseout="SYNO.SS.App.AxisAcsCtrler.DoorIconEvent.OnMouseOut({0})" ',ON_CLICK_HTML:' onclick="SYNO.SS.App.AxisAcsCtrler.DoorIconEvent.OnClick({0}, {1})" ',owner:null,dsCamera:null,constructor:function(a){this.owner=a.owner;this.dsCamera=a.dsCamera;var b=Ext.apply({innerTpl:this.GetInnerTpl(),iconTpl:new Ext.XTemplate("{photoName:this.PhotoRender}"),titleTpl:new Ext.XTemplate('{name:this.CtrlerRender}<span class="title-status">{status:this.StatusRender}</span>'),descTpl:new Ext.XTemplate("{host:this.DescRender}&nbsp:&nbsp{port:this.DescRender}"),titleRightTpl:new Ext.XTemplate("{door:this.DoorCountRender}")},a);this.callParent([b]);this.AddTplRenderer()},GetInnerTpl:function(){var b=this.getInnerKeyValTableTpl([{key:_T("ss_common","ds_model"),value:"{model:this.GeneralRender}"},{key:_T("ss_common","mac_address"),value:"{mac_addr:this.GeneralRender}"}]);var a=this.GetDoorInfoListTpl();var d=this.GetPeerInfoListTpl();var c=new Ext.XTemplate("<div>",b.html,a.html,d.html,"</div>");return c},GetDoorInfoListTpl:function(){var b=this.createPlayMaskTpl();var c=String.format(this.ON_MOUSEOVER_HTML,"'{id:this.ElIdRender}'","{status}")+String.format(this.ON_MOUSEOUT_HTML,"'{id:this.ElIdRender}'");var a=String.format(this.ON_CLICK_HTML,"'{.:this.MonitorParamRender}'","{status}");var d=new Ext.XTemplate('<tpl for="door">','<div id="{id:this.ElIdRender}" class="{status:this.DoorIconClsRender}"'+c+">",'<div class="image"'+a+">"+b.html+"</div>",'<div class="name">{name}<span class="title-status">{status:this.DoorStatusRender}</span></div>','<div class="related-cam">',_T("axis_access_controller","related_cam")+" {.:this.CamRender}","</div>","</div>","</tpl>");return new Ext.XTemplate('<tpl if="0 < door.length">','<div class="door-title">',_T("axis_access_controller","door"),"</div>",'<div class="door-view">',d.html,"</div>","</tpl>")},GetPeerInfoListTpl:function(){var a=new Ext.XTemplate('<div class="peer-info-list-header">',"<dl>",String.format('<dt class="peer-info-list-header-column" style="width:33.1%">{0}</dt>',_T("axis_access_controller","access_controller")),String.format('<dt class="peer-info-list-header-column" style="width:33.1%">{0}</dt>',_T("camera","camera_attr_ip")),String.format('<dt class="peer-info-list-header-column" style="width:33.1%; border-right: 0px;">{0}</dt>',_T("camera","camera_attr_mac")),'<div class="x-clear"></div>',"</dl>","</div>");var b=new Ext.XTemplate('<div class="peer-info-list-body">','<tpl for="peer_info">','<dl class="sm-grid-disk-list-row">','<dt class="peer-info-list-column" style="width:33.1%">{name:this.EmptyRender}</dt>','<dt class="peer-info-list-column" style="width:33.1%">{host:this.EmptyRender}</dt>','<dt class="peer-info-list-column" style="width:33.1%">{mac_addr:this.EmptyRender}</dt>','<div class="x-clear"></div>',"</dl>","</tpl>","</div>");return new Ext.XTemplate('<tpl if="0 < peer_info.length">','<div class="door-title">',_T("axis_access_controller","peer_controller"),"</div>",'<div class="peer-info-list">',a.html,b.html,"</div>",'<div class="x-clear"></div>',"</tpl>")},AddTplRenderer:function(){this.tpl.PHOTO_WIDTH_DEF=64;this.tpl.PHOTO_HEIGHT_DEF=48;this.tpl.PAIRED_CAM_LINK_CLICK_EVENT='onclick="SYNO.SS.App.AxisAcsCtrler.PairedCamLinkClickEvent({0})"';this.tpl.NEED_RETRIEVE_LINK_CLICK_EVENT='onclick="SYNO.SS.App.AxisAcsCtrler.NeedToRetrieveClickEvent({0})"';this.tpl.NEED_RETRIEVE_LINK_STYLE="text-decoration: underline; cursor: pointer;";this.tpl.owner=this.owner;this.tpl.dsCamera=this.dsCamera;this.tpl.appWindow=this.owner.findAppWindow();this.tpl.PhotoRender=function(b,a){return'<div class="axis-ctrler-icon '+SYNO.SS.App.AxisAcsCtrler.GetStatusCls(a.status,a)+'">&nbsp;</div>'};this.tpl.CtrlerRender=function(b,a){return(b||_T("axis_access_controller","unknow_controller"))};this.tpl.GeneralRender=function(c,a){var b=this.RenderRowColor(a);return String.format("<span style='color:{0}'>{1}</span>",b,c)};this.tpl.DescRender=function(c,a){var b=this.RenderRowColor(a);return String.format("<span style='color:{0}'>{1}</span>",b,c)};this.tpl.DoorCountRender=function(b,a){return String.format(_T("axis_access_controller","door_count"),this.GeneralRender(b.length,a))};this.tpl.StatusRender=function(f,c){var a="",e="";var b,d;if(SYNO.SS.App.AxisAcsCtrler.Status.Normal===f){if(SYNO.SS.App.AxisAcsCtrler.NeedToRetrieve.ANTR_NO===c.need_to_retrieve){return""}if(SYNO.SS.App.AxisAcsCtrler.NeedToRetrieve.ANTR_YES===c.need_to_retrieve){a=String.format(this.NEED_RETRIEVE_LINK_CLICK_EVENT,"'"+this.owner.getId()+"'");e=this.NEED_RETRIEVE_LINK_STYLE}}b=SYNO.SS.App.AxisAcsCtrler.GetStatusString(f,c);d=SYNO.SS.App.AxisAcsCtrler.GetStatusColor(f,c);return String.format("&nbsp;-&nbsp;<span {0} style='{1}color:{2};'>{3}</span>",a,e,d,b)};this.tpl.RenderRowColor=function(b){var c;var a=b.status;if((SYNO.SS.App.AxisAcsCtrler.Status.Disabled===a)||(SYNO.SS.App.AxisAcsCtrler.Status.Deleted===a)){c=SYNO.SS.Color.DISABLED_GRAY}return c};this.tpl.DoorIconClsRender=function(b,a){switch(b){case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_UNKNOWN:case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_DISCONNECTED:case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_INCOMPATIBLE:return"door-info-error";case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_DISABLED:return"door-info-disabled";default:return"door-info"}};this.tpl.CamRender=function(e,a){var d=this.owner.getId();var b=String.format(this.PAIRED_CAM_LINK_CLICK_EVENT,"'"+d+"'");var c;if(0===e.cam_id){return String.format(_T("axis_access_controller","click_to_set_video_source"),b)}else{c=this.dsCamera.getById(e.cam_id);return(c)?c.data.name:_T("camera","conn_status_unknown")}};this.tpl.EmptyRender=function(b,a){return b||_T("ss_common","status_unknown")};this.tpl.ElIdRender=function(c,b){var a=this.appWindow.getCMSAppDSId();return String.format("ds_{0}_door_{1}",a,c)};this.tpl.MonitorParamRender=function(c,b){var a=this.appWindow.getCMSAppDSId();return encodeURIComponent(Ext.encode({doorId:c.id,dsId:a,blHeader:true,blAddPlugin:true,cmsAppDSId:a,blNeedRedirect:(LOCAL_DS_ID!==a),mode:SYNO.SS.App.WebPlayer.Def.PreviewMode.Door}))};this.tpl.DoorStatusRender=function(d,b){var a,c;switch(d){case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_UNKNOWN:case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_DISCONNECTED:case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_DISABLED:case SYNO.SS.App.AxisAcsCtrler.Door.Status.DOOR_INCOMPATIBLE:a=SYNO.SS.App.AxisAcsCtrler.Door.Status.GetEnumString(d,b);c=SYNO.SS.App.AxisAcsCtrler.GetDoorStatusColor(d,b);return String.format("&nbsp;-&nbsp;<span style='color:{0}'>{1}</span>",c,a);default:return""}}}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");Ext.define("SYNO.SS.App.AxisAcsCtrler.EditCtrlerDialog",{extend:"SYNO.SDS.ModalWindow",DEVICE_INFO_PANEL:0,ADVANCED_PANEL:1,plugin:null,tabPanel:null,btnSave:null,btnCancel:null,blSaving:false,constructor:function(a){cc=this;this.plugin=new SYNO.SS.App.AxisAcsCtrler.EditCtrlerDlgPlugin({model:a.model,owner:a.owner,blResetOnClose:true});this.plugin.init(this);this.Init();Ext.apply(a,{title:_T("axis_access_controller","edit_controller")+" - "+a.name,banner:false,width:640,height:480,layout:"fit",items:[this.tabPanel],buttons:[this.btnSave,this.btnCancel],listeners:{beforeclose:this.OnBeforeClose,scope:this}});this.callParent([a])},Init:function(){this.InitForm();this.InitTabPanel();this.InitBtns()},InitTabPanel:function(){this.tabPanel=new SYNO.ux.TabPanel({activeTab:this.DEVICE_INFO_PANEL,items:[this.panelDeviceInfo,this.panelAdvanced],listeners:{beforetabchange:function(a,c,b){if(undefined===b){return true}if(false===b.getForm().isValid()){return false}if(c===this.panelAdvanced){return this.PrepareAdvancedPanel()}return true},scope:this}})},InitBtns:function(){this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),btnStyle:"blue",disabled:_S("DEMO_MODE"),handler:function(a,b){this.blSaving=true;if(true===this.PrepareAdvancedPanel()){this.SaveDoor();this.blSaving=false}},scope:this});this.btnCancel=new SYNO.ux.Button({text:_T("ss_common","common_cancel"),handler:function(a,b){this.close()},scope:this})},OnBeforeClose:function(){if(false===this.IsDirty()){return true}SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.Reset();this.close()},scope:this});return false},IsDirty:function(){var a=false;this.tabPanel.items.each(function(b){if(true===b.getForm().isDirty()){a=true;return false}});return a},Reset:function(){this.tabPanel.items.each(function(a){a.getForm().reset()})},GoAdvancedPanel:function(){if(false===this.blSaving){this.tabPanel.setActiveTab(this.ADVANCED_PANEL)}else{this.PrepareAdvancedPanel();this.SaveDoor();this.blSaving=false}}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");Ext.define("SYNO.SS.App.AxisAcsCtrler.PrivilegeDialog",{extend:"SYNO.SDS.ModalWindow",COL_IDX_UID:0,COL_IDX_AUTHORIZED:1,COL_IDX_MANUAL_LOCK:2,dsDoor:null,dsUser:null,dsPrivilege:null,dsPrivilegeDefault:null,loadingDs:null,fieldPrivilege:[{name:"id"},{name:"uid"},{name:"door_id"},{name:"authorized",type:"bool"},{name:"manual_lock",type:"bool"}],privDisplayFields:["uid","authorized","manual_lock"],privDisplayTitle:[_T("ss_privilege","privilege_account"),_T("ss_privilege","authorized"),_T("axis_access_controller","manual_lock_option")],btnSave:null,btnHideUnauthorized:null,gridDoor:null,cmPrivilege:null,gridPrivilege:null,blPreviewMode:false,constructor:function(a){this.Init();Ext.apply(a,{title:_T("ss_common","common_privilege"),banner:false,useStatusBar:false,cls:SYNO.SS.Grid.Categ.CLS_CATEG_CONTAINER,width:640,height:480,layout:"fit",tbar:{style:"padding-left: 0px;",items:[this.btnSave,this.btnHideUnauthorized]},items:[{xtype:"syno_panel",style:"margin-top: 10px;",layout:"border",items:[this.gridDoor,this.gridPrivilege]}]});this.callParent([a])},Init:function(){this.InitStore();this.InitButtons();this.InitPanelDoor();this.InitGridPrivilege()},InitStore:function(){this.dsDoor=new SYNO.API.JsonStore({appWindow:this,api:SYNO.SS.App.AxisAcsCtrler.Api,method:"ListDoor",version:1,fields:[{name:"id",type:"int"},{name:"name"}]});var a=[SYNO.SS.AccountStatus.ACC_STATUS_NORMAL,SYNO.SS.AccountStatus.ACC_STATUS_DISABLE,SYNO.SS.AccountStatus.ACC_STATUS_EXPIRED,SYNO.SS.AccountStatus.ACC_STATUS_UNEXPIRED].join();this.dsUser=new Ext.data.JsonStore({url:"cgi/userPrivilege.cgi",baseParams:{action:"enum",limit:65535,enumMode:SYNO.SS.App.User.Def.EnumPriv.USER_LIST,privilege:SYNO.SS.UserPrivType.ALL_PRIV,status:a},totalProperty:"total",idProperty:"uid",root:"Account",fields:[{name:"id",type:"int"},{name:"uid",type:"int"},{name:"privProfileId",type:"int"},{name:"privProfileName"},{name:"privProfileCustomUid",type:"int"},{name:"privilege",type:"int"},{name:"user"},{name:"lang"},{name:"status",type:"int"},{name:"fullname"},{name:"authType",type:"int",defaultValue:SYNO.SS.UserAuthType.LOCAL},{name:"expiredDate"},{name:"photoName"},{name:"dsId",type:"int"}],listeners:{beforeload:function(c,d){var b=this.findAppWindow().getCMSAppDSId();SYNO.SS.Utils.FillRedirectParamToStore(this.dsUser,b,"cgi/userPrivilege.cgi")},scope:this}});this.dsPrivilege=new Ext.data.JsonStore({fields:this.fieldPrivilege});this.dsPrivilegeDefault=new SYNO.API.JsonStore({appWindow:this,api:SYNO.SS.App.AxisAcsCtrler.Api,method:"ListPrivilege",version:1,totalProperty:"total",root:"data",fields:this.fieldPrivilege})},InitButtons:function(){this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),disabled:true,handler:this.OnSave,scope:this});this.btnHideUnauthorized=new SYNO.ux.Button({text:_T("ss_privilege","hide_unauthorized"),enableToggle:true,toggleHandler:function(a,b){this.blPreviewMode=b;this.FilterPrivilege()},scope:this})},InitPanelDoor:function(){var a=new Ext.grid.ColumnModel([{dataIndex:"name",renderer:this.RenderDoor.createDelegate(this)}]);a.setColumnHeader(this.COL_IDX_UID,_T("axis_access_controller","door"));this.gridDoor=new SYNO.SS.Grid.GridPanel({region:"west",split:true,minSize:160,maxSize:200,hideHeaders:true,width:180,cls:SYNO.SS.Grid.Categ.CLS_CATEG_GRID_PANEL,cm:a,store:this.dsDoor});this.gridDoor.getSelectionModel().on("rowselect",function(c,d,b){this.FilterPrivilege()},this)},InitGridPrivilege:function(){this.cmPrivilege=new Ext.grid.ColumnModel([{dataIndex:this.privDisplayFields[this.COL_IDX_UID],renderer:this.RenderUser.createDelegate(this)},{align:"center",dataIndex:this.privDisplayFields[this.COL_IDX_AUTHORIZED],renderer:this.RenderCol.createDelegate(this)},{align:"center",dataIndex:this.privDisplayFields[this.COL_IDX_MANUAL_LOCK],renderer:this.RenderCol.createDelegate(this)}]);this.cmPrivilege.setColumnHeader(this.COL_IDX_UID,this.privDisplayTitle[this.COL_IDX_UID]);this.ChangePrivColumnHeader(this.COL_IDX_AUTHORIZED);this.ChangePrivColumnHeader(this.COL_IDX_MANUAL_LOCK);this.gridPrivilege=new SYNO.SS.Grid.GridPanel({region:"center",margins:"0 0 20 16",cls:"log-config-panel-border-bottom",cm:this.cmPrivilege,store:this.dsPrivilege,listeners:{cellclick:this.OnPrivilegeCellClick,headerclick:this.OnPrivilegeHeaderClick,scope:this}});this.dsPrivilege.on("load",this.OnPrivDataChanged,this);this.dsPrivilege.on("datachanged",this.OnPrivDataChanged,this)},RenderDoor:function(e,b,a,f,d,c){return'<div class="'+SYNO.SS.Grid.Categ.CLS_CATEG_ENTRY+' general_cursor_default"><div class="'+SYNO.SS.Grid.Categ.CLS_ENTRY_NAME+'">'+e+"</div></div>"},RenderUser:function(e,b,a,f,d,c){return"<div>"+this.dsUser.getById(e).data.user+"</div>"},RenderCol:function(e,f,a,g,c,b){var d="";if(true===this.blPreviewMode){d=(true===e)?IMG_CHECKED_AUTH:IMG_DASH}else{if(true===this.IsColCheckable(c,a)){d=(true===e)?IMG_CHECKED:IMG_UNCHECKED}else{if(""===d){d=(true===e)?IMG_CHECKED_DISABLE:IMG_UNCHECKED_DISABLE}}}return d},RenderHeader:function(d,b,a){var c=this.IsAllChecked(b,a);return this.RenderHeaderCheck(c,d)},RenderHeaderCheck:function(c,a){var b;if(true===this.blPreviewMode){b=""}else{b=(true===c)?IMG_CHECKED:IMG_UNCHECKED}return b+'<span class="grid_header_check">'+a+"</span>"},IsColCheckable:function(a,b){if(this.COL_IDX_MANUAL_LOCK===a){if(false===b.data.authorized){return false}}return true},IsAllChecked:function(a,c){var d=0;var b=true;var e=function(f){if(true===this.IsColCheckable(a,f)){if(false===f.data[this.privDisplayFields[a]]){b=false;return false}else{d++}}};c.each(e,this);return(b&&(0<d))},ChangePrivColumnHeader:function(a){var b=this.RenderHeader(this.privDisplayTitle[a],a,this.dsPrivilege);this.cmPrivilege.setColumnHeader(a,b)},CorrectManualLock:function(){var a=function(b){if(false===b.data.authorized){b.data.manual_lock=false}};this.dsPrivilege.each(a)},RefreshPrivColumnHeader:function(){this.ChangePrivColumnHeader(this.COL_IDX_AUTHORIZED);this.ChangePrivColumnHeader(this.COL_IDX_MANUAL_LOCK)},SetupSaveButton:function(){if(true===this.IsDirty()){this.btnSave.enable()}else{this.btnSave.disable()}},IsDirty:function(){var e,b=this.dsPrivilegeDefault.getCount();var c=this.dsPrivilege.snapshot||this.dsPrivilege.data;var d,a;var f=false;for(e=0;e<b;e++){d=this.dsPrivilegeDefault.getAt(e);a=c.itemAt(e);this.fieldPrivilege.forEach(function(h,g,i){if(d.data[h.name]!==a.data[h.name]){f=true}},this);if(true===f){break}}return f},FilterPrivilege:function(){var a=this.gridDoor.getSelectionModel().getSelected().data.id;if(true===this.blPreviewMode){this.dsPrivilege.filterBy(function(b,c){if(a!==b.data.door_id){return false}if(true!==b.data.authorized){return false}return true},this)}else{this.dsPrivilege.filter("door_id",a,false,true,true)}},onOpen:function(){this.loadingDs=[];this.setStatusBusy();this.loadingDs.push(this.dsDoor);this.dsDoor.load({callback:function(a,b,c){this.RemoveLoadingStore(this.dsDoor);this.OnDsLoadingDone(this.dsDoor,c)},scope:this});this.loadingDs.push(this.dsUser);this.dsUser.load({callback:function(a,b,c){this.RemoveLoadingStore(this.dsUser);this.OnDsLoadingDone(this.dsUser,c)},scope:this});this.loadingDs.push(this.dsPrivilegeDefault);this.dsPrivilegeDefault.load({callback:function(a,b,c){this.RemoveLoadingStore(this.dsPrivilegeDefault);this.OnDsLoadingDone(this.dsPrivilegeDefault,c)},scope:this});this.callParent(arguments)},onClose:function(){},OnDsLoadingDone:function(b,c){var a;if(true===c){if(0===this.loadingDs.length){this.LoadDsPrivilege();this.clearStatusBusy()}}else{if(0!==this.loadingDs.length){a=this.loadingDs;this.loadingDs=[];a.forEach(function(e,d,f){Ext.Ajax.abort(e.proxy.activeRequest);delete e.proxy.activeRequest})}if(true===this.getMsgBox().isVisible()){return}this.getMsgBox().alert(this.title,_T("ss_common","commfail"),function(){this.clearStatusBusy();this.close()})}},OnPrivilegeCellClick:function(c,h,d,f){if((true===this.blPreviewMode)||(this.COL_IDX_UID===d)){return}var b=c.getStore();var a=b.getAt(h);var g=c.getColumnModel().getDataIndex(d);a.data[g]=!a.data[g];b.fireEvent("datachanged",b)},OnPrivilegeHeaderClick:function(a,b,c){if(true===this.blPreviewMode||(this.COL_IDX_UID===b)){return}if(true===this.IsAllChecked(b,this.dsPrivilege)){this.dsPrivilege.each(function(d){if(true===this.IsColCheckable(b,d)){d.data[this.privDisplayFields[b]]=false}},this)}else{this.dsPrivilege.each(function(d){if(true===this.IsColCheckable(b,d)){d.data[this.privDisplayFields[b]]=true}},this)}this.dsPrivilege.fireEvent("datachanged",this.dsPrivilege)},OnPrivDataChanged:function(){this.CorrectManualLock();this.RefreshPrivColumnHeader();this.SetupSaveButton()},OnSave:function(c,f){var b,d=this.dsPrivilegeDefault.getCount();var g=this.dsPrivilege.snapshot||this.dsPrivilege.data;var k,h;var j;var a=[];for(b=0;b<d;b++){k=this.dsPrivilegeDefault.getAt(b);h=g.itemAt(b);j=true;this.fieldPrivilege.forEach(function(i,e,l){if(k.data[i.name]!==h.data[i.name]){j=false}},this);if(false===j){a.push(h.data)}}this.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"SavePrivilege",version:1,params:{arrayJson:Ext.encode(a)},callback:this.OnSaveDone,scope:this,setBusy:_T("ss_common","common_saving")})},OnSaveDone:function(d,a,c,b){if(true===d){this.dsPrivilege.suspendEvents(false);this.dsPrivilege.clearFilter();this.dsPrivilegeDefault.removeAll();SYNO.SS.Utils.StoreDataCopy(this.dsPrivilege,this.dsPrivilegeDefault);this.FilterPrivilege();this.dsPrivilege.resumeEvents();this.btnSave.disable()}else{this.getMsgBox().alert(this.title,_T("ss_common","error_system"))}},RemoveLoadingStore:function(a){var b;for(b=0;b<this.loadingDs.length;b++){if(this.loadingDs[b]===a){this.loadingDs.splice(b,1);break}}},LoadDsPrivilege:function(){var a=[];this.dsUser.each(function(b){this.dsDoor.each(function(f){var c,d;var e=b.data.uid+"_"+f.data.id;c=this.dsPrivilegeDefault.getById(e);if(c){a.push(c.copy())}else{d=(SYNO.SS.UserPrivType.MANAGER===b.data.privilege);c=new this.dsPrivilege.recordType({id:e,uid:b.data.uid,door_id:f.data.id,authorized:d,manual_lock:d},e)}a.push(c)},this)},this);this.dsPrivilege.suspendEvents(false);this.dsPrivilege.add(a);this.dsPrivilegeDefault.removeAll();SYNO.SS.Utils.StoreDataCopy(this.dsPrivilege,this.dsPrivilegeDefault);this.dsPrivilege.resumeEvents();this.gridDoor.getSelectionModel().selectFirstRow()}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");SYNO.SS.App.AxisAcsCtrler.EmptyStyleClickAddEvent=function(b){var a=Ext.getCmp(b);a.OnAdd()};Ext.define("SYNO.SS.App.AxisAcsCtrler.CtrlerPanel",{extend:"SYNO.ux.Panel",RETRIEVING:null,PADDING:20,owner:null,btnAdd:null,btnDelete:null,btnEdit:null,btnRetrieve:null,btnPrivilege:null,menuItemEnable:null,menuItemDisable:null,btnEnable:null,toolBar:null,gridCateg:null,dsCtrler:null,dsCamera:null,expandableList:null,panelCtrlerList:null,panelCategContainer:null,constructor:function(a){this.owner=a.appWin;this.Init();this.callParent([Ext.apply({title:_T("axis_access_controller","access_controller"),layout:"fit",tbar:this.toolBar,items:[this.panelCategContainer],listeners:{activate:this.Activate,deactivate:this.Deactivate}},a)])},Init:function(){this.RETRIEVING=SYNO.SS.App.AxisAcsCtrler.NeedToRetrieve.ANTR_RETRIEVING;this.dsCtrler=new SYNO.API.JsonStore({autoDestroy:true,appWindow:this,api:SYNO.SS.App.AxisAcsCtrler.Api,method:"Enum",version:1,baseParams:{start:0,limit:SYNO.SS.Pgls.MIN_PAGE_RECORDS},totalProperty:"total",root:"data",fields:SYNO.SS.App.AxisAcsCtrler.CtrlerFields});this.dsCamera=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.Camera",method:"List",version:7,root:"cameras",totalProperty:"total",fields:SYNO.SS.GblStore.fieldCamera});this.btnAdd=new SYNO.ux.Button({text:_T("ss_common","common_add"),handler:this.OnAdd,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.DeleteSelected,scope:this});this.btnEdit=new SYNO.ux.Button({text:_T("ss_common","common_edit"),handler:function(b,c){this.EditCtrler()},scope:this});this.menuItemEnable=new Ext.menu.Item({text:_T("ss_common","common_enable"),disabled:true,handler:function(b,c){this.Enable(true)},scope:this});this.menuItemDisable=new Ext.menu.Item({text:_T("ss_common","common_disable"),disabled:true,handler:function(b,c){this.Enable(false)},scope:this});this.btnEnable=new SYNO.ux.Button({text:_T("ss_common","common_enable"),menu:{items:[this.menuItemEnable,this.menuItemDisable]}});this.btnRetrieve=new SYNO.ux.Button({text:_T("axis_access_controller","retrieve"),handler:function(b,c){this.Retrieve()},scope:this});this.btnPrivilege=new SYNO.ux.Button({text:_T("ss_common","common_privilege"),handler:function(c,d){var b=new SYNO.SS.App.AxisAcsCtrler.PrivilegeDialog({owner:this.owner});b.open()},scope:this});this.dsCateg=new Ext.data.JsonStore({fields:["id","type","category","entryName","entryVal","recCnt"]});this.gridCateg=new SYNO.SS.Grid.CategoryGridPanel({category:["status"],store:this.dsCateg,delegate:this});this.toolBar=new SYNO.ux.Toolbar({items:[this.btnAdd,this.btnDelete,this.btnEdit,this.btnEnable,this.btnRetrieve,this.btnPrivilege]});this.expandableList=new SYNO.SS.App.AxisAcsCtrler.CtrlerExpandableListView({owner:this,store:this.dsCtrler,dsCamera:this.dsCamera,toggleOnDblClick:false,prepareData:this.PreparePeerInfo,listeners:{selectionchange:this.ChgButtonStatus,contextmenu:this.OnContextMenu,dblclick:function(f,b,c,d){this.EditCtrler()},scope:this},plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsCategPlugin",store:this.dsCtrler,gridCateg:this.gridCateg,pageSize:SYNO.SS.Pgls.MIN_PAGE_RECORDS,divLoadingHeight:60,blPreloadAll:true,GetParams:this.GetFilterParams.createDelegate(this)})});var a=new SYNO.SS.Pgls.BottomBar({panelRecord:this.expandableList,refreshFunction:this.OnRefresh,refreshFunctionScope:this});this.panelCtrlerList=new SYNO.ux.Panel({region:"center",layout:"fit",items:[this.expandableList],bbar:a});this.panelCategContainer=new SYNO.SS.Pgls.PglsCategContainerPanel({items:[this.gridCateg,this.panelCtrlerList],gridCateg:this.gridCateg,panelRecord:this.expandableList,labelItemCnt:a.labelItemCnt,dsRecord:this.dsCtrler,countMethod:"CountByCategory",countParams:{limit:0,needMask:false},GetParams:this.GetFilterParams.createDelegate(this),emptyStyleMonStore:this.dsCtrler,emptyStyleTip:_T("axis_access_controller","no_controller_item_tip"),emptyStyleTipFunc:"SYNO.SS.App.AxisAcsCtrler.EmptyStyleClickAddEvent('"+this.getId()+"')",fnNeedApplyEmptyStyle:this.HasNoRecord.createDelegate(this),plugins:SYNO.SS.AutoUpdate.CreatePlugin({})})},Activate:function(){this.dsCtrler.on("load",this.OnCtrlerLoad,this);this.OnRefresh()},Deactivate:function(){this.dsCtrler.un("load",this.OnCtrlerLoad,this)},OnRefresh:function(b,c,a){this.LoadData();this.ChgButtonStatus()},HasNoRecord:function(){return(0===this.gridCateg.GetTotalCount())},OnContextMenu:function(a,d,b,c){if(false===a.isSelected(b)){a.select(b)}this.ShowContextMenu(c)},InitContextMenu:function(){this.contextMenu=new SYNO.ux.Menu({items:[{text:_T("ss_common","common_edit"),handler:this.EditCtrler,scope:this},{text:_T("ss_common","common_enable"),handler:function(){this.Enable(true)},scope:this},{text:_T("ss_common","common_disable"),handler:function(){this.Enable(false)},scope:this},{text:_T("axis_access_controller","retrieve"),handler:this.Retrieve,scope:this},{text:_T("ss_common","common_delete"),handler:this.DeleteSelected,scope:this},{itemId:"cmShortcutSeparator",xtype:"menuseparator"},{itemId:"cmAddDesktopShortcut",text:_T("desktop","add_desktop_shortcut"),handler:function(){this.owner.fireEvent("shortcutOnAddItem")},scope:this}]});this.addManagedComponent(this.contextMenu)},ShowContextMenu:function(b){var a=[this.btnEdit,this.menuItemEnable,this.menuItemDisable,this.btnRetrieve];if(!this.contextMenu){this.InitContextMenu()}a.each(function(d,c){this.contextMenu.items.itemAt(c).setVisible(false===d.disabled)},this);this.contextMenu.showAt(b.getXY())},GetCategEntryId:function(a,b){return b.toString()},GetCategName:function(a){return _T("ss_common","status")},GetCategEntryName:function(a,b){switch(b){case SYNO.SS.Grid.Categ.VALUE_ALL:return _T("ss_common","categ_all_status");case SYNO.SS.App.AxisAcsCtrler.Status.Normal:case SYNO.SS.App.AxisAcsCtrler.Status.Disconnected:case SYNO.SS.App.AxisAcsCtrler.Status.Disabled:return SYNO.SS.App.AxisAcsCtrler.GetStatusString(b);default:return _T("camera","conn_status_others")}},GetCategEntryType:function(a,b){return"status"},FilterCateg:function(c,b,a){if(c==SYNO.SS.Grid.Categ.ENTRY_ALL){a.clearFilter();return}a.filter(c,b,false,true,true)},LoadData:function(){var b=this.GetFilterParams();var a=(function(){var c=0;return function(){c++;if(2==c){this.dsCtrler.resumeEvents();this.owner.clearStatusBusy();if(0<this.owner.maskCnt){this.owner.clearStatusBusy()}}}})();this.owner.setStatusBusy();this.dsCtrler.suspendEvents(true);this.dsCamera.load({callback:a,scope:this});this.dsCtrler.load({params:b,callback:a,scope:this})},OnAdd:function(){var a=new SYNO.SS.App.AxisAcsCtrler.AddCtrlerDialog({owner:this.owner,model:new SYNO.SS.App.AxisAcsCtrler.EditCtrlerModel({appWindow:this,dsId:this.owner.getCMSAppDSId(),dsCamera:this.dsCamera})});a.open()},DeleteSelected:function(a,c){var b=function(e){if("yes"!==e){return}var f=[];var d=this.expandableList.getSelectedRecords();d.forEach(function(h,g,i){f.push(h.data.id)});if(0===f.length){return}this.owner.setStatusBusy();this.owner.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"Delete",version:1,params:{ids:Ext.encode(f)},callback:function(h,g){if(true===h){this.owner.fireEvent("updateactivepage")}else{this.owner.clearStatusBusy();this.owner.getMsgBox().alert(this.title,_T("common","error_system"))}},setBusy:true,scope:this})};this.owner.getMsgBox().confirm(this.title,_T("axis_access_controller","controller_del_warning"),b,this)},Enable:function(b){var c=[];var a=this.expandableList.getSelectedRecords();a.forEach(function(e,d,f){c.push(e.data.id)});this.owner.setStatusBusy();this.owner.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"EnableCtrler",version:1,params:{blEnable:b,arrayJson:Ext.encode(c)},callback:function(e,d){if(true===e){this.owner.fireEvent("updateactivepage")}else{this.owner.clearStatusBusy();this.owner.getMsgBox().alert(this.title,_T("common","error_system"),this.fireEvent.createDelegate(this,"updateactivepage"))}},setBusy:true,scope:this})},Retrieve:function(){var b=this.expandableList.getSelectedRecords();var a=function(c){this.owner.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"Retrieve",version:1,params:{ctrlerId:c},callback:function(e,d){this.owner.fireEvent("updateactivepage")},scope:this})};if(0===b.length){return}b.forEach(function(d,c,e){if((true===d.data.enable)&&(this.RETRIEVING!==d.data.need_to_retrieve)){d.data.need_to_retrieve=this.RETRIEVING;a.call(this,d.data.id)}},this);this.dsCtrler.fireEvent("datachanged",this.dsCtrler)},ChgButtonStatus:function(){var b=this.expandableList.getSelectedRecords();var c=false;var d=false;var a=(0===b.length);b.forEach(function(f,e,g){if(true===f.data.enable){c=true}else{d=true}});this.btnDelete.setDisabled(true===a);this.btnEdit.setDisabled(1!==b.length);this.btnEnable.setDisabled(true===a);this.menuItemEnable.setDisabled(false===d);this.menuItemDisable.setDisabled(false===c);this.btnRetrieve.setDisabled(false===c);this.btnPrivilege.setDisabled(true===a)},GetFilterParams:function(){var c=Ext.apply({},this.dsCtrler.baseParams);var a=this.gridCateg.curEntry;var b=a.entryVal;c.filterStatus=b;return c},PreparePeerInfo:function(d,c,b){var a=b.store;d.peer_info=[];if(0===d.grp_id){return d}a.each(function(f,e){if((e!==c)&&(f.get("grp_id")===d.grp_id)){d.peer_info.push({name:f.get("name"),host:f.get("host"),mac_addr:f.get("mac_addr")})}});return d},OnCtrlerLoad:function(b,a,c){var d=this.owner.GetDsCtrler();SYNO.SS.Utils.StoreDataCopy(b,d);d.fireEvent("load",d,a,c);this.gridCateg.ReloadDsCateg();this.ChgButtonStatus();this.owner.fireEvent("shortcutDataReady")},EditCtrler:function(c){var a=this.expandableList.getSelectedRecords();var b=new SYNO.SS.App.AxisAcsCtrler.EditCtrlerDialog({name:a[0].get("name"),owner:this.owner,model:new SYNO.SS.App.AxisAcsCtrler.EditCtrlerModel({appWindow:this,dsId:this.owner.getCMSAppDSId(),dsCamera:this.dsCamera,ctrlerRecord:a[0]})});b.show();if(true===c){b.GoAdvancedPanel()}}});Ext.define("SYNO.SS.App.AxisAcsCtrler.EditCtrlerModel",{extend:"Ext.util.Observable",dsId:LOCAL_DS_ID,dsCamera:null,dsDS:null,ctrler:null,blGotDoor:false,door:null,previousObj:null,constructor:function(a){this.dsId=a.dsId;this.dsCamera=a.dsCamera;if(true===this.IsCmsHost()){this.dsDS=SYNO.SS.GblStore.GetSlaveDSStoreCopy()}if(a.ctrlerRecord){this.ctrler=a.ctrlerRecord.data;this.previousObj=this.ctrler;this.door=this.ctrler.door;this.blGotDoor=true}else{this.ctrler={}}this.callParent()},GetDeviceInfo:function(){return this.ctrler},GetDoors:function(){return this.door},GetDsCamera:function(){return this.dsCamera},GetDsDS:function(){return this.dsDS},PrepareAdvanced:function(b,a){if(true===this.blGotDoor){this.blGotDoor=false;if(false===this.IsDirty(a)){return true}}if(null!==this.door){if(false===this.IsDirty(a)){this.door=a.door;return true}}var c={ctrlerId:a.id,ip:a.host,port:a.port,userName:a.username,password:a.password};b.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"GetDoorNames",version:1,params:c,callback:this.OnGetDoorName,scope:this,setBusy:true,ownerWin:b,intermediateObj:a});return false},OnGetDoorName:function(f,b,e,c){var a,d;if(true===f){this.door=[];b.doors.forEach(this.AppendDoors,this);this.blGotDoor=true;this.previousObj=c.intermediateObj;c.ownerWin.GoAdvancedPanel()}else{a=c.ownerWin.getMsgBox();if(SS_WEBAPI_ERR_IMPROPER_FIRMWARE_VER==b.code){d=String.format(_T("axis_access_controller","update_firmware_tip"),b.errors)}else{d=_T("axis_access_controller","failed_to_load_info")}a.alert(c.ownerWin.title,d)}},AppendDoors:function(b,a,c){this.door.push({name:b})},IsDirty:function(a){if(false===this.previousObj.enable){return false}if((this.previousObj.host===a.host)&&(this.previousObj.port===a.port)&&(this.previousObj.username===a.username)&&(this.previousObj.password===a.password)){return false}return true},IsCmsHost:function(){return(true===IsCMSHost())&&(LOCAL_DS_ID===this.dsId)}});Ext.define("SYNO.SS.App.AxisAcsCtrler.AdvancedPanel",{extend:"SYNO.ux.Panel",owner:null,CTRLER_GRID_MIN_CATEG_WIDTH:210,CTRLER_GRID_MAX_CATEG_WIDTH:480,COL_IDX_LOG_EVT:2,COL_IDX_LOG_ALARM:3,colDisplayFields:{2:"log_evt",3:"log_alarm"},colDisplayTitle:{2:_T("axis_access_controller","log_event"),3:_T("axis_access_controller","log_alarm")},rowForceCheck:[SYNO.SS.App.AxisAcsCtrler.LogFltType.ACSCTRL_GRANTED,SYNO.SS.App.AxisAcsCtrler.LogFltType.ACSCTRL_DENIED,SYNO.SS.App.AxisAcsCtrler.LogFltType.DEVICE_CASING_OPEN,SYNO.SS.App.AxisAcsCtrler.LogFltType.DEVICE_ACTION_FAILED,SYNO.SS.App.AxisAcsCtrler.LogFltType.DOOR_ALARM,SYNO.SS.App.AxisAcsCtrler.LogFltType.IDPOINT_TAMPER,SYNO.SS.App.AxisAcsCtrler.LogFltType.ACSCTRL_DURESS,SYNO.SS.App.AxisAcsCtrler.LogFltType.DOOR_TAMPER],btnSave:null,btnRefresh:null,dsCtrler:null,gridCtrler:null,dsLogConfigDefault:null,dsLogConfig:null,cmLogConfig:null,gridLogConfig:null,constructor:function(a){this.owner=a.appWin;this.Init();this.callParent([Ext.apply({title:_T("ss_common","advanced"),layout:"border",cls:SYNO.SS.Grid.Categ.CLS_CATEG_CONTAINER,tbar:{items:[this.btnSave,this.btnRefresh]},items:[{xtype:"syno_panel",region:"west",layout:"fit",split:true,minSize:this.CTRLER_GRID_MIN_CATEG_WIDTH,maxSize:this.CTRLER_GRID_MAX_CATEG_WIDTH,items:[this.gridCtrler]},{xtype:"syno_panel",region:"center",layout:"fit",margins:"0 0 12 16",cls:"log-config-panel-border-bottom",items:[this.gridLogConfig]}],listeners:{activate:this.Activate,deactivate:this.Deactivate}},a)])},Init:function(){this.InitButtons();this.InitGridCtrler();this.InitGridLogConfig()},InitButtons:function(){this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),handler:this.OnSave,scope:this});this.btnRefresh=new SYNO.ux.Button({text:_T("ss_common","common_refresh"),handler:this.OnRefresh,scope:this})},InitGridCtrler:function(){this.dsCtrler=this.owner.GetDsCtrler();var a=new Ext.grid.RowSelectionModel({singleSelect:true});var b=new Ext.grid.ColumnModel([{dataIndex:"name",renderer:this.RenderCtrler.createDelegate(this)}]);this.gridCtrler=new SYNO.SS.Grid.GridPanel({hideHeaders:true,store:this.dsCtrler,cls:SYNO.SS.Grid.Categ.CLS_CATEG_GRID_PANEL,viewConfig:{forceFit:true},colModel:b,selModel:a})},InitGridLogConfig:function(){var b=[{name:"ctrler_id",type:"int"},{name:"evt_grp",type:"int"},{name:"flt_type",type:"int"},{name:"log_alarm",type:"boolean"},{name:"log_evt",type:"boolean"}];this.dsLogConfigDefault=new Ext.data.JsonStore({fields:b});this.dsLogConfig=new Ext.data.GroupingStore({reader:new Ext.data.JsonReader({fields:b}),groupField:"evt_grp",sortInfo:{field:"evt_grp",direction:"ASC"},listeners:{datachanged:this.OnLogConfigDataChanged,scope:this}});this.cmLogConfig=new Ext.grid.ColumnModel([{dataIndex:"evt_grp",renderer:this.RenderEvtGrp.createDelegate(this)},{id:"flt_type",header:_T("ss_log","log_desc"),dataIndex:"flt_type",renderer:this.RenderFltType.createDelegate(this)},{dataIndex:this.colDisplayFields[this.COL_IDX_LOG_EVT],width:141,fixed:true,renderer:this.RenderCol.createDelegate(this)},{dataIndex:this.colDisplayFields[this.COL_IDX_LOG_ALARM],width:141,fixed:true,renderer:this.RenderCol.createDelegate(this)}]);this.ChangeLogConfigColumnHeader(this.COL_IDX_LOG_EVT);this.ChangeLogConfigColumnHeader(this.COL_IDX_LOG_ALARM);var a=new SYNO.SS.Grid.GroupingView({forceFit:true});this.gridLogConfig=new SYNO.SS.Grid.GridPanel({store:this.dsLogConfig,cm:this.cmLogConfig,view:a,viewConfig:{forceFit:true},autoExpandColumn:"flt_type",listeners:{cellclick:this.OnLogConfigCellClick,headerclick:this.OnLogConfigHeaderClick,scope:this}})},RenderCtrler:function(e,b,a,f,d,c){return'<div class="'+SYNO.SS.Grid.Categ.CLS_CATEG_ENTRY+' general_cursor_default"><div class="'+SYNO.SS.Grid.Categ.CLS_ENTRY_NAME+'">'+e+"</div></div>"},RenderEvtGrp:function(e,b,a,f,d,c){return SYNO.SS.App.AxisAcsCtrler.LogEvtGrp.GetEnumString(e)},RenderFltType:function(e,b,a,f,d,c){return String.format("<span style='line-height:20px; margin-left: 8px'>{0}{1}</span>","&nbsp;&nbsp;&nbsp;&nbsp;",SYNO.SS.App.AxisAcsCtrler.LogFltType.GetEnumString(e))},RenderCol:function(e,f,a,g,c,b){var d;if(true===this.IsEditable(g,c,a)){d=(true===e)?IMG_CHECKED:IMG_UNCHECKED}else{d=(true===e)?IMG_CHECKED_DISABLE:IMG_UNCHECKED_DISABLE}return"<div style='text-align: center;'>"+d+"</div>"},RenderHeader:function(d,b,a){var c=this.IsAllChecked(b,a);return this.RenderHeaderCheck(c,d)},RenderHeaderCheck:function(c,a){var b=(true===c)?IMG_CHECKED:IMG_UNCHECKED;return"<div style='text-align: center;'>"+b+'<span class="grid_header_check">'+a+"</span></div>"},Activate:function(){var a=this.gridCtrler.getSelectionModel();a.on("beforerowselect",this.ConfirmLostChange,this);a.on("rowselect",this.FilterLogConfig,this);if(0===a.getCount()){a.selectFirstRow()}this.OnRefresh()},Deactivate:function(){var a=this.gridCtrler.getSelectionModel();a.un("beforerowselect",this.ConfirmLostChange,this);a.un("rowselect",this.FilterLogConfig,this)},OnSave:function(){this.owner.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"SaveLogConfig",version:1,params:{data:this.GetParam()},callback:this.OnSaveDone,scope:this,setBusy:_T("ss_common","common_saving")})},GetParam:function(){var a={id:this.gridCtrler.getSelectionModel().getSelected().data.id,log_evt:[],log_alarm:[]};this.dsLogConfig.each(function(b){a.log_evt[b.get("flt_type")]=(true===b.get("log_evt"))?1:0;a.log_alarm[b.get("flt_type")]=(true===b.get("log_alarm"))?1:0});a.log_evt=a.log_evt.join("");a.log_alarm=a.log_alarm.join("");return a},OnSaveDone:function(b,a){if(b){this.OnRefresh();this.btnSave.disable()}else{if(SS_WEBAPI_ERR_MSG_CONNECT_FAILED==a.code){this.owner.getMsgBox().alert(this.title,_T("axis_access_controller","conn_err_msg"))}else{this.owner.getMsgBox().alert(this.title,_T("ss_common","error_system"))}}},OnRefresh:function(){this.owner.sendWebAPI({api:SYNO.SS.App.AxisAcsCtrler.Api,method:"EnumLogConfig",version:1,callback:function(b,a){if(b){this.dsLogConfigDefault.loadData(this.CreateStoreData(a.data,this));SYNO.SS.Utils.StoreDataCopy(this.dsLogConfigDefault,this.dsLogConfig);this.FilterLogConfig()}else{this.owner.getMsgBox().alert(this.title,_T("ss_common","error_system"))}},scope:this,setBusy:true})},CreateStoreData:function(e,b){var d=[];var c;var a,f;e.each(function(g){c=g.log_evt.length;for(f=0;f<c;f++){a=d.size();d[a]={};d[a].ctrler_id=g.id;d[a].evt_grp=SYNO.SS.App.AxisAcsCtrler.LogFltType.GetEvtGrp(f);d[a].flt_type=f;d[a].log_alarm=("1"===g.log_alarm.charAt(f));d[a].log_evt=("1"===g.log_evt.charAt(f));if(true===this.IsForceCheck(f,this.COL_IDX_LOG_EVT)){d[a].log_evt=true}if(false===d[a].log_evt){d[a].log_alarm=false}}},b);return d},NeedConfirmChange:function(){return this.IsDirty()},ReverseChange:function(){SYNO.SS.Utils.StoreDataCopy(this.dsLogConfigDefault,this.dsLogConfig)},ConfirmLostChange:function(b,d,c,a){if(false===this.IsDirty()){return true}SYNO.SS.Utils.ConfirmLostChange({msgBox:this.owner.getMsgBox(),fnYes:function(){this.ReverseChange();b.selectRow(d)},scope:this});return false},FilterLogConfig:function(){var a=this.gridCtrler.getSelectionModel().getSelected().data.id;this.dsLogConfig.filter("ctrler_id",a,false,true,true)},OnLogConfigDataChanged:function(){this.CorrectLogEvt();this.ChangeLogConfigColumnHeader(this.COL_IDX_LOG_EVT);this.ChangeLogConfigColumnHeader(this.COL_IDX_LOG_ALARM);this.SetupSaveButton()},CorrectLogEvt:function(){this.dsLogConfig.each(function(a,b){if(true===this.IsForceCheck(b,this.COL_IDX_LOG_EVT)){a.data.log_evt=true}else{if(false===this.IsColCheckable(this.COL_IDX_LOG_ALARM,a)){a.data.log_alarm=false}}},this)},SetupSaveButton:function(){if(true===this.IsDirty()){this.btnSave.enable()}else{this.btnSave.disable()}},IsAllChecked:function(a,c){var b=false;c.each(function(d){if(true===this.IsColCheckable(a,d)){b=(true===d.data[this.colDisplayFields[a]]);return b}},this);return b},IsDirty:function(){var b,a=this.dsLogConfigDefault.getCount();var c=this.dsLogConfig.snapshot||this.dsLogConfig.data;for(b=0;b<a;b++){if(true===this.IsRecordDirty(c.itemAt(b),this.dsLogConfigDefault.getAt(b))){return true}}return false},IsRecordDirty:function(c,b){var d,a;for(a in this.colDisplayFields){d=this.colDisplayFields[a];if(c.data[d]!==b.data[d]){return true}}return false},IsForceCheck:function(b,a){if(this.COL_IDX_LOG_EVT===a){return(-1!==this.rowForceCheck.indexOf(b))}return false},IsColCheckable:function(b,a){if(this.COL_IDX_LOG_ALARM===b){return a.data.log_evt}return true},IsEditable:function(c,b,a){if((true===this.IsForceCheck(c,b))||(false===this.IsColCheckable(b,a))){return false}return true},OnLogConfigCellClick:function(d,h,c,f){var b=d.getStore();var a=b.getAt(h);var g=this.colDisplayFields[c];if(true===this.IsEditable(h,c,a)){a.data[g]=!a.data[g];b.fireEvent("datachanged",b)}},OnLogConfigHeaderClick:function(b,a,d){var c=this.IsAllChecked(a,this.dsLogConfig);this.dsLogConfig.each(function(e,f){if(true===this.IsEditable(f,a,e)){e.data[this.colDisplayFields[a]]=!c}},this);this.dsLogConfig.fireEvent("datachanged",this.dsLogConfig)},ChangeLogConfigColumnHeader:function(a){var b=this.RenderHeader(this.colDisplayTitle[a],a,this.dsLogConfig);this.cmLogConfig.setColumnHeader(a,b)}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler");Ext.define("SYNO.SS.App.AxisAcsCtrler.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.AxisAcsCtrler.MainWindow"});Ext.define("SYNO.SS.App.AxisAcsCtrler.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",MIN_WIDTH:940,MIN_HEIGHT:515,dsCtrler:null,tabIndex:{NONE:-1,CTRLER:0,CARD_HOLDER:1,LOG:2,ADVANCED:3},blConfirmLostChange:false,constructor:function(c){this.Init();var d=new SYNO.SS.App.AxisAcsCtrler.CtrlerPanel({appWin:this});var e=this.CreateTabItemForGblSearch("SYNO.SS.App.AxisAcsCtrler.CardHolderPanel",[{appWin:this}]);var b=this.CreateTabItemForGblSearch("SYNO.SS.App.AxisAcsCtrler.LogPanel",[{appWin:this}]);var a=this.CreateTabItemForGblSearch("SYNO.SS.App.AxisAcsCtrler.AdvancedPanel",[{appWin:this}]);this.callParent([Ext.apply({width:this.MIN_WIDTH,height:this.MIN_HEIGHT,minWidth:this.MIN_WIDTH,minHeight:this.MIN_HEIGHT,resizable:true,layout:"fit",tabIndex:this.tabIndex,panelList:[d,e,b,a],plugins:[{ptype:"shortcutCreatePlugin",panelItems:d.expandableList,fnGetAppItemConfig:(function(f,g){f.title=g.get("name");Ext.apply(f.param,{blCmsApp:true,dsId:this.getCMSAppDSId(),itemId:g.get("id")});return f}).createDelegate(this)},{ptype:"shortcutLaunchPlugin",panelItems:d.expandableList,panelCateg:d.gridCateg,store:this.dsCtrler,idProperty:"id"}]},c)]);this.tabPanel.getItem(this.tabIndex.CARD_HOLDER).disable();this.tabPanel.getItem(this.tabIndex.LOG).disable();this.tabPanel.getItem(this.tabIndex.ADVANCED).disable();this.on("updateactivepage",this.OnRefresh);this.mon(this.dsCtrler,"load",this.CheckToEnable,this);this.mon(this.tabPanel,"beforetabchange",this.OnBeforeTabChange,this)},onOpen:function(a){this.callParent(arguments);this.fireEvent("shortcutOnOpen",a)},onRequest:function(a){this.callParent(arguments);this.fireEvent("shortcutOnRequest",a)},onClose:function(){if((true===this.blConfirmLostChange)||(false===this.NeedConfirmChange())){this.blConfirmLostChange=false;this.tabPanel.getActiveTab().fireEvent("deactivate");this.callParent(arguments);return true}SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.blConfirmLostChange=true;this.close()},scope:this});return false},getHelpParam:function(){switch(this.GetCurrentTabIndex()){case this.tabIndex.CARD_HOLDER:return"axisacsctrler_cardholder.html";case this.tabIndex.LOG:return"axisacsctrler_log_center.html";case this.tabIndex.ADVANCED:return"axisacsctrler_advanced.html";default:return"axisacsctrler_list.html"}},Init:function(){this.dsCtrler=new SYNO.API.JsonStore({appWindow:this,api:SYNO.SS.App.AxisAcsCtrler.Api,method:"Enum",version:1,baseParams:{start:0,limit:SYNO.SS.Pgls.MIN_PAGE_RECORDS},totalProperty:"total",root:"data",fields:SYNO.SS.App.AxisAcsCtrler.CtrlerFields})},OnRefresh:function(){this.GetTabPanel({}).getActiveTab().OnRefresh();SYNO.SDS.StatusNotifier.fireEvent("ctrlerDataUpdated")},CheckToEnable:function(b,a,c){if(0<b.getCount()){this.tabPanel.getItem(this.tabIndex.CARD_HOLDER).enable();this.tabPanel.getItem(this.tabIndex.LOG).enable();this.tabPanel.getItem(this.tabIndex.ADVANCED).enable()}else{this.tabPanel.getItem(this.tabIndex.CARD_HOLDER).disable();this.tabPanel.getItem(this.tabIndex.LOG).disable();this.tabPanel.getItem(this.tabIndex.ADVANCED).disable()}},GetDsCtrler:function(){return this.dsCtrler},NeedConfirmChange:function(){var a=this.tabPanel.getActiveTab();return(a&&Ext.isFunction(a.NeedConfirmChange))?a.NeedConfirmChange():false},ReverseChange:function(){var a=this.tabPanel.getActiveTab();if(a&&Ext.isFunction(a.ReverseChange)){a.ReverseChange()}},OnBeforeTabChange:function(a,c,b){if((true===this.blConfirmLostChange)||(false===this.NeedConfirmChange())){this.blConfirmLostChange=false;return true}SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.blConfirmLostChange=true;this.ReverseChange();this.tabPanel.setActiveTab(c.getItemId())},scope:this});return false}});Ext.namespace("SYNO.SS.App.AxisAcsCtrler.Utils");Ext.apply(SYNO.SS.App.AxisAcsCtrler.Utils,{EVENT_TIME_PRE_RANGE:10,EVENT_TIME_POST_RANGE:20,PlayLogEvents:function(h,c){var b=c.findAppWindow();var a=(0<b.cmsAppDSId)?b.cmsAppDSId:h.data.cam_ds_id;var g=h.data.tmstmp-this.EVENT_TIME_PRE_RANGE;var e=h.data.tmstmp+this.EVENT_TIME_POST_RANGE;var d=[{api:"SYNO.SurveillanceStation.Event",method:"List",version:4,params:{cameraIds:(LOCAL_DS_ID===h.data.cam_ds_id)?h.data.cam_id:h.data.cam_id_on_server,evtSrcId:LOCAL_DS_ID,evtSrcType:EVENT_SRC_LOCAL,fromTime:g,toTime:e,recording:0,locked:0,reason:"",blIncludeSnapshot:true}},{api:"SYNO.SurveillanceStation.Event",method:"List",version:4,params:{cameraIds:(LOCAL_DS_ID===h.data.cam_ds_id)?h.data.cam_id:h.data.cam_id_on_server,evtSrcId:LOCAL_DS_ID,evtSrcType:EVENT_SRC_LOCAL,recording:1,locked:0,reason:"",blIncludeSnapshot:true}}];var f=function(t,q,m,k){var p,o;var l;var s=[];var r=Ext.data.Record.create(SYNO.SS.App.Event.Def.storeEvtListFields);var n=new Ext.data.SimpleStore({appWindow:b,fields:SYNO.SS.App.Event.Def.storeEvtListFields,data:[]});for(p=0;p<q.result.length;p++){l=SYNO.API.Util.GetValByIndex(q,p);if(Ext.isDefined(l.code)){continue}s=l.events;for(o=0;o<s.length;o++){n.add(new r(s[o]))}if((0===p)&&(true===this.ConfirmRecordingState(n,e))){break}}this.ConfirmRange(n.getRange(),g,e);this.OnEventLoad(n,n.getRange(),a,c)};b.sendWebAPI({compound:{stopwhenerror:false,params:d},dsId:a,callback:f,scope:this})},ConfirmRecordingState:function(c,d){var b;var a=c.findExact("recording",true);if(-1===a){return false}else{b=c.getAt(a)}return true},ConfirmRange:function(a,c,b){a.each(function(e){if((b<=e.data.startTime)||(c>=e.data.stopTime)){e.store.remove(e);return}var h=Math.max(c,e.data.startTime);var g=Math.min(b,e.data.stopTime);var d;var f;if(IsVideoTypeUseVLC(e.data.video_type)){d=(h-e.data.startTime);f=(g-h)}else{d=e.data.frameCount*(h-e.data.startTime)/(e.data.stopTime-e.data.startTime);f=e.data.frameCount*(g-h)/(e.data.stopTime-e.data.startTime)}e.data.offsetFrameCnt=d;e.data.playFrameCnt=f})},OnEventLoad:function(d,c,a,e){var b=SYNO.SS.Module.InstanceNameMap[MODULE_ID_EVENT_PLAYER];c.sort(function(h,g){return h.data.startTime-g.data.startTime});if(0===c.length){if(e.modal){d.appWindow.getMsgBox().alert(d.appWindow.title,_T("axis_access_controller","no_event"))}else{e.getMsgBox().alert(d.appWindow.title,_T("axis_access_controller","no_event"))}return}if(LOCAL_DS_ID!==a){Ext.each(c,function(g){g.set("idOnRecServer",g.get("id"));g.set("dsId",a)})}var f={records:c};SYNO.SDS.AppLaunch(b,f,true)}});