/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.PersonalSettings.FormPanel",{extend:"SYNO.ux.FormPanel",LABEL_WIDTH:220,FIELD_WIDTH:260,DESC_MAX_LENGTH:64,constructor:function(a){a=Ext.applyIf(a,{trackResetOnLoad:true,labelWidth:this.LABEL_WIDTH});this.callParent([a])},ResetData:function(){this.getForm().reset()},IsFormDirty:function(){return this.getForm().isDirty()},GetMsgBox:function(){return this.findAppWindow().getMsgBox()},SetStatusBusy:function(){this.findAppWindow().setStatusBusy()},ClearStatusBusy:function(){this.findAppWindow().clearStatusBusy()},Close:function(a){var b=this.findAppWindow();if(true===a){b.blForceClose=true}b.close()}});Ext.define("SYNO.SS.App.PersonalSettings.Account",{extend:"SYNO.SS.App.PersonalSettings.FormPanel",DEFAULT_PWD:"12345678",DEFAULT_CONFIRM_PWD:"87654321",fldUserName:null,fldUserDesc:null,fldPwd:null,fldConfirmPwd:null,chkChangePwd:null,fldOriginPwd:null,cmbDisplayLang:null,blInited:false,passwordChecker:null,constructor:function(){this.InitUI();this.callParent([{title:_T("options","account"),items:this.GetFormItems(),trackResetOnLoad:true,labelWidth:this.LABEL_WIDTH}]);this.on("afterrender",this.InitData,this)},InitUI:function(){this.passwordChecker=new SYNO.SS.Utils.CheckStrongPassword();this.fldUserName=new SYNO.ux.DisplayField({name:"username",fieldLabel:_T("ss_common","common_name"),cls:"ellipsis_text",style:"cursor: default;"});if(SYNO.SS.UserAuthType.LOCAL===_S("USER_AUTH_TYPE")){this.fldUserDesc=new SYNO.ux.TextField({name:"fullname",fieldLabel:_T("ss_common","common_description"),width:this.FIELD_WIDTH,maxLength:this.DESC_MAX_LENGTH})}else{this.fldUserDesc=new SYNO.ux.DisplayField({name:"fullname",fieldLabel:_T("ss_common","common_description"),width:this.FIELD_WIDTH,maxLength:this.DESC_MAX_LENGTH})}this.chkChangePwd=new SYNO.SS.Form.Checkbox({name:"change_password",boxLabel:_T("ss_common","change_password"),hideLabel:true,value:false,listeners:{scope:this,check:function(a,b){this.fldOriginPwd.setDisabled(!b);this.fldPwd.setDisabled(!b);this.fldConfirmPwd.setDisabled(!b)}}});this.fldOriginPwd=new SYNO.ux.TextField({inputType:"password",preventAutoFill:true,width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","old_password"),maxLength:USER_PWD_MAX_LENGTH,value:"",disabled:(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE"))});this.fldPwd=new SYNO.ux.TextField({inputType:"password",name:"password",preventAutoFill:true,width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","password"),maxLength:USER_PWD_MAX_LENGTH,value:(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE"))?"":this.DEFAULT_PWD,disabled:(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE")),validator:this.passwordChecker.isStrongValidator.createDelegate(this.passwordChecker)});this.fldConfirmPwd=new SYNO.ux.TextField({inputType:"password",name:"password2",preventAutoFill:true,width:this.FIELD_WIDTH,fieldLabel:_T("ss_common","confirm_pwd"),maxLength:USER_PWD_MAX_LENGTH,value:(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE"))?"":this.DEFAULT_CONFIRM_PWD,disabled:(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE")),validator:(function(a){if(false===this.blInited){return true}else{if((this.DEFAULT_CONFIRM_PWD===a)&&(this.DEFAULT_PWD===this.fldPwd.getValue())){return true}else{if(a===this.fldPwd.getValue()){return true}else{return _T("ss_common","error_repswd")}}}}).createDelegate(this),validateOnBlur:true,validationEvent:"blur"});this.cmbDisplayLang=new SYNO.ux.ComboBox({name:"lang",fieldLabel:_T("visualstation","lang_display"),width:this.FIELD_WIDTH,store:SYNO.SS.Utils.GetLangStore(),valueField:"value",displayField:"display",mode:"local",forceSelection:true,triggerAction:"all",editable:false});this.passwordChecker.initPasswordChecker({getForm:this.getForm.createDelegate(this),getUserAcc:"username",getUserDesc:"fullname",getPasswd:"password",getPasswdConfirm:"password2",getStartValidate:function(){return true}})},InitData:function(){this.SetStatusBusy();Ext.Ajax.request({url:PATH_UI_CGI+"userPrivilege.cgi",params:{action:"loadOptions"},method:"POST",callback:function(b,d,a){var c;this.ClearStatusBusy();if(d){c=Ext.util.JSON.decode(a.responseText).data;this.SetFormValues(c)}else{this.GetMsgBox().alert(_T("ss_common","common_options"),_T("ss_common","error_system"),this.close,this)}},scope:this})},GetFormItems:function(){var a;if(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE")){a=[this.fldUserName,this.fldUserDesc,this.chkChangePwd,{xtype:"syno_panel",style:"padding-left: 30px;",layout:"form",labelWidth:this.LABEL_WIDTH-30,items:[this.fldOriginPwd,this.fldPwd,this.fldConfirmPwd]},this.cmbDisplayLang]}else{a=[this.fldUserName,this.fldUserDesc,this.fldPwd,this.fldConfirmPwd,this.cmbDisplayLang]}return a},SetFormValues:function(a){this.passwordChecker.passwordPolicy=a.passwdRules;this.getForm().setValues(a);this.fldUserName.getEl().dom.setAttribute("ext:qtip",this.fldUserName.getValue());if(false===a.editable){this.fldUserDesc.setDisabled(true);this.fldPwd.setDisabled(true);this.fldConfirmPwd.setDisabled(true);if(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE")){this.chkChangePwd.setDisabled(true)}}else{if(SYNO.SS.UserAuthType.LDAP!==_S("USER_AUTH_TYPE")){this.fldPwd.setDisabled(a.disallowchpasswd);this.fldConfirmPwd.setDisabled(a.disallowchpasswd)}else{this.chkChangePwd.setDisabled(a.disallowchpasswd);this.fldPwd.setDisabled(true);this.fldConfirmPwd.setDisabled(true)}}this.syncSize();this.blInited=true},Validate:function(){if(SYNO.SS.UserAuthType.LOCAL===_S("USER_AUTH_TYPE")){return(this.fldUserDesc.validate())&&(this.fldPwd.validate())&&(this.fldConfirmPwd.validate())}else{if((SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE"))&&(true==this.chkChangePwd.getValue())){return(this.fldOriginPwd.validate())&&(this.fldPwd.validate())&&(this.fldConfirmPwd.validate())}else{return true}}},OnSubmit:function(){this.SetStatusBusy({text:_T("ss_common","common_saving")});var c={action:"saveOptions",userName:this.fldUserName.getValue(),userDesc:this.fldUserDesc.getValue(),userPwd:this.fldPwd.getValue(),userConfirmPwd:this.fldConfirmPwd.getValue(),displayLang:this.cmbDisplayLang.getValue(),oriDisplayLang:_S("LANG")};var b=String.format("{0}<ul><br><li>{1}</li></ul>",_T("ss_common","refresh_confirm"),_T("ss_common","lang_changed"));var a=function(){SYNO.SDS.Desktop.getMsgBox().confirm(_T("ss_common","language"),b,function(d){if("yes"===d){location.reload()}},this)};if(SYNO.SS.UserAuthType.LDAP===_S("USER_AUTH_TYPE")){Ext.apply(c,{originalUserPwd:this.fldOriginPwd.getValue()})}Ext.Ajax.request({url:PATH_UI_CGI+"userPrivilege.cgi",params:c,method:"POST",callback:function(g,h,d){var e,f;this.ClearStatusBusy();e=SYNO.SS.Utils.ParseRespJson(d.responseText);if(h&&e.success){if(true===this.cmbDisplayLang.isDirty()){SYNO.SDS.Desktop.mon(this,"destroy",a)}this.Close(true)}else{SYNO.SS.Utils.Alert(this.GetMsgBox(),_T("ss_common","common_options"),e)}},scope:this})}});Ext.define("SYNO.SS.App.PersonalSettings.Desktop",{extend:"Ext.form.FormPanel",imageSelectId:null,newImage:false,wallpaperSelector:null,constructor:function(a){Ext.applyIf(a,{title:_T("ss_common","desktop"),cls:"ss-personal-desktop-form",trackResetOnLoad:true,listeners:{afterlayout:{single:true,scope:this,fn:this.OnAfterLayout}},layout:"table",layoutConfig:{columns:2},items:[{colspan:2,itemId:"customize_color",name:"customize_color",xtype:"syno_checkbox",boxLabel:_T("options","customize_color")},{indent:1,xtype:"syno_displayfield",value:_T("options","text_color")+_T("ss_common","common_colon")},{itemId:"text_color",name:"text_color",xtype:"syno_colorfield",width:190,value:"#FFFFFF"},{indent:1,xtype:"syno_displayfield",value:_T("options","background_color")+_T("ss_common","common_colon")},{itemId:"background_color",name:"background_color",xtype:"syno_colorfield",width:190,value:"#FFFFFF"},{colspan:2,itemId:"customize_wallpaper",name:"customize_wallpaper",xtype:"syno_checkbox",boxLabel:_T("options","customize_wallpaper")},{rowspan:4,indent:1,itemId:"wallpaper_thumbnail",xtype:"box",cls:"thumb-customize",autoEl:{tag:"img"}},{cellCls:"wallpaper-cell",itemId:"wallpaper_filename",name:"wallpaper_filename",xtype:"syno_displayfield",hidden:_S("diskless"),value:""},{cellCls:"wallpaper-cell",id:this.imageSelectId=Ext.id(),xtype:"syno_button",hidden:_S("diskless"),text:_T("options","select_image"),scope:this,handler:this.OnSelectWallpaper},{cellCls:"wallpaper-cell",itemId:"wallpaper_position",name:"wallpaper_position",xtype:"syno_combobox",hidden:_S("diskless"),value:"center",width:190,forceSelection:true,allowBlank:false,displayField:"display",valueField:"value",store:new Ext.data.ArrayStore({fields:["display","value"],data:[[_T("options","login_background_position_center"),"center"],[_T("options","login_background_position_fill"),"fill"],[_T("options","login_background_position_fit"),"fit"],[_T("options","login_background_position_stretch"),"stretch"],[_T("options","login_background_position_tile"),"tile"]]}),listeners:{select:{fn:this.OnChangeSettings,scope:this,buffer:100}}},{cellCls:"wallpaper-cell-last",itemId:"wallpaper_path",name:"wallpaper_path",xtype:"hidden",value:""},{itemId:"wallpaper_ext",name:"wallpaper_ext",xtype:"hidden",value:""},{itemId:"wallpaper_type",name:"wallpaper_type",xtype:"hidden",value:""}]});this.callParent([a]);this.origConfig=Ext.apply({},SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper")||{});this.customizeWallpaper=this.getComponent("customize_wallpaper");this.wallpaperPath=this.getComponent("wallpaper_path");this.wallpaperExt=this.getComponent("wallpaper_ext");this.wallpaperType=this.getComponent("wallpaper_type");this.wallpaperThumbnail=this.getComponent("wallpaper_thumbnail");this.wallpaperFileName=this.getComponent("wallpaper_filename")},OnAfterLayout:function(){var b,a=this.getForm();b=new SYNO.SDS.Utils.EnableCheckGroup(a,"customize_color",["text_color","background_color"]);b=new SYNO.SDS.Utils.EnableCheckGroup(a,"customize_wallpaper",[this.imageSelectId,"wallpaper_position"]);if("admin"===_S("user")){SYNO.SDS.Utils.DisplayField(this.getForm(),"email",false)}a.setValues(this.origConfig);this.origConfig.wallpaper=1+(this.origConfig.wallpaper||0);this.wallpaperThumbnail.getEl().dom.src=Ext.urlAppend("wallpaper.cgi",Ext.urlEncode({user:_S("user"),id:this.origConfig.wallpaper}));this.getComponent("customize_color").on("check",this.OnChangeSettings,this,{buffer:200});this.getComponent("customize_wallpaper").on("check",this.OnChangeSettings,this,{buffer:200});this.getComponent("text_color").on("valid",this.OnChangeSettings,this,{buffer:200});this.getComponent("background_color").on("valid",this.OnChangeSettings,this,{buffer:200})},ApplyForm:function(){var a=this.getForm();if(!this.wallpaperPath.getValue()){this.customizeWallpaper.setValue(false)}if(!a.isDirty()){return}if(!a.isValid()){this.module.getMsgBox().alert(this.module.title,_T("ss_common","forminvalid"));return false}this.ApplySettings()},ApplySettings:function(){var b={},c={},a={};Ext.apply(c,this.getForm().getValues());Ext.apply(a,SYNO.SDS.UserSettings.getProperty("Desktop","wallpaper")||{});if(!this.customizeWallpaper.getValue()){delete (c.wallpaper_path);delete (c.wallpaper_ext);delete (c.wallpaper_type)}c.newImage=this.newImage;Ext.apply(b,a);Ext.apply(b,c,{customize_color:false,customize_wallpaper:false});b.wallpaper=1+(b.wallpaper||0);b.customize_color=this.ParseBool(b.customize_color);b.customize_wallpaper=this.ParseBool(b.customize_wallpaper);SYNO.SDS.UserSettings.setProperty("Desktop","wallpaper",b);SYNO.SDS.UserSettings.save()},OnChangeSettings:function(){var a=Ext.apply({},this.getForm().getValues());if(!this.customizeWallpaper.getValue()||!a.wallpaper_path){delete (a.wallpaper_path);delete (a.wallpaper_ext);delete (a.wallpaper_type);a.customize_wallpaper=false}if(!this.getComponent("text_color").isValid()){a.text_color="#FFFFFF"}if(!this.getComponent("background_color").isValid()){a.background_color="#FFFFFF"}a.newImage=this.newImage;a.wallpaper=1+(a.wallpaper||0);a.customize_color=this.ParseBool(a.customize_color);a.customize_wallpaper=this.ParseBool(a.customize_wallpaper);SYNO.SDS.Desktop.updateBackground(a);SYNO.SDS.Desktop.updateTextColor(a)},ParseBool:function(a){if(a==="true"||a==="on"||a===true){return true}return false},OnSelectWallpaper:function(){if(this.wallpaperSelector){this.wallpaperSelector.show()}else{this.wallpaperSelector=new SYNO.SS.App.Utils.ImageSelector({owner:this.module},"desktop","background");this.wallpaperSelector.mon(this.wallpaperSelector,"choose",this.OnSelectWallpaperDone,this);this.wallpaperSelector.open()}},OnSelectWallpaperDone:function(a){this.newImage=true;this.wallpaperPath.setValue(a.data.path);this.wallpaperExt.setValue(a.data.type);this.wallpaperType.setValue(a.data.apply_type);this.wallpaperFileName.setValue(Ext.util.Format.ellipsis(a.data.filename,30,true));this.wallpaperThumbnail.getEl().dom.src=a.data.url;this.wallpaperSelector.hide();this.OnChangeSettings()},RestoreOrigSettings:function(){SYNO.SDS.Desktop.updateBackground(this.origConfig);SYNO.SDS.Desktop.updateTextColor(this.origConfig)},IsFormDirty:function(){return this.getForm().isDirty()}});Ext.define("SYNO.SS.App.PersonalSettings.Others",{extend:"SYNO.SS.App.PersonalSettings.FormPanel",DEFAULT_APP_LIVE:"SYNO.SS.App.Liveview.Instance",DEFAULT_APP_TIMELINE:"SYNO.SS.App.Timeline.Instance",DEFAULT_APP_EVENT:"SYNO.SS.App.Event.Instance",DEFAULT_APP_CAMERA:"SYNO.SS.App.Camera.Instance",chkNoLogoutConfirm:null,chkResumeLoginSts:null,chkDefApp:null,cmbDefApp:null,panelDefApp:null,fldResetDesktop:null,btnResetDesktop:null,constructor:function(){this.InitUI();this.callParent([{hideMode:"offsets",title:_T("options","others"),cls:"options-panel-others",items:[this.chkNoLogoutConfirm,this.chkResumeLoginSts,this.panelDefApp,this.fldResetDesktop,this.btnResetDesktop]}]);this.InitData()},InitUI:function(){this.chkNoLogoutConfirm=new SYNO.ux.Checkbox({boxLabel:_T("options","disable_logout_confirm"),name:"disableLogoutConfirm"});this.chkResumeLoginSts=new SYNO.ux.Checkbox({boxLabel:_T("options","remember_window_state"),name:"rememberWindowState"});this.chkDefApp=new SYNO.ux.Checkbox({boxLabel:_T("options","default_app"),name:"enableDefApp",listeners:{check:function(b,c){if(true===c){this.cmbDefApp.enable()}else{this.cmbDefApp.disable()}},scope:this}});var a=new Ext.data.ArrayStore({fields:["defAppValue","defAppDisplay"],data:[[this.DEFAULT_APP_LIVE,_T("ss_common","common_liveview")],[this.DEFAULT_APP_TIMELINE,_T("event","event_timeline")],[this.DEFAULT_APP_EVENT,_T("event","recordings")],[this.DEFAULT_APP_CAMERA,_T("camera","ip_camera")]]});this.cmbDefApp=new SYNO.ux.ComboBox({store:a,valueField:"defAppValue",displayField:"defAppDisplay",disabled:true,name:"defaultApp"});this.panelDefApp=new SYNO.ux.Panel({cls:"panel-def-app",layout:"column",items:[this.chkDefApp,this.cmbDefApp]});this.fldResetDesktop=new SYNO.ux.DisplayField({labelWidth:480,itemCls:"fld-reset-desktop",fieldLabel:_T("options","reset_desktop_status")});this.btnResetDesktop=new SYNO.ux.Button({text:_T("options","reset_desktop"),disabled:_S("DEMO_MODE"),handler:this.OnResetDestop,scope:this})},InitData:function(){this.SetFormValues()},SetFormValues:function(){var b=SYNO.SDS.UserSettings.getProperty("Desktop","disableLogoutConfirm");var c=SYNO.SDS.UserSettings.getProperty("Desktop","rememberWindowState");var a=SYNO.SDS.UserSettings.getProperty("Desktop","enableDefApp");var d=SYNO.SDS.UserSettings.getProperty("Desktop","defaultApp");this.getForm().setValues({disableLogoutConfirm:(false!==b),rememberWindowState:(c||false),enableDefApp:(true===a),defaultApp:(d||this.DEFAULT_APP_LIVE)})},OnSubmit:function(){var b=this.chkNoLogoutConfirm.getValue();var c=this.chkResumeLoginSts.getValue();var a=this.chkDefApp.getValue();var d=this.cmbDefApp.getValue();SYNO.SDS.UserSettings.setProperty("Desktop","disableLogoutConfirm",b);SYNO.SDS.UserSettings.setProperty("Desktop","rememberWindowState",c);SYNO.SDS.UserSettings.setProperty("Desktop","enableDefApp",a);SYNO.SDS.UserSettings.setProperty("Desktop","defaultApp",d)},OnResetDestop:function(){var a=function(b){if("yes"===b){this.SetStatusBusy();SYNO.SDS.UserSettings.reset({callback:this.OnResetDestopDone,scope:this})}};this.GetMsgBox().confirm(_T("options","others"),_T("options","reset_desktop_status_warn"),a,this)},OnResetDestopDone:function(b,c,a){this.ClearStatusBusy();if(true===c){SYNO.SDS.UserSettings.setProperty("Desktop","disableLogoutConfirm",true);location.reload(true)}else{this.GetMsgBox().alert(_T("options","others"),_T("ss_common","error_system"))}}});Ext.namespace("SYNO.SS.App.Personal");Ext.define("SYNO.SS.App.PersonalSettings.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.PersonalSettings.MainWindow"});Ext.define("SYNO.SS.App.PersonalSettings.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",tabIndex:{NONE:-1,ACCOUNT:0,DESKTOP:1,OTHERS:2},WIN_WIDTH:850,WIN_HEIGHT:500,blForceClose:false,btnOK:null,btnCancel:null,constructor:function(a){this.InitUI();this.callParent([Ext.apply({cls:"ss-personal-setting-window",title:_T("ss_common","common_options"),resizable:false,maximizable:false,width:this.WIN_WIDTH,height:this.WIN_HEIGHT,layout:"fit",tabIndex:this.tabIndex,panelList:[this.panelAccount,this.panelDesktop,this.panelOthers],buttons:[this.btnOK,this.btnCancel]},a)])},InitUI:function(){this.panelAccount=this.CreateTabItemForGblSearch("SYNO.SS.App.PersonalSettings.Account",[this]);this.panelDesktop=this.CreateTabItemForGblSearch("SYNO.SS.App.PersonalSettings.Desktop",[{module:this,baseURL:this.jsConfig.jsBaseURL}]);this.panelOthers=this.CreateTabItemForGblSearch("SYNO.SS.App.PersonalSettings.Others",[this]);this.btnOK=new SYNO.ux.Button({text:_T("ss_common","common_ok"),btnStyle:"blue",disabled:_S("DEMO_MODE"),handler:this.OnOK,scope:this});this.btnCancel=new SYNO.ux.Button({text:_T("ss_common","common_cancel"),scope:this,handler:this.close})},onOpen:function(a){this.callParent(arguments)},onClose:function(){if((true===this.blForceClose)||(false===this.IsDirty())){this.blForceClose=false;return true}SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){if(this.panelDesktop.IsFormDirty()){this.panelDesktop.RestoreOrigSettings()}this.blForceClose=true;this.close()},scope:this});return false},IsDirty:function(){return((true===this.panelAccount.IsFormDirty())||(true===this.panelDesktop.IsFormDirty())||(true===this.panelOthers.IsFormDirty()))},OnOK:function(){var a=true;if(false===this.panelDesktop.ApplyForm()){this.tabPanel.setActiveTab(this.panelDesktop);return}if(true===this.panelOthers.IsFormDirty()){this.panelOthers.OnSubmit()}if(true===this.panelAccount.IsFormDirty()){a=false;if(true===this.panelAccount.Validate()){this.panelAccount.OnSubmit()}}if(true===a){this.blForceClose=true;this.close()}},getHelpParam:function(){var a;switch(this.GetCurrentTabIndex()){case this.tabIndex.ACCOUNT:a="options_account.html";break;case this.tabIndex.DESKTOP:a="options_desktop.html";break;case this.tabIndex.OTHERS:a="options_others.html";break;default:a="options.html"}return a}});