/* Copyright (c) 2015 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.Snapshot.AdvancedPanel",{extend:"SYNO.SDS.Utils.FormPanel",parentWin:null,advancedSetting:{},chkAddTimestamp:null,cmbboxPosition:null,chkDispSetting:null,cmbboxDispSetting:null,chkLimitSize:null,textLimitSizeInGb:null,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{border:false,trackResetOnLoad:true,cls:"management_panel snapshot_advance_panel",title:_T("ss_common","advanced"),bodyStyle:"padding:0px 0px 0px 0px",disabled:(SYNO.SS.UserPrivType.ADMIN!==_S("USER_PRIVILEGE")),buttons:[new SYNO.ux.Button({text:_T("ss_mail","mail_save"),disabled:_S("DEMO_MODE"),btnStyle:"blue",handler:this.OnSave,scope:this}),new SYNO.ux.Button({text:_T("ss_common","common_reset"),handler:function(){if(true===this.getForm().isDirty()){this.OnRefresh()}},scope:this})],items:[new SYNO.ux.FieldSet({title:_T("camera","cam_param_time_stamp"),autoHeight:true,collapsible:true,items:[this.chkAddTimestamp,this.cmbboxPosition]}),new SYNO.ux.FieldSet({title:_T("snapshot","display_duration_setting"),autoHeight:true,collapsible:true,items:{xtype:"syno_panel",layout:"hbox",items:[this.chkDispSetting,this.cmbboxDispSetting]}}),new SYNO.ux.FieldSet({title:_T("snapshot","archive"),autoHeight:true,collapsible:true,items:{xtype:"syno_panel",layout:"hbox",items:[this.chkLimitSize,this.textLimitSizeInGb]}})],scope:this}]);SYNO.SS.App.Snapshot.Utils.WebAPIRequestForSetting(this.LoadSetting.createDelegate(this))},Activate:function(){this.OnRefresh()},Init:function(){this.advancedSetting=SYNO.SS.App.Snapshot.Utils.advancedSetting;this.chkAddTimestamp=new SYNO.SS.Form.Checkbox({name:"addTimestamp",boxLabel:_T("snapshot","append_timestamp"),hideLabel:true,autoHeight:true,handler:function(a,b){this.cmbboxPosition.setDisabled(!b)},scope:this});this.cmbboxPosition=new SYNO.ux.ComboBox({name:"timestampPosition",disabled:true,value:LOCAL_DS_ID,fieldLabel:_T("camera","cam_param_position"),valueField:"id",displayField:"name",boxMaxWidth:200,store:new Ext.data.ArrayStore({fields:["id","name"],data:[[SYNO.SS.App.Snapshot.Def.TimestampPosition.TOP,_T("camera","cam_param_top")],[SYNO.SS.App.Snapshot.Def.TimestampPosition.BOTTOM,_T("camera","cam_param_bottom")]]})});this.chkDispSetting=new SYNO.SS.Form.Checkbox({name:"dispSnapshot",boxLabel:_T("snapshot","last_duration")+" ("+_T("ss_common","common_second")+")",hideLabel:true,autoHeight:true,width:325,handler:function(a,b){this.cmbboxDispSetting.setDisabled(!b)},scope:this});this.cmbboxDispSetting=new SYNO.ux.ComboBox({name:"dispDuration",value:SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_15S,fieldLabel:_T("event","event_duration")+" ("+_T("ss_common","common_second")+")",valueField:"id",displayField:"name",hideLable:true,disabled:true,boxMaxWidth:200,store:new Ext.data.ArrayStore({fields:["id","name"],data:[[SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_5S,5],[SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_10S,10],[SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_15S,15],[SYNO.SS.App.Snapshot.Def.DispDuration.SHOW_20S,20],[SYNO.SS.App.Snapshot.Def.DispDuration.ALWAYS_SHOW,_T("action_rule","forever")]]})});this.chkLimitSize=new SYNO.SS.Form.Checkbox({name:"limitTotalSize",boxLabel:_T("snapshot","filesize_limit")+" ("+_T("ss_common","size_gb")+")",hideLabel:true,autoHeight:true,width:325,scope:this,handler:function(a,b){this.textLimitSizeInGb.setDisabled(!b)}});this.textLimitSizeInGb=new SYNO.ux.TextField({name:"limitSizeInGb",hideLabel:true,width:200,maxLength:5,disabled:true,allowBlank:false,vtype:"integer",validator:this.IsValidVolSize.createDelegate(this),validateOnBlur:true,validationEvent:"blur",invalidText:_T("camera","invalid_rotation_size")})},OnRefresh:function(){this.setStatusBusy();SYNO.SS.App.Snapshot.Utils.WebAPIRequestForSetting(this.OnRefreshDone.createDelegate(this))},OnRefreshDone:function(){this.LoadSetting();this.clearStatusBusy()},LoadSetting:function(){this.advancedSetting=SYNO.SS.App.Snapshot.Utils.advancedSetting;if(!this.advancedSetting){return}var a=new Ext.data.Record(this.advancedSetting);this.getForm().loadRecord(a)},OnSave:function(){if(!this.getForm().isValid()){return}if(!this.IsFormDirty()){this.setStatusError({text:_T("ss_common","setting_nochange")});return}var a={};this.getForm().items.items.forEach(function(c,b){a[c.getName()]=c.getValue()},this);this.WebAPIRequest("SYNO.SurveillanceStation.SnapShot",1,"SaveSetting",a,this.OnSaveDone)},OnSaveDone:function(a){SYNO.SS.App.Snapshot.Utils.advancedSetting=a.setting;this.LoadSetting();SYNO.SS.App.Snapshot.Utils.UpdateSnapshotSetting()},IsFormDirty:function(){return this.getForm().isDirty()},Alert:function(b){var a=(b)?b:_T("ss_common","error_system");this.parentWin.getMsgBox().alert(_T("ss_common","advanced"),a)},WebAPIRequest:function(b,a,f,d,e){this.setStatusBusy({text:_T("ss_common","common_saving")});var c={api:b,version:a,method:f,params:d,callback:function(j,h,i,g){this.OnWebAPIRequestDone(j,h,i,e)},scope:this};this.sendWebAPI(c)},OnWebAPIRequestDone:function(d,a,b,c){this.clearStatusBusy();if(!d){this.Alert()}else{this.setStatusOK({text:_T("ss_common","setting_applied")});if((undefined!==c)&&("function"===(typeof c))){c.call(this,a)}}},IsValidVolSize:function(c){var b=parseInt(c,10);var a=_S("SERVICE_VOL_SIZE");if(0>=b){return false}if(0===a){return true}if(b>a){return String.format(_T("camera","max_disk_size"),SYNO.SS.Utils.FormatFloat(a,2))}return true}});Ext.namespace("SYNO.SS.App.Snapshot");Ext.define("SYNO.SS.App.Snapshot.ExpandableListView",{extend:"SYNO.ux.ExpandableListView",owner:null,constructor:function(a){this.owner=a.owner;var b=Ext.apply({iconTpl:new Ext.XTemplate("{snapshotImage:this.RenderPreview}"),titleTpl:new Ext.XTemplate('{camName:this.RenderName}<span class="title-status">{locked:this.RenderStatus}</span>'),titleRightTpl:new Ext.XTemplate("{ownerDsId:this.RenderResolution}"),descTpl:new Ext.XTemplate("{createdTm:this.RenderCreateTm}"),descRightTpl:new Ext.XTemplate("{byteSize:this.RenderSize}")},a);this.callParent([b]);SYNO.SS.App.Snapshot.ExpViewUitls.AddTplRenderer(this.tpl,this)}});Ext.define("SYNO.SS.App.Snapshot.ExpandableIconView",{extend:"SYNO.ux.ExpandableIconView",owner:null,constructor:function(a){this.owner=a.owner;var b=Ext.apply({iconTpl:this.CreateIconTpl(),descTpl:this.CreateDescTpl(),innerTpl:this.CreateInnerTpl()},a);this.callParent([b]);SYNO.SS.App.Snapshot.ExpViewUitls.AddTplRenderer(this.tpl,this)},CreateIconTpl:function(){return new Ext.XTemplate(String.format('<img src="{snapshotImage}" class="{0} {1} {2}" onerror="this.src=\'{3}\';"><img src="{lockedImg}" class="{lockedCls}" style="display: {lockedDisplay}";><img src="{modifiedImg}" class="{modifiedCls}" style="display: {modifiedDisplay}";>',this.CLS_PREVIEW,this.CLS_RECT,IS_IE10_MINUS_BROWSER?this.CLS_PLAY_ICON_MASK:"",SYNO.SS.CameraPage.IMG_DISABLED[SYNO.SS.MultiView.ICON_VIEW_IDX]))},CreateDescTpl:function(){return this.getDescTpl(['<div ext:qtip="{camName}">{camName}</div>',"<div>{displayedTime}</div>"])},CreateInnerTpl:function(){var b=[{key:_T("camera","camera_attr_resolution"),value:"{width:this.RenderResolution}"},{key:_T("ss_common","common_filesize"),value:"{byteSize:this.RenderSize}"}];var c=this.getInnerKeyValTableTpl(b);var a=new Ext.XTemplate("<div>",c.html,"</div>");return a}});Ext.namespace("SYNO.SS.App.Snapshot.ExpViewUitls");Ext.apply(SYNO.SS.App.Snapshot.ExpViewUitls,{AddTplRenderer:function(b,a){var c=(a instanceof SYNO.SS.App.Snapshot.ExpandableIconView);b.appWin=a.owner;b.RenderPreview=function(g,e){var f=SYNO.SS.MultiView.LIST_VIEW_IDX;var h=e.recordId;e.snapshotImage=(!e.snapshotImage)?"data:image/jpeg;base64,"+e.imageData:e.snapshotImage;var d=String.format('<img src="{0}" class="snapshot_list_snapshot" onerror="this.src=SYNO.SS.CameraPage.IMG_DISABLED[{1}];">',e.snapshotImage,f);return'<div class="snapshot_list_preview_ct">'+d+"</div>"};b.RenderName=function(e,d){return String.format("<span>{0}</span>",e)};b.RenderStatus=function(f,e){var d=[];var g="";if(true===e.locked){d.push(_T("event","event_col_archive"))}if(0!==e.modifiedCnt){d.push(_T("snapshot","modified"))}d=d.join(" , ");g=(false===Ext.isEmpty(d))?"&nbsp;-&nbsp;<span>{0}</span>":"";return String.format(g,d)};b.RenderSrcServer=function(e,d){var f=SYNO.SS.Grid.Categ.ServerId2Name(e);if(true===c){return String.format("<span>{0}</span>",f)}else{return String.format("<span>[{0}]</span>",f)}};b.RenderResolution=function(e,d){return String.format("<span>{0}x{1}</span>",d.width,d.height)};b.RenderSize=function(f,d){var e=""+Math.round(f/1024)+" KB";return String.format("<span>{0}</span>",e)};b.RenderCreateTm=function(h,e){var i=GenLocalDateTimeStr(h*TRANS_MILLISECOND,true);var g=this.appWin.gridCateg.curEntry.type;var f=i.substr(11,8);var d=((SYNO.SS.Grid.Categ.ENTRY_AM===g)||(SYNO.SS.Grid.Categ.ENTRY_PM===g)||(SYNO.SS.Grid.Categ.ENTRY_DAY===g))?f:i;return String.format("<span>{0}</span>",d)}}});Ext.namespace("SYNO.SS.App.Snapshot");Ext.define("SYNO.SS.App.Snapshot.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.Snapshot.MainWindow"});Ext.define("SYNO.SS.App.Snapshot.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",WIN_MIN_WIDTH:940,WIN_MIN_HEIGHT:515,MAX_PLAYER_CNT:5,SNAPSHOT_ID_PREFIX:"snapshot_preview_snapshot_",SNAPSHOT_MASK_ID_PREFIX:"snapshot_mask_snapshot_",tabIndex:{NONE:-1,LIST:0,ADVANCED:1},title:null,strKeyword:"",blFiltered:false,blListTabActivated:false,initViewMode:SYNO.SS.MultiView.LIST_VIEW_IDX,panelSnapshotList:null,panelMultiView:null,dvSnapshotList:null,dsCateg:null,gridCateg:null,gridSnapshotList:null,panelSnapshot:null,panelAdvanced:null,blDataLoading:false,cbDataLoad:null,dsSnapshot:null,btnEdit:null,btnDownload:null,btnDelete:null,btnLock:null,btnUnLock:null,btnSwitchView:null,contextMenu:null,categContextMenu:null,panelCategContainer:null,searchBox:null,maskMgr:null,constructor:function(a){SYNO.SS.App.Snapshot.winInst=this;this.Init();this.callParent([Ext.apply({title:_T("ss_common","common_snapshot"),width:this.WIN_MIN_WIDTH,height:this.WIN_MIN_HEIGHT,minWidth:this.WIN_MIN_WIDTH,minHeight:this.WIN_MIN_HEIGHT,layout:"fit",resizable:true,panelList:[this.panelSnapshot,this.panelAdvanced],tabIndex:this.tabIndex,plugins:[{ptype:"shortcutCreatePlugin",panelCateg:this.gridCateg,panelItems:this.panelMultiView,fnGetAppItemConfig:this.GetSnapshotItemShortcutConfig.createDelegate(this)},{ptype:"shortcutLaunchPlugin",blPagelessApp:true,panelCateg:this.gridCateg,panelItems:this.panelMultiView,store:this.dsSnapshot,idProperty:"recordId",fnCheckItemValid:this.CheckSnapshotValid.createDelegate(this)}]},a)]);this.InitEventHandler()},onBeforeDestroy:function(){SYNO.SS.App.Snapshot.winInst=null;this.callParent(arguments)},onOpen:function(a){this.callParent(arguments);this.Activate();this.fireEvent("shortcutOnOpen",a)},onRequest:function(a){this.callParent(arguments);this.fireEvent("shortcutOnRequest",a)},onClose:function(){this.Deactivate();this.callParent(arguments)},getHelpParam:function(){if(this.tabIndex.LIST===this.GetCurrentTabIndex()){return"snapshot_list.html"}else{if(this.tabIndex.ADVANCED===this.GetCurrentTabIndex()){return"snapshot_advanced.html"}else{return""}}},Activate:function(c,b,a){Ext.dd.DragDropMgr.useCache=false;if(true===this.gridCateg.rendered){this.gridCateg.Reset()}this.ActivateTab();this.Resize();return true},Deactivate:function(){Ext.dd.DragDropMgr.useCache=true;this.blListTabActivated=false;return this.DeactivateTab()},CheckSnapshotValid:function(c){var d=c.itemId.split("_");var a=parseInt(d[0],10);var b=parseInt(d[1],10);this.WebAPIRequest("ChkSnapshotValid",{dsId:a,snapId:b},c.fnCallback.createDelegate(c.callbackScope))},Resize:function(){var c=this.GetCurrentTabIndex();var e=this.getInnerWidth();var b=this.getInnerHeight();var a,d;this.tabPanel.setSize(e,b);if((this.tabIndex.LIST===c)||(this.tabIndex.NONE===c)){a=this.panelSnapshot.body.getWidth();d=this.panelSnapshot.body.getHeight();this.panelCategContainer.setSize(a,d);this.panelCategContainer.syncSize()}},GetSnapshotItemShortcutConfig:function(a,c){var b=GenLocalDateTimeStr(c.get("createdTm")*TRANS_MILLISECOND,true);Ext.apply(a,{title:c.get("camName")+"_"+b,icon:(!c.get("snapshotImage"))?"data:image/jpeg;base64,"+c.get("imageData"):c.get("snapshotImage")});Ext.apply(a.param,{blIconPathInModule:false,itemId:c.get("recordId"),dsId:c.get("ownerDsId"),iconError:SYNO.SS.Image.Camera.IconShortcutError,startTime:c.get("createdTm")*TRANS_MILLISECOND,categInfo:{entryVal:"",type:"date"}});Ext.apply(a,{launchParams:{"snapshot:snapshot_editor":{className:"SYNO.SS.App.SnapshotEditor.Application",filter:Ext.apply(this.GetFilterParams(true),{idList:c.get("id")}),recordId:c.get("recordId"),rowIdx:0}}});return a},Init:function(){this.title=_T("ss_common","common_snapshot");this.panelAdvanced=this.CreateTabItemForGblSearch("SYNO.SS.App.Snapshot.AdvancedPanel",[this]);this.dsSnapshot=new SYNO.API.JsonStore({autoDestroy:true,appWindow:this,api:"SYNO.SurveillanceStation.SnapShot",version:1,method:"List",baseParams:{from:0,to:0,locked:0,modified:0},root:"data",totalProperty:"total",idProperty:"recordId",fields:SYNO.SS.App.Snapshot.Def.storeSnapshotListFields,listeners:{datachanged:function(){var b=this.gridCateg.GetTotalCount();if(0===b){this.ChgButtonStatus()}},scope:this}});this.btnEdit=new SYNO.ux.Button({text:_T("ss_common","common_edit"),cls:"btn_filter_tbar",handler:this.OnEdit,disabled:false,scope:this});this.btnDownload=new SYNO.ux.Button({text:_T("event","event_export"),cls:"btn_filter_tbar",handler:this.OnDownload,disabled:true,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),cls:"btn_filter_tbar",menu:{items:[{id:"snapshotMenuDelSelected",text:_T("event","delete_selected"),handler:this.DeletePreProcess,scope:this},{id:"snapshotMenuDelCateg",text:_T("event","delete_category"),handler:function(){this.DeleteFilterPreProcess(true)},scope:this},{id:"snapshotMenuDelAll",text:_T("ss_common","common_delete_all"),handler:function(){if(false===this.blFiltered){this.DeleteAllPreProcess()}else{this.DeleteFilterPreProcess(false)}},scope:this}],listeners:{beforeshow:function(d){var c,b;c=(false===this.blFiltered)?_T("event","delete_category"):_T("event","delete_filtered_category");b=d.items.itemAt(1);b.setText(c);c=(false===this.blFiltered)?_T("ss_common","common_delete_all"):_T("event","delete_filtered");b=d.items.itemAt(2);b.setText(c)},scope:this}}});this.btnLock=new SYNO.ux.Button({text:_T("event","event_archive"),cls:"btn_filter_tbar",disabled:true,menu:{items:[{id:"snapshotMenuLockSelected",text:_T("event","archive_lock_selected"),handler:this.OnLock,scope:this},{id:"snapshotMenuLockCateg",text:_T("event","archive_lock_category"),handler:function(){this.OnLockFiltered(true)},scope:this},{id:"snapshotMenuLockAll",text:_T("event","archive_lock_all"),handler:function(){if(false===this.blFiltered){this.OnLockAll()}else{this.OnLockFiltered(false)}},scope:this}],listeners:{beforeshow:function(d){var c,b;c=(false===this.blFiltered)?_T("event","archive_lock_category"):_T("event","archive_lock_filtered_category");b=d.items.itemAt(1);b.setText(c);c=(false===this.blFiltered)?_T("event","archive_lock_all"):_T("event","archive_lock_filtered");b=d.items.itemAt(2);b.setText(c)},scope:this}}});this.btnUnLock=new SYNO.ux.Button({text:_T("event","event_unarchive"),cls:"btn_filter_tbar",disabled:true,menu:{items:[{id:"snapshotMenuUnLockSelected",text:_T("event","archive_unlock_selected"),handler:this.OnUnlock,scope:this},{id:"snapshotMenuUnLockCateg",text:_T("event","archive_unlock_category"),handler:function(){this.OnUnlockFiltered(true)},scope:this},{id:"snapshotMenuUnLockAll",text:_T("event","archive_unlock_all"),handler:function(){if(false===this.blFiltered){this.OnUnlockAll()}else{this.OnUnlockFiltered(false)}},scope:this}],listeners:{beforeshow:function(d){var c,b;c=(false===this.blFiltered)?_T("event","archive_unlock_category"):_T("event","archive_unlock_filtered_category");b=d.items.itemAt(1);b.setText(c);c=(false===this.blFiltered)?_T("event","archive_unlock_all"):_T("event","archive_unlock_filtered");b=d.items.itemAt(2);b.setText(c)},scope:this}}});if(_S("DEMO_MODE")){this.btnEdit.disable();this.btnDownload.disable();this.btnDelete.disable();this.btnLock.disable();this.btnUnLock.disable()}this.gridSnapshotList=new SYNO.SS.App.Snapshot.ExpandableListView({owner:this,store:this.dsSnapshot,cls:"right_expandable_listView",listeners:{selectionchange:this.ChgButtonStatus,contextmenu:this.OnContextMenuListView,dblclick:function(b,d,c,f){SYNO.SS.IconView.OnClick(f,this.OnEdit,this)},scope:this},playIconOnPreview:true,fnPlay:this.OnEdit.createDelegate(this)});this.dvSnapshotList=new SYNO.SS.App.Snapshot.ExpandableIconView({owner:this,store:this.dsSnapshot,prepareData:this.PrepareDvSnapshotListData.createDelegate(this),listeners:{contextmenu:this.OnContextMenuIconView,selectionchange:this.ChgButtonStatus,dblclick:function(b,d,c,f){SYNO.SS.IconView.OnClick(f,this.OnEdit,this)},scope:this},playIconOnPreview:true,fnPlay:this.OnEdit.createDelegate(this)});this.dsCateg=new Ext.data.JsonStore({fields:["id","type","category","entryName","entryVal","recCnt","date","grpHdrName","dsId"]});this.gridCateg=new SYNO.SS.Grid.CategoryGridPanel({cls:"flexcroll_extra_left",border:false,enableDragDrop:true,useSplitSwitchBtn:true,category:[SYNO.SS.Grid.Categ.CATEG_DATE],store:this.dsCateg,viewConfig:{forceFit:true},ShowContextMenu:this.ShowGridCategContextMenu.createDelegate(this)});this.panelMultiView=new SYNO.SS.MultiView.MultiViewPanel({grid:this.gridSnapshotList,dv:this.dvSnapshotList,btnSwitch:this.gridCateg.btnSwitch,initViewMode:this.initViewMode,listeners:{viewswitch:this.OnViewSwitch,scope:this},plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsCategPlugin",store:this.dsSnapshot,gridCateg:this.gridCateg,pageSize:SYNO.SS.App.Snapshot.Def.SNAPSHOT_LIST_PAGE_SIZE,divLoadingHeight:64,GetParams:this.GetFilterParams.createDelegate(this),sortCfg:[{field:"createdTm",direction:"DESC"},{field:"recordId",direction:"DESC"}]})});this.btnSwitchView=this.panelMultiView.btnSwitch;this.btnSwitchView.menu.items.items[2].hide();this.btnSwitchView.menu.items.items[3].hide();this.panelSnapshotList=new SYNO.ux.Panel({region:"center",layout:"fit",border:false,items:[this.panelMultiView],bbar:new SYNO.SS.Pgls.BottomBar({panelRecord:this.panelMultiView,refreshFunction:this.OnRefresh,refreshFunctionScope:this})});var a=(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_VIEW))?_T("ss_privilege","no_authorized_snapshots"):_T("ss_common","no_item_category_tip");this.panelCategContainer=new SYNO.SS.Pgls.PglsCategContainerPanel({items:[this.gridCateg,this.panelSnapshotList],gridCateg:this.gridCateg,panelRecord:this.panelMultiView,labelItemCnt:this.panelSnapshotList.getBottomToolbar().labelItemCnt,dsRecord:this.dsSnapshot,countMethod:"CountByCategory",countParams:{limit:0,timezoneOffset:-new Date().getTimezoneOffset()},EMPTY_MSG:a,GetParams:this.GetFilterParams.createDelegate(this),plugins:[SYNO.SS.AutoUpdate.CreatePlugin({fnRefresh:this.OnRefresh.createDelegate(this),fnCompare:function(d,c){if(d.data.createdTm>c.data.createdTm){return -1}else{if(d.data.createdTm<c.data.createdTm){return 1}else{if(d.id>c.id){return -1}else{if(d.id<c.id){return 1}else{return 0}}}}}})],listeners:{dataupdated:this.ChgButtonStatus,scope:this}});this.searchBox=new SYNO.SS.SearchField({listeners:{searchfield:this.OnSearchField,scope:this}});this.panelSnapshot=this.CreateTabItemForGblSearch("SYNO.SS.App.Snapshot.ListPanel",[{cls:"management_panel",title:_T("camera","list"),tbar:new SYNO.ux.Toolbar([this.btnEdit,this.btnDownload,this.btnDelete,this.btnLock,this.btnUnLock,{xtype:"tbfill"},this.btnSwitchView,this.searchBox]),items:this.panelCategContainer}]);this.maskMgr=new SYNO.SS.App.Snapshot.MaskMgr(this)},InitEventHandler:function(){var a;a=this.dsSnapshot;a.on("beforeload",this.OnBeforeLoadData,this);a.on("load",this.OnLoadData,this);a.on("exception",function(){this.maskMgr.clearStatusBusy();this.getMsgBox().alert(this.title,_T("ss_common","error_system"),this.OnFilterCancel,this)},this);this.mon(this.tabPanel,"tabchange",this.OnTabChange,this);this.mon(this.tabPanel,"beforetabchange",this.OnBeforeTabChange,this);this.mon(SYNO.SDS.StatusNotifier,"snapshotUpdateStore",this.OnUpdateStore,this);this.mon(this,"resize",this.Resize,this)},OnBeforeLoadData:function(a,b){this.blDataLoading=true},OnLoadData:function(c,b,d){var a=(false!==d.params.needMask);this.gridCateg.ReloadDsCateg();this.Resize();this.blDataLoading=false;if(true===a){this.maskMgr.clearStatusBusy()}if(this.cbDataLoad){this.cbDataLoad();this.cbDataLoad=null}this.fireEvent("shortcutDataReady")},ShowGridCategContextMenu:function(f){if(true===this.blDataLoading){this.cbDataLoad=this.ShowGridCategContextMenu.createDelegate(this,[f]);return}this.ChgButtonStatus();var b=!this.btnDelete.disabled&&!Ext.getCmp("snapshotMenuDelCateg").disabled;var d=!this.btnLock.disabled&&!Ext.getCmp("snapshotMenuLockCateg").disabled;var c=!this.btnUnLock.disabled&&!Ext.getCmp("snapshotMenuUnLockCateg").disabled;var a=[];var g;if(true===b){a.push({text:_T("ss_common","common_delete"),scope:this,handler:function(){this.DeleteFilterPreProcess(true)}})}if(true===d){a.push({text:_T("ss_common","common_lock"),scope:this,handler:function(){this.OnLockFiltered(true)}})}if(true===c){a.push({text:_T("ss_common","common_unlock"),scope:this,handler:function(){this.OnUnlockFiltered(true)}})}if(0<a.length){a.push({itemId:"cmShortcutSeparator",xtype:"menuseparator"})}a.push({itemId:"cmAddDesktopShortcut",text:_T("desktop","add_desktop_shortcut"),handler:function(){this.fireEvent("shortcutOnAddCateg")},scope:this});g=new SYNO.ux.Menu({items:a});g.showAt(f.getXY())},PrepareDvSnapshotListData:function(e,c,b){var g;var a=this.GetStatus(e,SYNO.SS.MultiView.ICON_VIEW_IDX);var f=this.gridCateg.curEntry.type;var d=this.dvSnapshotList;e.snapshotImage=e.imageData?"data:image/jpeg;base64,"+e.imageData:SYNO.SS.CameraPage.IMG_DISABLED[SYNO.SS.MultiView.ICON_VIEW_IDX];Ext.apply(e,{lockedImg:a.lockStatus.img,lockedCls:a.lockStatus.cls,lockedDisplay:a.lockStatus.display});Ext.apply(e,{modifiedImg:a.modifiedStatus.img,modifiedCls:a.modifiedStatus.cls,modifiedDisplay:a.modifiedStatus.display});if(!e.date){g=GenLocalDateTimeStr(e.createdTm*TRANS_MILLISECOND,true);e.date=g.substr(0,10);e.dayTime=g.substr(11,8)}if((SYNO.SS.Grid.Categ.ENTRY_DAY===f)||(SYNO.SS.Grid.Categ.ENTRY_AM===f)||(SYNO.SS.Grid.Categ.ENTRY_PM===f)){e.displayedTime=e.dayTime}else{e.displayedTime=e.date+" "+e.dayTime}if(!e.serverName){e.serverName=SYNO.SS.GblStore.GetDsName(e.ownerDsId)}return e},GetStatus:function(d,a){var b={};var e={};var c=["snapshot_icon_view_status_first","snapshot_icon_view_status_second"];b.img="";b.tip="";b.cls="";b.display="none";e.img="";e.tip="";e.cls="";e.display="none";if(SYNO.SS.MultiView.ICON_VIEW_IDX===a){if(true===d.locked){b.img=_IMG(SYNO.SS.Image.StatusIconLock);b.tip=_T("event","event_status_locked");b.cls=c.shift();b.display=""}if(0!==d.modifiedCnt){e.img=_IMG(SYNO.SS.Image.StatusIconModified);e.tip=_T("snapshot","modified");e.cls=c.shift();e.display=""}}return{lockStatus:b,modifiedStatus:e}},ActivateTab:function(){switch(this.GetCurrentTabIndex()){case this.tabIndex.NONE:case this.tabIndex.LIST:if(false===this.blListTabActivated){this.OnFilterCancel();this.blListTabActivated=true}this.panelMultiView.ActivateDvRectSel(true);break;case this.tabIndex.ADVANCED:this.panelAdvanced.Activate();break;default:break}return true},DeactivateTab:function(a){if(this.tabIndex.LIST==this.GetCurrentTabIndex()){this.panelMultiView.ActivateDvRectSel(false)}else{if(true===this.panelAdvanced.IsFormDirty()){SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.panelAdvanced.getForm().reset();this.tabPanel.setActiveTab(a.getItemId())},scope:this});return false}}return true},OnTabChange:function(){this.ActivateTab();this.Resize()},OnBeforeTabChange:function(a,b){return this.DeactivateTab(b)},InitContextMenu:function(){this.contextMenu=new SYNO.ux.Menu({items:[{itemId:"cmViewSnapshot",text:_T("ss_common","common_edit"),hidden:_S("DEMO_MODE"),scope:this,handler:this.OnEdit},{itemId:"cmDownloadSnapshot",text:_T("event","event_export"),hidden:_S("DEMO_MODE"),scope:this,handler:this.OnDownload},{itemId:"cmDeleteSnapshot",text:_T("ss_common","common_delete"),hidden:_S("DEMO_MODE"),scope:this,handler:this.DeletePreProcess},{itemId:"cmLockSnapshotSeparator",xtype:"menuseparator"},{itemId:"cmLockSnapshot",text:_T("ss_common","common_lock"),hidden:_S("DEMO_MODE"),scope:this,handler:this.OnLock},{itemId:"cmUnlockSnapshot",text:_T("ss_common","common_unlock"),hidden:_S("DEMO_MODE"),scope:this,handler:this.OnUnlock},{itemId:"cmShortcutSeparator",xtype:"menuseparator"},{itemId:"cmAddDesktopShortcut",text:_T("desktop","add_desktop_shortcut"),handler:function(){this.fireEvent("shortcutOnAddItem")},scope:this}]})},OnContextMenuListView:function(b,a,c,d){d.stopEvent();if(false===b.isSelected(a)){b.select(a)}this.ShowContextMenu(d)},OnContextMenuIconView:function(d,a,f,g){var c=g.getTarget(d.itemSelector);var b=d.UpdateSelectionOnEvent(g,c);if((0>=b.length)||(null===c)){return}this.ShowContextMenu(g)},ShowContextMenu:function(b){var a;if(!this.contextMenu){this.InitContextMenu()}this.contextMenu.getComponent("cmViewSnapshot").hide();this.contextMenu.getComponent("cmDownloadSnapshot").hide();this.contextMenu.getComponent("cmDeleteSnapshot").hide();this.contextMenu.getComponent("cmLockSnapshotSeparator").hide();this.contextMenu.getComponent("cmLockSnapshot").hide();this.contextMenu.getComponent("cmUnlockSnapshot").hide();if(false===this.btnEdit.disabled){this.contextMenu.getComponent("cmViewSnapshot").show()}if(false===this.btnDownload.disabled){this.contextMenu.getComponent("cmDownloadSnapshot").show()}if((false===this.btnDelete.disabled)&&(false===Ext.getCmp("snapshotMenuDelSelected").disabled)){this.contextMenu.getComponent("cmDeleteSnapshot").show()}if((false===this.btnLock.disabled)&&(false===Ext.getCmp("snapshotMenuLockSelected").disabled)){this.contextMenu.getComponent("cmLockSnapshot").show();this.contextMenu.getComponent("cmLockSnapshotSeparator").show()}if((false===this.btnUnLock.disabled)&&(false===Ext.getCmp("snapshotMenuUnLockSelected").disabled)){this.contextMenu.getComponent("cmUnlockSnapshot").show();this.contextMenu.getComponent("cmLockSnapshotSeparator").show()}b.stopEvent();for(a=0;a<this.contextMenu.items.getCount();++a){if(false===this.contextMenu.items.get(a).hidden){this.contextMenu.showAt(b.getXY());break}}},OnViewSwitch:function(a,b){},OnEdit:function(){var b=this.GetFilterParams(true);var a=this.panelMultiView.GetSelected();var c=this.gridSnapshotList.getStore().indexOf(a);if(undefined===a){return}var d={recordId:a.get("recordId"),rowIdx:c,filter:b};SYNO.SDS.AppLaunch(SYNO.SS.Module.InstanceNameMap[MODULE_ID_SNAPSHOT_EDITOR],d,true)},OnDownload:function(){var a=this.panelMultiView.GetSelected();if(undefined===a){return}SYNO.SS.App.Snapshot.Utils.CheckFileExist(this.title,this.getMsgBox(),a)},OnLock:function(){this.WebAPIRequest("Lock",{objList:this.GetSelectedObjList()})},OnLockFiltered:function(a){this.WebAPIRequest("LockFiltered",this.GetFilterParams(a))},OnLockAll:function(){this.WebAPIRequest("LockFiltered",this.GetFilterParams(false))},OnUnlock:function(){this.WebAPIRequest("Unlock",{objList:this.GetSelectedObjList()})},OnUnlockFiltered:function(a){this.WebAPIRequest("UnlockFiltered",this.GetFilterParams(a))},OnUnlockAll:function(){this.WebAPIRequest("UnlockFiltered",this.GetFilterParams(false))},OnRefresh:function(a){this.ReloadStore(a)},OnUpdateStore:function(){this.panelCategContainer.InstantUpdate()},ReloadStore:function(a){var b=this.GetFilterParams(true);b.start=0;b.limit=a?a:SYNO.SS.App.Snapshot.Def.SNAPSHOT_LIST_PAGE_SIZE;this.maskMgr.setStatusBusy();this.dsSnapshot.load({params:b})},ResetFilterSetting:function(){this.blFiltered=false;this.strKeyword=""},OnFilterCancel:function(){this.ResetFilterSetting();this.ChgButtonStatus();this.FilterList()},FilterList:function(){this.panelMultiView.ScrollToTop();this.dsSnapshot.setBaseParam("keyword",this.strKeyword);this.ReloadStore()},GetFilterParams:function(b){var d=Ext.apply({userId:_S("USER_ID")},this.dsSnapshot.baseParams);var a,c;if(true===b){a=this.gridCateg.curEntry;switch(a.type){case SYNO.SS.Grid.Categ.ENTRY_DAY:case SYNO.SS.Grid.Categ.ENTRY_AM:case SYNO.SS.Grid.Categ.ENTRY_PM:c=SYNO.SS.Grid.Categ.GetTimeInSec(a.entryVal);d.from=c.start;d.to=c.end;break;default:break}}return d},DeletePreProcess:function(){this.getMsgBox().confirm(this.title,_T("snapshot","del_warning"),this.OnDelete,this)},DeleteFilterPreProcess:function(a){var c;var b="";c=(true===a)?this.gridCateg.GetEntryCount():this.gridCateg.GetTotalCount();b=String.format(_T("snapshot","del_all_warning"),c);var d=function(e){this.OnFilteredDelete(e,a)};this.getMsgBox().confirm(this.title,b,d,this)},OnDelete:function(a){if("yes"!==a){return}var b=function(){SYNO.SS.App.Snapshot.Utils.ChkSnapshotValid();this.ReloadStore(this.dsSnapshot.getCount())};this.WebAPIRequest("Delete",{objList:this.GetSelectedObjList()},b)},OnFilteredDelete:function(b,a){if("yes"!=b){return}var c=Ext.applyIf({deleteAllCommand:false},this.GetFilterParams(a));var d=function(){SYNO.SS.App.Snapshot.Utils.ChkSnapshotValid();this.OnRefresh()};this.WebAPIRequest("DeleteFiltered",c,d)},DeleteAllPreProcess:function(){this.getMsgBox().confirm(this.title,_T("snapshot","del_all_confirm_msg"),this.OnDeleteAll,this)},OnDeleteAll:function(a){if("yes"!=a){return}var b=Ext.apply({deleteAllCommand:true},this.GetFilterParams());var c=function(){SYNO.SS.App.Snapshot.Utils.ChkSnapshotValid();this.OnRefresh()};this.WebAPIRequest("DeleteFiltered",b,c)},GetSelectedObjList:function(){var a=this.panelMultiView.GetSelections();var b=[];a.forEach(function(d,c){var e={dsId:d.get("ownerDsId"),id:"0:"+((LOCAL_DS_ID===d.get("ownerDsId"))?d.get("id"):d.get("idOnRecServer"))};b.push(e)},this);return b},ChgButtonStatus:function(){if(true===Ext.isEmpty(this.gridCateg)){return}if(!_S("DEMO_MODE")){this.btnDelete.enable();Ext.getCmp("snapshotMenuDelCateg").enable();Ext.getCmp("snapshotMenuDelAll").enable();this.btnLock.enable();Ext.getCmp("snapshotMenuLockCateg").enable();Ext.getCmp("snapshotMenuLockAll").enable();this.btnUnLock.enable();Ext.getCmp("snapshotMenuUnLockCateg").enable();Ext.getCmp("snapshotMenuUnLockAll").enable()}else{this.btnDelete.disable();Ext.getCmp("snapshotMenuDelCateg").disable();Ext.getCmp("snapshotMenuDelAll").disable();this.btnLock.disable();Ext.getCmp("snapshotMenuLockCateg").disable();Ext.getCmp("snapshotMenuLockAll").disable();this.btnUnLock.disable();Ext.getCmp("snapshotMenuUnLockCateg").disable();Ext.getCmp("snapshotMenuUnLockAll").disable()}var b=this.panelMultiView.GetSelections();var c=b.length;var a=false;var d=false;b.forEach(function(f,e){if(true===f.data.locked){a=true}else{d=true}},this);if(0===c){this.btnEdit.disable();this.btnDownload.disable();Ext.getCmp("snapshotMenuDelSelected").disable();Ext.getCmp("snapshotMenuLockSelected").disable();Ext.getCmp("snapshotMenuUnLockSelected").disable()}else{if(1===c){this.btnEdit.enable();this.btnDownload.enable();if(true===a){Ext.getCmp("snapshotMenuDelSelected").disable();Ext.getCmp("snapshotMenuLockSelected").disable();Ext.getCmp("snapshotMenuUnLockSelected").enable()}else{Ext.getCmp("snapshotMenuDelSelected").enable();Ext.getCmp("snapshotMenuLockSelected").enable();Ext.getCmp("snapshotMenuUnLockSelected").disable()}}else{if(1<c){this.btnEdit.enable();this.btnDownload.disable();if(!_S("DEMO_MODE")){this.btnLock.enable();this.btnUnLock.enable()}if((true===a)&&(true===d)){Ext.getCmp("snapshotMenuDelSelected").enable();Ext.getCmp("snapshotMenuLockSelected").enable();Ext.getCmp("snapshotMenuUnLockSelected").enable()}else{if(true===a){Ext.getCmp("snapshotMenuDelSelected").disable();Ext.getCmp("snapshotMenuLockSelected").disable();Ext.getCmp("snapshotMenuUnLockSelected").enable()}else{if(true===d){Ext.getCmp("snapshotMenuDelSelected").enable();Ext.getCmp("snapshotMenuLockSelected").enable();Ext.getCmp("snapshotMenuUnLockSelected").disable()}}}}}}if((true===_S("DEMO_MODE"))||(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_DOWNLOAD))){this.btnDownload.disable()}if((true===_S("DEMO_MODE"))||(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_LOCK))){this.btnLock.disable();this.btnUnLock.disable()}if((true===_S("DEMO_MODE"))||(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_DELETE))){this.btnDelete.disable()}if(false===SYNO.SS.Utils.IsOperAllowed(SYNO.SS.App.User.Def.PrivOper.SNAPSHOT_VIEW)){this.btnEdit.disable()}},WebAPIRequest:function(c,a,b){this.maskMgr.setStatusBusy();this.sendWebAPI({api:"SYNO.SurveillanceStation.SnapShot",version:1,method:c,params:a,callback:function(g,e,f,d){this.OnWebAPIRequestDone(g,e,f,d,b)},scope:this})},OnWebAPIRequestDone:function(g,d,e,c,f){var b=_T("ss_common","error_system");var a=this.getMsgBox();if(g){if((f)&&("function"===(typeof f))){f.call(this,g,d,e,c)}else{this.ReloadStore(this.dsSnapshot.getCount())}}else{a.alert(this.title,b)}this.maskMgr.clearStatusBusy()},OnSearchField:function(a){this.strKeyword=a;this.blFiltered=(""!==a);this.dsSnapshot.abortLoad();this.maskMgr.resetStatus();this.FilterList()}});Ext.define("SYNO.SS.App.Snapshot.ListPanel",{extend:"SYNO.ux.Panel"});Ext.define("SYNO.SS.App.Snapshot.MaskMgr",{extend:"Object",parent:null,maskCnt:0,constructor:function(a){this.parent=a;this.callParent()},setStatusBusy:function(){if(0===this.maskCnt){this.parent.setStatusBusy()}this.maskCnt++},clearStatusBusy:function(){this.maskCnt--;if(0>this.maskCnt){this.maskCnt=0}if(0===this.maskCnt){this.parent.clearStatusBusy()}},resetStatus:function(){this.maskCnt=0;this.parent.maskCnt=0;this.parent.clearStatusBusy()}});