#!/bin/sh

PKG_STR_SHARE_FOLDER_NAME="名称"
PKG_STR_SHARE_FOLDER_VOLUME="所在位置"
PKG_STR_VOLUME_FREE_SIZE="可用容量"
PKG_STR_WIZARD_INSTALL_TITLE="请设置录制文件夹"

# Copyright (c) 2014 Synology Inc. All rights reserved.

SYNO_SHARE_TOOL="/usr/syno/sbin/synoshare"
DEFAULT_SHARED_FOLER_NAME="surveillance"
KEY_NAME="share_name"
KEY_PATH="vol_path"
DEF_SYNOINFO_CONF="/etc.defaults/synoinfo.conf"
MODEL_NAME="$(/bin/get_key_value "${DEF_SYNOINFO_CONF}" "upnpmodelname")"
FILE_SYSTEM_HFS_PLUS="hfsplus"

GetLocalVol()
{
	local Location

	if [ "EDS14" == "${MODEL_NAME}" ] ; then
		Location="external"
	else
		Location="internal"
	fi

	env -i HTTP_X_SYNO_RELAY_LANGUAGE=${SYNOPKG_DSM_LANGUAGE} /usr/syno/bin/synowebapi --exec api=SYNO.Core.Storage.Volume method=list version=1 limit=-1 offset=0 location='"'${Location}'"'
}

GetJsonKeyStr()
{
	local Key=$1

	sed -n 's/[[:blank:]]*"'"${Key}"'"[[:blank:]]*:[[:blank:]]*"\([^"]*\)".*/\1/p'
}

ReplaceNewline()
{
	local Filler=$1

	sed ':a;$!N;s/\n/'"${Filler}"'/;ta'
}

CreateJsonStrList()
{
	local Json=$1
	local Key=$2
	local Filler=$3

	echo "${Json}" |\
	GetJsonKeyStr "${Key}" |\
	ReplaceNewline "${Filler} ${Filler}" |\
	sed 's/\(.*\)/'"${Filler}\1${Filler}"'/'
}

GetStrListValue()
{
	local List=$1
	local Idx=$2
	local Rule='[[:blank:]]*"\([^"]*\)"'

	for i in $(seq 2 ${Idx}); do
		Rule="${Rule}"'[[:blank:]]*"\([^"]*\)"'
	done
	Rule="${Rule}.*"

	echo "${List}" |\
	sed 's/'"${Rule}"'/\'${Idx}'/'
}

CreateDisplayName()
{
	local StrList=$1
	local Size=$2
	local Idx=$3
	local Name=$(GetStrListValue "${StrList}" ${Idx})

	awk 'BEGIN{printf "'"${Name}"' ('"${PKG_STR_VOLUME_FREE_SIZE}"': %.2f GB)",'${Size}'/1024/1024/1024}'
}

CreateVolStore()
{
	local VolJson=$1
	local NameList=$(CreateJsonStrList "${VolJson}" "display_name" "\"")
	local SizeList=$(CreateJsonStrList "${VolJson}" "size_free_byte" "")
	local PathList=$(CreateJsonStrList "${VolJson}" "volume_path" "\"")
	local FSTypeList=$(CreateJsonStrList "${VolJson}" "fs_type")
	local VolStore Idx RowName RowPath FSType

	#create volume store
	Idx=1
	for Size in ${SizeList}; do
		FSType="$(echo "${FSTypeList}" | awk '{print $'"$Idx"'}')"

		if [ 0 \< ${Size} -a "${FILE_SYSTEM_HFS_PLUS}" != "${FSType}" ]; then
			RowPath=$(GetStrListValue "${PathList}" ${Idx})
			RowName=$(CreateDisplayName "${NameList}" ${Size} ${Idx})

			VolStore="${VolStore},[\"${RowPath}\",\"${RowName}\"]"
		fi
		Idx=$(expr ${Idx} + 1)
	done

	echo "${VolStore}" | sed 's/,\(.*\)/\1/'
}

GetLocalVolListSize()
{
	local VolJson=$1
	local FreeSizeList=$(CreateJsonStrList "${VolJson}" "size_free_byte" "")
	local VolCnt=0

	for FreeSize in ${FreeSizeList}; do
		if [ 0 \< ${FreeSize} ]; then
			VolCnt=$(expr ${VolCnt} + 1)
		fi
	done

	echo ${VolCnt}
}

GetFirstVolume()
{
	local VolStore=$1

	echo "${VolStore}" | sed 's,[^"]*"\([^"]*\)".*,\1,'
}

SearchSharedFolder()
{
	local SharedFolderName="${DEFAULT_SHARED_FOLER_NAME}"

	${SYNO_SHARE_TOOL} --enum ALL | grep -v : | grep "^${SharedFolderName}$"
}

if [ -n "$(SearchSharedFolder)" ]; then
	exit 0
fi

LocalVolJson=$(GetLocalVol)
DsVolStore=$(CreateVolStore "${LocalVolJson}")
FirstVol=$(GetFirstVolume "${DsVolStore}")

LocalVolNum=$(GetLocalVolListSize "${LocalVolJson}")
if [ 1 -ge "${LocalVolNum}" ]; then
	exit 0
fi

/bin/cat > ${SYNOPKG_TEMP_LOGFILE} <<EOF
[{
	"step_title": "${PKG_STR_WIZARD_INSTALL_TITLE}",
	"items": [{
		"type": "textfield",
		"subitems": [{
			"key": "${KEY_NAME}",
			"desc": "${PKG_STR_SHARE_FOLDER_NAME}",
			"value": "${DEFAULT_SHARED_FOLER_NAME}",
			"disabled": true
		}]
	}, {
		"type": "combobox",
		"subitems": [{
			"key": "${KEY_PATH}",
			"desc": "${PKG_STR_SHARE_FOLDER_VOLUME}",
			"editable": false,
			"lastSelect": 0,
			"mode": "local",
			"value": "${FirstVol}",
			"store": [${DsVolStore}]
		}]
	}]
}]
EOF

exit 0
