#!/bin/sh

PKG_STR_WIZARD_UPGRADE_TITLE="继续进行之前详加阅读"
PKG_STR_WIZARD_UPGRADE_NOTE="升级至 Surveillance Station 需要转换数据库，因此需要一段时间来完成，实际状况将取决于数据库中的录制内容数量。在升级过程中，请耐心等待，并请勿在此过程中关闭系统或卸载该套件。"
PKG_STR_WIZARD_UPGRADE_VS_NOTE="此版本的 Surveillance Station 仅兼容 VisualStation {0} 和更新版本。此版本的 Surveillance Station 不再支持 VisualStation VS60 和 VS80 型号。"
PKG_STR_WIZARD_VS_CHECK_LABEL="我了解兼容性限制，并希望继续更新。"
PKG_STR_WIZARD_VS_CHECK_HINT="请仔细阅读兼容性限制，并勾选复选框以继续。"

# Copyright (c) 2014 Synology Inc. All rights reserved.

SS_PKG_PATH="/var/packages/SurveillanceStation/"
SS_INFO_FILE=${SS_PKG_PATH}"INFO"
SS_SYSTEM_DB_FILE=${SS_PKG_PATH}"target/system.db"
SS_VER_KEY="version"
SS_SQLITE3_VER="6.3"
SS_THUMBNAIL_ISSUE_BUILD_VER="3312"
SS_THUMBNAIL_FIXED_BUILD_VER="3352"
SS_IMCOMPATIBLE_VS="('VS60', 'VS80')"
SS_MIN_VS_VERSION="2.2-1413"

UPGRADE_DB_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"desc": "${PKG_STR_WIZARD_UPGRADE_NOTE}"
	}]
}`

UPGRADE_VS_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"type": "multiselect",
		"desc": "$(echo ${PKG_STR_WIZARD_UPGRADE_VS_NOTE} | sed "s/{0}/${SS_MIN_VS_VERSION}/g")",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_VS_CHECK_LABEL}",
			"validator": {
				"fn": "{
					var v=arguments[0];
					if (!v) {
						return '${PKG_STR_WIZARD_VS_CHECK_HINT}';
					} else {
						return true;
					}
				}"
			}
		}]
	}]
}`

IsUpgradeToSqlite3()
{
	local PreSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | sed -n 's/\([0-9]*\.[0-9]*\)-[0-9]*/\1/p')

	if [ ${SS_SQLITE3_VER} \> ${PreSSVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeThumbnailToFile()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | sed -n 's/\([0-9]*\.[0-9]*\)-\([0-9]*\)/\2/p')

	if [ ${SS_THUMBNAIL_ISSUE_BUILD_VER} -le ${PreSSBuildVer} ] && [ ${SS_THUMBNAIL_FIXED_BUILD_VER} -gt ${PreSSBuildVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasImcompatibleVS()
{
	local SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ${SS_IMCOMPATIBLE_VS}"
	local Cnt=$(/usr/syno/bin/sqlite3 ${SS_SYSTEM_DB_FILE} "${SqlCmd}")

	if [ -z "${Cnt}" ]; then
		Cnt=$(/usr/syno/pgsql/bin/psql -A -t -U postgres surveillance -c "${SqlCmd}")
	fi

	if [ ${Cnt} -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

main()
{
	local UpgradeNotePages=""

	if [ "true" == $(HasImcompatibleVS) ]; then
		UpgradeNotePages="${UPGRADE_VS_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToSqlite3) ] || [ "true" == $(IsUpgradeThumbnailToFile) ]; then
		if [ -z "${UpgradeNotePages}" ]; then
			UpgradeNotePages="${UPGRADE_DB_NOTE_PAGE}"
		else
			UpgradeNotePages="${UpgradeNotePages},${UPGRADE_DB_NOTE_PAGE}"
		fi
	fi

	if [ -z "${UpgradeNotePages}" ]; then
		exit 0
	fi

/bin/cat > ${SYNOPKG_TEMP_LOGFILE} <<EOF
[${UpgradeNotePages}]
EOF

	exit 0
}

main "$@"
