#!/bin/sh

PKG_STR_WIZARD_UPGRADE_TITLE="執行前請注意"
PKG_STR_WIZARD_UPGRADE_NOTE="升級至 Surveillance Station 需轉換資料庫系統，因此可能會耗費一段時間 (實際狀況視資料庫中的錄影檔數量而定)。升級過程中，請耐心等候，並且不要將系統關機或解除安裝套件。"
PKG_STR_WIZARD_UPGRADE_VS_NOTE="此版 Surveillance Station 僅相容於 VisualStation {0} 或更新版本。此版 Surveillance Station 將不再支援 VisualStation VS60 及 VS80 機種。"
PKG_STR_WIZARD_VS_CHECK_LABEL="我了解此相容性限制，並願意繼續更新。"
PKG_STR_WIZARD_VS_CHECK_HINT="請詳閱相容性限制，並勾選核取方塊來繼續更新。"

# Copyright (c) 2014 Synology Inc. All rights reserved.

SS_PKG_PATH="/var/packages/SurveillanceStation/"
SS_INFO_FILE=${SS_PKG_PATH}"INFO"
SS_SYSTEM_DB_FILE=${SS_PKG_PATH}"target/system.db"
SS_VER_KEY="version"
SS_SQLITE3_VER="6.3"
SS_THUMBNAIL_ISSUE_BUILD_VER="3312"
SS_THUMBNAIL_FIXED_BUILD_VER="3352"
SS_IMCOMPATIBLE_VS="('VS60', 'VS80')"
SS_MIN_VS_VERSION="2.2-1413"

UPGRADE_DB_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"desc": "${PKG_STR_WIZARD_UPGRADE_NOTE}"
	}]
}`

UPGRADE_VS_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"type": "multiselect",
		"desc": "$(echo ${PKG_STR_WIZARD_UPGRADE_VS_NOTE} | sed "s/{0}/${SS_MIN_VS_VERSION}/g")",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_VS_CHECK_LABEL}",
			"validator": {
				"fn": "{
					var v=arguments[0];
					if (!v) {
						return '${PKG_STR_WIZARD_VS_CHECK_HINT}';
					} else {
						return true;
					}
				}"
			}
		}]
	}]
}`

IsUpgradeToSqlite3()
{
	local PreSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | sed -n 's/\([0-9]*\.[0-9]*\)-[0-9]*/\1/p')

	if [ ${SS_SQLITE3_VER} \> ${PreSSVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeThumbnailToFile()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | sed -n 's/\([0-9]*\.[0-9]*\)-\([0-9]*\)/\2/p')

	if [ ${SS_THUMBNAIL_ISSUE_BUILD_VER} -le ${PreSSBuildVer} ] && [ ${SS_THUMBNAIL_FIXED_BUILD_VER} -gt ${PreSSBuildVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasImcompatibleVS()
{
	local SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ${SS_IMCOMPATIBLE_VS}"
	local Cnt=$(/usr/syno/bin/sqlite3 ${SS_SYSTEM_DB_FILE} "${SqlCmd}")

	if [ -z "${Cnt}" ]; then
		Cnt=$(/usr/syno/pgsql/bin/psql -A -t -U postgres surveillance -c "${SqlCmd}")
	fi

	if [ ${Cnt} -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

main()
{
	local UpgradeNotePages=""

	if [ "true" == $(HasImcompatibleVS) ]; then
		UpgradeNotePages="${UPGRADE_VS_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToSqlite3) ] || [ "true" == $(IsUpgradeThumbnailToFile) ]; then
		if [ -z "${UpgradeNotePages}" ]; then
			UpgradeNotePages="${UPGRADE_DB_NOTE_PAGE}"
		else
			UpgradeNotePages="${UpgradeNotePages},${UPGRADE_DB_NOTE_PAGE}"
		fi
	fi

	if [ -z "${UpgradeNotePages}" ]; then
		exit 0
	fi

/bin/cat > ${SYNOPKG_TEMP_LOGFILE} <<EOF
[${UpgradeNotePages}]
EOF

	exit 0
}

main "$@"
