#!/bin/sh

PKG_STR_WIZARD_UPGRADE_TITLE="진행하기 전에 읽으십시오"
PKG_STR_WIZARD_UPGRADE_NOTE="Surveillance Station 으로 업그레이드하려면 데이터베이스 변환이 필요하며 이로 인해 데이터베이스에 있는 레코드 수에 따라 시간이 걸릴 수 있습니다. 잠시 기다려 주시고, 이 작업을 진행하는 중에 시스템 전원을 끄거나 패키지를 제거하지 마십시오."
PKG_STR_WIZARD_UPGRADE_VS_NOTE="이 버전의 Surveillance Station은 VisualStation {0} 이상과만 호환됩니다. VisualStation VS60 및 VS80 모델은 이 버전의 Surveillance Station에서 더 이상 지원되지 않습니다."
PKG_STR_WIZARD_VS_CHECK_LABEL="본인은 호환성 제약 사항을 이해했으며, 업데이트를 진행하기를 원합니다."
PKG_STR_WIZARD_VS_CHECK_HINT="호환성 제약 사항을 주의깊게 읽고 확인란을 선택하고 진행하십시오."

# Copyright (c) 2014 Synology Inc. All rights reserved.

SS_PKG_PATH="/var/packages/SurveillanceStation/"
SS_INFO_FILE=${SS_PKG_PATH}"INFO"
SS_SYSTEM_DB_FILE=${SS_PKG_PATH}"target/system.db"
SS_VER_KEY="version"
SS_SQLITE3_VER="6.3"
SS_THUMBNAIL_ISSUE_BUILD_VER="3312"
SS_THUMBNAIL_FIXED_BUILD_VER="3352"
SS_IMCOMPATIBLE_VS="('VS60', 'VS80')"
SS_MIN_VS_VERSION="2.2-1413"

UPGRADE_DB_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"desc": "${PKG_STR_WIZARD_UPGRADE_NOTE}"
	}]
}`

UPGRADE_VS_NOTE_PAGE=`/bin/cat<<EOF
{
	"step_title": "${PKG_STR_WIZARD_UPGRADE_TITLE}",
	"items": [{
		"type": "multiselect",
		"desc": "$(echo ${PKG_STR_WIZARD_UPGRADE_VS_NOTE} | sed "s/{0}/${SS_MIN_VS_VERSION}/g")",
		"subitems": [{
			"desc": "${PKG_STR_WIZARD_VS_CHECK_LABEL}",
			"validator": {
				"fn": "{
					var v=arguments[0];
					if (!v) {
						return '${PKG_STR_WIZARD_VS_CHECK_HINT}';
					} else {
						return true;
					}
				}"
			}
		}]
	}]
}`

IsUpgradeToSqlite3()
{
	local PreSSVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | sed -n 's/\([0-9]*\.[0-9]*\)-[0-9]*/\1/p')

	if [ ${SS_SQLITE3_VER} \> ${PreSSVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

IsUpgradeThumbnailToFile()
{
	local PreSSBuildVer=$(/bin/get_key_value "${SS_INFO_FILE}" "${SS_VER_KEY}" | sed -n 's/\([0-9]*\.[0-9]*\)-\([0-9]*\)/\2/p')

	if [ ${SS_THUMBNAIL_ISSUE_BUILD_VER} -le ${PreSSBuildVer} ] && [ ${SS_THUMBNAIL_FIXED_BUILD_VER} -gt ${PreSSBuildVer} ]; then
		echo "true"
	else
		echo "false"
	fi
}

HasImcompatibleVS()
{
	local SqlCmd="SELECT COUNT(*) FROM visualstation WHERE platform IN ${SS_IMCOMPATIBLE_VS}"
	local Cnt=$(/usr/syno/bin/sqlite3 ${SS_SYSTEM_DB_FILE} "${SqlCmd}")

	if [ -z "${Cnt}" ]; then
		Cnt=$(/usr/syno/pgsql/bin/psql -A -t -U postgres surveillance -c "${SqlCmd}")
	fi

	if [ ${Cnt} -gt 0 ]; then
		echo "true"
	else
		echo "false"
	fi
}

main()
{
	local UpgradeNotePages=""

	if [ "true" == $(HasImcompatibleVS) ]; then
		UpgradeNotePages="${UPGRADE_VS_NOTE_PAGE}"
	fi

	if [ "true" == $(IsUpgradeToSqlite3) ] || [ "true" == $(IsUpgradeThumbnailToFile) ]; then
		if [ -z "${UpgradeNotePages}" ]; then
			UpgradeNotePages="${UPGRADE_DB_NOTE_PAGE}"
		else
			UpgradeNotePages="${UpgradeNotePages},${UPGRADE_DB_NOTE_PAGE}"
		fi
	fi

	if [ -z "${UpgradeNotePages}" ]; then
		exit 0
	fi

/bin/cat > ${SYNOPKG_TEMP_LOGFILE} <<EOF
[${UpgradeNotePages}]
EOF

	exit 0
}

main "$@"
