#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

. /var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh

UPGRADE_ERR_LOG="/var/log/surveillance/ssupgradeerr.log"
UPGRAGE_SCRIPT_DIR="${SS_AXISACSCTRL_DIR}/sql/upgrade"
UPGRADE_SCRIPT_LIST=`find ${UPGRAGE_SCRIPT_DIR} -name "*.sh" | sort`

DBI_AXISACSCTRL="axisacsctrl"
DBI_AXISACSEVTLOG="axisacsevtlog"

##### Function for upgrade scripts

SSUpgradeErrLog()
{
	local CurrDate=$(date)

	echo "$1"
	echo "${CurrDate}: $1" >> ${UPGRADE_ERR_LOG}
}

GetSqliteDBPath()
{
	case $1 in
	${DBI_AXISACSCTRL})
		echo ${SS_AXISACSCTRL_DB}
		;;
	${DBI_AXISACSEVTLOG})
		echo ${SS_AXISACSEVTLOG_DB}
		;;
	esac
}

ExecuteSqlCmd()
{
	local DBInstance="$1"

	if [ true == ${USE_SQLITE} ]; then
		local DBPath=$(GetSqliteDBPath ${DBInstance})

		Sqlite3Exec ${DBPath} "$2"
	fi
}

ExecuteSqlScriptFile()
{
	local DBInstance="$1"
	local FilePath="${UPGRAGE_SCRIPT_DIR}/$2"

	if [ true == ${USE_SQLITE} ]; then
		local DBPath=$(GetSqliteDBPath ${DBInstance})

		Sqlite3Exec ${DBPath} < ${FilePath}
	fi
}

#	usage: TestTableColumnToRunScript -d DBInstance -t TableName -c ColumnName -[eE] -s SqlScriptFile
#	options:
#		-t <name>		Table name to test
#		-c <name>		Column name to test
#		-s <name>		Sql script file to run if condition meets
#		-d <name>		Optional. DB Instance: system or recording. Default value is system.
#		-e				Optional. Sql script file will run when column does exist
#		-E				Optional. Sql script file will run when column does NOT exist. The default behavior.
TestTableColumnToRunScript()
{
	local DBInstance="${DBI_AXISACSCTRL}"
	local TableName
	local ColumnName
	local CondToRunScript=1
	local SqlScriptFile
	local Ret
	local OPTARG
	local OPTIND

	while getopts "d:t:c:eEs:" opt "$@"; do
		case "$opt" in
			d)
				DBInstance="$OPTARG"
			;;
			t)
				TableName="$OPTARG"
			;;
			c)
				ColumnName="$OPTARG"
			;;
			e)
				CondToRunScript=0
			;;
			E) 
				CondToRunScript=1
			;;
			s) 
				SqlScriptFile="$OPTARG"
			;;
		esac
	done
	shift $((OPTIND-1))

	if [ true == $(IsNonRecordingMode) -a "${DBI_AXISACSEVTLOG}" == "${DBInstance}" ]; then
		echo "Pass axisacsevtlog.db[${TableName}][${ColumnName}] check when in non-recording mode."
		return 0
	fi

	echo "Test ${TableName} table to check if column (${ColumnName}) exists"
	ExecuteSqlCmd "${DBInstance}" "SELECT ${ColumnName} FROM ${TableName} LIMIT 1;"
	Ret=$?

	if [ ${Ret} == "${CondToRunScript}" ]; then
		echo "Execute ${SqlScriptFile}"
		ExecuteSqlScriptFile "${DBInstance}" "${SqlScriptFile}"
		Ret=$?

		if [ ${Ret} != 0 ]; then
			SSUpgradeErrLog "Failed to upgrade surveillance database (${TableName} ${ColumnName}), ret: ${Ret}"
			SSUpgradeErrLog "script: ${SqlScriptFile}"
		fi
	fi
}

##### Functions for main function

RunUpgradeScript()
{
	for Script in $UPGRADE_SCRIPT_LIST;
	do
		echo "Run script: ${Script}"
		. ${Script}
	done
}

main()
{
	RunUpgradeScript
}

main "$@"
