#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

CURR_SCRIPT_NAME="$(basename $0)"

# DSM related
SYNO_SHARE_TOOL="/usr/syno/sbin/synoshare"
SERVICETOOL="/usr/syno/bin/servicetool"
SYNOPKG_TOOL="/usr/syno/bin/synopkg"
SYNOSYSTEMCTL_TOOL="/usr/syno/bin/synosystemctl" # DSM 7.0~
SYNO_SERVICE_TOOL="/usr/syno/sbin/synoservice" # DSM 6.x
RET_SYNO_SERVICE_ENABLED=1 # DSM 6.x
SYNOINFO_CONF="/etc/synoinfo.conf"
DEF_SYNOINFO_CONF="/etc.defaults/synoinfo.conf"
MODEL_NAME="$(/bin/get_key_value "${DEF_SYNOINFO_CONF}" "upnpmodelname")"
DS_SERIAL_NUMBER="$(cat /proc/sys/kernel/syno_serial)"
SYNO_WEBAPI="/usr/syno/bin/synowebapi"
NORMAL_SHUTDOWN_FILE="/var/.NormalShutdown"

# SS tmp files
SS_PKG_STARTING_FILE="/tmp/sspkgstarting"
SS_NON_RECORDING_FILE="/tmp/ss_non_recording"
SS_LEAVING_NON_RECORDING_FILE="/tmp/ss_leaving_non_recording"
SS_UNMOUNTING_ACTIVE_VOLUME_FILE="/tmp/ss_unmounting_active_volume"

# SS related
SS_PACKAGE_DIR="/var/packages/SurveillanceStation"
SS_TARGET_DIR="${SS_PACKAGE_DIR}/target"
SS_PKG_INFO_FILE="${SS_PACKAGE_DIR}/INFO"
SS_PKG_ENABLED_FILE="${SS_PACKAGE_DIR}/enabled"
SS_SCRIPTS_DIR="${SS_TARGET_DIR}/scripts"
S82_SCRIPT="${SS_SCRIPTS_DIR}/S82surveillance.sh"
SS_UTILS_SCRIPT="${SS_SCRIPTS_DIR}/ss_utils.sh"
SS_LOG_DIR="/var/log/surveillance"
SS_LOG_FILE="${SS_LOG_DIR}/surveillance.log"
SSCORED_NAME="sscored"
SS_EMAP_DIR_NAME="@SSEmap"
SS_EMAP_DIR="${SS_TARGET_DIR}/${SS_EMAP_DIR_NAME}"
SS_RTSP_DIR_NAME="@rtsp_info"
SS_RTSP_DIR="${SS_TARGET_DIR}/${SS_RTSP_DIR_NAME}"
SS_USER_PHOTO_DIR_NAME="@SSUserPhoto"
SS_USER_PHOTO_DIR="${SS_TARGET_DIR}/${SS_USER_PHOTO_DIR_NAME}"
SS_DATA_DIR_NAME="@SSData"
SS_DATA_DIR="${SS_TARGET_DIR}/${SS_DATA_DIR_NAME}"
SS_AXISACSCTRL_DIR="${SS_TARGET_DIR}/axis_acsctrl"
SS_TRANSACTIONS_DIR="${SS_TARGET_DIR}/transactions"
SS_APID_CONF="${SS_TARGET_DIR}/conf/upstart/pkg-surveillance-apid.conf"

# SS share folder related
SS_SHARE_FOLDER_LINK="/var/services/surveillance"
DEFAULT_SS_SHARE_NAME="surveillance"
SS_SERVICE_DATA_FOLDER_NAME="@surveillance"
SS_SERVICE_DATA_FOLDER_LINK="$SS_TARGET_DIR/$SS_SERVICE_DATA_FOLDER_NAME"
CREATE_SHARE_RETRY_CNT=3
SS_SHARE_DS_SETTING_CONF="${SS_SERVICE_DATA_FOLDER_LINK}/ds_settings.conf"
CONF_KEY_DS_SERIAL_NUMBER="ds_serial_number"
CONF_KEY_SS_UPGRADE_NUM="ss_upgrade_num"

# SS settings.conf related
SS_SETTINGS_CONF="${SS_PACKAGE_DIR}/etc/settings.conf"
SS_SETTINGS_CONF_BKP="${SS_SETTINGS_CONF}_backup"
CONF_KEY_ACTIVE_VOLUME="active_volume"
CONF_KEY_SYS_DB_BKP_PATH="system_db_backup_path"
CONF_KEY_AXISACSCTRL_DB_BKP_PATH="axisacsctrl_db_backup_path"
CONF_KEY_POS_DB_BKP_PATH="pos_db_backup_path"
CONF_KEY_IPSPEAKER_DB_BKP_PATH="ipspeaker_db_backup_path"
CONF_KEY_ARCHIVING_DB_BKP_PATH="archiving_db_backup_path"
CONF_KEY_TIMELAPSE_DB_BKP_PATH="timelapse_db_backup_path"
CONF_KEY_SERV_DATA_BKP_PATH="service_data_backup_path"
CONF_KEY_IS_LOGIN_BY_ALIAS="login_by_alias"
CONF_KEY_LOGIN_ALIAS="login_alias"
CONF_KEY_IS_LOGIN_BY_PORT="login_by_port"
CONF_KEY_LOGIN_PORT="login_port"

# SS DB
SS_SYSTEM_DB_TABLE="camera"
SS_SYSTEM_DB_NAME="system.db"
SS_SYSTEM_DB="${SS_TARGET_DIR}/${SS_SYSTEM_DB_NAME}"
SS_SYSTEM_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/system.sql"
#
SS_REC_DB_TABLE="event"
SS_REC_DB_NAME="recording.db"
SS_REC_DB="${SS_SERVICE_DATA_FOLDER_LINK}/${SS_REC_DB_NAME}"
SS_REC_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/recording.sql"
#
SS_REC_CNT_DB_TABLE="recording_cnt"
SS_REC_CNT_DB_NAME="recording_cnt.db"
SS_REC_CNT_DB="${SS_SERVICE_DATA_FOLDER_LINK}/${SS_REC_CNT_DB_NAME}"
SS_REC_CNT_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/recording_cnt.sql"
#
SS_AXISACSCTRL_DB_TABLE="axisacsctrler"
SS_AXISACSCTRL_DB_NAME="axisacsctrl.db"
SS_AXISACSCTRL_DB="${SS_TARGET_DIR}/${SS_AXISACSCTRL_DB_NAME}"
SS_AXISACSCTRL_SQL_SCRIPT="${SS_AXISACSCTRL_DIR}/sql/axisacsctrl.sql"
#
SS_AXISACSEVTLOG_DB_TABLE="axisacsevtlog"
SS_AXISACSEVTLOG_DB_NAME="axisacsevtlog.db"
SS_AXISACSEVTLOG_DB="${SS_SERVICE_DATA_FOLDER_LINK}/${SS_AXISACSEVTLOG_DB_NAME}"
SS_AXISACSEVTLOG_SQL_SCRIPT="${SS_AXISACSCTRL_DIR}/sql/axisacsevtlog.sql"
#
SS_SNAPSHOT_DB_TABLE="snapshot"
SS_SNAPSHOT_DB_NAME="snapshot.db"
SS_SNAPSHOT_DB="${SS_SERVICE_DATA_FOLDER_LINK}/${SS_SNAPSHOT_DB_NAME}"
SS_SNAPSHOT_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/snapshot.sql"
#
SS_LOG_DB_TABLE="log"
SS_LOG_DB_NAME="log.db"
SS_LOG_DB="${SS_SERVICE_DATA_FOLDER_LINK}/${SS_LOG_DB_NAME}"
SS_LOG_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/log.sql"
#
SS_ARCHIVING_DB_TABLE="archive_pull_task"
SS_ARCHIVING_DB_NAME="archiving.db"
SS_ARCHIVING_DB="${SS_TARGET_DIR}/${SS_ARCHIVING_DB_NAME}"
SS_ARCHIVING_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/archiving.sql"
#
SS_VIDEO_ANALYTICS_DB_TABLE="video_analytics_log"
SS_VIDEO_ANALYTICS_DB_NAME="videoanalytics.db"
SS_VIDEO_ANALYTICS_DB="${SS_SERVICE_DATA_FOLDER_LINK}/${SS_VIDEO_ANALYTICS_DB_NAME}"
SS_VIDEO_ANALYTICS_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/videoanalytics.sql"
#
SS_POS_DB_TABLE="pos"
SS_POS_DB_NAME="pos.db"
SS_POS_DB="${SS_TARGET_DIR}/${SS_POS_DB_NAME}"
SS_POS_SQL_SCRIPT="${SS_TRANSACTIONS_DIR}/sql/pos.sql"
#
SS_TRANSACTIONSLOG_DB_TABLE="transactionslog"
SS_TRANSACTIONSLOG_DB_NAME="transactionslog.db"
SS_TRANSACTIONSLOG_DB="${SS_SERVICE_DATA_FOLDER_LINK}/${SS_TRANSACTIONSLOG_DB_NAME}"
SS_TRANSACTIONSLOG_SQL_SCRIPT="${SS_TRANSACTIONS_DIR}/sql/transactionslog.sql"
#
SS_REC_DEL_DETAIL_DB_TABLE="recording_delete_detail"
SS_REC_DEL_DETAIL_DB_NAME="recording_delete_detail.db"
SS_REC_DEL_DETAIL_DB="${SS_SERVICE_DATA_FOLDER_LINK}/${SS_REC_DEL_DETAIL_DB_NAME}"
SS_REC_DEL_DETAIL_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/recording_delete_detail.sql"
#
SS_TIMELAPSE_DB_TABLE="timelapse_task"
SS_TIMELAPSE_DB_NAME="timelapse.db"
SS_TIMELAPSE_DB="${SS_TARGET_DIR}/${SS_TIMELAPSE_DB_NAME}"
SS_TIMELAPSE_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/timelapse.sql"
#
SS_IPSPEAKER_DB_TABLE="ipspeaker"
SS_IPSPEAKER_DB_NAME="ipspeaker.db"
SS_IPSPEAKER_DB="${SS_TARGET_DIR}/${SS_IPSPEAKER_DB_NAME}"
SS_IPSPEAKER_SQL_SCRIPT="${SS_SCRIPTS_DIR}/sql/ipspeaker.sql"

# SVS Data Dir
SS_CMS_DIR_NAME="@Cms"
SS_CAP_INFO_DIR_NAME="@SSCapInfo"
SS_SHARE_BACKUP_DIR_NAME="@SSDBBackup"
SS_AUDIO_PATTERN="@AudioPattern"

# SS DB related
USE_SQLITE=true
PGSQL_DB_NAME="surveillance"
PGSQL_DB_USER="postgres"
PGSQL_BIN_PSQL="/bin/psql -U ${PGSQL_DB_USER} ${PGSQL_DB_NAME}"
PGSQL_BIN_CREATEDB="/bin/createdb -U ${PGSQL_DB_USER} ${PGSQL_DB_NAME}"
PGSQL_BIN_PG_DUMP="/bin/pg_dump --inserts -U ${PGSQL_DB_USER} ${PGSQL_DB_NAME}"
PGSQL_BIN_DROPDB="/bin/dropdb -U ${PGSQL_DB_USER} ${PGSQL_DB_NAME}"
SS_SQLITE3="${SS_TARGET_DIR}/bin/sqlite3"
SS_SQL_UPGRADE_SCRIPT="${SS_SCRIPTS_DIR}/sql/sql.sh"
SS_AXISACSCTRL_SQL_UPGRADE_SCRIPT="${SS_AXISACSCTRL_DIR}/sql/sql.sh"
SS_TRANSACTIONS_SQL_UPGRADE_SCRIPT="${SS_TRANSACTIONS_DIR}/sql/sql.sh"
SS_UPGRADER="${SS_TARGET_DIR}/bin/ssupgrader"
SS_RECSHARE_CTRL="${SS_TARGET_DIR}/bin/ssrecsharectl"
SS_USER_SYNC="${SS_TARGET_DIR}/bin/ssusersync"
SS_PRE_VERSION_PATH="/tmp/SurveillanceStation.upgrade"
SS_CAMERA="${SS_TARGET_DIR}/bin/sscamera"
SS_TOOL="${SS_TARGET_DIR}/bin/sstool"
SS_INDEXER="${SS_TARGET_DIR}/bin/ssindexer"
SS_SQL_VER_KEY="ss_sql_version"
SS_UPGRADER_VER_KEY="ss_upgrader_version"

SS_DB_LIST=(${SS_SYSTEM_DB} ${SS_REC_DB} ${SS_REC_CNT_DB} ${SS_AXISACSCTRL_DB} ${SS_AXISACSEVTLOG_DB} \
			${SS_SNAPSHOT_DB} ${SS_LOG_DB} ${SS_ARCHIVING_DB} ${SS_POS_DB} ${SS_VIDEO_ANALYTICS_DB} \
			${SS_TRANSACTIONSLOG_DB} ${SS_REC_DEL_DETAIL_DB} ${SS_TIMELAPSE_DB} ${SS_IPSPEAKER_DB})

SS_TBL_LIST=(${SS_SYSTEM_DB_TABLE} ${SS_REC_DB_TABLE} ${SS_REC_CNT_DB_TABLE} ${SS_AXISACSCTRL_DB_TABLE} ${SS_AXISACSEVTLOG_DB_TABLE} \
			 ${SS_SNAPSHOT_DB_TABLE} ${SS_LOG_DB_TABLE} ${SS_ARCHIVING_DB_TABLE} ${SS_POS_DB_TABLE} ${SS_VIDEO_ANALYTICS_DB_TABLE} \
			 ${SS_TRANSACTIONSLOG_DB_TABLE} ${SS_REC_DEL_DETAIL_DB_TABLE} ${SS_TIMELAPSE_DB_TABLE} ${SS_IPSPEAKER_DB_TABLE})

SS_SQL_LIST=(${SS_SYSTEM_SQL_SCRIPT} ${SS_REC_SQL_SCRIPT} ${SS_REC_CNT_SQL_SCRIPT} ${SS_AXISACSCTRL_SQL_SCRIPT} ${SS_AXISACSEVTLOG_SQL_SCRIPT} \
			 ${SS_SNAPSHOT_SQL_SCRIPT} ${SS_LOG_SQL_SCRIPT} ${SS_ARCHIVING_SQL_SCRIPT} ${SS_POS_SQL_SCRIPT} ${SS_VIDEO_ANALYTICS_SQL_SCRIPT} \
			 ${SS_TRANSACTIONSLOG_SQL_SCRIPT} ${SS_REC_DEL_DETAIL_SQL_SCRIPT} ${SS_TIMELAPSE_SQL_SCRIPT} ${SS_IPSPEAKER_SQL_SCRIPT})

# SS Account related
AUTH_DOMAIN=0x2
AUTH_LDAP=0x8
SS_USER_SYNC_TMP_FILE="/tmp/ss_user_syncing"

# Private functions

__IsSSEnabled()
{
	[ -f "${SS_PKG_ENABLED_FILE}" ] && echo true || echo false
}

__CreateSSShareFolder()
{
	local VolumePath="$1"

	env -i HTTP_X_SYNO_RELAY_LANGUAGE=enu ${SYNO_WEBAPI} --exec api=SYNO.Core.Share method=create \
		version=1 name='"'${DEFAULT_SS_SHARE_NAME}'"' \
		shareinfo='{"name":"'${DEFAULT_SS_SHARE_NAME}'","vol_path":"'${VolumePath}'","enable_share_cow": false}' \
		> /dev/null 2>&1
}

__SynoShareGetSSShareInfo()
{
	echo "$(${SYNO_SHARE_TOOL} --get "${DEFAULT_SS_SHARE_NAME}")"
}

__GetSSShareFolderVolPath()
{
	echo "$(__SynoShareGetSSShareInfo | grep "Path" | awk '{print $2}' | sed 's/^[\.]*//g' | \
			sed 's/^\[//g' | sed 's/\]$//g')"
}

__IsSSShareFolderLinkAlive()
{
	if [ -L "${SS_SHARE_FOLDER_LINK}" -a -d "$(readlink "${SS_SHARE_FOLDER_LINK}")" ]; then
		echo true
	else
		echo false
	fi
}

__CheckSSShareFolderLink()
{
	if [ false == $(__IsSSShareFolderLinkAlive) ]; then
		SSDebugLog "Service link missing. Call servicetool to re-link."
		if [ true == $(IsDSM7) ]; then
			${SERVICETOOL} --setshare "${DEFAULT_SS_SHARE_NAME}" > /dev/null 2>&1
		else
			${SYNO_SERVICE_TOOL} --setshare "${DEFAULT_SS_SHARE_NAME}" > /dev/null 2>&1
		fi
	fi
}

__GetSSShareUserWithRWPriv()
{
	local ShareInfo="$1"
	local Users="admin,@administrators,SurveillanceStation"
	local CurRWUserFile=`mktemp`

	# Get current user with RW privilige
	__SynoShareGetSSShareInfo | sed -n 's/.*RW list.*\[\(.*\)\]/\1/p' | tr ',' '\n' > $CurRWUserFile

	# Append other users with RW privilege based on the above file
	while read User; do
		case "$User" in
			admin|@administrators|SurveillanceStation) continue ;;
			"") ;;
			*) Users="$Users,$User" ;;
		esac
	done < $CurRWUserFile

	rm -f $CurRWUserFile

	echo $Users
}

__PrepareLocalServiceShare()
{
	local VolumePath="$1"
	local CreateRetryCnt=0

	while [ -n "$VolumePath" -a \
			-z "$(__GetSSShareFolderVolPath)" -a \
		    ${CREATE_SHARE_RETRY_CNT} -gt ${CreateRetryCnt} ]; do
		__CreateSSShareFolder "${VolumePath}"
		CreateRetryCnt=$((CreateRetryCnt+1))
		sleep 1
	done

	if [ -z "$(__GetSSShareFolderVolPath)" ]; then
		local AliveVolumePath="$(${SERVICETOOL} --get-alive-volume)"

		__CreateSSShareFolder "${AliveVolumePath}"
		if [ -z "$(__GetSSShareFolderVolPath)" ]; then
			SSDebugLog "Failed to create surveillance share folder."
			return 1
		fi
	fi

	__CheckSSShareFolderLink
	CheckSSSharePrivilege

	if [ false == $(IsServiceDataLinkAlive) ]; then
		SSDebugLog "Service data link is not alive after share folder creation."
		return 1
	fi

	return 0
}

__IsHARunning()
{
	local SupportHA=$(/bin/get_key_value "${DEF_SYNOINFO_CONF}" "support_ha")
	local RunHA=$(/bin/get_key_value "${SYNOINFO_CONF}" "runha")

	[ "yes" == "${SupportHA}" -a "yes" == "${RunHA}" ] && echo true || echo false
}

# Public functions

Sqlite3Exec()
{
	$SS_SQLITE3 -init /dev/null -cmd ".timeout 300000" "$@"
}

PackageInfoGet()
{
	if [ -f "${SS_PKG_INFO_FILE}" ]; then
		SURVEILLANCE_PKG_NAME=$(/bin/get_key_value "${SS_PKG_INFO_FILE}" package)
		SURVEILLANCE_PKG_VERSION=$(/bin/get_key_value "${SS_PKG_INFO_FILE}" version)
		SURVEILLANCE_PKG_VENDOR=$(/bin/get_key_value "${SS_PKG_INFO_FILE}" maintainer)
	else
		echo "Surveillance station package info file does not exist!";
		exit 1;
	fi
}

IsSupportSynoApiDaemon()
{
	if [ true == $(IsDSM7) ]; then
		echo false;
		return
	fi

	local SUPPORT_SYNOAPID_VER="14890"
	local dsm_build_number="$(get_key_value "/etc/VERSION" "buildnumber")"

	if [ ${#dsm_build_number} -lt ${#SUPPORT_SYNOAPID_VER} ]; then
		echo false
	elif [ ${#dsm_build_number} -gt ${#SUPPORT_SYNOAPID_VER} ]; then
		echo true
	elif [[ dsm_build_number < SUPPORT_SYNOAPID_VER ]]; then
		echo false
	else
		echo true
	fi
}

ShouldRunApiDaemon()
{
	if [ true == IsSupportSynoApiDaemon ] && [ -f $SS_APID_CONF ]; then
		echo true
	else
		echo false
	fi
}

IsModelEDS14()
{
	if [ "EDS14" == "${MODEL_NAME}" ] ; then
		echo true
	else
		echo false
	fi
}

SurveillanceStationRestart()
{
	synopkg restart SurveillanceStation
}

SSDebugLog()
{
	local CurrDate="$(date +'%b %e %H:%M:%S')"
	local LogMsg="$1"
	local MaskVal="`umask`"

	#For creating log file with mode 666
	umask 0000
	echo "${LogMsg}"
	echo "${CurrDate} ${CURR_SCRIPT_NAME}: ${LogMsg}" >> "${SS_LOG_FILE}"
	umask "${MaskVal}"
}

IsNonRecordingMode()
{
	if [ -f ${SS_LEAVING_NON_RECORDING_FILE} ]; then
		echo false
	else
		[ -f ${SS_NON_RECORDING_FILE} ] && echo true || echo false
	fi
}

UpdateNonRecordingMode()
{
	if [ false == $(IsServiceDataLinkAlive) ]; then
		SSDebugLog "Enter non-recording mode"
		SetNonRecordingMode true
	else
		SSDebugLog "Leave non-recording mode"
		SetNonRecordingMode false
	fi
}

IsUnmountingActiveVolume()
{
	[ -f $SS_UNMOUNTING_ACTIVE_VOLUME_FILE ] && echo true || echo false
}

SetUnmountingActiveVolume()
{
	if [ true == "$1" ]; then
		touch $SS_UNMOUNTING_ACTIVE_VOLUME_FILE
	else
		rm -f $SS_UNMOUNTING_ACTIVE_VOLUME_FILE
	fi
}

GetPrevBuildNum()
{
	local BuildNum;

	if [ "INSTALL" == "${SYNOPKG_PKG_STATUS}" ]; then
		echo "0"
		return
	fi

	if [ -f "${SS_PRE_VERSION_PATH}" ]; then
		BuildNum=$(GetValueFromConfFile "${SS_PRE_VERSION_PATH}" "PreVer" | cut -d'-' -f2)
		rm -f "${SS_PRE_VERSION_PATH}"
	else
		BuildNum=$(GetValueFromConfFile "${SS_SHARE_DS_SETTING_CONF}" "${CONF_KEY_SS_UPGRADE_NUM}")
	fi

	if [ -n "${BuildNum}" ]; then
		echo "${BuildNum}"
	else
		echo "0"
	fi
}

RunSSUpgrader()
{
	local PrevBuildNum=$(GetPrevBuildNum);
	local CurBuildNum=$(GetValueFromConfFile "${SS_PKG_INFO_FILE}" "version" | cut -d'-' -f2)

	${SS_UPGRADER} ${PrevBuildNum}

	if [ -d $SS_SERVICE_DATA_FOLDER_LINK/ -a "${PrevBuildNum}" -ne "${CurBuildNum}" ]; then
		SetValueToConfFile "${SS_SHARE_DS_SETTING_CONF}" "${CONF_KEY_SS_UPGRADE_NUM}" "${CurBuildNum}"
	fi
}

RecountEvtRec()
{
	$SS_TOOL -c
}

# usage: SetNonRecordingMode (true|false) TRIGGER_SSCTL_REASON
SetNonRecordingMode()
{
	local blSet="$1"
	local TriggerSsctlReason="$2"
	local blTriggerSsctl=false
	local ShareName="$3"

	if [ -n "${TriggerSsctlReason}" ]; then
		blTriggerSsctl=true
	fi

	if [ true == ${blSet} ]; then
		if [ true == ${blTriggerSsctl} ]; then
			${S82_SCRIPT} trigger-ssctl pre-enter-non-rec-mode "${TriggerSsctlReason}" "${ShareName}"
		fi

		SaveSN
		touch ${SS_NON_RECORDING_FILE}

		if [ true == ${blTriggerSsctl} ]; then
			${S82_SCRIPT} trigger-ssctl post-enter-non-rec-mode "${TriggerSsctlReason}"
		fi
	else
		if [ true == ${blTriggerSsctl} ]; then
			${S82_SCRIPT} trigger-ssctl pre-leave-non-rec-mode "${TriggerSsctlReason}"
		fi

		touch ${SS_LEAVING_NON_RECORDING_FILE}
		SaveSN

		# TODO: Some functions of the ssupgrader may run with no effects in non-rec-mode.
		#       It's nice to fix it.

		${SS_SQL_UPGRADE_SCRIPT}
		RunSSUpgrader
		${SS_AXISACSCTRL_SQL_UPGRADE_SCRIPT}
		${SS_TRANSACTIONS_SQL_UPGRADE_SCRIPT}
		${S82_SCRIPT} trigger-ssctl clean-up-recording-event

		rm -f ${SS_LEAVING_NON_RECORDING_FILE}
		rm -f ${SS_NON_RECORDING_FILE}

		if [ true == ${blTriggerSsctl} ]; then
			${S82_SCRIPT} trigger-ssctl post-leave-non-rec-mode "${TriggerSsctlReason}" "${ShareName}"
		fi
	fi
}

SaveSN()
{
	SetValueToConfFile "${SS_SHARE_DS_SETTING_CONF}" \
					   "${CONF_KEY_DS_SERIAL_NUMBER}" "${DS_SERIAL_NUMBER}"
}

# usage: GetValueFromConfFile CONF_FILE KEY
GetValueFromConfFile()
{
	/bin/get_key_value "$1" "$2"
}

# usage: SetValueToConfFile CONF_FILE KEY VALUE
SetValueToConfFile()
{
	local ConfFile="$1"
	local Key="$2"
	local Value="$3"
	local KeyValPair=$(grep "^${Key}=" "${ConfFile}")

	if [ -n "${KeyValPair}" ]; then
		# escape \
		Value=$(echo ${Value} | sed 's/\//\\\//g')

		sed -i "s/^${Key}=.*/${Key}=\"${Value}\"/g" "${ConfFile}"
	else
		echo "${Key}=\"${Value}\"" >> "${ConfFile}"
	fi
}

# usage: RemoveKeyFromConfFile CONF_FILE KEY
RemoveKeyFromConfFile()
{
	local ConfFile="$1"
	local Key="$2"
	local KeyValPair=$(grep "^${Key}=" "${ConfFile}")

	if [ -n "${KeyValPair}" ]; then
		sed -i "s/^${Key}=.*//g" "${ConfFile}"
	fi
}

IsSSCoredRunning()
{
	[ -n "$(pidof ${SSCORED_NAME})" ] && echo true || echo false
}

PkgGetString()
{
	local File=$1
	local Sec=$2
	local Key=$3

	sed -n '/^\['$Sec'\]/,/^'$Key'/s/'$Key'.*=.*"\(.*\)"/\1/p' "$File"
}

IsValidSSVolumeLocation()
{
	local Location="$1"
	local blRet=false

	if [ true == $(IsModelEDS14) ]; then
		if [ "USB" == "${Location}" ]; then
			blRet=true
		fi
	else
		if [ "INTERNAL" == "${Location}" ]; then
			blRet=true
		fi
	fi

	echo "${blRet}"
}

UpdateActiveVolume()
{
	if [ true == $(__IsSSShareFolderLinkAlive) ]; then
		local ShareFolderPath="$(readlink "${SS_SHARE_FOLDER_LINK}")"
		local ActiveVolumePath="$(dirname "${ShareFolderPath}")"
		SetValueToConfFile "${SS_SETTINGS_CONF}" "${CONF_KEY_ACTIVE_VOLUME}" "${ActiveVolumePath}"

		if [ true == $(IsModelEDS14) ]; then
			UpdateServiceDataLink $ActiveVolumePath
		fi
	fi
}

IsServiceDataLinkAlive()
{
	if [ -d $SS_SERVICE_DATA_FOLDER_LINK/ ]; then
		echo true
	else
		echo false
	fi
}

UpdateServiceDataLink()
{
	local VolPath="$1"

	if [ -z "$VolPath" ]; then
		SSDebugLog "Cannot update service link with empty volpath."
		return -1
	elif [ ! -d $VolPath ]; then
		SSDebugLog "Cannot update service link with invalid volpath."
		return -1
	fi

	if [ -d $VolPath/$SS_SERVICE_DATA_FOLDER_NAME ]; then
		ln -sf $VolPath/$SS_SERVICE_DATA_FOLDER_NAME $SS_TARGET_DIR
	fi
}

IsDBAvailable()
{
	local DBPath="$1"
	local TableName="$2"

	if [ ! -f "${DBPath}" ]; then
		echo false
		return
	fi

	Sqlite3Exec "${DBPath}" "SELECT 1 FROM ${TableName} LIMIT 0;" > /dev/null 2>&1

	if [ 0 -ne "$?" ]; then
		local Ret=$(Sqlite3Exec "${DBPath}" "SELECT 1 FROM ${TableName} LIMIT 0;" 2>&1)
		SSDebugLog "Failed to SELECT ${TableName} table from ${DBPath} with error '${Ret}'." > /dev/null 2>&1
		SSDebugLog "${DBPath} exist but unable to SELECT ${TableName} table." > /dev/null 2>&1
		echo false
		return
	fi

	echo true
}

RecreateDb()
{
	local DbPath=$1
	local SqlScript=$2

	SSDebugLog "Prepare ${DbPath}."

	rm "${DbPath}"
	Sqlite3Exec "${DbPath}" < "${SqlScript}" > /dev/null 2>&1
	chown SurveillanceStation:SurveillanceStation "${DbPath}"
}

# Don't use "mkdir -p" to avoid create hard link in service link folder
CreateSurvOwnedDir()
{
	local DirPath=$1

	if [ ! -d "${DirPath}" ]; then
		mkdir "${DirPath}"
		chown SurveillanceStation:SurveillanceStation "${DirPath}"
	fi
}

GetServiceDataVolPath()
{
	if [ true == $(IsModelEDS14) ]; then
		# For EDS14, @surveillance locates in 'surveillance' share volume
		if [ -L $SS_SHARE_FOLDER_LINK -a -d $SS_SHARE_FOLDER_LINK ]; then
			echo $(dirname $(readlink $SS_SHARE_FOLDER_LINK))
		else
			echo $(GetValueFromConfFile $SS_SETTINGS_CONF $CONF_KEY_ACTIVE_VOLUME)
		fi
	else
		# For DS, @surveillance locates in 'SS package' volume
		local Vol=$(GetRootDir $SS_TARGET_DIR)
		[ -n "$Vol" ] && echo "/$Vol" || echo ""
	fi
}

CheckToCreateRecDB()
{
	if [ ! -d "$SS_SERVICE_DATA_FOLDER_LINK" ]; then
		return
	fi

	if [ false == $(IsDBAvailable "${SS_REC_DB}" "${SS_REC_DB_TABLE}") ]; then
		RecreateDb "${SS_REC_DB}" "${SS_REC_SQL_SCRIPT}"
		SSDebugLog "Remove ${SS_REC_CNT_DB}"
		rm -f "${SS_REC_CNT_DB}"
	fi

	if [ false == $(IsDBAvailable "${SS_REC_CNT_DB}" "${SS_REC_CNT_DB_TABLE}") ]; then
		RecreateDb "${SS_REC_CNT_DB}" "${SS_REC_CNT_SQL_SCRIPT}"
		${S82_SCRIPT} trigger-ssctl rebuild-recording-cnt
	fi

	if [ false == $(IsDBAvailable "${SS_LOG_DB}" "${SS_LOG_DB_TABLE}") ]; then
		RecreateDb "${SS_LOG_DB}" "${SS_LOG_SQL_SCRIPT}"
	fi

	if [ false == $(IsDBAvailable "${SS_AXISACSEVTLOG_DB}" "${SS_AXISACSEVTLOG_DB_TABLE}") ]; then
		RecreateDb "${SS_AXISACSEVTLOG_DB}" "${SS_AXISACSEVTLOG_SQL_SCRIPT}"
	fi

	if [ false == $(IsDBAvailable "${SS_SNAPSHOT_DB}" "${SS_SNAPSHOT_DB_TABLE}") ]; then
		RecreateDb "${SS_SNAPSHOT_DB}" "${SS_SNAPSHOT_SQL_SCRIPT}"
	fi

	if [ false == $(IsDBAvailable "${SS_ARCHIVING_DB}" "${SS_ARCHIVING_DB_TABLE}") ]; then
		RecreateDb "${SS_ARCHIVING_DB}" "${SS_ARCHIVING_SQL_SCRIPT}"
	fi

	if [ false == $(IsDBAvailable "${SS_VIDEO_ANALYTICS_DB}" "${SS_VIDEO_ANALYTICS_DB_TABLE}") ]; then
		RecreateDb "${SS_VIDEO_ANALYTICS_DB}" "${SS_VIDEO_ANALYTICS_SQL_SCRIPT}"
	fi

	if [ false == $(IsDBAvailable "${SS_REC_DEL_DETAIL_DB}" "${SS_REC_DEL_DETAIL_DB_TABLE}") ]; then
		RecreateDb "${SS_REC_DEL_DETAIL_DB}" "${SS_REC_DEL_DETAIL_SQL_SCRIPT}"
	fi

	if [ false == $(IsDBAvailable "${SS_TIMELAPSE_DB}" "${SS_TIMELAPSE_DB_TABLE}") ]; then
		RecreateDb "${SS_TIMELAPSE_DB}" "${SS_TIMELAPSE_SQL_SCRIPT}"
	fi
}

CheckSSSharePrivilege()
{
	local ShareInfo="$(__SynoShareGetSSShareInfo)"
	local GotAdminRWPriv="$(echo "$ShareInfo" | grep "RW list" | egrep "\badministrators\b")"
	local GotAdminROPriv="$(echo "$ShareInfo" | grep "RO list" | egrep "\badmin\b|\badministrators\b")"
	local Users=""

	if [ -z "$GotAdminRWPriv" -o -n "$GotAdminROPriv" ]; then
		Users=`__GetSSShareUserWithRWPriv`
		SSDebugLog "Set surveillance shared folder RW privilege for users [$Users]."
		$SYNO_SHARE_TOOL --setuser "$DEFAULT_SS_SHARE_NAME" RW = "$Users" > /dev/null 2>&1
	fi
}

PrepareServiceDataDir()
{
	local VolPath=$(GetServiceDataVolPath)

	if [ -z "$VolPath" -o ! -d "$VolPath" ]; then
		return -1
	fi

	local DstDir=$VolPath/$SS_SERVICE_DATA_FOLDER_NAME
	local TmpRmDir=$DstDir/"@eaDir/@tmp"

	if [ ! -d $DstDir ]; then
		if ! RestoreServiceDataDir $DstDir; then
			SSDebugLog "Create service data dir [$DstDir]."
			mkdir -p $DstDir
		fi
	fi

	if [ ! -d $TmpRmDir ]; then
		mkdir -p $TmpRmDir
	fi

	UpdateServiceDataLink $VolPath

	if [ -d $SS_SHARE_FOLDER_LINK ]; then
		mv -f \
			${SS_SHARE_FOLDER_LINK}/*.db \
			${SS_SHARE_FOLDER_LINK}/*.db-wal \
			${SS_SHARE_FOLDER_LINK}/*.db-shm \
			${SS_SHARE_FOLDER_LINK}/*.conf \
			${SS_SHARE_FOLDER_LINK}/.mv_evt_thumbnail.completed \
			${SS_SERVICE_DATA_FOLDER_LINK} 2> /dev/null

		MoveDirsToServiceDataDir "${SS_CMS_DIR_NAME} ${SS_CAP_INFO_DIR_NAME} \
								  ${SS_SHARE_BACKUP_DIR_NAME} ${SS_AUDIO_PATTERN}"
	fi

	ChangeServiceDataOwnerToSS

	return 0
}

RestoreServiceDataDir()
{
	local Conf="$SS_SETTINGS_CONF"
	local Key="$CONF_KEY_SERV_DATA_BKP_PATH"
	local BkpDir=$(GetValueFromConfFile "$Conf" "$Key")

	if [ -z "$BkpDir" ]; then
		BkpDir=$(GetValueFromConfFile "$SS_SETTINGS_CONF_BKP" "$Key")
	fi
	rm "$SS_SETTINGS_CONF_BKP"

	local SrcDir="${BkpDir}/${SS_SERVICE_DATA_FOLDER_NAME}"
	local DstDir="$1"

	if [ -d "$SrcDir" ]; then
		if mv "$SrcDir" "$DstDir"; then
			SSDebugLog "Restore service dir from [$SrcDir] to [$DstDir]"
			RemoveKeyFromConfFile "$Conf" "$Key"
			return 0
		else
			SSDebugLog "Failed to restore service dir from [$SrcDir] to [$DstDir]"
			return 1
		fi
	fi

	return 1
}

GetRootDir()
{
	local Dir="$1"
	local Res=""

	if [ -d "$Dir" ]; then
		Res=$(realpath "$Dir" | cut -d'/' -f2)
	fi

	echo "$Res"
}

MoveDirsToServiceDataDir()
{
	local TgtDirs="$1"
	local SrcDir=""
	local DstDir=""

	for Dir in $TgtDirs; do
		SrcDir="${SS_SHARE_FOLDER_LINK}/$Dir"
		DstDir="${SS_SERVICE_DATA_FOLDER_LINK}/$Dir"

		if [ ! -d "$SrcDir" ]; then
			continue
		fi

		if [ -d "$DstDir" ]; then
			mv -f "$SrcDir"/* "$DstDir"
			rm -rf "$SrcDir"
		else
			mv -f "$SrcDir" "$DstDir"
		fi
	done
}

ChangeServiceDataOwnerToSS()
{
	# No chown -R, since there may be lots of files under $SS_SERVICE_DATA_FOLDER_LINK
	chown -h SurveillanceStation:SurveillanceStation $SS_SERVICE_DATA_FOLDER_LINK
	chown SurveillanceStation:SurveillanceStation $SS_SERVICE_DATA_FOLDER_LINK
	chown SurveillanceStation:SurveillanceStation $SS_SERVICE_DATA_FOLDER_LINK/*

	# Add sticky bit
	chmod a+t $SS_SERVICE_DATA_FOLDER_LINK/@eaDir/@tmp
}

PrepareShareFolder()
{
	local VolumePath="$1"
	local Ret

	if [ -z "${VolumePath}" ]; then
		VolumePath=$(GetValueFromConfFile "${SS_SETTINGS_CONF}" "${CONF_KEY_ACTIVE_VOLUME}")
	fi

	__PrepareLocalServiceShare "${VolumePath}"
	Ret="$?"
	if [ 0 -ne "${Ret}" ]; then
		return "${Ret}"
	fi

	UpdateActiveVolume
}

HasSSPgsqlData()
{
	$PGSQL_BIN_PSQL -c "select 1 from camera" > /dev/null 2>&1

	if [ 2 == $? ]; then
		echo false
	else
		echo true
	fi
}

IsShutDown()
{
	if [ true == $(IsDSM7) ]; then
		/usr/syno/bin/synobootseq --is-shutdown > /dev/null

		if [ 0 == $? ]; then
			echo true
		else
			echo false
		fi
	else
		if	[ -f "${NORMAL_SHUTDOWN_FILE}" ]; then
			echo true
		else
			echo false
		fi
	fi
}

ShouldHandleVolumeEvent()
{
	if [ false == $(IsNonRecordingMode) -a \
		 false == $(IsShutDown) ]; then
		echo true
	else
		echo false
	fi
}

USBVolumeMounted()
{
	${S82_SCRIPT} trigger-ssctl usb-volume-mounted "$1"
}

GetTablesInDb()
{
	local DbPath="$1"

	if [ ! -f "$DbPath" ]; then
		SSDebugLog "DbPath [$DbPath] doesn't exist."
		return 1
	fi

	Sqlite3Exec $DbPath "select name from sqlite_master where type='table'"
}

MakeDebugLogDir()
{
	if [ ! -d ${SS_LOG_DIR} ]; then
		mkdir "${SS_LOG_DIR}"
		chmod 755 "${SS_LOG_DIR}"
		mv /var/log/surveillance.log* /var/log/ssnotification.log* /var/log/ssrotate.log* /var/log/ssupgradeerr.log /var/log/localdisplay.log "${SS_LOG_DIR}"
		chown -R SurveillanceStation:SurveillanceStation "${SS_LOG_DIR}"
	fi
}

GetDbIdx()
{
	local Db="$1"
	local DbLen=${#SS_DB_LIST[@]}

	for (( i=0; i<${DbLen}; i++ )); do
		if [ "${SS_DB_LIST[$i]}" == "${Db}" ]; then
			echo $i
			return
		fi
	done
}

GetVerifyTableByDb()
{
	local Idx=$(GetDbIdx "$1")

	if [ "$Idx" -ge 0 ]; then
		echo ${SS_TBL_LIST[$Idx]}
	fi
}

GetSqlScriptByDb()
{
	local Idx=$(GetDbIdx "$1")

	if [ "$Idx" -ge 0 ]; then
		echo ${SS_SQL_LIST[$Idx]}
	fi
}

IsSystemdUnitActivated()
{
	local Unit="$1"

	if [ "active" == "$(${SYNOSYSTEMCTL_TOOL} get-active-status ${Unit})" ]; then
		echo true
	else
		echo false
	fi
}

IsDSM7()
{
	if [ "$(get_key_value "/etc.defaults/VERSION" "majorversion")" -ge "7" ]; then
		echo true
	else
		echo false
	fi
}
