#!/bin/sh
# Copyright (c) 2018 Synology Inc. All rights reserved.

SURVEILLANCE_INC_SCRP=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
. ${SURVEILLANCE_INC_SCRP}

CA_DIR="/var/packages/SurveillanceStation/target/crtDir/"
CA_FILE="${CA_DIR}ca.crt"

## Actions
HASH_VALUE=$(openssl x509 -noout -hash -in ${CA_FILE} 2>/dev/null )

chmod 755 ${CA_DIR}
rm -f ${CA_DIR}*.0 #remove old link
chmod 644 ${CA_FILE}
ln -sf ${CA_FILE} "${CA_DIR}${HASH_VALUE}.0"

if [ true == $(IsDSM7) ]; then
	${SYNOSYSTEMCTL_TOOL} reload syslog-ng
else
	${SYNO_SERVICE_TOOL} --reload syslog-ng
fi

exit 0
