#!/bin/sh
# Copyright (c) 2016 Synology Inc. All rights reserved.

# --sdk-mod-ver
#								SYNOMODULE="app_privilege"
# --name/--pkg-ver/--vendor
#								NONE
# --post
#								NITEM: number of rule
#								TYPE_#: list of type (ex. USER, GROUP, EVERYONE)
#								ID_#: list of id (uid, gid, 0)
#								APP_#: list of application
#								RESULT: 0:success, -1:error

SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
if [ -f "${SS_COMMON_SCRIPT}" ]; then
	. ${SS_COMMON_SCRIPT}
else
	echo "$(date +'%b %e %H:%M:%S') $(basename ${SS_COMMON_SCRIPT}) not found." >> "/var/log/surveillance/surveillance.log"
	exit 0
fi

PostAppPrivSet()
{
	if [ 0 != ${RESULT} ]; then
		return;
	fi

	local UidList
	local GidList

	for i in $(seq 1 ${NITEM}); do
		eval "Type=\"\${TYPE_${i}}\""
		eval "Id=\"\${ID_${i}}\""
		eval "App=\"\${APP_${i}}\""

		if [ "SYNO.SDS.SurveillanceStation" != "${App}" ]; then
			continue;
		fi

		if [ "USER" == "${Type}" ]; then
			UidList="${UidList}","${Id}"
		elif [ "GROUP" == "${Type}" ]; then
			GidList="${GidList}","${Id}"
		fi

	done

	UidList=$(echo "${UidList}" | sed 's/^.//')
	GidList=$(echo "${GidList}" | sed 's/^.//')

	if [ -n "${UidList}" ]; then
		${SS_USER_SYNC} "update-user" "${UidList}"
	fi

	if [ -n "${GidList}" ]; then
		${SS_USER_SYNC} "update-group-gid" "${GidList}"
	fi
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--post)
			PostAppPrivSet;
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"
