#!/bin/sh
# Copyright (c) 2018 Synology Inc. All rights reserved.

# --sdk-mod-ver
#								SYNOMODULE="dirsvs"
# --name/--pkg-ver/--vendor
#								NONE
# --post
#								NITEMS, SERVER_TYPE, GID_#, GROUP_NAME_#

SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
if [ -f "${SS_COMMON_SCRIPT}" ]; then
	. ${SS_COMMON_SCRIPT}
else
	echo "$(date +'%b %e %H:%M:%S') $(basename ${SS_COMMON_SCRIPT}) not found." >> "/var/log/surveillance/surveillance.log"
	exit 0
fi

PostGroupDelete()
{
	if [ ! -f "${SS_USER_SYNC_TMP_FILE}" ]; then
		${SS_USER_SYNC} "sync-all" "$((${AUTH_DOMAIN} | ${AUTH_LDAP}))"
	else
		SSDebugLog "dirsvs_group/delete PostGroupDelete is ignored due to ssusersync is running."
	fi
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--post)
			PostGroupDelete
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"