#!/bin/sh
# Copyright (c) 2018 Synology Inc. All rights reserved.

# --sdk-mod-ver
#								SYNOMODULE="group"
# --name/--pkg-ver/--vendor
#								NONE
# --pre/--post
#								NITEMS: number of rule
#								GID_#: list of gid
#								GROUP_NAME_#: list of groupname
#								GROUP_OP_RESULT_#: 0x0000: success
#								RESULT: 0:success, -1:error

SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
if [ -f "${SS_COMMON_SCRIPT}" ]; then
	. ${SS_COMMON_SCRIPT}
else
	echo "$(date +'%b %e %H:%M:%S') $(basename ${SS_COMMON_SCRIPT}) not found." >> "/var/log/surveillance/surveillance.log"
	exit 0
fi

PreGroupDelete()
{
	if [ 0 != ${RESULT} ]; then
		return;
	fi

	local GrpNameList

	for i in $(seq 1 ${NITEMS}); do
		eval "GrpName=\"\${GROUP_NAME_${i}}\""

		GrpNameList="${GrpNameList}","${GrpName}"
	done

	GrpNameList=$(echo "${GrpNameList}" | sed 's/^.//')

	if [ -n "${GrpNameList}" ]; then
		${SS_USER_SYNC} "delete-group-name" "${GrpNameList}"
	fi
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
        --pre)
            PreGroupDelete
	    ;;
		--post)
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
	esac
}

main "$@"