#!/bin/sh
# Copyright (c) 2018 Synology Inc. All rights reserved.

# --sdk-mod-ver
#								SYNOMODULE="user"
# --name/--pkg-ver/--vendor
#								NONE
# --post
#								NITEMS: number of rule
#								USER_NAME_#: list of username
#								UID_#: list of uid (uid, gid, 0)
#								USER_OP_RESULT_#: 0x0000: success
#								RESULT: 0:success, -1:error

SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
if [ -f "${SS_COMMON_SCRIPT}" ]; then
	. ${SS_COMMON_SCRIPT}
else
	echo "$(date +'%b %e %H:%M:%S') $(basename ${SS_COMMON_SCRIPT}) not found." >> "/var/log/surveillance/surveillance.log"
	exit 0
fi

PostUserDelete()
{
	if [ 0 != ${RESULT} ]; then
		return;
	fi

	local UidList

	for i in $(seq 1 ${NITEMS}); do
		eval "USER_OP_RESULT=\${USER_OP_RESULT_${i}}"
		eval "Uid=\"\${UID_${i}}\""

		if [ 0x0000 == ${USER_OP_RESULT} ]; then
			UidList="${UidList}","${Uid}"
		fi

	done

	UidList=$(echo "${UidList}" | sed 's/^.//')

	if [ -n "${UidList}" ]; then
		${SS_USER_SYNC} "update-user" "${UidList}"
	fi
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--post)
			PostUserDelete;
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"