#!/bin/sh
# Copyright (c) 2016 Synology Inc. All rights reserved.

###############################################################
#   This script should be hooked when invoking ipv4 change
#   Usable environment variable:
#       both: IFNAME, ORIGIN_ADDRESS, NEW_ADDRESS, IS_LINK
#
#   Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
SURVEILLANCE_INC_SCRP=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
if [ -f "${SURVEILLANCE_INC_SCRP}" ]; then
	. ${SURVEILLANCE_INC_SCRP}
else
	echo "$(date +'%b %e %H:%M:%S') $(basename ${SURVEILLANCE_INC_SCRP}) not found." >> "/var/log/surveillance/surveillance.log"
	exit 0
fi

#At begining, acquire package settings
PackageInfoGet;

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0"
	;;
	--name)
		#Print package name
		echo ${SURVEILLANCE_PKG_NAME};
	;;
	--pkg-ver)
		#Print package version
		echo ${SURVEILLANCE_PKG_VERSION};
	;;
	--vendor)
		#Print package vendor
		echo ${SURVEILLANCE_PKG_VENDOR};
	;;
	--pre)
	;;
	--post)
		#Skip quick connect net change for dsm bug
		if [ "tun1000" == "${IFNAME}" ]; then
			exit 0
		fi

		if [ -f "${SS_PKG_ENABLED_FILE}" -a true == $(IsSSCoredRunning) ]; then
			SSDebugLog "SurveillanceStation reset-cached-data Ifname:[${IFNAME}] Ip:[${ORIGIN_ADDRESS} to ${NEW_ADDRESS}].";
			${S82_SCRIPT} trigger-ssctl reset-cached-data
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

