#!/bin/sh
# Copyright (c) 2015 Synology Inc. All rights reserved.

###############################################################
#	This script should be hooked when invoking SYNOShareDelete()
#	Usable environment variable:
#		NITEMS, CLEAN_DATA, SHARE_NAME_#, SHARE_PATH_#,
#		SHARE_STATUS_#(encrypt/decrypt/normal), SHARE_OP_RESULT_#,
#		#: $(seq 1 ${NITEMS})
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
SURVEILLANCE_INC_SCRP=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
. ${SURVEILLANCE_INC_SCRP}

PreDelete()
{
	if [ false == $(ShouldHandleVolumeEvent) -o \
		 true == $(IsEds14UnmountActiveVolume) ]; then
		return
	fi

	local ShareName
	local SharePathList
	local RecShareList=$(Sqlite3Exec "${SS_SYSTEM_DB}" "SELECT name from recordingshare WHERE owner_ds_id = 0 AND mount_type = 0;")
	local IFS=$'\n'

	for i in $(seq 1 ${NITEMS}); do
		eval "ShareName=\"\${SHARE_NAME_${i}}\""
		eval "SharePath=\"\${SHARE_PATH_${i}}\""

		for RecShare in ${RecShareList}; do
			if [ "${RecShare}" == "${ShareName}" ]; then
				SharePathList="${SharePathList}","${SharePath}"
				break
			fi
		done
	done

	SharePathList=$(echo "${SharePathList}" | sed 's/^.//')

	if [ -n "${SharePathList}" ]; then
		SSDebugLog "Record share '${SharePathList}' is deleted by DSM."
		${SS_RECSHARE_CTRL} "pre-del-rec-share" "${SharePathList}"
	fi
}

IsEds14UnmountActiveVolume()
{
	if [ true == $(IsModelEDS14) -a true == $(IsUnmountingActiveVolume) ]; then
		echo true
	else
		echo false
	fi
}

main()
{
	PackageInfoGet;

	case $1 in
		--sdk-mod-ver)
			#Print SDK support version
			echo "2.0"
		;;
		--name)
			#Print package name
			echo ${SURVEILLANCE_PKG_NAME};
		;;
		--pkg-ver)
			#Print package version
			echo ${SURVEILLANCE_PKG_VERSION};
		;;
		--vendor)
			#Print package vendor
			echo ${SURVEILLANCE_PKG_VENDOR};
		;;
		--pre)
			#Actions before share delete
			PreDelete;
		;;
		--post)
			#Actions after share delete
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
	esac
}

main "$@"
