#!/bin/sh
# Copyright (c) 2000-2015 Synology Inc. All rights reserved.

###############################################################
#	This script should be hooked when invoking SYNOShareSet()
#	Usable environment variable:
#		ORIGIN_SHARE_NAME, SHARE_NAME, ORIGIN_SHARE_PATH, SHARE_PATH,
#		ORIGIN_SHARE_STATUS(encrypt/decrypt/normal), SHARE_STATUS(encrypt/decrypt/normal),
#		RESULT, ORIGIN_SHARE_ENABLE, SHARE_ENABLE
#
#	Note: The script should bear to be invoked multiple times
###############################################################

HOOK_SCRP=/var/packages/SurveillanceStation/target/scripts/ShareHookCommon.sh
. $HOOK_SCRP

PrintArgs()
{
	local Msg="$1"

	SSDebugLog "[$Msg] NAME: $ORIGIN_SHARE_NAME => $SHARE_NAME"
	SSDebugLog "[$Msg] PATH: $ORIGIN_SHARE_PATH => $SHARE_PATH"
	SSDebugLog "[$Msg] STATUS: $ORIGIN_SHARE_STATUS => $SHARE_STATUS"
	SSDebugLog "[$Msg] ENABLE: $ORIGIN_SHARE_ENABLE => $SHARE_ENABLE"
	SSDebugLog "[$Msg] ToDisable: $(ChgToDisable), ToEnable: $(ChgToEnable), NeedUpdShare: $(NeedUpdShare)"
}

ChgToDisable()
{
	if [ "$ORIGIN_SHARE_ENABLE" == "1" ] && [ "$SHARE_ENABLE" == "0" ]; then
		echo true
	else
		echo false
	fi
}

ChgToEnable()
{
	if [ "$ORIGIN_SHARE_ENABLE" == "0" ] && [ "$SHARE_ENABLE" == "1" ]; then
		echo true
	else
		echo false
	fi
}

IsEncStsChg()
{
	if [ "$ORIGIN_SHARE_STATUS" !=  "$SHARE_STATUS" ]; then
		case "$ORIGIN_SHARE_STATUS" in
			"encrypt"|"decrypt")
				echo true
				return ;;
			 *) ;;
		esac

		case $SHARE_STATUS in
			"encrypt"|"decrypt")
				echo true
				return ;;
			 *) ;;
		esac
	fi

	echo false
}

NeedUpdShare()
{
	if [ "$ORIGIN_SHARE_PATH" != "$SHARE_PATH" ] ||
	   [ "$ORIGIN_SHARE_ENABLE" != "$SHARE_ENABLE" ] ||
	   [ "true" == $(IsEncStsChg) ]; then
		echo true
	else
		echo false
	fi
}

SSShareSetBegin()
{
	local ToDisable=$(ChgToDisable)

	if [ true == $ToDisable ]; then
		SharePreSetHook true false
	fi
}

SSShareSetEnd()
{
	local ToEnable=$(ChgToEnable)

	if [ true == $(NeedUpdShare) ]; then
		SharePostSetHook $ToEnable false
	fi
}

main()
{
	PackageInfoGet;

	case $1 in
		--sdk-mod-ver)
			#Print SDK support version
			echo "2.0"
		;;
		--name)
			#Print package name
			echo ${SURVEILLANCE_PKG_NAME};
		;;
		--pkg-ver)
			#Print package version
			echo ${SURVEILLANCE_PKG_VERSION};
		;;
		--vendor)
			#Print package vendor
			echo ${SURVEILLANCE_PKG_VENDOR};
		;;
		--pre)
			#Actions before share set
			SSShareSetBegin;
		;;
		--post)
			#Actions after share set
			SSShareSetEnd;
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
	esac
}

main "$@"

