#!/bin/sh
# Copyright (c) 2018 Synology Inc. All rights reserved.

# --sdk-mod-ver
#								SYNOMODULE="volume"
# --name/--pkg-ver/--vendor
#								NONE
# --post
#								DEVICE: mount device (ex: /dev/md1)
#								MOUNTPOINT: mount point (ex: /volume1)
#								TYPE: file system type (ex: ext4)
#								LOCATION: location ("INTERNAL", "EUNIT", "USB", "ESATA")
#								RESULT: expand result (0, -1)

SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
if [ -f "${SS_COMMON_SCRIPT}" ]; then
	. ${SS_COMMON_SCRIPT}
else
	echo "$(date +'%b %e %H:%M:%S') $(basename ${SS_COMMON_SCRIPT}) not found." >> "/var/log/surveillance/surveillance.log"
	exit 0
fi

PostVolumeExpand()
{
	if [ "0" != "${RESULT}" ]; then
		return;
	fi

	${SS_RECSHARE_CTRL} "post-volume-expand" "${MOUNTPOINT}"
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--post)
			PostVolumeExpand;
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"
