#!/bin/sh
# Copyright (c) 2014 Synology Inc. All rights reserved.

# --sdk-mod-ver
#								SYNOMODULE="volume"
# --name/--pkg-ver/--vendor
#								NONE
# --post
#								DEVICE: mount device (ex: /dev/md1)
#								MOUNTPOINT: mount point (ex: /volume1)
#								TYPE: file system type (ex: ext4)
#								LOCATION: location ("INTERNAL", "EUNIT", "USB", "ESATA")

SS_COMMON_SCRIPT=/var/packages/SurveillanceStation/target/scripts/SurveillanceStationCommon.sh
. ${SS_COMMON_SCRIPT}

SHARE_DIR_ROOT="$MOUNTPOINT/@sharebin"

CheckRecVolume()
{
	${SS_RECSHARE_CTRL} "rec-share-recovery" "$MOUNTPOINT"
}

RenameFolderToSS()
{
	local ShareName="$1"

	SSDebugLog "Find surveillance alias [$ShareName], rename to $DEFAULT_SS_SHARE_NAME."
	mv "$SHARE_DIR_ROOT/$ShareName" "$SHARE_DIR_ROOT/$DEFAULT_SS_SHARE_NAME"
}

IsSSFolder()
{
	local RecDb="$SHARE_DIR_ROOT/$1/$SS_REC_DB_NAME"

	IsDBAvailable "$RecDb" "$SS_REC_DB_TABLE"
}

RenameSSFolderAliasIfExist()
{
	local Alias=$(ls -1Ad "$SHARE_DIR_ROOT/"*/ | sed -n 's,'"$SHARE_DIR_ROOT"'/\(surveillance\(_1\)\+\)/,\1,p')

	if [ -z "$Alias" ]; then
		return 1
	elif [ -d "$SHARE_DIR_ROOT/$SS_SERVICE_DATA_FOLDER_NAME" ]; then
		SSDebugLog "Find $SS_SERVICE_DATA_FOLDER_NAME in this mount point, rename first alias."
		RenameFolderToSS $(echo $Alias | head -n1)
		return
	fi

	for ShareName in $Alias; do
		if [ true == $(IsSSFolder "$ShareName") ]; then
			SSDebugLog "Find $SS_REC_DB_NAME in $ShareName, rename this alias."
			RenameFolderToSS "$ShareName"
			return
		fi
	done

	return 1
}

PostMount()
{
	if [ false == $(IsNonRecordingMode) -o \
		 false == $(IsValidSSVolumeLocation "${LOCATION}") ]; then
		if [ "USB" == "${LOCATION}" ]; then
			USBVolumeMounted "${MOUNTPOINT}"
		fi

		return
	fi

	local blLeaveNonRecMode=true

	if [ -d "${SS_SHARE_FOLDER_LINK}" -o -d "$SHARE_DIR_ROOT/$DEFAULT_SS_SHARE_NAME" ]; then
		SSDebugLog "Surveillance share folder found on the mounted volume."
		PrepareServiceDataDir
	elif [ true == $(IsModelEDS14) ]; then
		RenameSSFolderAliasIfExist
		if [ 0 -eq "$?" ]; then
			return
		fi

		SSDebugLog "SS Share link not found. Try to rebuild it."

		if ! PrepareShareFolder "${MOUNTPOINT}"; then
			SSDebugLog "Failed to rebuild surveillance share folder."
			blLeaveNonRecMode=false
		fi
	fi

	if [ true == ${blLeaveNonRecMode} -a true == $(IsNonRecordingMode) ]; then
		SSDebugLog "Leave non-recording mode due to new volume mounted."
		UpdateActiveVolume
		SetNonRecordingMode false volume
	fi
}

main()
{
	PackageInfoGet

	case $1 in
		--sdk-mod-ver)
			echo "1.0"
		;;
		--name)
			echo ${SURVEILLANCE_PKG_NAME}
		;;
		--pkg-ver)
			echo ${SURVEILLANCE_PKG_VERSION}
		;;
		--vendor)
			echo ${SURVEILLANCE_PKG_VENDOR}
		;;
		--post)
			PostMount
			CheckRecVolume
		;;
		*)
			echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--post"
		;;
	esac
}

main "$@"
