
CREATE TABLE IF NOT EXISTS log (
	id					integer PRIMARY KEY AUTOINCREMENT,
	dsid				integer DEFAULT 0,
	id_on_rec_server	integer DEFAULT 0,
	level				integer,
	timestamp			integer,
	update_time			integer,
	event_msg			text,
	log_type			bigint DEFAULT -1,
	log_grp				integer DEFAULT -1,
	item_id				bigint DEFAULT -1,
	user_name			text DEFAULT '',
	detail_id			integer DEFAULT 0
);

CREATE TABLE IF NOT EXISTS log_cnt (
	dsid				integer PRIMARY KEY,
	cnt					integer DEFAULT 0
);

INSERT OR IGNORE INTO log_cnt(dsid, cnt) VALUES(0, 0);

CREATE INDEX IF NOT EXISTS log_timestamp_idx ON log(timestamp);
CREATE INDEX IF NOT EXISTS log_update_time_idx ON log(update_time);

CREATE TRIGGER IF NOT EXISTS log_auto_update AFTER UPDATE ON log BEGIN UPDATE OR IGNORE log SET update_time = (SELECT MAX(update_time) FROM log) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS log_auto_update_insert AFTER INSERT ON log BEGIN
	UPDATE OR IGNORE log SET update_time = (SELECT MAX(update_time) FROM log) + 1 WHERE id = new.id;
	UPDATE log_cnt SET cnt = (cnt+1) WHERE dsid = NEW.dsid;
END;
CREATE TRIGGER IF NOT EXISTS log_auto_update_delete AFTER DELETE ON log BEGIN
	UPDATE log_cnt SET cnt = (cnt-1) WHERE dsid = OLD.dsid;
END;

CREATE TABLE IF NOT EXISTS message (
	id					integer PRIMARY KEY AUTOINCREMENT,
	dsid				integer DEFAULT 0,
	level				integer,
	timestamp			integer,
	event_msg			text,
	params				text,
	log_grp				integer DEFAULT -1,
	item_id				bigint DEFAULT -1
);

CREATE INDEX IF NOT EXISTS message_timestamp_idx ON message(timestamp);

CREATE TABLE IF NOT EXISTS actrulehistory (
	id				integer PRIMARY KEY AUTOINCREMENT,
	level			integer DEFAULT 0,
	timestamp		integer default 0,
	rule_name		varchar(512),
	rule_type		integer DEFAULT 0,
	act_status		integer DEFAULT 0
);

CREATE INDEX IF NOT EXISTS rulehistory_timestamp_idx ON actrulehistory(timestamp);

CREATE TABLE IF NOT EXISTS iomodulelog (
	id                  integer PRIMARY KEY AUTOINCREMENT,
	iomodule_id         integer DEFAULT 0,
	port_idx            integer DEFAULT 0,
	iomodule_name		varchar(256) DEFAULT '',
	port_name			varchar(128) DEFAULT '',
	type                integer DEFAULT 0,
	timestamp           integer DEFAULT 0,
	active_time         integer DEFAULT 0
);

CREATE TABLE IF NOT EXISTS intercomlog (
	id					integer PRIMARY KEY AUTOINCREMENT,
	camera_id			integer DEFAULT 0,
	type				integer DEFAULT 0,
	timestamp			integer DEFAULT 0,
	log_user			text DEFAULT '',
	is_from_host		boolean DEFAULT '0'
);

CREATE INDEX IF NOT EXISTS intercomlog_timestmp_idx ON intercomlog(timestamp, camera_id);
