CREATE TABLE IF NOT EXISTS snapshot (
	id						integer PRIMARY KEY AUTOINCREMENT,
	camera_name			varchar(256) DEFAULT '',
	filename				varchar(256) DEFAULT '',
	created_time			integer DEFAULT 0,
	last_modified_time		integer DEFAULT 0,
	modified_counter		integer DEFAULT 0,
	byte_size				integer DEFAULT 0,
	width					integer DEFAULT 0,
	height					integer DEFAULT 0,
	locked					boolean DEFAULT 0,
	mark_as_del				boolean DEFAULT '0',
	update_time				integer DEFAULT 0,
	video_time				integer DEFAULT 0,
	cam_id					integer DEFAULT 0
);

CREATE TABLE IF NOT EXISTS snapshotpushserv (
	id						integer PRIMARY KEY AUTOINCREMENT,
	filename				varchar(256) DEFAULT '',
	created_time			integer DEFAULT 0
);

CREATE INDEX IF NOT EXISTS snapshot_update_time_idx ON snapshot(update_time);
CREATE INDEX IF NOT EXISTS snapshot_cam_id_idx ON snapshot(cam_id);
CREATE TRIGGER IF NOT EXISTS snapshot_auto_update AFTER UPDATE ON snapshot BEGIN UPDATE OR IGNORE snapshot SET update_time = (SELECT MAX(update_time) FROM snapshot) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS snapshot_auto_update_insert AFTER INSERT ON snapshot BEGIN UPDATE OR IGNORE snapshot SET update_time = (SELECT MAX(update_time) FROM snapshot) + 1 WHERE id = new.id; END;
