BEGIN;

ALTER TABLE alertevent ADD COLUMN update_seq integer DEFAULT 0;

CREATE INDEX IF NOT EXISTS alert_event_update_seq_idx ON alertevent(update_seq);
CREATE TRIGGER IF NOT EXISTS alert_event_auto_update AFTER UPDATE ON alertevent BEGIN UPDATE OR IGNORE alertevent SET update_seq = (SELECT MAX(update_seq) FROM alertevent) + 1 WHERE id = new.id; END;
CREATE TRIGGER IF NOT EXISTS alert_event_auto_update_insert AFTER INSERT ON alertevent BEGIN UPDATE OR IGNORE alertevent SET update_seq = (SELECT MAX(update_seq) FROM alertevent) + 1 WHERE id = new.id; END;

COMMIT;
