#!/bin/bash
# Copyright (c) 2016 Synology Inc. All rights reserved.

IsLogRelatedTbl()
{
	case $1 in
		log|log_cnt|log_hist|log_ds_*|message|actrulehistory)
			return 0 ;;
		*)
			return 1 ;;
	esac
}

HasLogRecord()
{
	local DbPath=$1
	local RecCnt=0

	if [ ! -f "$DbPath" ]; then
		SSDebugLog "Db [$DbPath] doesn't exist."
		return 1
	fi

	for Tbl in $(GetTablesInDb $DbPath); do
		if IsLogRelatedTbl $Tbl; then
			RecCnt=$(Sqlite3Exec $DbPath "SELECT COUNT(1) from $Tbl;")
			[ $RecCnt != 0 ] && return 0
		fi
	done

	return 1
}

DropLogRelatedTbl()
{
	local Db=$1

	for Tbl in $(GetTablesInDb $Db); do
		if IsLogRelatedTbl $Tbl; then
			Sqlite3Exec $Db "DROP TABLE IF EXISTS $Tbl;"
		fi
	done
}

KeepLogRelatedTbl()
{
	local Db=$1

	for Tbl in $(GetTablesInDb $Db); do
		if ! IsLogRelatedTbl $Tbl; then
			Sqlite3Exec $Db "DROP TABLE IF EXISTS $Tbl;"
		fi
	done
}

MigrateLogRelatedTables()
{
	if [ true == $(IsNonRecordingMode) ]; then
		SSDebugLog "Skip MigrateLogRelatedTables() due to in non-rec mode."
		return 0
	fi

	local RecDbHasLogTbl=$(IsDBAvailable $SS_REC_DB $SS_LOG_DB_TABLE)

	if [ false == $RecDbHasLogTbl ]; then
		return 0
	fi

	if HasLogRecord $SS_REC_DB; then
		SSDebugLog "Migrate log related DB tables to $SS_LOG_DB_NAME"
		cp $SS_REC_DB $SS_LOG_DB
		KeepLogRelatedTbl $SS_LOG_DB
	fi

	# always need to do this since log tables are still added to recording.db by old script
	DropLogRelatedTbl $SS_REC_DB

	return 0
}

MigrateLogRelatedTables
