BEGIN;

CREATE TABLE IF NOT EXISTS sharerecording (
	id								INTEGER PRIMARY KEY ASC AUTOINCREMENT,
	hash							TEXT NOT NULL,
	event_id						INTEGER DEFAULT 0,
	event_db_type					INTEGER DEFAULT 0,
	event_src_id					INTEGER DEFAULT 0,
	file_path						TEXT NOT NULL,
	camera_id						INTEGER DEFAULT 0
);

CREATE UNIQUE INDEX IF NOT EXISTS share_recording_hash ON sharerecording (hash);
CREATE INDEX IF NOT EXISTS share_recording_event_id ON sharerecording (event_id);
CREATE INDEX IF NOT EXISTS share_recording_event_db_type ON sharerecording (event_db_type);
CREATE INDEX IF NOT EXISTS share_recording_event_src_id ON sharerecording (event_src_id);

COMMIT;