#!/bin/sh
#
# by thlu

log() { echo "$@" >&2; }

show_help() {
	cat >&2 <<EOF
Usage: $(basename $0) [options] <cgi> <param>
	if <param> is not set, use standard input instead
Options:
	-u <username>   set login username
	-f <input>      set input to file instead of stdin when <param> not set
	-c <input>      use chrome style form input
	-d              use gdb debug
	-v              use valgrind (X64 only)
	-s              use strace
	-e              show env only, will not run cgi
	-g <get param>  the content of QUERY_STRING
Example:
	$(basename $0) ./login.cgi "username=admin&passwd=1"
	$(basename $0) ./network.cgi "action=load"
	$(basename $0) -g "upload=false" -j ./install.cgi "buildin=true"
EOF
	return 0
}

login_user="admin"
input_file="-"
junior_config="/root/config"

while getopts "c:u:f:edhg:" opt; do
	case "$opt" in
		u) login_user=$OPTARG ;;
		f) input_file=$OPTARG ;;
		c) chrome_input=$OPTARG ;;
		e) show_env=yes ;;
		d) run_gdb=yes ;;
		v) run_valgrind=yes;;
		s) run_strace=yes;;
		g) get_param=$OPTARG ;;
		h) show_help && exit 0 ;;
	esac
done
shift $((OPTIND-1))

method="POST"
prog="$1"
if [ -z "$prog" ]; then
	show_help && exit 0
fi
if [ -x "$prog" -a ${prog:0:1} != "/" -a ${prog:0:1} != "." ]; then
	prog="./$prog"
fi
if [ ! -x "$prog" ]; then
	echo "[$prog] is not a executable file"
fi

if [ -n "$get_param" ]; then
	method="GET"
elif [ -n "$2" ]; then
	param=$2
elif [ -z "$input_file" -o "$input_file" = "-" ] && [ -z "$chrome_input" ]; then
	param=$(cat)
elif [ -n "$chrome_input" ]; then
	param=
	for i in $(sed 's/:/=/' "$chrome_input"); do
		param="$param&$i"
	done
	param=${param:1}
elif [ -n "$input_file" ]; then
	if ! param=$(cat $input_file) ;then
		exit 1
	fi
else
	show_help && exit 1
fi
current_users="/tmp/current.users"

# prepare cgi env
export SERVER_ADDR=$(ifconfig | grep -m 1 inet\ addr | cut -d':' -f 2 | cut -d' ' -f 1)
export SERVER_PORT="5000"
export HTTP_USER_AGENT="Firefox"
export HTTP_HOST="$SERVER_ADDR:$SERVER_PORT"
export HTTP_ACCEPT_LANGUAGE="en-us,zh-tw;q=0.7,en;q=0.3"
export HTTP_ACCEPT_ENCODING="gzip,deflate"
export HTTP_ACCEPT_CHARSET="utf-8,Big5;q=0.7,*;q=0.7"
export HTTP_KEEP_ALIVE="300"
export HTTP_CONNECTION="keep-alive"
export HTTP_X_REQUESTED_WITH="XMLHttpRequest"
export CONTENT_TYPE="application/x-www-form-urlencoded; charset=UTF-8"
export HTTP_REFERER="http://$SERVER_ADDR:$SERVER_PORT/webman/index.cgi"
export HTTP_PRAGMA="no-cache"
export HTTP_CACHE_CONTROL="no-cache"
export PATH="/sbin:/bin:/usr/sbin:/usr/bin:/usr/syno/bin:/usr/syno/sbin:/usr/local/bin:/usr/local/sbin"
export SERVER_NAME="$SERVER_ADDR"
export REMOTE_ADDR="192.168.1.1"
export SERVER_ADMIN="admin"
export REQUEST_METHOD="$method"
export QUERY_STRING=$get_param
export CONTENT_LENGTH=$(printf "%s" "$param" | wc -c)
export HTTP_COOKIE=
export SCRIPT_NAME="/cgi/"

log "cgi: $prog, server ip: $SERVER_ADDR, login as: $login_user"

if [ $(basename "$prog") = "login.cgi" ]; then
	$prog << EOF > ${current_users}
$param
EOF
	exit $?
fi

if [ ! -d /initrd ]; then
	if [ -f $junior_config ]; then
		REMOTE_ADDR=$(grep -m 1 "^DEV_IP=" $junior_config | cut -d'=' -f1)
	fi
	log "junior remote ip: $REMOTE_ADDR"
elif grep -q ",$login_user," "$current_users"; then
	REMOTE_ADDR=$(grep -m 1 ",$login_user," "$current_users" | cut -d',' -f1)
	HTTP_COOKIE="id="$(grep -m 1 ",$login_user," "$current_users" | cut -d',' -f3)
	log "remote ip: $REMOTE_ADDR"
else
	cookie="CGIFEED$$"
	sys_uptime=`cat /proc/uptime  | cut -d '.' -f1`
	echo "${REMOTE_ADDR},${login_user},${cookie},${sys_uptime},${sys_uptime},1,0" >> ${current_users}
	HTTP_COOKIE="id=${cookie}"
	log "remote ip: $REMOTE_ADDR"
fi

if [ "$show_env" = "yes" ]; then
	env
elif [ "$run_gdb" = "yes" ]; then
	(
	local temp_input="/tmp/.cgifeed.$$.input"
	local temp_cmd="/tmp/.cgifeed.$$.cmd"

	echo "$param" > "$temp_input"
	cat <<EOF > "$temp_cmd"
set args < "$temp_input"
EOF
	PATH="$PATH:/root/bin"
	gdb $prog -x "$temp_cmd"
	rm "$temp_cmd" "$temp_input"
	)
elif [ "$run_valgrind" = "yes" ]; then
	(
	PATH="$PATH:/root/bin"
	valgrind --leak-check=yes $prog << EOF
$param
EOF
	)
elif [ "$run_valgrind" = "yes" ]; then
	/root/bin/strace $prog << EOF
$param
EOF
else
	$prog << EOF
$param
EOF
fi

