#!/bin/sh

#---------------------------- Definitions -------------------------------------
AXIS_DEVICE_PACK_CONF_PATH="/var/packages/SurveillanceStation/target/device_pack/camera_support/AXIS.conf"
AXIS_LEGACY_CONF_PATH="/var/packages/SurveillanceStation/target/conf/camera_support/AXIS.conf"
AXIS_P1347_5M_MODEL_NAME="P1347-5M"
AXIS_P1347_TXT_FILE_NAME="axis-p1347-5m.txt"

#---------------------------- Functions ---------------------------------------
main()
{
	if [[ -f ${AXIS_DEVICE_PACK_CONF_PATH} ]]; then
		conf_path="${AXIS_DEVICE_PACK_CONF_PATH}"
	elif [[ -f ${AXIS_LEGACY_CONF_PATH} ]]; then
		conf_path="${AXIS_LEGACY_CONF_PATH}"
	else
		echo "Conf file not found. Abort."
		exit 1
	fi

	if [[ -z $(cat "${conf_path}" | grep "${AXIS_P1347_5M_MODEL_NAME}") ]]; then
		echo "Conf ${AXIS_P1347_5M_MODEL_NAME} not found. Installing."
		cp "${conf_path}" "${conf_path}.bak"
		cat "$(dirname $0)/${AXIS_P1347_TXT_FILE_NAME}" >> "${conf_path}"
	fi
}

main "$@"
