#!/usr/bin/python

import time
import subprocess
import threading
import json
import os
import sys
import pexpect

CAM_STATUS_CONNECTED = 1
gblSignal = False

def AuthDsAndGetSid(ip, user, passwd):
    loginCmd = ('curl -s -c cookie{0}.txt '
    '"http://{1}:5000/webapi/auth.cgi?api=SYNO.API.Auth&method=login&version=3'
    '&account={2}'
    '&passwd={3}&format=sid"'
    .format(ip.replace('.', ''), ip, user, passwd))

    curlLogin = os.popen(loginCmd).read()

    if 0 > curlLogin.find('sid'):
        print "Authentication failed. Check ip, user and passwd on server [%s]" % ip
        return False, None
    else:
        jsonData = json.loads(curlLogin)
        return True, jsonData['data']['sid']

def GetTargetDsSid(config):
    user = config['targetDs']['username']
    passwd = config['targetDs']['password']
    ip = config['targetDs']['ip']

    return AuthDsAndGetSid(ip, user, passwd)

def DisableAndEnableCameras(ip, sid):
    res, camIds = GetCamIdListStr(ip, sid)

    if False == res:
        return False

    if 0 == len(camIds):
        return True

    stopCmd = ('curl -s -b cookie{0}.txt '
    '"http://{1}:5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera&method="Disable"&version=9'
    '&idList=%22{2}%22"'
    .format(ip.replace('.',''), ip, camIds))
    curlDisableCam = os.popen(stopCmd).read()
    jsonData = json.loads(curlDisableCam)

    if False == jsonData['success']:
        return False

    startCmd = ('curl -s -b cookie{0}.txt '
    '"http://{1}:5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera&method="Enable"&version=9&idList=%22{2}%22"'
    .format(ip.replace('.',''), ip, camIds))
    curlEnableCam = os.popen(startCmd).read()
    jsonData = json.loads(curlEnableCam)

    return jsonData['success']

def IsAllCamConnected(ip, sid, namingPrefix):
    res, jsonData = GetCameraListOnDs(ip, sid)

    if False == res:
        return False

    fnMatch = lambda cam : (0 > cam['newName'].find(namingPrefix) or CAM_STATUS_CONNECTED == cam['status'])
    if True == all(fnMatch(camera) for camera in jsonData['data']['cameras']):
        return True
    else:
        return False

def WaitCamConnected(ip, sid, namingPrefix):
    waitCount = 0
    try:
        sys.stdout.write("Waiting")
        sys.stdout.flush()

        while True:
            ''' wait at most 30s disable and enable, and another 30s to break '''
            if 15 <= waitCount:
                print "Exceed 30s. Cameras CANNOT be connected!"
                break

            if True == IsAllCamConnected(ip, sid, namingPrefix):
                print ""
                return

            time.sleep(2)
            waitCount += 1
            sys.stdout.write(".")
            sys.stdout.flush()

    except KeyboardInterrupt:
        print "Waiting cameras failed."

def GetCameraListOnDs(ip, sid):
    listCmd = ('curl -s -b cookie{0}.txt '
    '"http://{1}:5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera&method=%22List%22&version=9'
    '&_sid={2}"'.format(ip.replace('.',''), ip, sid))

    curlCamList = os.popen(listCmd).read()
    jsonData = json.loads(curlCamList)

    return jsonData['success'], jsonData

def GetCamIdListStr(ip, sid):
    camIds = ""
    res, jsonData = GetCameraListOnDs(ip, sid)

    if False == res:
        print jsonData
        return False, camIds

    for camera in jsonData['data']['cameras']:
        camId = camera['id']
        camIds += str(camId) + ","

    return True, camIds[:len(camIds) - 1]

def WaitCamConnectedOnTargetDs(config, sid, namingPrefix):
    ip = config['targetDs']['ip']
    print "Wait for every camera on target DS to be connected ..."

    WaitCamConnected(ip, sid, namingPrefix)

def ClearAllCameraOnDs(ip, sid):
    res, camIds = GetCamIdListStr(ip, sid)

    if False == res:
        return False

    if 0 == len(camIds):
        return True

    delCmd = ('curl -s -b cookie{0}.txt '
    '"http://{1}:5000/webapi/entry.cgi?api=SYNO.SurveillanceStation.Camera&method="Delete"&version=9'
    '&idList=%22{2}%22'
    '&_sid=%22{3}%22"'.format(ip.replace('.', ''), ip, camIds, sid))

    curlDelCam = os.popen(delCmd).read()
    jsonData = json.loads(curlDelCam)

    if True != jsonData['success']:
        print curlDelCam

    return True

def ClearAllCameraOnTargetDs(config, sid):
    targetDsIp = config['targetDs']['ip']
    print "Clear cameras on target ds ..."

    return ClearAllCameraOnDs(targetDsIp, sid)

def SSHLoginToSUAndRunScript(child, scriptCmd, username, password, expectRunning):
    sent = False

    while True:
        res = child.expect(["continue connecting", "password: ", "Password: ",  username + "@.*\$", "root@.*#",
                            "Permission denied", "Connection reset by peer", pexpect.TIMEOUT, pexpect.EOF])
        if 0 == res:
            child.send("yes\n")
        elif 1 == res:
            child.send(password + '\n')
        elif 2 == res:
            child.send(password + '\n')
        elif 3 == res:
            child.send("sudo -i\n")
        elif 4 == res:
            if True == sent:
                break
            child.send(scriptCmd + '\n')
            sent = True
            if True == expectRunning:
                break
        elif 5 == res:
            print "[wrong password]"
            exit(1)
        elif 6 == res:
            print "[connection reset]"
            exit(1)
        elif 7 == res:
            print "[time out]"
            exit(1)
        else:
            break

def EnableTargetDsSSHRootLogin(config):
    user = config['targetDs']['username']
    passwd = config['targetDs']['password']
    ip = config['targetDs']['ip']

    print "Enable target ds dirct ssh via ip ..."
    EnableSSHRootLogin(ip, user, passwd)

def EnableSSHRootLogin(ip, username, password):
    sshCmd = "ssh {0}@{1}".format(username, ip)

    child = pexpect.spawn(sshCmd, timeout = None)
    scriptCmd = "cp /etc/pam.d/login /etc/pam.d/sshd"
    SSHLoginToSUAndRunScript(child, scriptCmd, username, password, False)
    child.close(force = True)

    child = pexpect.spawn(sshCmd, timeout = None)
    scriptCmd = "cp /etc.defaults/pam.d/login /etc.defaults/pam.d/sshd"
    SSHLoginToSUAndRunScript(child, scriptCmd, username, password, False)
    child.close(force = True)

def EnableViewerSSHRootLogin(config):
    print "Enable viewers direct ssh via ip ..."

    for viewer in config['viewerDs']['data']:
        EnableSSHRootLogin(viewer['ip'], viewer['username'], viewer['password'])

def EditMaxCameraConf(config):
    user = config['targetDs']['username']
    password = config['targetDs']['password']
    ip = config['targetDs']['ip']
    sshCmd = "ssh {0}@{1}".format(user, ip)
    scriptCmd = "sed -i -r 's/surveillance_camera_max=\"[0-9]*\"/surveillance_camera_max=\"999\"/' /etc/synoinfo.conf /etc.defaults/synoinfo.conf"

    print "Edit max camera configuration on target ds ..."
    child = pexpect.spawn(sshCmd, timeout = None)
    SSHLoginToSUAndRunScript(child, scriptCmd, "", password, False)
    child.close(force = True)

def ShowAndWaitCommand(cmd):
    print "========== %s ===========" % cmd

    child = pexpect.spawn(cmd, logfile = sys.stdout, timeout = None)
    child.read()
    child.close(force = True)

    return 0 == child.exitstatus

def ScpExpectRoutine(child, password, closeChild = True):
    success = True

    while True:
        res = child.expect(['continue connecting', 'Password: ', 'password: ', 'Permission denied', 'Is a directory', pexpect.EOF, 'root@.*#'])

        if 0 == res:
            child.send('yes\n')
        elif 1 == res or 2 == res:
            child.send(password + '\n')
        elif 3 == res:
            print "[wrong password]"
            success = False
        elif 4 == res:
            print "[scp directory does not exist] Please check path settings in conf.json"
            success = False
        else:
            break

    if True == closeChild:
        child.close(force = True)

    return success

def RunLiveviewSimOnViewerDs(config, streamNum):
    offset = 0
    totalStream = streamNum
    childProcess = []
    targetDsIp = config['targetDs']['ip']
    viewerDsNum = len(config['viewerDs']['data'])
    liveviewSimFileName = config['liveviewSimFileName']
    ratio = GetRatio(config['viewerDs']['ratio'], viewerDsNum)
    streamNumPerRatio = GetNumberPerUnit(streamNum, sum(ratio))

    streamNumEachServer = [(num * streamNumPerRatio) for num in ratio]

    for viewerIdx in xrange(0, viewerDsNum):
        user = config['viewerDs']['data'][viewerIdx]['username']
        password = config['viewerDs']['data'][viewerIdx]['password']
        ip = config['viewerDs']['data'][viewerIdx]['ip']
        path = config['viewerDs']['data'][viewerIdx]['path']

        if (offset + streamNumEachServer[viewerIdx] <= streamNum):
            streamOnViewer = streamNumEachServer[viewerIdx]
        else:
            streamOnViewer = streamNum - offset

        sshCmd = "ssh {0}@{1}".format(user, ip)
        scriptCmd = "{0}/{1} -u ss-viewer -p 111111 -o {2} -l {3} {4}".format(path, liveviewSimFileName, str(offset), str(streamOnViewer), targetDsIp)

        if (0 < streamOnViewer):
            print scriptCmd
            offset += streamOnViewer
            child = pexpect.spawn(sshCmd, timeout = None)
            SSHLoginToSUAndRunScript(child, scriptCmd, "", password, True)
            childProcess.append(child)

    return childProcess

def RunMonitorTool(config):
    targetDsIp = config['targetDs']['ip']
    targetDsUser = config['targetDs']['username']
    targetDsPassword = config['targetDs']['password']
    targetDsMonitorPath = config['targetDs']['path']
    monitorDirName = config['localHost']['monitorDirName']
    monitorFileName = config['monitorFileName']

    sshCmd = "ssh {0}@{1}".format(targetDsUser, targetDsIp)
    scriptCmd = "{0}/{1}/{2} -c -1".format(targetDsMonitorPath, monitorDirName, monitorFileName)
    child = pexpect.spawn(sshCmd, timeout = None)
    SSHLoginToSUAndRunScript(child, scriptCmd, "", targetDsPassword, True)

    return child

def StartMonitoring(config, logName):
    targetDsUser = config['targetDs']['username']
    targetDsPassword = config['targetDs']['password']
    targetDsIp = config['targetDs']['ip']
    monitorStartAfterHr = config['monitorParams']['monitorStartAfterHr']
    monitorPeriodHr = config['monitorParams']['monitorPeriodHr']
    monitorCheckFreqHr = config['monitorParams']['monitorCheckFreqHr']
    acceptRatio = config['monitorParams']['acceptRatio']
    localHostUser = config['localHost']['username']
    monitorStartTime = float(monitorStartAfterHr) * 3600.0
    monitorCheckFreq = float(monitorCheckFreqHr) * 3600.0
    monitorPeriod = float(monitorPeriodHr) * 3600.0
    successRun = 0
    testRun = 0
    checkFreqCount = 0
    startTime = time.time()
    resFound = False
    monitorRes = False
    global gblSignal

    child = RunMonitorTool(config)

    print "Start monitoring ..."

    try:
        while True:
            res = child.expect(["===================================", pexpect.EOF])
            if 0 != res:
                "Monitor stops unexpectedly."
                break

            currentTime = time.time()
            if currentTime - startTime <= monitorStartTime:
                continue

            testRun += 1
            testRes, condValList = PassTestingCondition(config, child.before)
            if True == testRes:
                successRun += 1

            timeMonitored = currentTime - startTime - monitorStartTime

            resFound, monitorRes = MonitorFinalCheck(timeMonitored, monitorPeriod, successRun, testRun, acceptRatio)
            if True == resFound:
                break

            resFound, monitorRes = MonitorFreqCheck(timeMonitored, checkFreqCount, monitorCheckFreq, successRun, testRun, acceptRatio)
            if False == resFound:
                continue

            checkFreqCount += 1
            if False == monitorRes:
                break

        child.sendcontrol('c')
        child.close(force = True)

        if True == resFound:
            scpCmd = 'scp {0}@{1}:/var/log/nvr_performance.log /home/{2}/{3}'.format(targetDsUser, targetDsIp, localHostUser, logName)
            child = pexpect.spawn(scpCmd, logfile = sys.stdout, timeout = None)
            ScpExpectRoutine(child, targetDsPassword)
            return monitorRes, condValList
        else:
            return False, None

    except KeyboardInterrupt:
        print "Ctrl-C received, kill SS80."
        gblSignal = True
        child.sendcontrol('c')
        child.close(force = True)
        return False, None

def MonitorCheck(timePassed, timeRequired, successRun, testRun, acceptRatio):
    if timePassed > timeRequired:
        return True, IsRatioAccept(successRun, testRun, acceptRatio)

    return False, False

def MonitorFinalCheck(timePassed, timeRequired, successRun, testRun, acceptRatio):
    resFound, monitorRes = MonitorCheck(timePassed, timeRequired, successRun, testRun, acceptRatio)

    if True == resFound:
        if True == monitorRes:
            print "Monitor final check succeeds."
        else:
            print "Monitor final check fails."

    return resFound, monitorRes

def MonitorFreqCheck(timePassed, checkFreqCount, monitorCheckFreq, successRun, testRun, acceptRatio):
    resFound, monitorRes = MonitorCheck(timePassed, (checkFreqCount + 1) * monitorCheckFreq, successRun, testRun, acceptRatio)

    if True == resFound:
        if True == monitorRes:
            print "FreqCheck succeeds with elapsed time %s" % str((checkFreqCount + 1) * monitorCheckFreq)
        else:
            print "FreqCheck fails with elapsed time %s" % str((checkFreqCount + 1) * monitorCheckFreq)

    return resFound, monitorRes

def GetSignalStatus():
    global gblSignal
    return gblSignal

def IsRatioAccept(successRun, runCount, acceptRatio):
    return ((float(successRun) / float(runCount)) * 100.0) >= acceptRatio

def PassTestingCondition(config, data):
    dataSplit = data.split('\n')
    condValList = []
    res = True

    for conditionItem in config['testingCondition']['data']:
        checked = False
        condition = conditionItem['condition']
        passValue = conditionItem['value']

        for line in dataSplit:
            if condition not in line:
                continue

            line = line[line.find(condition) + len(condition):]
            lineSplit = line.split()

            if 'RecordingFPS:' == condition or 'LiveviewFPS:' == condition:
                percent = lineSplit[3]
                percent = percent[1:len(percent)-2]
                testValue = float(percent)

                if testValue < passValue:
                    print condition + " " + str(testValue)
                    res =  False

                checked = True
                condValList.append(testValue)

            else:
                if True == lineSplit[0].replace('.', '').isdigit():
                    testValue = float(lineSplit[0])

                    if testValue > passValue:
                        print condition + " " + str(testValue)
                        res = False

                    checked = True
                    condValList.append(testValue)
                else:
                    continue
            break

        if False == checked:
            print "Condition not exists for condition [%s]" % condition

    return res, condValList

def Simulation(config, streamNum, logName):
    childProcess = []
    monitorResult = False

    print "Run liveviewsim.py on remote ds ..."
    childProcess = RunLiveviewSimOnViewerDs(config, streamNum)

    print "======== Simulation with %s streams ========" % str(streamNum)
    monitorResult, condValList = StartMonitoring(config, logName)

    print "Close the liveviewsim scripts ..."
    for child in childProcess:
        child.close(force = True)

    return monitorResult, condValList

def AddAccountAndScpFile(config):
    print "Copy monitor directory to target ds ..."

    if False == ScpMonitorDir(config):
        print "Copy monitor directory failed."
        return False

    print "Add ss-viewer to target DS ..."
    AddSSViewerToTargetDs(config)

    print "Copy liveviewsim.py to remote ds ..."

    if False == ScpLiveviewSimFile(config):
        print "Copy liveviewsim.py failed."
        return False

    return True

def ScpMonitorDir(config):
    monitorDirPath = config['localHost']['monitorDirPath']
    monitorDirName = config['localHost']['monitorDirName']
    password = config['targetDs']['password']
    ip = config['targetDs']['ip']
    path = config['targetDs']['path']

    print "Copy monitor file to target ds to %s" % ip
    scpCmd = 'scp -r {0}/{1} {2}:{3}'.format(monitorDirPath, monitorDirName, ip, path)
    child = pexpect.spawn(scpCmd, timeout = None, logfile = sys.stdout)

    return ScpExpectRoutine(child, password)

def ScpLiveviewSimFile(config):
    liveviewSimFilePath = config['localHost']['liveviewSimFilePath']
    liveviewSimFileName = config['liveviewSimFileName']

    for viewer in config['viewerDs']['data']:
        user = viewer['username']
        password = viewer['password']
        ip = viewer['ip']
        path = viewer['path']
        print "Copy liveviewsim.py to server %s " % ip

        scpCmd = 'scp {0}/{1} {2}@{3}:{4}/'.format(liveviewSimFilePath, liveviewSimFileName, user, ip, path)
        child = pexpect.spawn(scpCmd, logfile = sys.stdout, timeout = None)

        if False == ScpExpectRoutine(child, password):
            return False

    return True

def RunScpRtspVideoDirCommand():
    scriptCmd = "python addRtspCam.py -s 1"
    return ShowAndWaitCommand(scriptCmd)

def GetRatio(strRatio, serverNum):
    ratioNums = list()

    strRatioSplit = strRatio.split(':')
    ratioNums = [int(elem) for elem in strRatioSplit]

    while (serverNum > len(ratioNums)):
            ratioNums.append(1)

    while (serverNum < len(ratioNums)):
            ratioNums.pop()

    return ratioNums

def GetNumberPerUnit(total, unitCount):
    if 0 == total % unitCount :
        return total / unitCount
    else:
        return (total / unitCount) + 1

def AddSSViewerToTargetDs(config):
    targetDsIp = config['targetDs']['ip']
    targetDsUser = config['targetDs']['username']
    targetDsPassword = config['targetDs']['password']
    targetDsMonitorPath = config['targetDs']['path']
    monitorDirName = config['localHost']['monitorDirName']

    sshCmd = "ssh {0}@{1}".format(targetDsUser, targetDsIp)
    scriptCmd = "{0}/{1}/utils.sh -a".format(targetDsMonitorPath, monitorDirName)
    child = pexpect.spawn(sshCmd, timeout = None)
    SSHLoginToSUAndRunScript(child, scriptCmd, "", targetDsPassword, False)
    child.close(force = True)
