CREATE TABLE IF NOT EXISTS transactionslog (
	pos_id			integer DEFAULT 0,
	transaction_id	integer DEFAULT 0,
	status			integer DEFAULT 0,
	begin_tmstmp	integer DEFAULT 0,
	end_tmstmp		integer DEFAULT 0,
	lock			boolean DEFAULT '0',
	posevent_ids	text DEFAULT '',
	PRIMARY KEY (pos_id, transaction_id)
);
CREATE INDEX IF NOT EXISTS transactionslog_timestamp ON transactionslog (begin_tmstmp, end_tmstmp, pos_id);
CREATE INDEX IF NOT EXISTS transactionslog_begin_timestamp ON transactionslog (begin_tmstmp, pos_id);
CREATE INDEX IF NOT EXISTS transactionslog_end_timestamp ON transactionslog (end_tmstmp, pos_id);

CREATE TABLE IF NOT EXISTS transactionscontent (
	pos_id			integer DEFAULT 0,
	transaction_id	integer DEFAULT 0,
	line_id			integer DEFAULT 0,
	tmstmp			integer DEFAULT 0,
	content			text DEFAULT '',
	linebreak		text DEFAULT '',
	PRIMARY KEY (pos_id, transaction_id, line_id)
);

CREATE TABLE IF NOT EXISTS posmaxtransactionid (
	pos_id				integer PRIMARY KEY,
	max_transaction_id	integer DEFAULT 0
);
