/* Copyright (c) 2019 Synology Inc. All rights reserved. */

Ext.define("SYNO.SS.App.ActionRule.History",{extend:"SYNO.ux.Panel",bInited:false,parentWin:null,dsHistory:null,btnClear:null,btnDownload:null,cmbServer:null,grid:null,constructor:function(a){this.parentWin=a;this.Init();this.callParent([{title:_T("action_rule","rule_history"),tbar:[this.btnClear,this.btnDownload],layout:"fit",items:this.panelGridContainer}])},Init:function(){if(true===this.bInited){return}this.dsHistory=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.ActionRule",method:"ListHistory",version:1,baseParams:{start:0,limit:SYNO.SS.Pgls.MIN_PAGE_RECORDS},root:"history",totalProperty:"total",fields:[{name:"id"},{name:"level"},{name:"ruleName"},{name:"ruleType"},{name:"actResult"},{name:"time"}],listeners:{beforeload:function(b,c){this.parentWin.setStatusBusy()},loadexception:function(){this.getMsgBox().alert(_T("action_rule","action_rule"),_T("ss_common","error_system"));this.parentWin.clearStatusBusy()},load:function(c,b,e){var d=(0>=b.length);this.btnClear.setDisabled(d);this.btnDownload.setDisabled(d);this.parentWin.clearStatusBusy()},scope:this}});this.btnClear=new SYNO.ux.Button({text:_T("ss_log","log_clear"),handler:this.OnClear,scope:this});this.btnDownload=new SYNO.ux.Button({text:_T("event","event_export"),handler:this.OnDownload,scope:this});this.cmbServer=new SYNO.SS.Form.ServerComboBox({value:LOCAL_DS_ID,valueField:"id",displayField:"name",listeners:{beforeselect:this.parentWin.BeforeServerSelect,scope:this.parentWin}});var a=new Ext.grid.ColumnModel([{header:_T("ss_log","log_type"),align:"center",width:65,fixed:true,sortable:false,dataIndex:"level",renderer:this.RenderType.createDelegate(this)},{header:_T("ss_log","log_time"),align:"center",width:175,fixed:true,sortable:false,dataIndex:"time",renderer:this.RenderTime.createDelegate(this)},{header:_T("action_rule","rule_name"),align:"center",width:250,sortable:false,dataIndex:"ruleName"},{header:_T("action_rule","rule_type_capitalization"),align:"center",width:140,sortable:false,dataIndex:"ruleType",renderer:this.RenderRuleType.createDelegate(this)},{header:_T("action_rule","action_result"),align:"center",width:140,sortable:false,dataIndex:"actResult",renderer:this.RenderActResult.createDelegate(this)}]);this.grid=new SYNO.SS.Grid.GridPanel({cls:"grid_row_height_fixed",store:this.dsHistory,border:false,cm:a,viewConfig:{forceFit:true},plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsPlugin",store:this.dsHistory})});this.panelGridContainer=new SYNO.SS.Pgls.PglsGridContainerPanel({grid:this.grid,store:this.dsHistory,emptyStyleMonStore:this.dsHistory,emptyStyleTip:_T("action_rule","no_history"),emptyStyleTipFunc:this.LaunchList.createDelegate(this),refreshFunction:this.OnRefresh,refreshFunctionScope:this});this.bInited=true},Activate:function(){this.OnRefresh()},OnRefresh:function(){this.dsHistory.load()},OnClear:function(){this.parentWin.getMsgBox().confirm(_T("action_rule","action_rule"),_T("action_rule","history_clear_warning"),function(a){if("yes"===a){this.parentWin.SendWebAPI(1,"DeleteHistory",{idList:-1},this.parentWin.OnRefreshHistory)}},this)},OnDownload:function(){this.parentWin.downloadWebAPI({webapi:{api:"SYNO.SurveillanceStation.ActionRule",version:1,method:"DownloadHistory"},redirectType:SYNO.SS.RedirectType.DOWNLOAD,filename:"surActHistory.html",scope:this})},LaunchList:function(){this.parentWin.tabPanel.setActiveTab(SYNO.SS.App.ActionRule.Def.TabIndex.LIST)},RenderType:function(d,e,a){var b;var c="<div align='center' style='padding-top:2px'><span class='{0} log_grid_icon_extra' ext:qtip='{1}'></span></div>";switch(d){case SYNO.SS.Log.LOG_INFO:b=String.format(c,"log_info",SYNO.SS.Log.LOG_STR_INFO);break;case SYNO.SS.Log.LOG_WARNING:b=String.format(c,"log_warning",SYNO.SS.Log.LOG_STR_WARNING);break;case SYNO.SS.Log.LOG_ERROR:b=String.format(c,"log_error",SYNO.SS.Log.LOG_STR_ERROR);break;default:b="";break}return b},RenderTime:function(b,c,a){return SYNO.SS.Grid.GenDateAndTimeStrOnly(b,{})},RenderRuleType:function(b,c,a){var d;if(SYNO.SS.App.ActionRule.Def.RuleType.TRIGGERED===b){d=_T("action_rule","triggered")}else{if(SYNO.SS.App.ActionRule.Def.RuleType.SCHEDULED===b){d=_T("action_rule","scheduled")}}return d},RenderActResult:function(b,c,a){var d;switch(b){case SYNO.SS.App.ActionRule.Def.ActResult.IDLE:d=_T("edge_storage","task_finished");break;case SYNO.SS.App.ActionRule.Def.ActResult.RUNNING:d=_T("joystick","opt_start");break;case SYNO.SS.App.ActionRule.Def.ActResult.FAILED:d=_T("edge_storage","task_failed");break;case SYNO.SS.App.ActionRule.Def.ActResult.INTRPT:d=_T("action_rule","act_result_interrupted");break;case SYNO.SS.App.ActionRule.Def.ActResult.IGNORE:d=_T("action_rule","act_result_ignored");break;case SYNO.SS.App.ActionRule.Def.ActResult.CONTINUE:d=_T("smartsearch","continue_search");break;default:d=_T("edge_storage","task_finished");break}return d}});Ext.define("SYNO.SS.App.ActionRule.Advanced",{extend:"SYNO.SDS.Utils.FormPanel",fsRotate:null,btnSave:null,btnClose:null,constructor:function(){this.Init();this.callParent([{disabled:(SYNO.SS.UserPrivType.ADMIN!==_S("USER_PRIVILEGE")),cls:"management_panel",title:_T("ss_common","advanced"),border:false,trackResetOnLoad:true,items:this.fsRotate,buttons:[this.btnSave,this.btnClose],listeners:{activate:this.Activate,deactivate:this.Deactivate,afterrender:this.OnAfterRender,scope:this}}])},Init:function(){var a=_T("action_rule","history_log_rotate");this.fsRotate=SYNO.SS.LogArchive.CreateRuleFieldSet(a);this.btnSave=new SYNO.ux.Button({btnStyle:"blue",text:_T("ss_common","common_save"),handler:this.OnSave,scope:this});this.btnClose=new SYNO.ux.Button({text:_T("ss_common","close"),handler:this.OnClose,scope:this})},Activate:function(){this.LoadSettings()},Deactivate:function(){this.getForm().reset()},OnAfterRender:function(){var a=this.findAppWindow();this.mon(a,"beforeclose",this.OnBeforeClose,this);this.mon(a.tabPanel,"beforetabchange",this.OnBeforeTabChange,this);this.LoadSettings()},LoadSettings:function(){this.WebAPIRequest({},"LoadAdvanced",3,this.OnLoadDone)},OnLoadDone:function(a,b,c){if(b){this.SetFormValues(b.log_archive_cfg)}},OnSave:function(){if(false===this.getForm().isValid()){this.setStatusError({text:_T("ss_common","forminvalid"),clear:true});return}if(false===this.IsFormDirty()){this.setStatusError({text:_T("ss_common","setting_nochange"),clear:true});return}var a={log_archive_cfg:this.getForm().getAllFieldValues()};this.WebAPIRequest(a,"SaveAdvanced",3,this.OnSaveDone)},OnSaveDone:function(a,b,c){if(true===a){this.setStatusOK({text:_T("ss_common","setting_applied"),clear:true})}if(c&&c.log_archive_cfg){this.SetFormValues(c.log_archive_cfg)}},SetFormValues:function(a){if(false===Ext.isDefined(a)){return}this.getForm().setValues(a)},OnBeforeClose:function(a){if(true===this.blForceClose){this.blForceClose=false;return true}if(true===this.IsFormDirty()){SYNO.SS.Utils.ConfirmLostChange({title:this.title,msgBox:this.GetMsgBox(),fnYes:function(b){this.blForceClose=true;a.close()},scope:this});return false}return true},OnClose:function(){this.findAppWindow().close()},OnBeforeTabChange:function(b,c,a){if(true===this.blForceChgTab){this.blForceChgTab=false;return true}if(true===this.IsFormDirty()){SYNO.SS.Utils.ConfirmLostChange({title:this.title,msgBox:this.GetMsgBox(),fnYes:function(d){this.blForceChgTab=true;b.setActiveTab(c)},scope:this});return false}return true},GetMsgBox:function(){return this.findAppWindow().getMsgBox()},IsFormDirty:function(){return this.getForm().isDirty()},WebAPIRequest:function(b,d,a,c){this.setStatusBusy({text:_T("ss_common","common_saving")});this.sendWebAPI({api:"SYNO.SurveillanceStation.ActionRule",version:a,method:d,params:b,callback:function(e,g,h,f){this.OnWebAPIRequestDone(e,g,h,c)},scope:this})},OnWebAPIRequestDone:function(a,b,c,d){this.clearStatusBusy();if(true!==a){this.GetMsgBox().alert(_T("ss_common","service"),_T("ss_common","error_system"))}else{if(true===Ext.isFunction(d)){d.call(this,a,b,c)}}}});Ext.define("SYNO.SS.App.ActionRule.InfoPanel",{extend:"SYNO.ux.FormPanel",NAME_LENGTH_LIMIT:64,COMBOBOX_BTN_WIDTH:27,curId:null,oriRuleType:null,parent:null,fldName:null,cmbRuleType:null,cmbActType:null,constructor:function(a){this.parent=a.parentWin;this.Init();Ext.apply(a,{title:_T("action_rule","rule_info"),trackResetOnLoad:true,defaults:{width:400,labelStyle:"width: 180px"},items:[this.fldName,this.cmbRuleType,this.cmbActType]});this.callParent([a])},Init:function(){this.fldName=new SYNO.SS.Form.NameTextField({name:"name",fieldLabel:_T("ss_common","common_name"),maxLength:this.NAME_LENGTH_LIMIT,enableKeyEvents:true,validator:this.IsRuleNameValid.createDelegate(this)});this.cmbRuleType=new SYNO.ux.ComboBox({name:"ruleType",fieldLabel:_T("action_rule","rule_type"),valueField:"ruleTypeId",displayField:"ruleTypeText",mode:"local",value:SYNO.SS.App.ActionRule.Def.RuleType.TRIGGERED,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,store:new Ext.data.ArrayStore({fields:["ruleTypeId","ruleTypeText"],data:[[SYNO.SS.App.ActionRule.Def.RuleType.TRIGGERED,_T("action_rule","triggered")],[SYNO.SS.App.ActionRule.Def.RuleType.SCHEDULED,_T("action_rule","scheduled")]]}),listeners:{afterrender:function(){SYNO.SS.Utils.AddTip(this.cmbRuleType.getEl(),_T("action_rule","rule_type_hint"),this.COMBOBOX_BTN_WIDTH)},select:this.SelectRuleType,scope:this}});this.cmbActType=new SYNO.ux.ComboBox({name:"actType",fieldLabel:_T("action_rule","action_type"),valueField:"actTypeId",displayField:"actTypeText",mode:"local",value:SYNO.SS.App.ActionRule.Def.ActType.INTERRUPTED,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,store:new Ext.data.ArrayStore({fields:["actTypeId","actTypeText"],data:[[SYNO.SS.App.ActionRule.Def.ActType.INTERRUPTED,_T("action_rule","interrupted")],[SYNO.SS.App.ActionRule.Def.ActType.NON_INTERRUPTED,_T("action_rule","non_interrupted")]]}),listeners:{afterrender:function(){SYNO.SS.Utils.AddTip(this.cmbActType.getEl(),_T("action_rule","action_type_hint"),this.COMBOBOX_BTN_WIDTH)},scope:this}});this.oriRuleType=this.cmbRuleType.getValue()},SelectRuleType:function(c,a,b){var d=a.get("ruleTypeId");if(this.oriRuleType!==d){this.UpdateCmbActType(d);this.parent.UpdateUI(d);this.oriRuleType=d}},UpdateCmbActType:function(b){var a=SYNO.SS.App.ActionRule.Utils.IsScheduled(b);if(true===a){this.cmbActType.setValue(SYNO.SS.App.ActionRule.Def.ActType.INTERRUPTED)}this.cmbActType.setDisabled(a)},UpdateUI:function(a){this.oriRuleType=a.get("ruleType");this.UpdateCmbActType(a.get("ruleType"));this.curId=a.get("multiRuleId");this.fldName.clearInvalid()},IsRuleNameValid:function(a){return SYNO.SS.Utils.IsValidName({name:a,fnValidator:function(c){var e=this.parent.owner.dsActRule.data;var b,d;for(b=0;b<e.length;b++){d=e.items[b];if((d.get("multiRuleId")!==this.curId)&&(d.get("name")===c)){return _T("ss_common","common_name_repetition")}}return true},scope:this})},IsFormValid:function(){return this.getForm().isValid()},IsDirty:function(){return this.getForm().isDirty()},ClearDirty:function(){this.fldName.originalValue=this.fldName.getValue();this.cmbRuleType.originalValue=this.cmbRuleType.getValue();this.cmbActType.originalValue=this.cmbActType.getValue()},GetRuleType:function(){return this.cmbRuleType.getValue()}});Ext.define("SYNO.SS.App.ActionRule.EventPanel",{extend:"SYNO.ux.FormPanel",MAX_EVT_NUM:5,MIN_EVT_NUM:1,FIELD_WIDTH:200,MIN_INTVL_LIST:[[5],[10],[15],[20],[25],[30],[60],[90],[120],[180],[300]],fsSetting:null,btnAdd:null,btnDelete:null,cmbMultiEvtSetting:null,evtFsArray:null,parent:null,DEFINES:SYNO.SS.App.ActionRule.Def,constructor:function(a){this.evtFsArray=[];this.parent=a.parentWin;this.Init(a);Ext.apply(a,{title:_T("ss_notification","event"),tbar:[this.btnAdd,this.btnDelete],items:[this.fsSetting,this.evtFsArray],listeners:{beforedestroy:function(){this.evtFsArray.clear()},scope:this}});this.callParent([a])},Init:function(c){var d,a;var b=(c.evtNums)?c.evtNums:1;this.btnAdd=new SYNO.ux.Button({text:_T("ss_common","common_add"),handler:this.OnAdd,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.OnDelete,scope:this});this.dsMultiEvt=new Ext.data.ArrayStore({autoDestroy:true,fields:["itemId","itemText"],data:[[this.DEFINES.MultiEvtSetting.MULTI_EVT_AND,"AND"],[this.DEFINES.MultiEvtSetting.MULTI_EVT_OR,"OR"]]});this.cmbMultiEvtSetting=new SYNO.ux.ComboBox({fieldLabel:_T("action_rule","multi_evt_setting"),width:405,valueField:"itemId",displayField:"itemText",mode:"local",value:0,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,store:this.dsMultiEvt});this.cmbMinIntvl=new SYNO.ux.ComboBox({name:"evtMinIntvl",width:405,fieldLabel:_T("camera","camera_guard_interval")+" ("+_T("common","time_seconds")+")",valueField:"minIntvl",displayField:"minIntvl",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,hidden:false,value:10,store:new Ext.data.ArrayStore({fields:["minIntvl"],data:this.MIN_INTVL_LIST}),listeners:{afterrender:function(){SYNO.SS.Utils.AddTip(this.cmbMinIntvl.getEl(),_T("action_rule","min_intvl_tip"),27)},scope:this}});this.fsSetting=new SYNO.ux.FieldSet({title:_T("ss_common","setting"),collapsible:true,labelWidth:180,autoHeight:true,items:[this.cmbMultiEvtSetting,this.cmbMinIntvl]});for(d=0;d<b;d++){a=new SYNO.SS.App.ActionRule.EvtFieldSet({parentWin:this.parent,parent:this,blAdd:c.blAdd},d);this.evtFsArray.push(a)}this.ChgBtnStatus()},OnAdd:function(){var a=new SYNO.SS.App.ActionRule.EvtFieldSet({parentWin:this.parent,parent:this,blAdd:true},this.evtFsArray.length,this.parentWin.pageInfo.cmbRuleType.getValue());this.evtFsArray.push(a);this.add(a);this.doLayout();this.ChgBtnStatus()},OnDelete:function(){var a=new SYNO.SS.App.ActionRule.DeleteDialog(this.parent,this,true);a.show()},ChgBtnStatus:function(){this.btnAdd.setDisabled(this.MAX_EVT_NUM===this.evtFsArray.length);this.btnDelete.setDisabled(this.MIN_EVT_NUM===this.evtFsArray.length);this.cmbMultiEvtSetting.setDisabled(this.MIN_EVT_NUM===this.evtFsArray.length)},RefreshFsHeader:function(){Ext.each(this.evtFsArray,function(b,a){b.SetTitle(a)})},SetValues:function(a){this.cmbMinIntvl.setValue(a.evtMinIntvl);this.cmbMultiEvtSetting.setValue(a.multiEvtSetting);Ext.each(this.evtFsArray,function(c,b){c.SetValues(a.events[b])});this.ClearDirty()},GetValues:function(){var a=[];Ext.each(this.evtFsArray,function(b){a.push(b.GetValues())});return a},GetSettings:function(){var a=[];Ext.each(this.evtFsArray,function(b){a.push(b.GetSettings())});return a},MaskPage:function(a){Ext.each(this.evtFsArray,function(c,b){c.MaskPage(b)})},UpdateUI:function(a,b){Ext.each(this.evtFsArray,function(d,c){d.UpdateUI(a.get("events")[c],b)})},UpdateDefUI:function(a){Ext.each(this.evtFsArray,function(b){b.UpdateDefUI(a)})},UpdateUIByActionChange:function(){Ext.each(this.evtFsArray,function(a){a.UpdateSourceStore()})},IsFormValid:function(){if(this.DEFINES.RuleType.SCHEDULED===this.parent.pageInfo.cmbRuleType.getValue()){return true}var a=true;Ext.each(this.evtFsArray,function(b){if(false===b.IsFormValid()){a=false;return false}});return a},IsDirty:function(){if(this.DEFINES.RuleType.SCHEDULED===this.parent.pageInfo.cmbRuleType.getValue()){return false}if(this.evtNums!==this.evtFsArray.length){return true}if(this.cmbMultiEvtSetting.isDirty()||this.cmbMinIntvl.isDirty()){return true}var a=false;Ext.each(this.evtFsArray,function(b){if(true===b.IsDirty()){a=true;return false}});return a},ClearDirty:function(){this.evtNums=this.evtFsArray.length;this.cmbMultiEvtSetting.originalValue=this.cmbMultiEvtSetting.getValue();this.cmbMinIntvl.originalValue=this.cmbMinIntvl.getValue();Ext.each(this.evtFsArray,function(a){a.ClearDirty()})}});Ext.define("SYNO.SS.App.ActionRule.EvtFieldSet",{extend:"SYNO.ux.FieldSet",RULE_EVT:SYNO.SS.App.ActionRule.Def.RuleEvt,OPTION_ALL:SYNO.SS.App.ActionRule.Def.OPTION_ALL,INTERCOM_EVT_IDX:SYNO.SS.App.ActionRule.Def.IntercomEvtIdx,MIN_INTVL_LIST:[[5],[10],[15],[20],[25],[30],[60],[90],[120]],COMBOBOX_BTN_WIDTH:27,EVT_TRIG_TYPE_SINGLE:0,EVT_TRIG_TYPE_CYCLE:1,FIELD_WIDTH:400,LABEL_WIDTH:185,parent:null,oriServer:null,blResetDefault:false,evtStatus:null,cmbSource:null,cmbServer:null,cmbDevice:null,cmbEvent:null,cmbEventItem:null,cmbTrigType:null,btnExtUrl:null,panelCenter:null,panelExtTip:null,panelEventItem:null,labelEventItem:null,dsSource:null,dsCamera:null,dsIOModule:null,dsDoor:null,dsCtrller:null,dsAcsRule:null,dsPOS:null,dsIPSpeaker:null,dsDevice:null,dsEvent:null,dsEventItem:null,dsCamEvtArray:null,dsDoorEvtArray:null,dsCtrllerEvtArray:null,dsPOSEvtArray:null,dsIPSpeakerEvtArray:null,dsExtEvtArray:null,dsIOModuleEvtArray:null,dsSSEvtArray:null,diEventItemArray:[],appEventItemArray:[],intercomEvtItemArray:[],doorEvtItemArray:null,DEFINES:SYNO.SS.App.ActionRule.Def,constructor:function(a,b){this.parentWin=a.parentWin;this.parent=a.parent;this.actOrder=b;this.Init(a.formStyle);Ext.apply(a,{title:_T("ss_notification","event")+" "+(this.actOrder+1),collapsible:true,items:[this.cmbSource,this.cmbServer,this.cmbDevice,this.cmbEvent,{xtype:"syno_panel",width:this.FIELD_WIDTH+this.LABEL_WIDTH,items:this.panelEventItem},this.cmbTrigType,this.panelExtTip],listeners:{afterrender:function(c){if(true==a.blAdd){c.ReloadDeviceStore(true)}},activate:function(c){if((c.el)&&(true===c.el.hasClass("x-masked"))){c.el.mask(_T("action_rule","scheduled_no_event"),"syno-ux-style-mask-info")}},scope:this}});this.callParent([a])},Init:function(a){this.PrepareStore();this.cmbSource=new SYNO.ux.ComboBox({name:"evtSrc",fieldLabel:_T("action_rule","event_source"),valueField:"srcId",displayField:"srcText",width:this.FIELD_WIDTH,mode:"local",value:this.DEFINES.Source.CAMERA,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,lastQuery:"",store:this.dsSource,listeners:{select:function(d,b,c){this.cmbDevice.setVisible(true===this.IsDeviceShow());this.cmbDevice.setDisabled(false===this.IsDeviceShow());this.cmbServer.setVisible(true===this.IsServerShow());this.cmbServer.setDisabled(false===this.IsServerShow());this.UpdateEvtItemStore();this.UpdateDeviceStore(true);this.UpdExtBtnVisibility();this.parent.updateFleXcroll();SYNO.SS.App.ActionRule.Utils.UpdateByEventChange(this.parentWin)},scope:this}});this.cmbServer=new SYNO.ux.ComboBox({name:"evtDsId",fieldLabel:_T("ss_common","surveillance_server"),valueField:"id",displayField:"name",width:this.FIELD_WIDTH,mode:"local",editable:false,forceSelection:true,triggerAction:"all",value:LOCAL_DS_ID,allowBlank:false,valueNotFoundText:"",hidden:(false===this.IsServerShow()),store:SYNO.SS.GblStore.GetSlaveDSStoreCopy(null,{blEnabledOnly:false}),listeners:{select:function(d,b,c){if(d.getValue()!==this.oriServer){this.ReloadDeviceStore(true);this.oriServer=d.getValue()}},scope:this}});this.cmbDevice=new SYNO.ux.ComboBox({name:"evtDevId",fieldLabel:_T("menu","menu_device"),valueField:"id",displayField:"name",width:this.FIELD_WIDTH,mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,emptyText:_T("action_rule","no_avaliable_device"),store:this.dsDevice,listeners:{select:function(f,b,c,d){var e=(undefined!==d)?d:true;this.UpdateEvtStore(e);this.UpdateDefUI(this.cmbEvent.getValue(),e)},scope:this}});this.cmbEvent=new SYNO.ux.ComboBox({name:"evtId",fieldLabel:_T("ss_notification","event"),valueField:"evtId",displayField:"evtText",width:this.FIELD_WIDTH,mode:"local",triggerAction:"all",lastQuery:"",forceSelection:true,allowBlank:false,editable:false,value:this.RULE_EVT.CAM_MD,store:this.dsEvent,listeners:{select:function(d,b,c){this.UpdateDefUI(b.get("evtId"),true);this.UpdTipMsg(b.get("evtId"));this.parent.updateFleXcroll()},afterrender:function(){SYNO.SS.Utils.AddTip(this.cmbEvent.getEl(),String.format("<div>*{0}</div>",_T("action_rule","la_event_src_tip")),this.COMBOBOX_BTN_WIDTH);this.UpdTipMsg(this.RULE_EVT.CAM_MD)},scope:this}});this.labelEventItem=new Ext.form.Label({text:_T("recording","digital_input_mode")+_T("ss_common","common_colon"),style:"line-height: 28px; font-size: 12px;",width:this.LABEL_WIDTH});this.cmbEventItem=new SYNO.ux.ComboBox({name:"evtItem",width:this.FIELD_WIDTH,valueField:"itemId",displayField:"itemText",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,value:this.OPTION_ALL,store:this.dsEventItem,valueNotFoundText:"",listeners:{select:function(d,b,c){SYNO.SS.App.ActionRule.Utils.UpdateScheData(this.parentWin,true)},scope:this}});this.panelEventItem=new SYNO.ux.Panel({style:"margin-bottom: 5px",layout:"column",hidden:true,items:[this.labelEventItem,{xtype:"syno_panel",width:this.FIELD_WIDTH,items:this.cmbEventItem}],listeners:{show:function(b){this.cmbEventItem.setDisabled(false)},hide:function(b){this.cmbEventItem.setDisabled(true)},scope:this}});this.cmbMinIntvl=new SYNO.ux.ComboBox({name:"evtMinIntvl",fieldLabel:_T("camera","camera_guard_interval")+" ("+_T("common","time_seconds")+")",valueField:"minIntvl",displayField:"minIntvl",mode:"local",triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,hidden:false,value:10,store:new Ext.data.ArrayStore({fields:["minIntvl"],data:this.MIN_INTVL_LIST})});this.btnExtUrl=new SYNO.ux.Button({text:_T("ss_common","get_command"),listeners:{afterrender:function(){SYNO.SS.Utils.AddTip(this.btnExtUrl.getEl(),_T("ss_common","tip_third_party_this_command"))},click:this.OnOpenExtUrlWindow,scope:this}});this.panelExtTip=new SYNO.ux.Panel({style:"margin-left:185px",hidden:true,items:this.btnExtUrl});this.cmbTrigType=new SYNO.ux.ComboBox({name:"trigType",fieldLabel:_T("action_rule","event_trigger_type"),valueField:"triggerType",displayField:"triggerText",width:this.FIELD_WIDTH,mode:"local",value:this.EVT_TRIG_TYPE_SINGLE,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,store:new Ext.data.ArrayStore({fields:["triggerType","triggerText"],data:[[this.EVT_TRIG_TYPE_SINGLE,_T("action_rule","event_single_trigger")],[this.EVT_TRIG_TYPE_CYCLE,_T("action_rule","event_cycle_trigger")]]})})},OnOpenExtUrlWindow:function(c,d,b){var a=new SYNO.SS.Window.ExtDeviceUrlWindow({eventId:this.cmbEvent.getValue(),parent:this.parentWin,dest:SYNO.SS.GblStore.GetDsDest(this.GetDsId())});a.show()},UpdateUI:function(a,c){if(!a){return}this.evt=a;if(true===c){var b=SYNO.SS.App.ActionRule.Utils.IsServerAvail(a.evtDsId,this,true);this.ReloadDeviceStore(false===b)}this.cmbDevice.setVisible(true===this.IsDeviceShow());this.blResetDefault=(0!=SYNO.SS.Utils.IsFlags(this.DEFINES.Status.EVT_SRC_INVALID,a.evtStatus));this.UpdTipMsg(this.cmbEvent.getValue());this.SetTitle()},PrepareStore:function(){var c;var a=[{name:"id",type:"int"},{name:"name"}];var d=[[this.DEFINES.Source.CAMERA,_T("ss_common","common_camera")],[this.DEFINES.Source.IOMODULE,_T("ss_common","common_iomodule")],[this.DEFINES.Source.IPSPEAKER,_T("ip_speaker","ip_speaker_speaker")],[this.DEFINES.Source.EXT_DEVICE,_T("ss_common","external_device")],[this.DEFINES.Source.CONTROLLER,_T("action_rule","access_controller")],[this.DEFINES.Source.DOOR,_T("axis_access_controller","door")],[this.DEFINES.Source.POS,_T("transactions","transactions_device")],[this.DEFINES.Source.WEBCLIENT,_T("ss_common","surveillance_station")]];var e=SYNO.SS.App.ActionRule.Def.GetFilteredSource(d);this.dsSource=new Ext.data.ArrayStore({fields:["srcId","srcText"],data:e});this.dsCamera=new Ext.data.JsonStore({autoDestroy:true,root:"cameras",fields:SYNO.SS.GblStore.fieldCamera});this.dsIOModule=new Ext.data.JsonStore({autoDestroy:true,root:"modules",fields:SYNO.SS.GblStore.fieldIOModule});this.dsDoor=new Ext.data.JsonStore({autoDestroy:true,fields:a});this.dsCtrller=new Ext.data.JsonStore({autoDestroy:true,root:"data",totalProperty:"total",fields:a});this.dsAcsRule=new Ext.data.JsonStore({autoDestroy:true,root:"data",fields:a});this.dsPOS=new Ext.data.JsonStore({autoDestroy:true,root:"data",fields:["id","name"]});this.dsIPSpeaker=new Ext.data.JsonStore({autoDestroy:true,root:"ipSpeakers",fields:SYNO.SS.GblStore.fieldIPSpeaker});this.dsDevice=new Ext.data.ArrayStore({autoDestroy:true,fields:["id","name"],data:[]});this.dsEvent=new Ext.data.ArrayStore({autoDestroy:true,fields:["evtId","evtText"],data:[]});this.dsCamEvtArray=[[this.RULE_EVT.CAM_MD,_T("ss_filter","motion_detected")],[this.RULE_EVT.DEV_APP_VMD,_T("ss_filter","acap_vmd_detected")],[this.RULE_EVT.DEV_DI,_T("action_rule","di_active")],[this.RULE_EVT.DEV_DI_INACTIVE,_T("action_rule","di_inactive")],[this.RULE_EVT.CAM_TAMPERING,_T("ss_filter","tampering_detected")],[this.RULE_EVT.DEV_AUDIO_DET,_T("ss_filter","audio_detected")],[this.RULE_EVT.CAM_PIR,_T("ss_filter","pir_detected")],[this.RULE_EVT.CAM_LA_EVT,_T("ss_filter","la_event_detected")],[this.RULE_EVT.DEV_APP,_T("ss_filter","acap_detected")],[this.RULE_EVT.DEV_LOST,_T("ss_filter","connection_lost")],[this.RULE_EVT.DEV_CONNECTED,_T("action_rule","connection_normal")],[this.RULE_EVT.DEV_ENABLED,_T("action_rule","cam_evt_enabled")],[this.RULE_EVT.DEV_DISABLED,_T("action_rule","cam_evt_disabled")],[this.RULE_EVT.INTERCOM_EVENT,_T("action_rule","intercom_event")]];if(true===IsIvaVisible()){this.dsCamEvtArray.push([this.RULE_EVT.IVA_EVENT_DETECTED,_T("video_analytics","event_detected")])}this.dsDoorEvtArray=[[this.RULE_EVT.DOOR_ACCESS_GRANTED,_T("action_rule","access_granted")],[this.RULE_EVT.DOOR_ACCESS_DENIED,_T("action_rule","access_denied")],[this.RULE_EVT.DOOR_ALARM,_T("ss_notification","door_alarm_detected")],[this.RULE_EVT.DOOR_TAMPERING,_T("ss_filter","tampering_detected")]];this.dsCtrllerEvtArray=[[this.RULE_EVT.CONTROLLER_ALARM,_T("ss_notification","controller_alarm_logged")],[this.RULE_EVT.CONTROLLER_CASING_OPEN,_T("action_rule","casing_open")]];var b=_T("camera","camera_model_u_define");this.dsPOSEvtArray=[[this.RULE_EVT.POS_NEW_TRANSACTION,_T("transactions","new_transaction")],[this.RULE_EVT.POS_USER_DEFINED_1,b+" 1"],[this.RULE_EVT.POS_USER_DEFINED_2,b+" 2"],[this.RULE_EVT.POS_USER_DEFINED_3,b+" 3"],[this.RULE_EVT.POS_USER_DEFINED_4,b+" 4"],[this.RULE_EVT.POS_USER_DEFINED_5,b+" 5"]];this.dsIPSpeakerEvtArray=[[this.RULE_EVT.DEV_ENABLED,_T("action_rule","ip_speaker_evt_enabled")],[this.RULE_EVT.DEV_DISABLED,_T("action_rule","ip_speaker_evt_disabled")],[this.RULE_EVT.DEV_LOST,_T("ss_filter","connection_lost")],[this.RULE_EVT.DEV_CONNECTED,_T("action_rule","connection_normal")]];this.dsExtEvtArray=[];for(c=1;c<=10;c++){this.dsExtEvtArray.push([c,_T("ss_common","external_event")+" "+c])}this.dsIOModuleEvtArray=[[this.RULE_EVT.DEV_DI,_T("action_rule","di_active")],[this.RULE_EVT.DEV_DI_INACTIVE,_T("action_rule","di_inactive")],[this.RULE_EVT.DEV_LOST,_T("ss_filter","connection_lost")],[this.RULE_EVT.DEV_CONNECTED,_T("action_rule","connection_normal")]];this.dsSSEvtArray=[[this.RULE_EVT.HOME_MODE_ENTER,_T("home_mode","enter_home_mode")],[this.RULE_EVT.HOME_MODE_LEAVE,_T("home_mode","leave_home_mode")]];this.dsEventItem=new Ext.data.ArrayStore({autoDestroy:true,fields:["itemId","itemText"],data:[]});this.RegStoreListenrer()},RegStoreListenrer:function(){this.dsEvent.on("load",function(b,a,c){if(true==c.add.blReset){this.cmbEvent.setValue(b.getAt(0).get("evtId"))}},this);this.dsEvent.on("datachanged",function(b,a,c){if(-1===b.findExact("evtId",this.cmbEvent.getValue())){this.cmbEvent.setValue(b.getAt(0).get("evtId"))}},this);this.dsEventItem.on("load",function(b,a,c){if(true==c.add.blReset){this.cmbEventItem.setValue(this.OPTION_ALL)}else{this.cmbEventItem.setValue(this.cmbEventItem.getValue())}},this);this.dsDevice.on("load",function(c,b,d){var a=c.findExact("id",this.cmbDevice.getValue());if(-1===a){this.cmbDevice.setValue("")}},this)},UpdateSourceStore:function(){var b=false;var a;var c=this.parentWin.pageAction.GetValues();for(a=0;a<c.length;a++){if(true===SYNO.SS.App.ActionRule.Utils.IsHomeModeAct(c[a].actId)){b=true;break}}this.dsSource.filterBy(function(d){if((SYNO.SS.App.ActionRule.Def.Source.WEBCLIENT===d.get("srcId"))&&(true===b)){return false}return true})},UpdateDeviceStore:function(e){var d,g=[],b=[];var f=this.cmbSource.getValue();var c,a;this.cmbEvent.setDisabled(false);switch(f){case this.DEFINES.Source.CAMERA:b=this.dsCamera.getRange();break;case this.DEFINES.Source.DOOR:b=this.dsDoor.getRange();break;case this.DEFINES.Source.CONTROLLER:b=this.dsCtrller.getRange();break;case this.DEFINES.Source.IOMODULE:b=this.dsIOModule.getRange();break;case this.DEFINES.Source.POS:b=this.dsPOS.getRange();break;case this.DEFINES.Source.IPSPEAKER:b=this.dsIPSpeaker.getRange();break;default:break}for(d=0;d<b.length;d++){g.push([b[d].get("id"),b[d].get("name")])}this.dsDevice.loadData(g,{blReset:e});if(true===this.IsDeviceShow()){c=(0>=b.length);if(0<b.length){if(true===e){this.cmbDevice.setValue(b[0].get("id"))}}else{this.cmbDevice.setValue("")}this.cmbEvent.setDisabled(c)}a=((true===e)||((false===e)&&(true===this.blResetDefault)));this.cmbDevice.fireEvent("select",this.cmbDevice,null,null,a)},UpdateEvtItemStore:function(){var a=((this.DEFINES.Source.IOMODULE===this.cmbSource.getValue())&&(0===this.dsIOModule.getTotalCount()));this.cmbEventItem.setDisabled(a)},ReloadDeviceStore:function(e){var c=this.GetDsId();var g=SYNO.SS.App.ActionRule.Utils.IsServerAvail(c,this,false);var f=SYNO.SS.GblStore.LoadFromCamStore({params:{blServerChecked:true,blOnlineDsOnly:true,ownerDsId:c}},true);this.dsCamera.loadData(f);this.dsCamera.each(function(h){if(LOCAL_DS_ID<h.get("ownerDsId")){h.set("id",h.get("camIdOnRecServer"))}});if(true===SYNO.SS.Utils.IsServiceRunning(SYNO.SS.Service.IO_MODULE)){var d=SYNO.SS.GblStore.LoadFromIOModStore({params:{ownerDsId:c,blOnlineDsOnly:true}},true);this.dsIOModule.loadData(d);this.dsIOModule.each(function(h){if(LOCAL_DS_ID<h.get("owner_ds_id")){h.set("id",h.get("id_on_rec_server"))}})}if(true===SYNO.SS.Utils.IsServiceRunning(SYNO.SS.Service.IP_SPEAKER)){var b=SYNO.SS.GblStore.LoadFromIPSpeakerStore({params:{ownerDsId:c,blOnlineDsOnly:true}},true);if(false===Ext.isEmpty(b)){this.dsIPSpeaker.loadData(b);this.dsIPSpeaker.each(function(h){if(LOCAL_DS_ID<h.get("ownerDsId")){h.set("id",h.get("idOnRecServer"))}})}}this.UpdateEvtItemStore();var a=[{api:"SYNO.SurveillanceStation.AxisAcsCtrler",method:"ListDoor",version:1},{api:"SYNO.SurveillanceStation.AxisAcsCtrler",method:"Enum",version:1},{api:"SYNO.SurveillanceStation.AxisAcsCtrler",method:"EnumAccessRule",version:1},{api:"SYNO.SurveillanceStation.Transactions.Device",method:"Enum",version:1,params:{filterDsIds:Ext.encode([LOCAL_DS_ID])}}];this.parentWin.Mask();this.sendWebAPI({compound:{mode:"parallel",params:a},dsId:c,callback:function(l,j,k,i){var h=[[this.dsDoor,"SYNO.SurveillanceStation.AxisAcsCtrler","ListDoor"],[this.dsCtrller,"SYNO.SurveillanceStation.AxisAcsCtrler","Enum"],[this.dsAcsRule,"SYNO.SurveillanceStation.AxisAcsCtrler","EnumAccessRule"],[this.dsPOS,"SYNO.SurveillanceStation.Transactions.Device","Enum"]];if(true===l){h.each(function(n){var m=SYNO.API.Util.GetValByAPI(j,n[1],n[2]);if(false===Ext.isDefined(m.code)){n[0].loadData(m)}})}this.UpdateDeviceStore(e);this.parentWin.Unmask()},scope:this})},UpdateEvtStore:function(e){var a,b;var g=this.cmbSource.getValue();var f={blReset:e};switch(g){case this.DEFINES.Source.CAMERA:this.dsEvent.loadData(this.dsCamEvtArray,f);break;case this.DEFINES.Source.EXT_DEVICE:this.dsEvent.loadData(this.dsExtEvtArray,f);break;case this.DEFINES.Source.DOOR:this.dsEvent.loadData(this.dsDoorEvtArray,f);break;case this.DEFINES.Source.CONTROLLER:this.dsEvent.loadData(this.dsCtrllerEvtArray,f);break;case this.DEFINES.Source.IOMODULE:this.dsEvent.loadData(this.dsIOModuleEvtArray,f);break;case this.DEFINES.Source.WEBCLIENT:this.dsEvent.loadData(this.dsSSEvtArray,f);break;case this.DEFINES.Source.POS:this.dsEvent.loadData(this.dsPOSEvtArray,f);break;case this.DEFINES.Source.IPSPEAKER:this.dsEvent.loadData(this.dsIPSpeakerEvtArray,f);break;default:break}if((SYNO.SS.App.ActionRule.Def.Source.CAMERA!==g)&&(SYNO.SS.App.ActionRule.Def.Source.IOMODULE!==g)&&(SYNO.SS.App.ActionRule.Def.Source.DOOR!==g)){return}var d;var c;var h;this.diEventItemArray.clear();this.appEventItemArray.clear();this.intercomEvtItemArray.clear();this.doorEvtItemArray=[];if(SYNO.SS.App.ActionRule.Def.Source.CAMERA===g){a=this.dsCamera.findExact("id",this.cmbDevice.getValue());b=this.dsCamera.getAt(a);if(false===Ext.isEmpty(b)){this.dsEvent.filterBy(function(l){var i=true,j;switch(l.get("evtId")){case this.RULE_EVT.DEV_DI:j=b.get("DINum");i=(j>0);this.diEventItemArray.push([this.OPTION_ALL,_T("ss_common","common_all")]);if(true==b.get("multiDI")){var k=b.get("io_list");for(d=1;d<=j;d++){Ext.each(k,function(m){if((m.idx+1)===d){this.diEventItemArray.push([d,m.name]);return false}},this)}}break;case this.RULE_EVT.DEV_DI_INACTIVE:j=b.get("DINum");i=(j>0);break;case this.RULE_EVT.CAM_TAMPERING:i=b.get("TDCap");break;case this.RULE_EVT.DEV_AUDIO_DET:i=b.get("ADCap");break;case this.RULE_EVT.CAM_PIR:i=((0<b.get("PDCap"))&&(DEPEND_NONE===b.get("PDDepend")));break;case this.RULE_EVT.DEV_APP:i=(b.get("application")&&(true===SYNO.SS.Utils.IsServiceRunning(SYNO.SS.Service.AXIS_ACAP))&&(true===SYNO.SS.App.Camera.Utils.HasApplicationCap(b.get("AppList"),false)));if(true===i){c=b.data.AppList;this.appEventItemArray.push([this.OPTION_ALL,_T("ss_common","common_all")]);for(d=0;d<c.length;d++){h=c[d];if((true===h.asEvent)&&(false===SYNO.SS.App.Camera.Utils.IsApplicationVMD(h))){this.appEventItemArray.push([h.idx+1,h.application])}}}break;case this.RULE_EVT.DEV_APP_VMD:i=((true===b.get("application"))&&(true===SYNO.SS.App.Camera.Utils.HasApplicationCap(b.get("AppList"),true)));break;case this.RULE_EVT.INTERCOM_EVENT:i=(SYNO.SS.App.Camera.Utils.IsDeviceIntercom(b.get("deviceType")))?true:false;if(true===i){this.intercomEvtItemArray.push([this.OPTION_ALL,_T("ss_common","common_all")]);if(0<b.get("doorbellNum")){this.intercomEvtItemArray.push([this.INTERCOM_EVT_IDX.DOORBELL,_T("ss_filter","doorbell_detected")])}this.intercomEvtItemArray.push([this.INTERCOM_EVT_IDX.REX,_T("ss_filter","rex_detected")]);this.intercomEvtItemArray.push([this.INTERCOM_EVT_IDX.DOOR_ACCESS,_T("ss_filter","door_access_detected")]);this.intercomEvtItemArray.push([this.INTERCOM_EVT_IDX.DOOR_LOCK,_T("ss_filter","door_lock_detected")]);this.intercomEvtItemArray.push([this.INTERCOM_EVT_IDX.DOOR_UNLOCK,_T("ss_filter","door_unlock_detected")])}break;default:break}return i},this)}}else{if(this.DEFINES.Source.IOMODULE===g){a=this.dsIOModule.findExact("id",this.cmbDevice.getValue());b=this.dsIOModule.getAt(a);if(false===Ext.isEmpty(b)){this.dsEvent.filterBy(function(m){var i=true,j;if(this.RULE_EVT.DEV_DI===m.get("evtId")){j=b.get("DINum");var l=b.get("io_list");i=(j>0);this.diEventItemArray.push([this.OPTION_ALL,_T("ss_common","common_all")]);if(true===b.get("multiDI")){for(var k=0;k<j;k++){this.diEventItemArray.push([k+1,(""!==l[k].name)?l[k].name:"IO_"+k])}}}else{if(this.RULE_EVT.DEV_DI_INACTIVE===m.get("evtId")){j=b.get("DINum");i=(j>0)}}return i},this)}else{this.diEventItemArray.push([this.OPTION_ALL,_T("ss_common","common_all")])}}else{if(this.DEFINES.Source.DOOR===g){this.doorEvtItemArray.push([this.OPTION_ALL,_T("ss_common","common_all")]);this.dsAcsRule.each(function(i){this.doorEvtItemArray.push([i.get("id"),i.get("name")])},this)}}}},GetDsId:function(){return(false===this.cmbServer.hidden)?this.cmbServer.getValue():this.parentWin.GetCurDsId()},MaskPage:function(a){if(true===a){this.cmbDevice.setDisabled(true);this.getEl().mask(_T("action_rule","scheduled_no_event"),"syno-ux-style-mask-info")}else{this.cmbDevice.setDisabled(false===this.IsDeviceShow());this.getEl().unmask()}},UpdateDefUI:function(d,c){var b=this.cmbSource.getValue();this.panelEventItem.hide();if((this.DEFINES.Source.EXT_DEVICE===b)||(this.DEFINES.Source.CONTROLLER===b)||(this.DEFINES.Source.DOOR===b)||(this.DEFINES.Source.POS===b)){if(this.RULE_EVT.DOOR_ACCESS_GRANTED===d){this.labelEventItem.setText(_T("axis_access_controller","access_rule_lowercase"));this.dsEventItem.loadData(this.doorEvtItemArray,{blReset:c});this.panelEventItem.show()}this.cmbTrigType.setDisabled(true);this.cmbTrigType.setValue(this.EVT_TRIG_TYPE_SINGLE)}else{if(this.DEFINES.Source.WEBCLIENT===b){this.cmbServer.setDisabled(true);this.cmbServer.hide();this.cmbDevice.setDisabled(true);this.cmbDevice.hide();this.cmbEvent.setDisabled(false);this.cmbTrigType.setDisabled(true);this.cmbTrigType.setValue(this.EVT_TRIG_TYPE_SINGLE)}else{switch(d){case this.RULE_EVT.DEV_ENABLED:case this.RULE_EVT.DEV_DISABLED:case this.RULE_EVT.DEV_LOST:case this.RULE_EVT.DEV_CONNECTED:this.cmbTrigType.setDisabled(false);break;case this.RULE_EVT.DEV_DI:case this.RULE_EVT.DEV_DI_INACTIVE:var a=((true===SYNO.SS.App.ActionRule.Utils.IsSrcCam(b))||(true===SYNO.SS.App.ActionRule.Utils.IsSrcIOModule(b)));if(true===a){this.labelEventItem.setText(_T("recording","digital_input_mode")+_T("ss_common","common_colon"));this.dsEventItem.loadData(this.diEventItemArray,{blReset:c});this.panelEventItem.show()}this.cmbTrigType.setDisabled(false);break;case this.RULE_EVT.DEV_APP:this.labelEventItem.setText(_T("ss_common","application")+_T("ss_common","common_colon"));this.dsEventItem.loadData(this.appEventItemArray,{blReset:c});this.panelEventItem.show();this.cmbTrigType.setDisabled(true);this.cmbTrigType.setValue(this.EVT_TRIG_TYPE_CYCLE);break;case this.RULE_EVT.CAM_MD:case this.RULE_EVT.CAM_TAMPERING:case this.RULE_EVT.CAM_LA_EVT:case this.RULE_EVT.CAM_PIR:case this.RULE_EVT.DEV_AUDIO_DET:case this.RULE_EVT.IVA_EVENT_DETECTED:case this.RULE_EVT.DEV_APP_VMD:this.cmbTrigType.setDisabled(true);this.cmbTrigType.setValue(this.EVT_TRIG_TYPE_CYCLE);break;case this.RULE_EVT.INTERCOM_EVENT:this.labelEventItem.setText(_T("action_rule","intercom_event")+_T("ss_common","common_colon"));this.dsEventItem.loadData(this.intercomEvtItemArray,{blReset:c});this.panelEventItem.show();this.cmbTrigType.setDisabled(true);this.cmbTrigType.setValue(this.EVT_TRIG_TYPE_SINGLE);break;default:this.cmbTrigType.setDisabled(true);this.cmbTrigType.setValue(this.EVT_TRIG_TYPE_SINGLE);break}}}SYNO.SS.App.ActionRule.Utils.UpdateScheData(this.parentWin,true)},UpdExtBtnVisibility:function(){var a=this.cmbSource.getValue();this.panelExtTip.setVisible(SYNO.SS.App.ActionRule.Utils.IsExtSrc(a))},UpdTipMsg:function(b){var a=Ext.getDom(this.cmbEvent.getEl()).parentNode.childNodes[3];if(this.DEFINES.RuleEvt.CAM_LA_EVT===b){a.hidden=false}else{a.hidden=true}},SetTitle:function(a){this.actOrder=(true==Ext.isDefined(a))?a:this.actOrder;var b=_T("ss_notification","event")+" "+(this.actOrder+1);if((true==SYNO.SS.App.ActionRule.Utils.IsEvtInvalid(this.evt))||(true==SYNO.SS.App.ActionRule.Utils.IsEvtItemInvalid(this.evt))){b+=String.format(" - <span style='color:{0}'>{1}</span>",SYNO.SS.Color.ALERT_RED,_T("action_rule","status_invalid"))}this.setTitle(b)},GetSettings:function(){if((this.DEFINES.Source.CAMERA!==this.cmbSource.getValue())&&(this.DEFINES.Source.IOMODULE!==this.cmbSource.getValue())&&(this.DEFINES.Source.IPSPEAKER!==this.cmbSource.getValue())){return{}}return{dsId:this.cmbServer.getValue(),evtDevId:this.cmbDevice.getValue(),evtId:this.cmbEvent.getValue(),evtSrcId:this.cmbSource.getValue(),evtTrig:this.cmbTrigType.getValue()}},SetValues:function(a){if(!a){return}this.ruleId=(a.id)?a.id:-1;this.cmbSource.setValue(a.evtSrc);this.cmbServer.setValue(a.evtDsId);this.cmbDevice.setValue(a.evtDevId);this.cmbEvent.setValue(a.evtId);this.cmbEventItem.setValue(a.evtItem);this.cmbTrigType.setValue(a.evtTrig);this.ClearDirty();this.UpdExtBtnVisibility()},GetValues:function(){var a;if(this.DEFINES.Source.EXT_DEVICE===this.cmbSource.getValue()){a=this.DEFINES.RuleAct.EXT}else{a=this.cmbDevice.getValue()}return{id:this.ruleId,evtSrc:this.cmbSource.getValue(),evtDsId:this.parentWin.parentWin.GetDsId(this.cmbServer.getValue()),evtDevId:(""==a)?0:a,evtId:this.cmbEvent.getValue(),evtItem:this.cmbEventItem.getValue(),evtTrig:this.cmbTrigType.getValue()}},IsFormValid:function(){return(this.cmbSource.isValid()&&this.cmbServer.isValid()&&this.cmbDevice.isValid()&&this.cmbEvent.isValid()&&this.cmbEventItem.isValid()&&this.cmbTrigType.isValid())},IsDirty:function(){return((true===this.blResetDefault)||this.cmbSource.isDirty()||this.cmbServer.isDirty()||this.cmbDevice.isDirty()||this.cmbEvent.isDirty()||this.cmbEventItem.isDirty()||this.cmbTrigType.isDirty())},ClearDirty:function(){this.blResetDefault=false;this.cmbSource.originalValue=this.cmbSource.getValue();this.cmbServer.originalValue=this.cmbServer.getValue();this.cmbDevice.originalValue=this.cmbDevice.getValue();this.cmbEvent.originalValue=this.cmbEvent.getValue();this.cmbEventItem.originalValue=this.cmbEventItem.getValue();this.cmbTrigType.originalValue=this.cmbTrigType.getValue()},IsDeviceShow:function(){var a=this.cmbSource.getValue();return((false===SYNO.SS.App.ActionRule.Utils.IsExtSrc(a))&&(false===SYNO.SS.App.ActionRule.Utils.IsWebClientSrc(a)))},IsServerShow:function(){var a=this.cmbSource.getValue();return(true===this.parentWin.IsCmbServerVisible())&&(false===SYNO.SS.App.ActionRule.Utils.IsWebClientSrc(a))}});Ext.define("SYNO.SS.App.ActionRule.ActionPanel",{extend:"SYNO.ux.FormPanel",MAX_ACTION_NUM:5,MIN_ACTION_NUM:1,btnAdd:null,btnDelete:null,actionFsArray:null,parent:null,audioPatternPlayer:null,constructor:function(a){this.actionFsArray=[];this.parent=a.parentWin;this.Init(a);Ext.apply(a,{title:_T("ss_common","common_action"),tbar:[this.btnAdd,this.btnDelete],items:this.actionFsArray,listeners:{deactivate:this.OnStop,beforedestroy:function(){this.OnStop();this.actionFsArray.clear()},scope:this}});this.callParent([a])},Init:function(a){var b,c;var d=(a.actNums)?a.actNums:1;if(true===SYNO.SS.Utils.IsSupportWebPlayer()){this.audioPatternPlayer=new SYNO.SS.Audioin.Html5AudioPatternPlayer({playerId:SYNO.SS.Audioin.AudioPatternPlayer_Id})}else{this.audioPatternPlayer=new SYNO.SS.Audioin.PluginAudioPatternPlayer()}this.btnAdd=new SYNO.ux.Button({text:_T("ss_common","common_add"),handler:this.OnAdd,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.OnDelete,scope:this});for(b=0;b<d;b++){c=new SYNO.SS.App.ActionRule.ActionFieldSet({parentWin:a.parentWin,parent:this,blAdd:a.blAdd},b);this.actionFsArray.push(c)}this.ChgBtnStatus()},OnAdd:function(){var a=new SYNO.SS.App.ActionRule.ActionFieldSet({parentWin:this.parent,parent:this,blAdd:true},this.actionFsArray.length,this.parentWin.pageInfo.cmbRuleType.getValue());this.actionFsArray.push(a);this.add(a);this.doLayout();this.ChgBtnStatus()},OnDelete:function(){var a=new SYNO.SS.App.ActionRule.DeleteDialog(this.parent,this,false);a.show()},ChgBtnStatus:function(){this.btnAdd.setDisabled(this.MAX_ACTION_NUM===this.actionFsArray.length);this.btnDelete.setDisabled(this.MIN_ACTION_NUM===this.actionFsArray.length)},RefreshFsHeader:function(){Ext.each(this.actionFsArray,function(b,a){b.SetTitle(a)})},SetValues:function(a){Ext.each(this.actionFsArray,function(c,b){c.SetValues(a[b])})},GetValues:function(){var a=[];Ext.each(this.actionFsArray,function(b){a.push(b.GetValues())});return a},GetActArrayForCheckSche:function(){var a=[];Ext.each(this.actionFsArray,function(b){a.push(b.GetActArrayForCheckSche())});return a},GetSettings:function(){var a=[];Ext.each(this.actionFsArray,function(b){a.push(b.GetSettings())});return a},UpdateUI:function(a,b){Ext.each(this.actionFsArray,function(d,c){d.UpdateUI(a.get("ruleType"),a.get("actions")[c],b)})},UpdateDefUI:function(a){Ext.each(this.actionFsArray,function(b){b.UpdateDefUI(a)})},UpdateUIByEventChange:function(){Ext.each(this.actionFsArray,function(a){a.UpdateActStore()})},OnStop:function(){Ext.each(this.actionFsArray,function(a){a.OnStop()})},IsFormValid:function(){var a=true;Ext.each(this.actionFsArray,function(b){if(false===b.IsFormValid()){a=false;return false}});return a},IsDirty:function(){if(this.actNums!==this.actionFsArray.length){return true}var a=false;Ext.each(this.actionFsArray,function(b){if(true===b.IsDirty()){a=true;return false}});return a},ClearDirty:function(){this.actNums=this.actionFsArray.length;Ext.each(this.actionFsArray,function(a){a.ClearDirty()})}});Ext.define("SYNO.SS.App.ActionRule.ActionFieldSet",{extend:"SYNO.ux.FieldSet",PLAY_INTERVAL_MS:50,SECOND_DEF_VALUE:10,SECOND_MIN_VALUE:1,SECOND_MAX_VALUE:60*60*24,MINUTE_MIN_VALUE:1,MINUTE_MAX_VALUE:60*24,HOUR_MIN_VALUE:1,HOUR_MAX_VALUE:24,FIELD_WIDTH:400,LABEL_STYLE:"width: 180px",DEFINES:SYNO.SS.App.ActionRule.Def,INTERCOM_ACTION_IDX:SYNO.SS.App.ActionRule.Def.IntercomActionIdx,HTTP_PREFIX:"http://",HTTPS_PREFIX:"https://",actStop:{NONE:0,DURATION:1,TIMES:2,BOTH:3},parentWin:null,parent:null,actOrder:null,act:{},blAdd:false,blFirstLoad:false,blLoadPreset:false,blLoadPatrol:false,blLoadAudio:false,blLoadIOModule:false,blLoadDoor:false,blLoadIPSpeaker:false,blLoadIPSpeakerGrp:false,blResetDefault:false,blDevSetReset:false,dsDevice:null,dsIOModule:null,dsDoor:null,dsIPSpeaker:null,dsIPSpeakerGrp:null,dsAction:null,dsPreset:null,dsPatrol:null,dsAudio:null,dsActItem:null,ruleId:-1,DONum:null,ruleType:SYNO.SS.App.ActionRule.Def.RuleType.TRIGGERED,oriServer:null,actStopCond:null,cmbSource:null,cmbServer:null,cmbDevice:null,cmbIOModule:null,cmbDoor:null,cmbIPSpeaker:null,cmbIPSpeakerGrp:null,cmbAction:null,cmbActItem:null,btnPlay:null,fldUrl:null,fldUsrName:null,fldPwd:null,cmbTimes:null,cmbTimeUnit:null,fldTimeDur:null,cmbRetPos:null,labelTime:null,panelTime:null,labelItem:null,panelItem:null,OPTION_ALL:-1,constructor:function(a,b,c){this.blAdd=a.blAdd;this.parentWin=a.parentWin;this.parent=a.parent;this.ruleType=(c)?c:this.ruleType;this.actOrder=b;this.Init();this.callParent([{title:_T("ss_common","common_action")+" "+(this.actOrder+1),collapsible:true,items:[this.cmbSource,this.cmbServer,this.cmbDevice,this.cmbIOModule,this.cmbDoor,this.cmbIPSpeaker,this.cmbIPSpeakerGrp,this.cmbAction,this.panelItem,this.fldUrl,this.fldUsrName,this.fldPwd,this.cmbTimes,this.panelTime,this.cmbRetPos],listeners:{afterrender:function(d){if(true===this.blAdd){d.UpdateDeviceStore(true)}},scope:this}}])},Init:function(){this.taskPlaying={run:this.UpdatePlayBtn,interval:this.PLAY_INTERVAL_MS,scope:this};this.InitDataStore();var a=[[this.DEFINES.Source.CAMERA,_T("ss_common","common_camera")],[this.DEFINES.Source.IOMODULE,_T("ss_common","common_iomodule")],[this.DEFINES.Source.EXT_DEVICE,_T("ss_common","external_device")],[this.DEFINES.Source.DOOR,_T("axis_access_controller","door")],[this.DEFINES.Source.VS,_T("ss_common","common_vs")],[this.DEFINES.Source.WEBCLIENT,_T("ss_common","surveillance_station")],[this.DEFINES.Source.IPSPEAKER,_T("ip_speaker","ip_speaker_speaker")],[this.DEFINES.Source.IPSPEAKER_GROUP,_T("ip_speaker","ip_speaker_group")]];var b=SYNO.SS.App.ActionRule.Def.GetFilteredSource(a);this.cmbSource=new SYNO.ux.ComboBox({fieldLabel:_T("action_rule","action_device"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"srcId",displayField:"srcText",mode:"local",value:this.DEFINES.Source.CAMERA,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,lastIndex:-1,store:new Ext.data.ArrayStore({fields:["srcId","srcText"],data:b}),listeners:{select:this.SelectActSrc,scope:this}});this.cmbSource.store.filterBy(function(d){var c=this.DEFINES.SourceDependentService(d.get("srcId"));return((false===Ext.isDefined(c))||(true===SYNO.SS.Utils.IsServiceRunning(c)))},this);this.cmbServer=new SYNO.ux.ComboBox({fieldLabel:_T("ss_common","surveillance_server"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"id",displayField:"name",mode:"local",editable:false,forceSelection:true,triggerAction:"all",value:LOCAL_DS_ID,allowBlank:false,valueNotFoundText:"",hidden:(false===this.parentWin.IsCmbServerVisible()),store:SYNO.SS.GblStore.GetSlaveDSStoreCopy(null,{blEnabledOnly:false}),listeners:{select:function(e,c,d){if(e.getValue()!==this.oriServer){if(true===this.blPlaying){this.btnPlay.toggle(false)}this.UpdateDeviceStore(true);this.oriServer=e.getValue()}},scope:this},GetValue:function(){return(true===this.isVisible())?this.getValue():LOCAL_DS_ID}});this.cmbDevice=new SYNO.ux.ComboBox({fieldLabel:_T("menu","menu_device"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:(LOCAL_DS_ID===this.parentWin.GetCurDsId())?"id":"camIdOnRecServer",displayField:"name",mode:"local",triggerAction:"all",forceSelection:true,editable:false,emptyText:_T("action_rule","no_avaliable_device"),allowBlank:false,store:this.dsDevice,listeners:{select:this.SelectDevice,scope:this}});this.cmbIOModule=new SYNO.ux.ComboBox({fieldLabel:_T("menu","menu_device"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"id",displayField:"name",mode:"local",triggerAction:"all",forceSelection:true,editable:false,emptyText:_T("action_rule","no_avaliable_device"),allowBlank:false,store:this.dsIOModule,listeners:{select:this.SelectDevice,scope:this}});this.cmbDoor=new SYNO.ux.ComboBox({fieldLabel:_T("menu","menu_device"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"id",displayField:"name",forceSelection:true,emptyText:_T("action_rule","no_avaliable_device"),allowBlank:false,store:this.dsDoor,listeners:{select:this.SelectDevice,scope:this}});this.cmbIPSpeaker=new SYNO.ux.ComboBox({fieldLabel:_T("menu","menu_device"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"id",displayField:"name",forceSelection:true,emptyText:_T("action_rule","no_avaliable_device"),allowBlank:false,store:this.dsIPSpeaker,listeners:{select:this.SelectDevice,scope:this}});this.cmbIPSpeakerGrp=new SYNO.ux.ComboBox({fieldLabel:_T("menu","menu_device"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"id",displayField:"name",forceSelection:true,emptyText:_T("action_rule","no_avaliable_device"),allowBlank:false,store:this.dsIPSpeakerGrp,listeners:{select:this.SelectDevice,scope:this}});this.cmbAction=new SYNO.ux.ComboBox({fieldLabel:_T("ss_common","common_action"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"actId",displayField:"actText",mode:"local",value:this.DEFINES.RuleAct.ENABLE,triggerAction:"all",lastQuery:"",forceSelection:true,allowBlank:false,editable:false,store:this.dsAction,listeners:{select:this.SelectAction,enable:function(c){this.cmbTimes.enable();this.cmbActItem.enable();this.cmbTimeUnit.enable();this.fldTimeDur.enable();this.cmbRetPos.enable()},disable:function(c){this.cmbTimes.disable();this.cmbActItem.disable();this.cmbTimeUnit.disable();this.fldTimeDur.disable();this.cmbRetPos.disable()},scope:this}});this.cmbActItem=new SYNO.ux.ComboBox({fieldLabel:_T("joystick","opt_to_preset"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"id",displayField:"name",mode:"local",triggerAction:"all",forceSelection:true,emptyText:_T("ss_common","no_avaliable_items"),allowBlank:false,editable:false,store:this.dsActItem,listeners:{select:function(e,c,d){if(true===this.blPlaying){this.btnPlay.toggle(false)}this.btnPlay.setDisabled(false)},scope:this}});this.btnPlay=new Ext.Button({style:"padding-top: 5px",iconCls:"pattern_btn_mini_play",enableToggle:true,toggleHandler:this.OnPlay,hidden:true,scope:this});this.labelItem=new Ext.form.Label({text:_T("joystick","opt_to_preset")+_T("ss_common","common_colon"),style:"line-height: 28px;",width:185});this.panelItem=new SYNO.ux.Panel({style:"margin-bottom: 5px",layout:"column",items:[this.labelItem,{xtype:"syno_panel",width:this.FIELD_WIDTH,items:this.cmbActItem},this.btnPlay],listeners:{show:function(c){this.cmbActItem.setDisabled(false)},hide:function(c){this.cmbActItem.setDisabled(true)},scope:this}});this.fldUrl=new SYNO.ux.TextField({fieldLabel:_T("action_rule","url"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,allowBlank:false,validateOnBlur:true,validationEvent:"blur",emptyText:"http(s)://",hidden:true,listeners:{afterrender:function(){SYNO.SS.Utils.AddTip(this.fldUrl.getEl(),_T("action_rule","url_hint"))},show:function(c){c.setDisabled(false)},hide:function(c){c.setDisabled(true)},scope:this}});this.fldUsrName=new SYNO.ux.TextField({fieldLabel:_T("camera","camera_attr_user"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,preventAutoFill:true,forceFakeAfter:true,hidden:true,listeners:{show:function(c){c.setDisabled(false)},hide:function(c){c.setDisabled(true)},scope:this}});this.fldPwd=new SYNO.ux.TextField({fieldLabel:_T("camera","camera_attr_password"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,inputType:"password",preventAutoFill:true,hidden:true,listeners:{show:function(c){c.setDisabled(false)},hide:function(c){c.setDisabled(true)},scope:this}});this.cmbTimes=new SYNO.ux.ComboBox({fieldLabel:_T("action_rule","times"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"times",displayField:"timesText",mode:"local",value:1,hidden:true,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,store:new Ext.data.ArrayStore({fields:["times","timesText"],data:[[1,"1"],[2,"2"],[3,"3"],[4,"4"],[5,"5"],[6,"6"],[7,"7"],[8,"8"],[9,"9"],[10,"10"]]}),listeners:{select:this.SelectTimes,scope:this}});this.labelTime=new Ext.form.Label({text:_T("event","event_duration")+_T("ss_common","common_colon"),style:"line-height: 28px;",width:185});this.cmbTimeUnit=new SYNO.ux.ComboBox({width:200,valueField:"unitId",displayField:"unitText",mode:"local",disabled:true,value:this.DEFINES.TimeUnit.SECOND,triggerAction:"all",lastQuery:"",forceSelection:true,allowBlank:false,editable:false,store:new Ext.data.ArrayStore({fields:["unitId","unitText","unitType"],data:[[this.DEFINES.TimeUnit.SECOND,_T("action_rule","second"),this.actStop.BOTH],[this.DEFINES.TimeUnit.MINUTE,_T("action_rule","minute"),this.actStop.BOTH],[this.DEFINES.TimeUnit.HOUR,_T("action_rule","hours"),this.actStop.BOTH],[this.DEFINES.TimeUnit.FOREVER,_T("action_rule","time_forever"),this.actStop.DURATION]]}),listeners:{select:this.SelectTimeUnit,scope:this}});this.fldTimeDur=new SYNO.ux.TextField({allowBlank:false,validateOnBlur:true,validationEvent:"blur",disabled:true,width:195,value:this.SECOND_DEF_VALUE,timeMin:1,timeMax:60,vtype:"unsigned",validator:function(c){if((this.timeMin>c)||(this.timeMax<c)){this.HideTooltip();return String.format(_T("event_detection","enter_value_between"),this.timeMin,this.timeMax)}this.ShowTooltip();return true},listeners:{disable:function(){if(false===this.validateValue(this.getValue())){this.setValue(this.originalValue)}}}});this.panelTime=new SYNO.ux.Panel({style:"margin-bottom: 5px",layout:"column",width:650,hidden:true,items:[this.labelTime,{xtype:"syno_panel",width:200,items:this.fldTimeDur},{xtype:"syno_panel",width:210,items:this.cmbTimeUnit}],listeners:{show:function(c){c.setDisabled(false)},hide:function(c){c.setDisabled(true)},scope:this}});this.cmbRetPos=new SYNO.ux.ComboBox({fieldLabel:_T("action_rule","return_position"),width:this.FIELD_WIDTH,labelStyle:this.LABEL_STYLE,valueField:"position",displayField:"name",mode:"local",value:-1,hidden:true,triggerAction:"all",forceSelection:true,allowBlank:false,editable:false,store:this.dsPreset})},InitDataStore:function(){this.dsDevice=SYNO.SS.GblStore.CreateCameraStoreInst();this.dsDevice.setBaseParam("blIncludeDeletedCam",false);this.dsDevice.setBaseParam("blOnlineDsOnly",true);this.dsIOModule=new SYNO.SS.IOModuleCacheStore({cmp:this,needSort:true,baseParams:{blOnlineDsOnly:true},fields:SYNO.SS.GblStore.fieldIOModule,listeners:{beforeload:function(){this.blLoadIOModule=false},scope:this}});this.dsDoor=new SYNO.API.JsonStore({appWindow:this.parentWin,api:"SYNO.SurveillanceStation.AxisAcsCtrler",method:"ListDoor",version:1,getDsId:this.GetDsId.createDelegate(this),fields:[{name:"id",type:"int"},{name:"name"}],listeners:{beforeload:function(){this.blLoadDoor=false},scope:this}});this.dsIPSpeaker=new SYNO.SS.IPSpeakerCacheStore({cmp:this,needSort:true,baseParams:{blOnlineDsOnly:true},fields:SYNO.SS.GblStore.fieldIPSpeaker,listeners:{beforeload:function(){this.blLoadIPSpeaker=false},scope:this}});this.dsIPSpeakerGrp=new SYNO.API.JsonStore({autoDestroy:true,appWindow:this.parentWin,api:"SYNO.SurveillanceStation.IPSpeaker.Group",method:"Enum",version:1,getDsId:this.GetDsId.createDelegate(this),root:"ipSpeakerGrps",fields:SYNO.SS.GblStore.fieldIPSpeakerGrp,listeners:{beforeload:function(){this.blLoadIPSpeakerGrp=false},scope:this}});this.dsAction=new Ext.data.ArrayStore({autoDestroy:true,fields:["actId","actText","actStop"],data:[[this.DEFINES.RuleAct.RECORD,_T("action_rule","start_actrule_recording"),this.actStop.DURATION],[this.DEFINES.RuleAct.STOP_RECORD,_T("action_rule","stop_actrule_recording"),this.actStop.NONE],[this.DEFINES.RuleAct.SNAPSHOT,_T("ss_privilege","take_snapshot"),this.actStop.TIMES],[this.DEFINES.RuleAct.PRESET,_T("action_rule","move_preset"),this.actStop.DURATION],[this.DEFINES.RuleAct.PATROL,_T("camera","camera_guard"),this.actStop.TIMES],[this.DEFINES.RuleAct.AUTOPAN,_T("liveview","auto_pan"),this.actStop.DURATION],[this.DEFINES.RuleAct.OBJ_TRACKING,_T("camera","auto_obj_tracking"),this.actStop.DURATION],[this.DEFINES.RuleAct.AUDIO_OUT,_T("camera","audio_output"),this.actStop.TIMES],[this.DEFINES.RuleAct.DO,_T("action_rule","digital_output_enable"),this.actStop.DURATION],[this.DEFINES.RuleAct.DO_DISABLE,_T("action_rule","digital_output_disable"),this.actStop.DURATION],[this.DEFINES.RuleAct.ENABLE,_T("action_rule","cam_act_enable"),this.actStop.NONE],[this.DEFINES.RuleAct.DISABLE,_T("action_rule","cam_act_disable"),this.actStop.NONE],[this.DEFINES.RuleAct.VS_AO,_T("camera","audio_output"),this.actStop.TIMES],[this.DEFINES.RuleAct.WEB_CLIENT_AO,_T("camera","audio_output"),this.actStop.TIMES],[this.DEFINES.RuleAct.HOME_MODE_ENTER,_T("home_mode","enter_home_mode"),this.actStop.NONE],[this.DEFINES.RuleAct.HOME_MODE_LEAVE,_T("home_mode","leave_home_mode"),this.actStop.NONE],[this.DEFINES.RuleAct.INTERCOM_ACTION,_T("action_rule","intercom_action"),this.actStop.NONE],[this.DEFINES.RuleAct.DOOR_ACCESS,_T("camera","door_access"),this.actStop.NONE],[this.DEFINES.RuleAct.DOOR_LOCK,_T("ss_common","common_lock"),this.actStop.NONE],[this.DEFINES.RuleAct.DOOR_UNLOCK,_T("ss_common","common_unlock"),this.actStop.NONE],[this.DEFINES.RuleAct.PREVIEW,_T("action_rule","cam_act_preview"),this.actStop.NONE]]});this.dsAudio=new SYNO.API.JsonStore({autoDestroy:true,appWindow:this,api:"SYNO.SurveillanceStation.AudioPattern",method:"List",version:1,getDsId:this.GetDsId.createDelegate(this),root:"audioPattern",totalProperty:"total",fields:[{name:"id",type:"int"},{name:"name"},{name:"fmt"},{name:"length"},{name:"isDefault",type:"boolean"}],listeners:{beforeload:function(a,b){this.parentWin.Mask();this.blLoadAudio=false},loadexception:function(a){this.parentWin.Unmask()},load:function(b,a,c){var d=this.cmbAction.getValue();this.blLoadAudio=true;if(true===c.params.blReset){if((this.DEFINES.RuleAct.WEB_CLIENT_AO===d)||(this.DEFINES.RuleAct.VS_AO===d)){this.cmbAction.fireEvent("select",this.cmbAction,null,-1)}}this.parentWin.Unmask()},scope:this}});this.dsActItem=new Ext.data.ArrayStore({autoDestroy:true,fields:["id","name"],data:[]});this.dsActItem.on("load",function(e,d,g){var f=Ext.isEmpty(d);if(true===f){var b="";switch(this.cmbAction.getValue()){case this.DEFINES.RuleAct.PRESET:b=_T("action_rule","no_available_preset");break;case this.DEFINES.RuleAct.PATROL:b=_T("action_rule","no_available_patrol");break;default:break}this.cmbActItem.emptyText=b;this.cmbActItem.setValue("");this.cmbActItem.applyEmptyText()}if(true===f){return}var h=true;var a=e.findExact("id",this.cmbActItem.getValue());var c=e.getAt(a);if((true===Ext.isEmpty(c))||(""===c.get("name"))){h=false}if((false===h)&&((false===this.blAdd))){if(true===this.blDevSetReset){this.cmbActItem.setValue(d[0].get("id"));this.cmbActItem.originalValue=this.cmbActItem.getValue();this.blDevSetReset=false}else{this.cmbActItem.setValue("");this.cmbActItem.originalValue=this.cmbActItem.getValue();this.btnPlay.setDisabled(true)}}else{if(false===this.blFirstLoad){this.cmbActItem.setValue(d[0].get("id"));this.cmbActItem.originalValue=this.cmbActItem.getValue()}}},this);this.dsPreset=new Ext.data.ArrayStore({autoDestroy:true,fields:[{name:"position"},{name:"name"},{name:"type"}],listeners:{load:function(d,c,e){this.AddDefaultPresetPos(false);this.blLoadPreset=true;var a=d.findExact("position",this.cmbRetPos.getValue());var b=d.getAt(a);if((true===Ext.isEmpty(b))||(""===b.get("name"))){this.cmbRetPos.setValue(this.DEFINES.PresetPos.NONE)}this.parentWin.Unmask()},scope:this}});this.dsPatrol=new Ext.data.ArrayStore({fields:[{name:"id"},{name:"name"}],autoDestroy:true,listeners:{load:function(b,a,c){this.blLoadPatrol=true;this.parentWin.Unmask()},scope:this}})},UpdateUI:function(d,a,c){var b=SYNO.SS.App.ActionRule.Utils.IsServerAvail(a.actDsId,this,true);this.ruleType=d;this.act=a;this.SetTitle();this.blFirstLoad=b;if(true===c){this.UpdateDeviceStore(false===b)}this.blResetDefault=(0!==SYNO.SS.Utils.IsFlags((this.DEFINES.Status.ACT_SRC_INVALID|this.DEFINES.Status.ITEM_INVALID),a.status))},UpdateTimeDurTip:function(){var a=String.format(_T("event_detection","enter_value_between"),this.fldTimeDur.timeMin,this.fldTimeDur.timeMax);this.fldTimeDur.SetTooltipText(a);this.fldTimeDur.ShowTooltip()},UpdateDefUI:function(a){this.ruleType=a;this.SelectActSrc(this.cmbSource,null,-1);this.UpdateTimeUnitUI();this.cmbTimeUnit.setValue(this.DEFINES.TimeUnit.SECOND);this.fldTimeDur.setValue(this.SECOND_DEF_VALUE);this.fldTimeDur.timeMin=this.SECOND_MIN_VALUE;this.fldTimeDur.timeMax=this.SECOND_MAX_VALUE;this.UpdateTimeDurTip()},UpdateTimeRelateUI:function(d,c,b){var a=true;switch(c){case this.actStop.DURATION:this.labelTime.setText(_T("event","event_duration")+_T("ss_common","common_colon"));this.cmbTimes.hide();if(true===SYNO.SS.App.ActionRule.Utils.IsTriggered(this.ruleType)){a=false;this.panelTime.show()}else{this.panelTime.hide()}break;case this.actStop.TIMES:this.panelTime.show();this.labelTime.setText(_T("camera","camera_guard_interval")+_T("ss_common","common_colon"));if(true===SYNO.SS.App.ActionRule.Utils.IsTriggered(this.ruleType)){this.cmbTimes.label.update(_T("action_rule","times")+_T("ss_common","common_colon"));this.cmbTimes.show();a=(1===this.cmbTimes.getValue())}else{if(this.DEFINES.RuleAct.PATROL===d){this.cmbTimes.label.update(_T("camera","camera_guard_cycle")+_T("ss_common","common_colon"));this.cmbTimes.show()}else{this.cmbTimes.hide()}a=false}break;case this.actStop.NONE:this.panelTime.hide();this.cmbTimes.hide();break;default:break}if(null!==b){this.cmbTimeUnit.setValue(this.DEFINES.TimeUnit.SECOND)}this.actStopCond=c;this.FilterTimeUnitStore();if(false==this.cmbAction.disabled){this.cmbTimeUnit.setDisabled(a);this.fldTimeDur.setDisabled((true===a)||(this.DEFINES.TimeUnit.FOREVER===this.cmbTimeUnit.getValue()));this.cmbRetPos.setDisabled(false)}},OnPlay:function(f,c){var a=this.dsAudio.getById(this.cmbActItem.getValue());var b=a.get("isDefault");var e=(true===b)?a.get("name")+a.get("fmt"):"";var d={dsId:this.findAppWindow().getAppDSId(),fileName:e,id:a.get("id"),blDefault:b};if(true===c){this.parent.audioPatternPlayer.Start(d);this.StopOtherAction();this.btnPlay.setIconClass("pattern_btn_mini_stop");this.totalPlayTime=a.get("length")*1000;Ext.TaskMgr.start(this.taskPlaying)}else{this.parent.audioPatternPlayer.Stop();this.btnPlay.setIconClass("pattern_btn_mini_play");this.totalPlayTime=0;Ext.TaskMgr.stop(this.taskPlaying)}this.blPlaying=c;this.curPlayTime=0},OnStop:function(){if(true===this.blPlaying){this.btnPlay.toggle(false)}},UpdatePlayBtn:function(){this.curPlayTime+=this.PLAY_INTERVAL_MS;if(this.curPlayTime>=this.totalPlayTime){this.btnPlay.toggle(false)}},StopOtherAction:function(){var a=this.actOrder;Ext.each(this.parent.actionFsArray,function(c,b){if((a!==b)&&(true===c.blPlaying)){c.btnPlay.setIconClass("pattern_btn_mini_play");c.btnPlay.toggle(false,true);c.totalPlayTime=0;c.blPlaying=false;Ext.TaskMgr.stop(c.taskPlaying)}})},SelectActSrc:function(d,b,c){if(true===this.blPlaying){this.btnPlay.toggle(false)}this.SetActionBehaviorUIDisabled(false);if(null===b){var f=this.cmbSource.getValue();var a=this.cmbSource.store.findExact("srcId",f);b=this.cmbSource.store.getAt(a)}var e;var g=[[this.DEFINES.Source.CAMERA,this.cmbDevice],[this.DEFINES.Source.IOMODULE,this.cmbIOModule],[this.DEFINES.Source.DOOR,this.cmbDoor],[this.DEFINES.Source.IPSPEAKER,this.cmbIPSpeaker],[this.DEFINES.Source.IPSPEAKER_GROUP,this.cmbIPSpeakerGrp]];Ext.each(g,function(h){h[1].setDisabled(h[0]!==b.get("srcId"));h[1].hide()},this);this.cmbAction.setDisabled(false);this.cmbAction.hide();this.fldUrl.hide();this.fldUsrName.hide();this.fldPwd.hide();this.cmbServer.hide();this.panelItem.hide();this.cmbRetPos.hide();this.panelTime.hide();this.UpdateActStore();switch(b.get("srcId")){case this.DEFINES.Source.CAMERA:this.cmbDevice.show();this.cmbAction.show();this.cmbServer.setVisible(this.parentWin.IsCmbServerVisible());this.cmbAction.setDisabled(0>=this.dsDevice.getCount());if((null!==c)||(true===this.blResetDefault)){e=(true===SYNO.SS.App.ActionRule.Utils.IsTriggered(this.ruleType))?this.DEFINES.RuleAct.RECORD:this.DEFINES.RuleAct.SNAPSHOT;this.cmbAction.setValue(e)}if((null!==c)&&(d.lastIndex!==c)&&(true===Ext.isEmpty(this.cmbDevice.getValue()))&&(0<this.dsDevice.getCount())){this.WaitStoreReady(this.dsDevice.getAt(0).get((LOCAL_DS_ID===this.parentWin.GetCurDsId())?"id":"camIdOnRecServer"));this.UpdateActStore();this.blDevSetReset=true;this.cmbAction.fireEvent("select",this.cmbAction,null,0)}else{this.cmbAction.fireEvent("select",this.cmbAction,null,c)}break;case this.DEFINES.Source.EXT_DEVICE:this.fldUrl.show();this.fldUsrName.show();this.fldPwd.show();if(null!==c){this.cmbTimeUnit.setValue(this.DEFINES.TimeUnit.SECOND)}this.actStopCond=this.actStop.TIMES;this.FilterTimeUnitStore();this.UpdateTimePanelUI();this.parent.updateFleXcroll();break;case this.DEFINES.Source.VS:this.SetUIForClientAOAction(this.DEFINES.RuleAct.VS_AO,c);break;case this.DEFINES.Source.WEBCLIENT:if(true===this.blAdd){this.SetUIForClientAOAction(this.DEFINES.RuleAct.WEB_CLIENT_AO,c)}else{if((true===SYNO.SS.App.ActionRule.Utils.IsHomeModeAct(this.act.actId))&&(SYNO.SS.App.ActionRule.Utils.IsTriggered(this.ruleType))){this.cmbAction.show()}else{this.SetUIForClientAOAction(this.DEFINES.RuleAct.WEB_CLIENT_AO,c)}}break;case this.DEFINES.Source.IOMODULE:this.cmbIOModule.show();this.cmbAction.show();this.cmbServer.setVisible(this.parentWin.IsCmbServerVisible());if(0>=this.dsIOModule.getCount()){this.cmbAction.setDisabled(true);this.cmbIOModule.setValue("")}if((null!==c)||(true===this.blResetDefault)){this.cmbAction.setValue(this.DEFINES.RuleAct.DO)}if((null!==c)&&(d.lastIndex!==c)&&(true===Ext.isEmpty(this.cmbIOModule.getValue()))&&(0<this.dsIOModule.getCount())){this.SetCmbIOModuleVal(this.dsIOModule.getAt(0).get("id"));this.UpdateActStore();this.blDevSetReset=true;this.cmbAction.fireEvent("select",this.cmbAction,null,0)}else{this.cmbAction.fireEvent("select",this.cmbAction,null,c)}break;case this.DEFINES.Source.DOOR:this.cmbServer.setVisible(this.parentWin.IsCmbServerVisible());this.cmbDoor.show();this.cmbAction.show();if(0>=this.dsDoor.getCount()){this.cmbDoor.setValue("");this.cmbAction.setDisabled(true)}if((null!==c)||(true===this.blResetDefault)){this.cmbAction.setValue(this.DEFINES.RuleAct.DOOR_ACCESS)}if((null!==c)&&(d.lastIndex!==c)&&(true===Ext.isEmpty(this.cmbDoor.getValue()))&&(0<this.dsDoor.getCount())){this.SetDevIdToCmb(this.dsDoor.getAt(0).get("id"),this.cmbDoor,this.dsDoor);this.blDevSetReset=true;this.cmbAction.fireEvent("select",this.cmbAction,null,0)}else{this.cmbAction.fireEvent("select",this.cmbAction,null,c)}break;case this.DEFINES.Source.IPSPEAKER:this.cmbIPSpeaker.show();this.cmbAction.show();this.cmbServer.setVisible(this.parentWin.IsCmbServerVisible());if(0>=this.dsIPSpeaker.getCount()){this.cmbAction.setDisabled(true);this.cmbIPSpeaker.setValue("")}if((null!==c)||(true===this.blResetDefault)){this.cmbAction.setValue(this.DEFINES.RuleAct.AUDIO_OUT)}if((null!==c)&&(d.lastIndex!==c)&&(true===Ext.isEmpty(this.cmbIPSpeaker.getValue()))&&(0<this.dsIPSpeaker.getCount())){this.SetDevIdToCmb(this.dsIPSpeaker.getAt(0).get("id"),this.cmbIPSpeaker,this.dsIPSpeaker);this.blDevSetReset=true;this.cmbAction.fireEvent("select",this.cmbAction,null,0)}else{this.cmbAction.fireEvent("select",this.cmbAction,null,c)}break;case this.DEFINES.Source.IPSPEAKER_GROUP:this.cmbIPSpeakerGrp.show();this.cmbAction.show();this.cmbServer.setVisible(this.parentWin.IsCmbServerVisible());if(0>=this.dsIPSpeakerGrp.getCount()){this.cmbAction.setDisabled(true);this.cmbIPSpeakerGrp.setValue("")}if((null!==c)||(true===this.blResetDefault)){this.cmbAction.setValue(this.DEFINES.RuleAct.AUDIO_OUT)}if((null!==c)&&(d.lastIndex!==c)&&(true===Ext.isEmpty(this.cmbIPSpeakerGrp.getValue()))&&(0<this.dsIPSpeakerGrp.getCount())){this.SetDevIdToCmb(this.dsIPSpeakerGrp.getAt(0).get("id"),this.cmbIPSpeakerGrp,this.dsIPSpeakerGrp);this.blDevSetReset=true;this.cmbAction.fireEvent("select",this.cmbAction,null,0)}else{this.cmbAction.fireEvent("select",this.cmbAction,null,c)}break}if((null!==c)&&(0<c)){d.lastIndex=c}},SetUIForClientAOAction:function(a,b){this.cmbAction.show();if(null!==b){this.cmbAction.setValue(a)}if(LOCAL_DS_ID!==this.cmbServer.getValue()){this.dsAudio.load({params:{blReset:true}})}this.cmbAction.fireEvent("select",this.cmbAction,null,b);this.UpdateTimePanelUI()},SetActionBehaviorUIDisabled:function(a){this.cmbTimes.setDisabled(a);this.cmbTimeUnit.setDisabled(a);this.fldTimeDur.setDisabled(a);this.cmbRetPos.setDisabled(a)},UpdateTimePanelUI:function(){if(true===SYNO.SS.App.ActionRule.Utils.IsTriggered(this.ruleType)){this.cmbTimes.show();this.SelectTimes()}else{this.cmbTimes.hide()}this.labelTime.setText(_T("camera","camera_guard_interval")+_T("ss_common","common_colon"));this.panelTime.show();SYNO.SS.App.ActionRule.Utils.UpdateScheData(this.parentWin)},SelectDevice:function(c,a,b){if(true===this.blPlaying){this.btnPlay.toggle(false)}if(0<a.get("presetNum")){this.LoadPresetPatrolList(a)}else{this.AddDefaultPresetPos(true)}this.UpdateActStore();var d=(true===SYNO.SS.App.ActionRule.Utils.IsTriggered(this.ruleType))?this.DEFINES.RuleAct.RECORD:this.DEFINES.RuleAct.SNAPSHOT;if(this.DEFINES.Source.IOMODULE===this.cmbSource.getValue()){d=this.DEFINES.RuleAct.DO}else{if((this.DEFINES.Source.IPSPEAKER===this.cmbSource.getValue())||(this.DEFINES.Source.IPSPEAKER_GROUP===this.cmbSource.getValue())){d=this.DEFINES.RuleAct.AUDIO_OUT}}this.cmbAction.setValue(d);this.cmbAction.fireEvent("select",this.cmbAction,null,null)},SelectAction:function(d,h,k){if(true===this.blPlaying){this.btnPlay.toggle(false)}var g,f,a=[];var n;if(this.DEFINES.Source.CAMERA===this.cmbSource.getValue()){this.SetActionBehaviorUIDisabled(false)}if(null===h){var c=this.cmbAction.getValue();n=this.cmbAction.store.findExact("actId",c);h=this.cmbAction.store.getAt(n);if(undefined===h){this.cmbAction.setValue(this.cmbAction.store.getAt(0).get("actId"));this.cmbAction.fireEvent("select",this.cmbAction,null,k);return}}this.UpdateTimeRelateUI(h.get("actId"),h.get("actStop"),k);this.panelItem.hide();this.btnPlay.hide();this.cmbRetPos.hide();switch(h.get("actId")){case this.DEFINES.RuleAct.PRESET:this.cmbRetPos.show();this.panelItem.show();this.labelItem.setText(_T("joystick","opt_to_preset")+_T("ss_common","common_colon"));f=this.dsPreset.getRange();for(g=0;g<f.length;g++){if(this.DEFINES.PresetType.NONE!==f[g].get("type")){a.push([f[g].get("position"),f[g].get("name")])}}if(0===a.length){this.SetActionBehaviorUIDisabled(true)}this.dsActItem.loadData(a);break;case this.DEFINES.RuleAct.PATROL:this.cmbRetPos.show();this.panelItem.show();this.labelItem.setText(_T("joystick","opt_to_patrol")+_T("ss_common","common_colon"));f=this.dsPatrol.getRange();for(g=0;g<f.length;g++){a.push([f[g].get("id"),f[g].get("name")])}if(0===a.length){this.SetActionBehaviorUIDisabled(true)}this.dsActItem.loadData(a);break;case this.DEFINES.RuleAct.AUTOPAN:case this.DEFINES.RuleAct.OBJ_TRACKING:this.cmbRetPos.show();break;case this.DEFINES.RuleAct.AUDIO_OUT:case this.DEFINES.RuleAct.VS_AO:case this.DEFINES.RuleAct.WEB_CLIENT_AO:this.panelItem.show();this.labelItem.setText(_T("audio_pattern","audio_pattern")+_T("ss_common","common_colon"));f=this.dsAudio.getRange();for(g=0;g<f.length;g++){a.push([f[g].get("id"),this.GetPatternName(f[g])])}this.dsActItem.loadData(a);this.btnPlay.show();break;case this.DEFINES.RuleAct.DO:case this.DEFINES.RuleAct.DO_DISABLE:this.panelItem.show();if(this.DEFINES.RuleAct.DO===h.get("actId")){this.labelItem.setText(_T("action_rule","digital_output_enable")+_T("ss_common","common_colon"))}else{this.labelItem.setText(_T("action_rule","digital_output_disable")+_T("ss_common","common_colon"))}if(SYNO.SS.App.ActionRule.Def.Source.IOMODULE===this.cmbSource.getValue()){if(0!=this.dsIOModule.getTotalCount()){var b=this.dsIOModule.findExact("id",this.cmbIOModule.getValue());var m=this.dsIOModule.getAt(b);if(false===Ext.isEmpty(m)){var e=m.get("io_list");for(g=m.get("DINum");g<e.size();g++){a.push([g+1,(""!==e[g].name)?e[g].name:"IO_"+g])}}}else{a.push([this.OPTION_ALL,_T("ss_common","common_all")]);this.cmbActItem.disable()}}else{var l=(LOCAL_DS_ID===this.parentWin.GetCurDsId())?"id":"camIdOnRecServer";n=this.dsDevice.findExact(l,this.cmbDevice.getValue());var p=this.dsDevice.getAt(n);if(p){var o=p.get("io_list");var j=p.get("DINum");for(g=1;g<=this.DONum;g++){Ext.each(o,function(i){if((i.idx-j+1)===g){a.push([g,i.name]);return false}})}}}this.dsActItem.loadData(a);break;case this.DEFINES.RuleAct.HOME_MODE_ENTER:case this.DEFINES.RuleAct.HOME_MODE_LEAVE:this.cmbTimes.hide();this.panelTime.hide();break;case this.DEFINES.RuleAct.INTERCOM_ACTION:this.panelItem.show();this.labelItem.setText(_T("action_rule","intercom_action")+_T("ss_common","common_colon"));if(false===SYNO.SS.App.ActionRule.Utils.IsScheduled(this.ruleType)){a.push([this.INTERCOM_ACTION_IDX.DOOR_ACCESS,_T("camera","door_access")])}a.push([this.INTERCOM_ACTION_IDX.DOOR_LOCK,_T("ss_common","common_lock")]);a.push([this.INTERCOM_ACTION_IDX.DOOR_UNLOCK,_T("ss_common","common_unlock")]);this.dsActItem.loadData(a);break;default:break}SYNO.SS.App.ActionRule.Utils.UpdateScheData(this.parentWin);SYNO.SS.App.ActionRule.Utils.UpdateByActionChange(this.parentWin);this.parent.updateFleXcroll()},GetPatternName:function(a){var b=a.get("name");return(true===a.get("isDefault"))?SYNO.SS.Utils.GetAudioPatternDefName(b):b},SelectTimes:function(){var a;var b=this.cmbTimeUnit.getValue();if((this.DEFINES.RuleAct.PATROL===this.cmbAction.getValue())&&(this.DEFINES.RuleType.SCHEDULED===this.ruleType)){a=false}else{a=(1===this.cmbTimes.getValue())}if(false==this.cmbAction.disabled){this.cmbTimeUnit.setDisabled(a);this.fldTimeDur.setDisabled((true===a)||(this.DEFINES.TimeUnit.FOREVER===b))}},SelectTimeUnit:function(d,f,h){if(null===f){var c=this.cmbTimeUnit.getValue();var j=this.cmbTimeUnit.store.findExact("unitId",c);if(-1===j){j=0}f=this.cmbTimeUnit.store.getAt(j)}var e;var i=this.dsAction.findExact("actId",this.cmbAction.getValue());var g=this.dsAction.getAt(i);if(false===Ext.isEmpty(g)){e=(this.actStop.TIMES===g.get("actStop"))}else{if(this.DEFINES.Source.EXT_DEVICE===this.cmbSource.getValue()){e=true}}var b=f.get("unitId");var a=((true===SYNO.SS.App.ActionRule.Utils.IsTriggered(this.ruleType))&&(1===this.cmbTimes.getValue())&&(true===e));a|=(this.DEFINES.TimeUnit.FOREVER===b);if(false===this.cmbAction.disabled){this.fldTimeDur.setDisabled(a);this.cmbRetPos.setDisabled(this.DEFINES.TimeUnit.FOREVER===b)}switch(b){case this.DEFINES.TimeUnit.SECOND:this.fldTimeDur.timeMin=this.SECOND_MIN_VALUE;this.fldTimeDur.timeMax=this.SECOND_MAX_VALUE;break;case this.DEFINES.TimeUnit.MINUTE:this.fldTimeDur.timeMin=this.MINUTE_MIN_VALUE;this.fldTimeDur.timeMax=this.MINUTE_MAX_VALUE;break;case this.DEFINES.TimeUnit.HOUR:this.fldTimeDur.timeMin=this.HOUR_MIN_VALUE;this.fldTimeDur.timeMax=this.HOUR_MAX_VALUE;break;case this.DEFINES.TimeUnit.FOREVER:this.cmbRetPos.setValue(this.DEFINES.PresetPos.NONE);break}this.UpdateTimeDurTip();this.fldTimeDur.validate()},GetDsId:function(){return(false===this.cmbServer.hidden)?this.cmbServer.getValue():this.parentWin.GetCurDsId()},WaitStoreReady:function(e,g,d){var c=false;var f=(LOCAL_DS_ID===this.parentWin.GetCurDsId())?"id":"camIdOnRecServer";var a=this.dsDevice.findExact(f,e);var b=(-1===a)?null:this.dsDevice.getAt(a);this.AddDefaultPresetPos(true);if((0<this.dsDevice.getCount())&&(false===Ext.isEmpty(b))){this.cmbDevice.setValue(b.get(f));this.DONum=b.get("DONum");if(0<b.get("presetNum")){c=true;this.LoadPresetPatrolList(b)}}else{this.cmbDevice.setValue("")}this.DoWaitStoreReady(c,g,d)},DoWaitStoreReady:function(c,d,b){var a=true;if(true==c){if((false===this.blLoadPreset)||(false===this.blLoadPatrol)){a=false}}if((false===this.blLoadAudio)||(false===this.blLoadIOModule)||(false===this.blLoadDoor)||(false===this.blLoadIPSpeaker)||(false===this.blLoadIPSpeakerGrp)){a=false}if(false===a){this.DoWaitStoreReady.defer(100,this,[c,d,b])}else{if(true===Ext.isFunction(d)){d.call(b);this.blFirstLoad=false;this.parentWin.Unmask()}}},SetCmbIOModuleVal:function(c){var d="id";var a=this.dsIOModule.findExact(d,c);var b=(-1===a)?null:this.dsIOModule.getAt(a);if((0<this.dsIOModule.getCount())&&(false===Ext.isEmpty(b))){this.cmbIOModule.setValue(b.get(d));this.DONum=b.get("DONum")}else{this.cmbIOModule.setValue("")}},SetDevIdToCmb:function(d,f,c){var e="id";var a=c.findExact(e,d);var b=(-1===a)?null:c.getAt(a);if((0<c.getCount())&&(false===Ext.isEmpty(b))){f.setValue(b.get(e))}else{f.setValue("")}},UpdateDeviceStore:function(b){var a=this.GetDsId();SYNO.SS.App.ActionRule.Utils.IsServerAvail(a,this,false);this.parentWin.Mask();this.dsAudio.load({params:{blReset:b}});if(true===SYNO.SS.Utils.IsServiceRunning(SYNO.SS.Service.IO_MODULE)){this.dsIOModule.load({params:{ownerDsId:(LOCAL_DS_ID!==this.parentWin.GetCurDsId())?LOCAL_DS_ID:a,blReset:b},callback:function(c,d,f){var e;this.blLoadIOModule=true;if(true===d.params.blReset){if(0<c.length){e=c[0].get("id");this.cmbIOModule.setValue(e)}else{this.cmbIOModule.setValue("")}}else{this.SetCmbIOModuleVal(this.cmbIOModule.getValue())}},scope:this})}else{this.blLoadIOModule=true}this.sendWebAPI({api:"SYNO.SurveillanceStation.AddOns",method:"GetInfo",version:1,dsId:this.GetDsId(),params:{service:SYNO.SS.Service.ACSCTRL},callback:function(f,d,e,c){if((true===f)&&(true===d.blEnabled)){this.dsDoor.load({params:{blReset:b},callback:function(g,h,i){this.blLoadDoor=true;if(true===h.params.blReset){if(0<g.length){this.cmbDoor.setValue(g[0].get("id"))}else{this.cmbDoor.setValue("")}}else{this.SetDevIdToCmb(this.cmbDoor.getValue(),this.cmbDoor,this.dsDoor)}},scope:this})}else{this.blLoadDoor=true;this.dsDoor.removeAll();this.cmbDoor.setValue("")}},scope:this});if(true===SYNO.SS.Utils.IsServiceRunning(SYNO.SS.Service.IP_SPEAKER)){this.dsIPSpeaker.load({params:{ownerDsId:this.GetDsId(),blReset:b},callback:function(c,d,e){var f;this.blLoadIPSpeaker=true;if(true===d.params.blReset){if(0<c.length){f=c[0].get("id");this.cmbIPSpeaker.setValue(f)}else{this.cmbIPSpeaker.setValue("")}}else{this.SetDevIdToCmb(this.cmbIPSpeaker.getValue(),this.cmbIPSpeaker,this.dsIPSpeaker)}},scope:this});this.dsIPSpeakerGrp.load({params:{blReset:b},callback:function(c,d,f){var e;this.blLoadIPSpeakerGrp=true;if(true===d.params.blReset){if(0<c.length){e=c[0].get("id");this.cmbIPSpeakerGrp.setValue(e)}else{this.cmbIPSpeakerGrp.setValue("")}}else{this.SetDevIdToCmb(this.cmbIPSpeakerGrp.getValue(),this.cmbIPSpeakerGrp,this.dsIPSpeakerGrp)}},scope:this})}else{this.blLoadIPSpeaker=true;this.blLoadIPSpeakerGrp=true}this.dsDevice.load({params:{ownerDsId:a,blReset:b},callback:function(d,e,g){var c,f;if(true===e.params.blReset){if(0<d.length){f=(LOCAL_DS_ID===this.parentWin.GetCurDsId())?"id":"camIdOnRecServer";c=d[0].get(f);this.cmbDevice.setValue(c);if(0<d[0].get("presetNum")){this.LoadPresetPatrolList(d[0])}}else{this.cmbDevice.setValue("")}}this.WaitStoreReady(this.cmbDevice.getValue(),function(){this.SelectActSrc(this.cmbSource,null,null);this.UpdateTimeUnitUI();this.SelectTimeUnit(this.cmbTimeUnit,null,null)},this)},scope:this})},UpdateActForWebClient:function(){var c=false;var b;var a=this.parentWin.pageEvent.GetValues();for(b=0;b<a.length;b++){if(true===SYNO.SS.App.ActionRule.Utils.IsHomeModeEvt(a[b].evtId)){c=true;break}}this.dsAction.filterBy(function(d){if(this.DEFINES.RuleAct.WEB_CLIENT_AO===d.get("actId")){return true}else{if(true===SYNO.SS.App.ActionRule.Utils.IsHomeModeAct(d.get("actId"))){if(true===c){return false}return(true===SYNO.SS.App.ActionRule.Utils.IsTriggered(this.ruleType))}else{return false}}},this)},UpdateActForVS:function(){this.dsAction.filterBy(function(a){return(this.DEFINES.RuleAct.VS_AO===a.get("actId"))},this)},UpdateActForCamera:function(){var c=(LOCAL_DS_ID===this.parentWin.GetCurDsId())?"id":"camIdOnRecServer";var a=this.dsDevice.findExact(c,this.cmbDevice.getValue());var b=this.dsDevice.getAt(a);if(!b){return}this.dsAction.filterBy(function(d){switch(d.get("actId")){case this.DEFINES.RuleAct.PRESET:case this.DEFINES.RuleAct.PATROL:return(0<b.get("presetNum"));case this.DEFINES.RuleAct.AUTOPAN:return(0!==b.get("autoPan"));case this.DEFINES.RuleAct.OBJ_TRACKING:return b.get("objTrack");case this.DEFINES.RuleAct.AUDIO_OUT:return b.get("audioOut");case this.DEFINES.RuleAct.DO:case this.DEFINES.RuleAct.DO_DISABLE:this.DONum=b.get("DONum");return(0<b.get("DONum"));case this.DEFINES.RuleAct.RECORD:case this.DEFINES.RuleAct.STOP_RECORD:case this.DEFINES.RuleAct.PREVIEW:return(false===SYNO.SS.App.ActionRule.Utils.IsScheduled(this.ruleType));case this.DEFINES.RuleAct.INTERCOM_ACTION:return SYNO.SS.App.Camera.Utils.IsDeviceIntercom(b.get("deviceType"));case this.DEFINES.RuleAct.SNAPSHOT:case this.DEFINES.RuleAct.ENABLE:case this.DEFINES.RuleAct.DISABLE:return true;default:return false}},this)},UpdateActForIOModule:function(){var a=this.dsIOModule.findExact("id",this.cmbIOModule.getValue());var b=this.dsIOModule.getAt(a);if(!b){return}this.dsAction.filterBy(function(c){switch(c.get("actId")){case this.DEFINES.RuleAct.DO:case this.DEFINES.RuleAct.DO_DISABLE:this.DONum=b.get("DONum");return(0<b.get("DONum"));default:return false}},this)},UpdateActForDoor:function(){this.dsAction.filterBy(function(a){switch(a.get("actId")){case this.DEFINES.RuleAct.DOOR_ACCESS:return(false===SYNO.SS.App.ActionRule.Utils.IsScheduled(this.ruleType));case this.DEFINES.RuleAct.DOOR_LOCK:case this.DEFINES.RuleAct.DOOR_UNLOCK:return true;default:return false}},this)},UpdateActForIPSpeaker:function(){this.dsAction.filterBy(function(a){return(this.DEFINES.RuleAct.AUDIO_OUT===a.get("actId"))},this)},UpdateActStore:function(){this.dsAction.clearFilter();switch(this.cmbSource.getValue()){case this.DEFINES.Source.CAMERA:this.UpdateActForCamera();break;case this.DEFINES.Source.VS:this.UpdateActForVS();break;case this.DEFINES.Source.WEBCLIENT:this.UpdateActForWebClient();break;case this.DEFINES.Source.IOMODULE:this.UpdateActForIOModule();break;case this.DEFINES.Source.DOOR:this.UpdateActForDoor();break;case this.DEFINES.Source.IPSPEAKER:case this.DEFINES.Source.IPSPEAKER_GROUP:this.UpdateActForIPSpeaker();break}},UpdateTimeUnitUI:function(){if((this.DEFINES.RuleType.SCHEDULED===this.ruleType)&&(false===this.cmbAction.disabled)){this.cmbTimeUnit.setDisabled(false);this.fldTimeDur.setDisabled(false)}},FilterTimeUnitStore:function(){var a=this.cmbTimeUnit.getStore();a.clearFilter();if((this.actStop.DURATION!==this.actStopCond)||(false===SYNO.SS.App.ActionRule.Utils.IsTriggered(this.ruleType))){a.filter("unitType",this.actStop.BOTH)}},AddDefaultPresetPos:function(a){if(true===a){this.dsPreset.removeAll()}var b=new Ext.data.Record({position:this.DEFINES.PresetPos.NONE,name:_T("ss_common","common_none"),type:this.DEFINES.PresetType.NONE});this.dsPreset.addSorted(b);if(false===this.blFirstLoad){this.cmbRetPos.setValue(this.DEFINES.PresetPos.NONE)}},LoadPresetPatrolList:function(a){var b=(LOCAL_DS_ID!=this.GetDsId())?"camIdOnRecServer":"id";this.LoadPresetList(a,b);this.LoadPatrolList(a,b)},LoadPresetList:function(c,e){this.blLoadPreset=false;var b;var a=-1;var d=[];this.parentWin.Mask();if(SYNO.SS.GblStore.jsonCamExtraCfg){b=SYNO.SS.GblStore.jsonCamExtraCfg.preset[this.GetDsId()];a=b.findExact("id",c.get(e))}if(-1===a){this.AddDefaultPresetPos(true);this.cmbRetPos.setValue(this.DEFINES.PresetPos.NONE);this.blLoadPreset=true;this.parentWin.Unmask()}else{Ext.each(b[a].presetList,function(g,f){d.push([g.position,g.name,g.type])});this.dsPreset.loadData(d)}},LoadPatrolList:function(b,e){this.blLoadPatrol=false;var d;var a=-1;var c=[];this.parentWin.Mask();if(SYNO.SS.GblStore.jsonCamExtraCfg){d=SYNO.SS.GblStore.jsonCamExtraCfg.patrol[this.GetDsId()];a=d.findExact("id",b.get(e))}if(-1===a){this.dsPatrol.removeAll();this.blLoadPatrol=true;this.parentWin.Unmask()}else{Ext.each(d[a].patrolList,function(f,g){c.push([f.id,f.name])});this.dsPatrol.loadData(c)}},SetTitle:function(a){this.actOrder=(true===Ext.isDefined(a))?a:this.actOrder;var b=_T("ss_common","common_action")+" "+(this.actOrder+1);if(true==SYNO.SS.App.ActionRule.Utils.IsActInvalid(this.act)){b+=String.format(" - <span style='color:{0}'>{1}</span>",SYNO.SS.Color.ALERT_RED,_T("action_rule","status_invalid"))}this.setTitle(b)},SetValues:function(a){this.ruleId=(a.id)?a.id:-1;this.cmbSource.setValue(a.actSrc);this.cmbServer.setValue(a.actDsId);if(this.DEFINES.Source.IOMODULE===a.actSrc){this.cmbIOModule.setValue(a.actDevId)}else{if(this.DEFINES.Source.IPSPEAKER===a.actSrc){this.cmbIPSpeaker.setValue(a.actDevId)}else{if(this.DEFINES.Source.IPSPEAKER_GROUP===a.actSrc){this.cmbIPSpeakerGrp.setValue(a.actDevId)}else{if(this.DEFINES.Source.DOOR===a.actSrc){this.cmbDoor.setValue(a.actDevId)}else{this.cmbDevice.setValue(a.actDevId)}}}}this.cmbAction.setValue(a.actId);this.cmbActItem.setValue(a.actItemId);this.cmbTimes.setValue(a.actTimes);this.cmbTimeUnit.setValue(a.actTimeUnit);this.cmbRetPos.setValue(a.actRetPos);this.fldUrl.setValue(a.extUrl);this.fldUsrName.setValue(a.userName);this.fldPwd.setValue(a.password);this.fldTimeDur.setValue(a.actTimeDur);this.ClearDirty()},GetValues:function(){var a=this.cmbDevice.getValue();if(this.DEFINES.Source.IOMODULE===this.cmbSource.getValue()){a=this.cmbIOModule.getValue()}else{if(this.DEFINES.Source.IPSPEAKER===this.cmbSource.getValue()){a=this.cmbIPSpeaker.getValue()}else{if(this.DEFINES.Source.IPSPEAKER_GROUP===this.cmbSource.getValue()){a=this.cmbIPSpeakerGrp.getValue()}else{if(this.DEFINES.Source.DOOR===this.cmbSource.getValue()){a=this.cmbDoor.getValue()}}}}return{id:this.ruleId,actSrc:this.cmbSource.getValue(),actDsId:this.cmbServer.GetValue(),actDevId:a,actId:this.cmbAction.getValue(),actItemId:this.cmbActItem.getValue(),actTimes:this.cmbTimes.getValue(),actTimeUnit:this.cmbTimeUnit.getValue(),actRetPos:this.cmbRetPos.getValue(),extUrl:this.fldUrl.getValue(),userName:this.fldUsrName.getValue(),password:this.fldPwd.getValue(),actTimeDur:this.fldTimeDur.getValue()}},ClearDirty:function(){this.blResetDefault=false;this.cmbSource.originalValue=this.cmbSource.getValue();this.cmbServer.originalValue=this.cmbServer.getValue();this.cmbDevice.originalValue=this.cmbDevice.getValue();this.cmbIOModule.originalValue=this.cmbIOModule.getValue();this.cmbDoor.originalValue=this.cmbDoor.getValue();this.cmbIPSpeaker.originalValue=this.cmbIPSpeaker.getValue();this.cmbIPSpeakerGrp.originalValue=this.cmbIPSpeakerGrp.getValue();this.cmbAction.originalValue=this.cmbAction.getValue();this.cmbActItem.originalValue=this.cmbActItem.getValue();this.cmbTimes.originalValue=this.cmbTimes.getValue();this.cmbTimeUnit.originalValue=this.cmbTimeUnit.getValue();this.cmbRetPos.originalValue=this.cmbRetPos.getValue();this.fldUrl.originalValue=this.fldUrl.getValue();this.fldUsrName.originalValue=this.fldUsrName.getValue();this.fldPwd.originalValue=this.fldPwd.getValue();this.fldTimeDur.originalValue=this.fldTimeDur.getValue()},GetActArrayForCheckSche:function(){return{src:this.cmbSource.getValue(),deviceId:((SYNO.SS.App.ActionRule.Def.Source.IOMODULE===this.cmbSource.getValue())?this.cmbIOModule.getValue():this.cmbDevice.getValue()),actId:this.cmbAction.getValue()}},GetSettings:function(){if((SYNO.SS.App.ActionRule.Def.Source.CAMERA!==this.cmbSource.getValue())&&(SYNO.SS.App.ActionRule.Def.Source.IOMODULE!==this.cmbSource.getValue())&&(SYNO.SS.App.ActionRule.Def.Source.DOOR!==this.cmbSource.getValue())&&(SYNO.SS.App.ActionRule.Def.Source.IPSPEAKER!==this.cmbSource.getValue())&&(SYNO.SS.App.ActionRule.Def.Source.IPSPEAKER_GROUP!==this.cmbSource.getValue())){return{}}var d=this.cmbSource.getValue();var b;var a=this.cmbServer.GetValue();var c;if(this.DEFINES.Source.IOMODULE===d){c=this.cmbIOModule.getValue()}else{if(this.DEFINES.Source.DOOR===d){c=this.cmbDoor.getValue()}else{if(this.DEFINES.Source.IPSPEAKER===d){c=this.cmbIPSpeaker.getValue()}else{if(this.DEFINES.Source.IPSPEAKER_GROUP===d){c=this.cmbIPSpeakerGrp.getValue()}else{c=this.cmbDevice.getValue()}}}}if(LOCAL_DS_ID!==a){if(this.DEFINES.Source.IOMODULE===d){b=this.dsIOModule.getById(c);c=b.get("id")}else{if(this.DEFINES.Source.IPSPEAKER===d){b=this.dsIPSpeaker.getById(c);c=b.get("id")}else{if(this.DEFINES.Source.IPSPEAKER_GROUP===d){b=this.dsIPSpeakerGrp.getById(c);c=b.get("id")}else{if(this.DEFINES.Source.DOOR===d){b=this.dsDoor.getById(c);c=b.get("id")}else{b=this.dsDevice.getById(c);c=b.get("camIdOnRecServer")}}}}}return{dsId:a,actDevId:c,actId:this.cmbAction.getValue(),actSrcId:this.cmbSource.getValue()}},IsFormValid:function(){if((this.DEFINES.Source.EXT_DEVICE===this.cmbSource.getValue())&&((this.HTTP_PREFIX===this.fldUrl.getValue())||(this.HTTPS_PREFIX===this.fldUrl.getValue))){this.fldUrl.markInvalid();return false}return(this.cmbSource.isValid()&&this.cmbServer.isValid()&&this.cmbDevice.isValid()&&this.cmbIOModule.isValid()&&this.cmbDoor.isValid()&&this.cmbIPSpeaker.isValid()&&this.cmbIPSpeakerGrp.isValid()&&this.cmbAction.isValid()&&this.cmbActItem.isValid()&&this.cmbTimes.isValid()&&this.cmbTimeUnit.isValid()&&((false===SYNO.SS.App.ActionRule.Utils.IsLensAct(this.cmbAction.getValue()))||(this.cmbRetPos.isValid()))&&this.fldUrl.isValid()&&this.fldUsrName.isValid()&&this.fldPwd.isValid()&&this.fldTimeDur.isValid())},IsDirty:function(){return((true===this.blResetDefault)||this.cmbSource.isDirty()||this.cmbServer.isDirty()||this.cmbDevice.isDirty()||this.cmbIOModule.isDirty()||this.cmbDoor.isDirty()||this.cmbIPSpeaker.isDirty()||this.cmbIPSpeakerGrp.isDirty()||this.cmbAction.isDirty()||this.cmbActItem.isDirty()||this.cmbTimes.isDirty()||this.cmbTimeUnit.isDirty()||((true===SYNO.SS.App.ActionRule.Utils.IsLensAct(this.cmbAction.getValue()))&&(this.cmbRetPos.isDirty()))||this.fldUrl.isDirty()||this.fldUsrName.isDirty()||this.fldPwd.isDirty()||this.fldTimeDur.isDirty())}});Ext.define("SYNO.SS.App.ActionRule.Schedule",{extend:"SYNO.ux.FormPanel",SCHEDULE_ID_PREFIX:"",blInit:false,blAnyAvailable:true,blScheduleActivated:false,panelAllowNotify:null,panelEraseNotify:null,labelAllowNotify:null,labelEraseNotify:null,labelScheNonavailable:null,panelScheduler:null,IMAGE_ICON_SIZE:35,SCHEDULE_TYPE_LABEL_WIDTH:285,constructor:function(a){this.SCHEDULE_ID_PREFIX=Ext.id();this.Init();Ext.apply(a,{title:_T("ss_common","schedule"),layout:"border",items:[{xtype:"syno_panel",region:"center",items:[this.panelModeSelection,this.panelScheduler]},this.labelScheNonavailable]});this.callParent([a])},Init:function(){var a;this.panelScheduler=new SYNO.SS.Panel.SchedulerPanel({htmlSchedulerId:this.SCHEDULE_ID_PREFIX,scheduleMode:SYNO.SS.Schedule.Mode.ACTRULE_WIZARD,blTwoColor:true});a=this.panelScheduler.getId();this.panelAllowNotify=new SYNO.ux.Panel({width:this.IMAGE_ICON_SIZE,html:"<span id='"+this.SCHEDULE_ID_PREFIX+"icon_custom2' class='btn_custom2_active'onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.SCHEDULE_ID_PREFIX+"', 'over', 'continue','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.SCHEDULE_ID_PREFIX+"', 'out', 'continue','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.SCHEDULE_ID_PREFIX+"', 'down', 'continue','"+a+"');\"></span>"});this.panelEraseNotify=new SYNO.ux.Panel({width:this.IMAGE_ICON_SIZE,html:"<span id='"+this.SCHEDULE_ID_PREFIX+"icon_erase' class='btn_erase_inactive'onMouseOver=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.SCHEDULE_ID_PREFIX+"', 'over', 'erase','"+a+"');\"onMouseOut=\"javascript:SYNO.SS.UTILSCHEDULER.ScheduleMouseAction('"+this.SCHEDULE_ID_PREFIX+"', 'out', 'erase','"+a+"');\"onMousedown=\"javascript:SYNO.SS.UTILSCHEDULER.ChkLeftMouseDown(event, SYNO.SS.UTILSCHEDULER.ScheduleMouseAction, '"+this.SCHEDULE_ID_PREFIX+"', 'down', 'erase','"+a+"');\"></span>"});this.labelAllowNotify=new Ext.form.Label({width:this.SCHEDULE_TYPE_LABEL_WIDTH,cls:"x-form-item ss-schedule-label-normal",text:_T("action_rule","available_time")});this.labelEraseNotify=new Ext.form.Label({width:270,cls:"x-form-item ss-schedule-label-normal",text:_T("camera","camera_no_recording")});this.labelScheNonavailable=new Ext.form.Label({region:"south",hidden:true,text:"*"+_T("action_rule","remind_disable_reason")});this.panelModeSelection=new SYNO.SS.Panel.ScheduleModePanel({items:[this.panelAllowNotify,this.labelAllowNotify,this.panelEraseNotify,this.labelEraseNotify]});this.panelScheduler.SetCurrentAct("continue")},Activate:function(a){if(true===this.blInit){return}if(false===this.blScheduleActivated){this.blScheduleActivated=true;this.panelScheduler.Activate(a)}this.blInit=true},UpdateAvailableSche:function(f,d){var e,c,b;var a=false;this.blAnyAvailable=false;if(false===this.blScheduleActivated){this.blScheduleActivated=true;this.panelScheduler.Activate()}for(e=0;e<7;e++){for(c=0;c<48;c++){this.panelScheduler.SetScheduleItemDisabled(e,c,false);this.panelScheduler.RedrawHalfHourItemByIdx(e,c);if(false==d){a=true}else{a=false}for(b=0;b<f.length;b++){if("1"===f[b].charAt(e*48+c)){this.panelScheduler.SetScheduleItemDisabled(e,c,a);this.panelScheduler.RedrawHalfHourItemByIdx(e,c);break}}if(b===f.length){this.blAnyAvailable=true}}}if(true===d){this.labelScheNonavailable.hide();this.blAnyAvailable=true}else{this.labelScheNonavailable.show()}},UpdateLabel:function(b){var a=(true===SYNO.SS.App.ActionRule.Utils.IsScheduled(b))?"allow_act":"available_time";this.labelAllowNotify.setText(_T("action_rule",a))},GetSchedule:function(){var c,b;var a=[];var d;for(c=0;c<7;c++){for(b=0;b<48;b++){if(true===this.panelScheduler.CheckItemIsDisabled(c,b)){d=0}else{d=this.panelScheduler.GetScheduleItemType(c,b)}a.push(d)}}return a.join("")},IsFormValid:function(){return this.getForm().isValid()},IsDirty:function(){return this.panelScheduler.IsDirty()},ClearDirty:function(){this.panelScheduler.ClearDirty()}});Ext.define("SYNO.SS.App.ActionRule.Wizard",{extend:"SYNO.SDS.Wizard.ModalWindow",blScheAvail:true,parentWin:null,steps:null,pageInfo:null,pageEvent:null,pageAction:null,pageSchedule:null,numMask:0,constructor:function(b){this.parentWin=b;this.InitSteps();var a={owner:b,title:_T("action_rule","add_rule"),width:700,height:500,banner:false,bodyCssClass:"ss_wizard",steps:this.steps,useStatusBar:true};this.callParent([a])},InitSteps:function(){this.pageInfo=new SYNO.SS.App.ActionRule.InfoPanel({itemId:"info",nextId:{triggered:"event",scheduled:"action"},parentWin:this,getNext:function(){if(false===this.parentWin.CheckStepValid()){this.parentWin.setStatusBarError({text:_T("ss_common","forminvalid"),clear:true});return false}var a=this.cmbRuleType.getValue();return(true===SYNO.SS.App.ActionRule.Utils.IsScheduled(a))?this.nextId.scheduled:this.nextId.triggered}});this.pageEvent=new SYNO.SS.App.ActionRule.EventPanel({itemId:"event",nextId:"action",parentWin:this,blAdd:true,getNext:function(){if(false===this.parentWin.CheckStepValid()){this.parentWin.setStatusBarError({text:_T("ss_common","forminvalid"),clear:true});return false}return this.nextId}});this.pageAction=new SYNO.SS.App.ActionRule.ActionPanel({itemId:"action",nextId:"schedule",parentWin:this,blAdd:true,getNext:function(){if(false===this.parentWin.CheckStepValid()){this.parentWin.setStatusBarError({text:_T("ss_common","forminvalid"),clear:true});return false}this.parentWin.pageSchedule.Activate();return this.nextId}});this.pageSchedule=new SYNO.SS.App.ActionRule.Schedule({itemId:"schedule",nextId:null,parentWin:this,getNext:function(){if(false===SYNO.SS.App.ActionRule.Utils.CheckRuleSettings(this.parentWin)){return false}if(true===this.parentWin.CheckStepValid()){this.parentWin.OnSubmit()}return false}});this.steps=[this.pageInfo,this.pageEvent,this.pageAction,this.pageSchedule]},UpdateUI:function(a){this.pageAction.UpdateDefUI(a);this.pageSchedule.UpdateLabel(a)},OnSubmit:function(){this.setStatusBarBusy({text:_T("ss_common","common_saving")});this.owner.SendWebAPI(3,"Save",SYNO.SS.App.ActionRule.Utils.GetAllParams(this,-1),this.OnSubmitDone,this)},OnSubmitDone:function(d,b,c,a){this.clearStatusBusy();if(d){this.owner.OnRefresh();this.close()}},CheckStepValid:function(){var a=this.getActiveStep();if(!a||(false===a.IsFormValid())){return false}return true},GetCurDsId:function(){return this.parentWin.GetCurDsId()},IsCmbServerVisible:function(){return this.parentWin.IsCmbServerVisible()},Mask:function(){if(0===this.numMask++){this.setStatusBarBusy()}return},Unmask:function(){if(0>=this.numMask){return}if(0===--this.numMask){this.clearStatusBusy()}return}});Ext.define("SYNO.SS.App.ActionRule.Edit",{extend:"SYNO.SDS.ModalWindow",pageIndex:{INFO:0,EVENT:1,ACTION:2,SCHEDULE:3},curRecord:null,blScheAvail:true,parentWin:null,blIgnoreChange:false,btnSave:null,btnClose:null,pageInfo:null,pageEvent:null,pageAction:null,pageSchedule:null,tabPanel:null,numMask:0,constructor:function(c,a){this.curRecord=a;this.parentWin=c;this.Init();var b={owner:c,title:_T("action_rule","edit_rule")+" - "+this.curRecord.get("name"),width:700,height:500,bodyCssClass:"win_tab_panel",bodyStyle:"padding:0px;",buttonAlign:"right",items:this.tabPanel,buttons:[this.btnSave,this.btnClose],listeners:{beforeclose:this.OnClose,scope:this}};this.callParent([b]);this.mon(SYNO.SDS.StatusNotifier,"updateEditPage",this.UpdateData,this)},Init:function(){this.pageInfo=new SYNO.SS.App.ActionRule.InfoPanel({parentWin:this,style:"padding-left: 8px"});this.pageEvent=new SYNO.SS.App.ActionRule.EventPanel({parentWin:this,blAdd:false,formStyle:"padding-left: 8px",evtNums:this.curRecord.get("events").length});this.pageAction=new SYNO.SS.App.ActionRule.ActionPanel({parentWin:this,blAdd:false,actNums:this.curRecord.get("actions").length});this.pageSchedule=new SYNO.SS.App.ActionRule.Schedule({});this.btnSave=new SYNO.ux.Button({text:_T("ss_common","common_save"),minWidth:75,btnStyle:"blue",handler:this.OnSave,scope:this});this.btnClose=new SYNO.ux.Button({text:_T("ss_common","close"),minWidth:75,handler:this.OnClose,scope:this});this.tabPanel=new SYNO.ux.TabPanel({height:410,deferredRender:false,activeTab:this.pageIndex.INFO,items:[this.pageInfo,this.pageEvent,this.pageAction,this.pageSchedule],listeners:{beforetabchange:function(a,c,b){if(undefined===b){return true}return b.IsFormValid()},scope:this}})},UpdateUI:function(a){this.UpdateEventVisibility(SYNO.SS.App.ActionRule.Utils.IsScheduled(a));this.pageAction.UpdateDefUI(a);this.pageSchedule.UpdateLabel(a)},InitData:function(){var a=this.curRecord.data;this.pageInfo.getForm().setValues(a);this.pageEvent.SetValues(a);this.pageAction.SetValues(a.actions);this.InitScheData();this.pageInfo.UpdateUI(this.curRecord,true);this.pageEvent.UpdateUI(this.curRecord,true);this.pageAction.UpdateUI(this.curRecord,true);this.UpdateEventVisibility(SYNO.SS.App.ActionRule.Utils.IsScheduled(a.ruleType))},UpdateData:function(a){Ext.each(a,function(c,b){if(c.data.ruleId===this.curRecord.data.ruleId){this.curRecord=c;return false}},this);this.setTitle(_T("action_rule","edit_rule")+" - "+this.curRecord.get("name"));this.pageEvent.UpdateUI(this.curRecord,false);this.pageAction.UpdateUI(this.curRecord,false)},InitScheData:function(){var a=this.owner.view.FillScheduleData(this.curRecord.get("multiRuleId"),this.curRecord.get("actSchedule"));this.pageSchedule.Activate(a);this.pageSchedule.UpdateLabel(this.curRecord.get("ruleType"))},OnSave:function(){if(false==this.IsValid()){this.setStatusError({text:_T("ss_common","forminvalid"),clear:true});return}if(false==SYNO.SS.App.ActionRule.Utils.CheckRuleSettings(this)){return}if(false==this.IsDirty()){this.setStatusError({text:_T("ss_common","setting_nochange"),clear:true});return}this.Mask({text:_T("ss_common","common_saving")});this.owner.SendWebAPI(3,"Save",SYNO.SS.App.ActionRule.Utils.GetAllParams(this,this.curRecord.get("multiRuleId")),this.OnSaveDone,this)},OnSaveDone:function(e,c,d,b){this.Unmask();if(e){var a=this.curRecord.get("status");this.owner.OnRefresh();this.ClearDirty();this.setStatusOK({text:_T("ss_common","setting_applied"),clear:true})}},OnClose:function(){if(true===this.blIgnoreChange){return true}if(true==this.IsDirty()){SYNO.SS.Utils.ConfirmLostChange({msgBox:this.getMsgBox(),fnYes:function(){this.blIgnoreChange=true;this.close()},scope:this});return false}this.blIgnoreChange=true;this.close()},GetCurDsId:function(){return this.parentWin.GetCurDsId()},IsCmbServerVisible:function(){return this.parentWin.IsCmbServerVisible()},IsDirty:function(){return(this.pageInfo.IsDirty()||this.pageEvent.IsDirty()||this.pageAction.IsDirty()||this.pageSchedule.IsDirty())},ClearDirty:function(){this.pageInfo.ClearDirty();this.pageEvent.ClearDirty();this.pageAction.ClearDirty();this.pageSchedule.ClearDirty()},IsValid:function(){return(this.pageInfo.IsFormValid()&&this.pageEvent.IsFormValid()&&this.pageAction.IsFormValid()&&this.pageSchedule.IsFormValid())},Mask:function(a){if(0===this.numMask++){this.setStatusBarBusy(a)}},Unmask:function(){if(0>=this.numMask){return}if(0===--this.numMask){this.clearStatusBusy()}},UpdateEventVisibility:function(a){if(a){this.tabPanel.hideTabStripItem(this.pageEvent)}else{this.tabPanel.unhideTabStripItem(this.pageEvent)}this.pageEvent.MaskPage(a)}});Ext.namespace("SYNO.SS.App.ActionRule");Ext.define("SYNO.SS.App.ActionRule.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SS.App.ActionRule.MainWindow"});Ext.define("SYNO.SS.App.ActionRule.MainWindow",{extend:"SYNO.SDS.TabPanelAppWindow",MIN_WIDTH:800,MIN_HEIGHT:466,bInited:false,tabIndex:SYNO.SS.App.ActionRule.Def.TabIndex,dsActRule:null,dsServer:null,curServer:null,selId:-1,btnAdd:null,btnDelete:null,btnEdit:null,menuItemEnable:null,menuItemDisable:null,btnEnable:null,cmbServer:null,view:null,panelGridContainer:null,panelRuleList:null,panelHistory:null,panelAdvanced:null,dlgAdd:null,dlgEdit:null,constructor:function(a){if(false===this.bInited){this.Init();this.bInited=true}this.callParent([Ext.apply({title:_T("action_rule","action_rule"),width:this.MIN_WIDTH,height:this.MIN_HEIGHT,minWidth:this.MIN_WIDTH,minHeight:this.MIN_HEIGHT,layout:"fit",panelList:[this.panelRuleList,this.panelHistory,this.panelAdvanced],tabIndex:this.tabIndex,resizable:true},a)]);this.InitEvents()},InitEvents:function(){this.mon(this.tabPanel,"tabchange",this.OnTabChange,this);this.mon(SYNO.SDS.StatusNotifier,"camDataUpdated",this.OnRefresh,this);this.mon(SYNO.SDS.StatusNotifier,"cmsDataUpdated",this.OnRefresh,this);this.mon(SYNO.SDS.StatusNotifier,"audioDataUpdated",this.OnRefresh,this);this.mon(SYNO.SDS.StatusNotifier,"ctrlerDataUpdated",this.OnRefresh,this);this.mon(SYNO.SDS.StatusNotifier,"updateIOModule",this.OnRefresh,this);this.mon(SYNO.SDS.StatusNotifier,"serverListRefresh",this.OnRefresh,this);this.mon(SYNO.SDS.StatusNotifier,"ipSpeakerUpdate",this.OnRefresh,this);this.mon(SYNO.SDS.StatusNotifier,"ipSpeakerGrpUpdate",this.OnRefresh,this)},OnTabChange:function(){var a=this.GetCurrentTabIndex();if(this.tabIndex.HISTORY===a){this.panelHistory.Activate()}},onOpen:function(b){var a=this.parseAppParams(b).ownerDsId;if(true===Ext.isDefined(b.itemId)){this.selId=b.itemId}this.SetCurDsId(a);this.callParent(arguments);this.OnRefresh()},onRequest:function(a){if(true===Ext.isDefined(a.itemId)){this.selId=a.itemId}this.callParent(a);this.tabPanel.setActiveTab(SYNO.SS.App.ActionRule.Def.TabIndex.LIST);this.OnRefresh()},getHelpParam:function(){switch(this.GetCurrentTabIndex()){case this.tabIndex.LIST:return"action_rule_list.html";case this.tabIndex.HISTORY:return"action_rule_history.html";case this.tabIndex.ADVANCED:return"action_rule_advanced.html";default:return"action_rule_list.html"}},Init:function(){var a=[{name:"ruleId",type:"int"},{name:"name"},{name:"status",type:"int"},{name:"ruleType",type:"int"},{name:"actType",type:"int"},{name:"evtMinIntvl",type:"int"},{name:"actions"},{name:"multiRuleId",type:"int"},{name:"actSchedule"},{name:"events"},{name:"multiEvtSetting",type:"int"},{name:"enabled"}];this.dsActRule=new SYNO.API.JsonStore({appWindow:this,api:"SYNO.SurveillanceStation.ActionRule",method:"List",version:3,baseParams:{start:0,limit:SYNO.SS.Pgls.MIN_PAGE_RECORDS},root:"actRule",totalProperty:"total",fields:a,listeners:{beforeload:function(b,c){this.setStatusBusy()},loadexception:function(){this.getMsgBox().alert(_T("action_rule","action_rule"),_T("ss_common","error_system"));this.curServer=this.dsServer.getById(LOCAL_DS_ID);this.cmbServer.setValue(LOCAL_DS_ID);this.panelHistory.cmbServer.setValue(LOCAL_DS_ID);this.clearStatusBusy()},load:function(d,c,e){var b=0;this.view.RenderScheduleAndSetActItem();if(0<c.length){b=d.findExact("multiRuleId",this.selId);if(-1===b){b=0}this.view.select(b);this.selId=-1}this.ChgButtonStatus();SYNO.SDS.StatusNotifier.fireEvent("updateEditPage",c);this.clearStatusBusy()},scope:this}});this.btnAdd=new SYNO.ux.Button({text:_T("ss_common","common_add"),handler:this.OnAdd,scope:this});this.btnDelete=new SYNO.ux.Button({text:_T("ss_common","common_delete"),handler:this.OnDelete,scope:this});this.btnEdit=new SYNO.ux.Button({text:_T("ss_common","common_edit"),handler:this.OnEdit,scope:this});this.menuItemEnable=new Ext.menu.Item({text:_T("ss_common","common_enable"),handler:this.OnEnable,scope:this});this.menuItemDisable=new Ext.menu.Item({text:_T("ss_common","common_disable"),handler:this.OnDisable,scope:this});this.btnEnable=new SYNO.ux.Button({text:_T("ss_common","common_enable"),menu:{items:[this.menuItemEnable,this.menuItemDisable]}});this.cmbServer=new SYNO.SS.Form.ServerComboBox({value:LOCAL_DS_ID,valueField:"id",displayField:"name",listeners:{beforeselect:this.BeforeServerSelect,scope:this}});this.view=new SYNO.SS.App.ActionRule.ExpandableListView({owner:this,store:this.dsActRule,toggleOnDblClick:false,listeners:{selectionchange:this.ChgButtonStatus,contextmenu:this.OnContextMenu,dblclick:this.OnEdit,scope:this}});this.expandablePanel=new SYNO.SS.ViewPanel({view:this.view,plugins:SYNO.SS.Pgls.CreatePglsPlugin({ptype:"synoSSPglsPlugin",store:this.dsActRule})});this.panelGridContainer=new SYNO.SS.Pgls.PglsGridContainerPanel({grid:this.expandablePanel,store:this.dsActRule,emptyStyleMonStore:this.dsActRule,emptyStyleTip:_T("action_rule","no_action_rules"),emptyStyleTipFunc:this.OnAdd.createDelegate(this),refreshFunction:this.OnRefresh,refreshFunctionScope:this});this.panelRuleList=new SYNO.ux.Panel({layout:"fit",title:_T("ss_common","list"),tbar:new SYNO.ux.Toolbar({items:[this.btnAdd,this.btnDelete,this.btnEdit,this.btnEnable]}),items:this.panelGridContainer});this.panelHistory=this.CreateTabItemForGblSearch("SYNO.SS.App.ActionRule.History",[this]);this.panelAdvanced=this.CreateTabItemForGblSearch("SYNO.SS.App.ActionRule.Advanced",[this])},OnAdd:function(){if(this.dlgAdd&&(false===this.dlgAdd.hidden)){return}this.dlgAdd=new SYNO.SS.App.ActionRule.Wizard(this);this.dlgAdd.open()},OnEdit:function(){if(this.dlgEdit&&(false===this.dlgEdit.hidden)){return}var a=this.view.getSelectedRecords();if((0===a.length)||(1<a.length)){return}this.dlgEdit=new SYNO.SS.App.ActionRule.Edit(this,a[0]);this.dlgEdit.show();this.dlgEdit.InitData()},GetSelectIdList:function(){var a=this.view.getSelectedRecords();var b,c=[];for(b=0;b<a.length;b++){Ext.each(a[b].get("actions"),function(d){c.push(d.id)})}return c.join(",")},OnDelete:function(){this.getMsgBox().confirm(_T("action_rule","action_rule"),_T("action_rule","rule_del_warning"),function(a){if("yes"===a){this.SendWebAPI(1,"Delete",{idList:this.GetSelectIdList()},this.OnRefresh)}},this)},OnEnable:function(){this.SendWebAPI(1,"Enable",{idList:this.GetSelectIdList()},this.OnRefresh)},OnDisable:function(){this.SendWebAPI(1,"Disable",{idList:this.GetSelectIdList()},this.OnRefresh)},OnRefresh:function(){this.view.collapseAll();this.dsActRule.load()},OnRefreshHistory:function(){this.panelHistory.OnRefresh()},ChgButtonStatus:function(){var a=this.view.getSelectedRecords();var c;var d=false;var e=false;var b=(0>=a.length);Ext.each(a,function(f){if(true===f.get("enabled")){d=true}else{e=true}return((false===d)||(false===e))});this.menuItemEnable.setDisabled(false===e);this.menuItemDisable.setDisabled(false===d);this.btnDelete.setDisabled(b);this.btnEdit.setDisabled(b||(1<a.length));this.btnEnable.setDisabled(b)},OnContextMenu:function(a,f,c,d){var b;if(0===this.dsActRule.getTotalCount()){return}if(false===a.isSelected(c)){a.select(c)}b=new SYNO.ux.Menu();if(false===this.btnEdit.disabled){b.add({text:_T("ss_common","common_edit"),handler:this.OnEdit,scope:this})}if(false===this.menuItemEnable.disabled){b.add({text:_T("ss_common","common_enable"),handler:this.OnEnable,scope:this})}if(false===this.menuItemDisable.disabled){b.add({text:_T("ss_common","common_disable"),handler:this.OnDisable,scope:this})}if(false===this.btnDelete.disabled){b.add({text:_T("ss_common","common_delete"),handler:this.OnDelete,scope:this})}if(0<b.items.length){d.stopEvent();b.showAt(d.getXY())}},SetCurDsId:function(a){var b=a;var c;this.cmbServer.UpdateStore();this.panelHistory.cmbServer.UpdateStore();this.dsServer=this.cmbServer.getStore();c=this.dsServer.getById(b);if(true===Ext.isEmpty(c)){b=LOCAL_DS_ID;c=this.dsServer.getById(LOCAL_DS_ID)}this.curServer=c;this.cmbServer.setValue(b);this.panelHistory.cmbServer.setValue(b)},BeforeServerSelect:function(d,a,c){var b;this.cmbServer.collapse();this.panelHistory.cmbServer.collapse();if(this.curServer===a){return true}this.curServer=a;b=this.curServer.get("id");this.cmbServer.setValue(b);this.panelHistory.cmbServer.setValue(b);this.OnRefresh();this.OnRefreshHistory();return true},GetCurDsId:function(){if(false===Ext.isEmpty(this.curServer)){return this.curServer.get("id")}return LOCAL_DS_ID},GetActDevId:function(a,b){return this.GetDeviceId(b,a.actSrc,a.actDevId)},GetDeviceId:function(a,c,b){switch(c){case SYNO.SS.App.ActionRule.Def.Source.EXT_DEVICE:b=SYNO.SS.App.ActionRule.Def.RuleAct.EXT;break;case SYNO.SS.App.ActionRule.Def.Source.VS_AO:case SYNO.SS.App.ActionRule.Def.Source.WEBCLIENT:b=0;break;case SYNO.SS.App.ActionRule.Def.Source.IOMODULE:case SYNO.SS.App.ActionRule.Def.Source.IPSPEAKER:case SYNO.SS.App.ActionRule.Def.Source.IPSPEAKER_GROUP:b=a.get("id");break;default:if((LOCAL_DS_ID!==this.GetCurDsId())&&(false===Ext.isEmpty(a))){b=a.get("camIdOnRecServer")}break}return(b)?b:0},IsCmbServerVisible:function(){return((true===IsCMSHost())&&(LOCAL_DS_ID===this.GetCurDsId()))},GetDsId:function(a){return(false===this.IsCmbServerVisible())?LOCAL_DS_ID:a},SendWebAPI:function(a,c,d,e,b){this.setStatusBusy();b=(b)?b:this;this.sendWebAPI({api:"SYNO.SurveillanceStation.ActionRule",version:a,method:c,params:d,callback:function(i,g,h,f){this.OnSendWebAPIDone(i,g,h,f,e,b)},scope:this})},OnSendWebAPIDone:function(f,c,d,b,e,a){this.clearStatusBusy();if(f){if((e)&&("function"===(typeof e))){e.call(a,f,c,d,b)}}else{if(("Enable"===b.method)||("Save"===b.method)){if((e)&&("function"===(typeof e))){e.call(a,f,c,d,b)}}errMsg=SYNO.API.getErrorString(c.code);a.getMsgBox().alert(_T("action_rule","action_rule"),errMsg)}}});